/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.appfile.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbd.business.domain.config.service.ConfigSysCfgParamHelper;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileStdRsmHelper {
    private static final Log logger = LogFactory.getLog(AppFileStdRsmHelper.class);
    private static final int FILE_PERIOD_DAY = -1;
    private static final Boolean CK_SWITCH = Boolean.TRUE;
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tspr_appfile");

    private AppFileStdRsmHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static int queryOtherAppCount(Long mid, Long appFileId) {
        logger.info("queryOtherAppCount.params:{},{}", (Object)mid, (Object)appFileId);
        if (HRObjectUtils.isEmpty((Object)mid) || mid == 0L) {
            return 0;
        }
        QFilter qFilter = new QFilter("stdrsm.mid", "=", (Object)mid);
        qFilter.and(new QFilter("id", "!=", (Object)appFileId));
        int count = APP_FILE_HELPER.queryOriginalArray("id", qFilter.toArray()).length;
        logger.info("queryOtherAppCount.count:{}", (Object)count);
        return count;
    }

    public static Set<Long> getAppFileIdsByStdRsmMidsAndPositionId(Set<Long> stdRsmMids, Long positionId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_appfile");
        QFilter qFilter = new QFilter("stdrsm.mid", "in", stdRsmMids);
        qFilter.and(new QFilter("position", "=", (Object)positionId));
        QFilter fileQfilter = new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_IN);
        qFilter.and(fileQfilter);
        return helper.queryOriginalCollection("stdrsm.mid", qFilter.toArray()).stream().map(dyo -> dyo.getLong("stdrsm.mid")).collect(Collectors.toSet());
    }

    public static void mergeCandidate(Long mainId, Long subId) {
        logger.info("mergeCandidate.stmRsmIds.mainId {} subId {}", (Object)mainId, (Object)subId);
        try (TXHandle tx = TX.required();){
            try {
                String selectProps = TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"position.id", "filestatus", "eliminatetime", "modifytime", "modifier", "stdrsm"});
                DynamicObject[] mainAppFiles = APP_FILE_HELPER.query(selectProps, new QFilter[]{new QFilter("stdrsm", "=", (Object)mainId)});
                DynamicObject[] subAppFiles = APP_FILE_HELPER.query(selectProps, new QFilter[]{new QFilter("stdrsm", "=", (Object)subId)});
                logger.info("mergeCandidate.appfileIds.main:{},sub:{}", (Object)Arrays.stream(mainAppFiles).map(DataEntityBase::getPkValue).toArray(), (Object)Arrays.stream(subAppFiles).map(DataEntityBase::getPkValue).toArray());
                ArrayList invalidAppFiles = Lists.newArrayListWithCapacity((int)subAppFiles.length);
                AppFileStdRsmHelper.setInvalidAppFiles(mainAppFiles, subAppFiles, invalidAppFiles);
                for (DynamicObject subAppFile : subAppFiles) {
                    subAppFile.set("stdrsm", (Object)mainId);
                }
                AppFileHelper.update(subAppFiles);
                AppFileStatusHelper.invalidAppFiles(invalidAppFiles.toArray(new DynamicObject[0]));
                AppFileFlowLockHelper.mergeCandidate(mainId, subId);
            }
            catch (RuntimeException ex) {
                logger.error("mergeCandidate.appfile.error", (Throwable)ex);
                tx.markRollback();
                throw ex;
            }
        }
    }

    private static void setInvalidAppFiles(DynamicObject[] mainAppFiles, DynamicObject[] subAppFiles, List<DynamicObject> invalidAppFiles) {
        for (DynamicObject subAppFile : subAppFiles) {
            if (!AppFileHelper.isInProcessOrEmp(subAppFile)) continue;
            AppFileStdRsmHelper.addInvaidAppFile(mainAppFiles, invalidAppFiles, subAppFile);
        }
    }

    private static void addInvaidAppFile(DynamicObject[] mainAppFiles, List<DynamicObject> invalidAppFiles, DynamicObject subAppFile) {
        Long positionId = subAppFile.getLong("position.id");
        for (DynamicObject mainAppFile : mainAppFiles) {
            boolean equals = HRObjectUtils.equals((Object)positionId, (Object)mainAppFile.getLong("position.id"));
            if (!equals || !AppFileHelper.isInProcessOrEmp(mainAppFile)) continue;
            invalidAppFiles.add(subAppFile);
            break;
        }
    }

    public static void showStandardResumePage(AbstractFormPlugin plugin, Long stdRsmId) {
        StdRsmCommonService.getInstance().showStandardResumePage(plugin, stdRsmId);
    }

    public static void selectTalentPool(AbstractFormPlugin plugin, List<Long> listWithoutDuplicates) {
        StdRsmCommonService.getInstance().selectTalentPool(plugin, listWithoutDuplicates);
    }

    public static void validateTalentRight(AbstractFormPlugin plugin, List<Long> selectPkIds, String pageNumber) {
        StdRsmCommonService.getInstance().validateTalentRight(plugin, selectPkIds, pageNumber, "savetalent");
    }

    public static void saveTalent(AbstractFormPlugin plugin, ListSelectedRowCollection listSelectedRows) {
        StdRsmCommonService.getInstance().saveTalent(plugin, listSelectedRows);
    }

    public static DynamicObject getAppFileByStdRsmIdAndPositionId(Long stdRsmId, Long positionId, Date applyTime) {
        logger.debug("getAppFileByStdRsmMidAndPositionId appfile query repeat");
        if (Boolean.TRUE.equals(AppFileStdRsmHelper.getCheckDupSwitch())) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_appfile");
            QFilter qFilter = new QFilter("stdrsm.mid", "=", (Object)stdRsmId);
            qFilter.and(new QFilter("position", "=", (Object)positionId));
            QFilter fileQfilter = new QFilter("filestatus", "in", (Object)Sets.newHashSet((Object[])new String[]{AppFileConstants.APP_FILE_STATUS_IN, AppFileConstants.APP_FILE_STATUS_TBEMP})).or(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_OUT).and(new QFilter("eliminatetime", ">", (Object)HRDateTimeUtils.addDay((Date)applyTime, (long)AppFileStdRsmHelper.getExpDay())))).or(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_EMPED).and("laborrelstatus", "!=", (Object)1080L));
            qFilter.and(fileQfilter);
            logger.info("getAppFileByStdRsmMidAndPositionId {}", (Object)qFilter.toString());
            return helper.queryOne(TSCBaseUtils.getSelectProperties((String)"tspr_appfile"), qFilter.toArray(), "createtime");
        }
        return null;
    }

    public static Map<String, Long> getAppFileByTpdataid(List<String> tpdataids) {
        logger.debug("getAppFileByTpdataid appfile query repeat");
        HashMap<String, Long> returnMap = new HashMap<String, Long>(8);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tspr_appfile");
        QFilter qFilter = new QFilter("tpdataid", "in", tpdataids);
        logger.info("getAppFileByTpdataid {}", (Object)qFilter.toString());
        DynamicObject[] queryList = helper.queryOriginalArray("id, filestatus, tpdataid, applytime, eliminatetime, laborrelstatus.id", new QFilter[]{qFilter});
        DynamicObject[] returnList = new DynamicObject[8];
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(AppFileConstants.APP_FILE_STATUS_IN);
        statusList.add(AppFileConstants.APP_FILE_STATUS_TBEMP);
        for (DynamicObject query : queryList) {
            String filestatus = query.getString("filestatus");
            if (statusList.contains(filestatus)) {
                if (returnMap.get(query.getString("tpdataid")) != null) break;
                returnMap.put(query.getString("tpdataid"), query.getLong("id"));
                continue;
            }
            if (filestatus.equals(AppFileConstants.APP_FILE_STATUS_OUT)) {
                Date applyTime = query.getDate("applytime");
                Date eliminatetime = query.getDate("eliminatetime");
                if (eliminatetime.getTime() <= HRDateTimeUtils.addDay((Date)applyTime, (long)AppFileStdRsmHelper.getExpDay()).getTime()) continue;
                if (returnMap.get(query.getString("tpdataid")) != null) break;
                returnMap.put(query.getString("tpdataid"), query.getLong("id"));
                continue;
            }
            if (!filestatus.equals(AppFileConstants.APP_FILE_STATUS_EMPED) || query.getLong("laborrelstatus.id") == 1080L) continue;
            if (returnMap.get(query.getString("tpdataid")) != null) break;
            returnMap.put(query.getString("tpdataid"), query.getLong("id"));
        }
        return returnMap;
    }

    private static Boolean getCheckDupSwitch() {
        Object checkDup = ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)"checkdup");
        if (checkDup instanceof Boolean) {
            return (Boolean)checkDup;
        }
        return CK_SWITCH;
    }

    private static int getExpDay() {
        Object fileExp = ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)"fileexp");
        if (fileExp instanceof Integer) {
            return -((Integer)fileExp).intValue();
        }
        return -1;
    }

    public static void updateStdRsmLastStgAndStat(long stgId, long statId, List<Long> stdRsmIdList) {
        logger.info("updateStdRsmLastStgAndStat.params:{},{},{}", new Object[]{stgId, statId, stdRsmIdList});
        HashMap lastStgAndStatMap = Maps.newHashMapWithExpectedSize((int)stdRsmIdList.size());
        for (Long stdRsmId : stdRsmIdList) {
            HashMap stgAndStatMap = Maps.newHashMapWithExpectedSize((int)2);
            stgAndStatMap.put("recrustg", String.valueOf(stgId));
            stgAndStatMap.put("recrustat", String.valueOf(statId));
            lastStgAndStatMap.put(stdRsmId, stgAndStatMap);
        }
        AppFileStdRsmHelper.updateStdRsmInfo(lastStgAndStatMap);
    }

    public static void updateStdRsmInfo(Long stdRsmId, Map<String, String> stdRsmInfoMap) {
        String appFileIdStr;
        int positionNum;
        String positionStr = stdRsmInfoMap.get("position");
        String recruchnlnmStr = stdRsmInfoMap.get("recruchnlnm");
        logger.info("updateAppPosNumAndRecChlStdRsmInfo.params:{},{},{}", new Object[]{stdRsmId, positionStr, recruchnlnmStr});
        HashMap appPosNumAndRecMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap stgAndStatMap = Maps.newHashMapWithExpectedSize((int)2);
        try (DataSet dataSet = APP_FILE_HELPER.queryDataSet("updateAppPosNumAndRecChlStdRsmInfo.positionnum", "position", new QFilter[]{new QFilter("stdrsm", "=", (Object)stdRsmId)});){
            positionNum = dataSet.count("position", true);
        }
        stgAndStatMap.put("positionnum", String.valueOf(positionNum));
        stgAndStatMap.put("recruchnlnm", recruchnlnmStr);
        if (HRStringUtils.isNotEmpty((String)positionStr)) {
            stgAndStatMap.put("position", positionStr);
        }
        if (HRStringUtils.isNotEmpty((String)(appFileIdStr = stdRsmInfoMap.get("appfile")))) {
            long appFileId = Long.parseLong(appFileIdStr);
            DynamicObject appFile = AppFileHelper.queryOne(appFileId);
            stgAndStatMap.put("recrustg", appFile.getString("recrustg.id"));
            stgAndStatMap.put("recrustat", appFile.getString("recrustat.id"));
        }
        appPosNumAndRecMap.put(stdRsmId, stgAndStatMap);
        AppFileStdRsmHelper.updateStdRsmInfo(appPosNumAndRecMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStdRsmInfo(Map<Long, Map<String, String>> stdRsmInfoMap) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("data", SerializationUtils.toJsonString(stdRsmInfoMap));
        try (MessagePublisher pub = null;){
            logger.info("updateStdRsmInfo.params:{}", stdRsmInfoMap);
            pub = MQFactory.get().createSimplePublisher("tsc", "tsc.tstpm.stdrsmupdate_queue");
            pub.publish((Object)params);
            logger.info("updateStdRsmInfo.success:{}", (Object)params);
        }
    }

    public static Map<Long, Boolean> getBlackListMap(List<Long> appFileIdList) {
        return Arrays.stream(AppFileHelper.queryAppFiles(appFileIdList, "stdrsm")).collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> "-4".equals(dyo.getString("stdrsm.datastatus"))));
    }

    public static QFilter isNotInBlackList(String appFileFieldPre) {
        return new QFilter(appFileFieldPre + "stdrsm" + "." + "datastatus", "<>", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
    }
}

