/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.bgsurvey.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.common.constants.bgsurvey.BackGroundSurveyConEnum;
import kd.tsc.tspr.common.constants.bgsurvey.BackgroundSurveyConst;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordChangeModel;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class BackgroundSurveyDomainService {
    public static HRBaseServiceHelper getServiceHelper() {
        return new HRBaseServiceHelper("tssrm_bakgroundsurvey");
    }

    public static DynamicObject[] getBackgroundSurveysByAppFile(Long appFileId) {
        QFilter backgroundSurveyQFilter = new QFilter("appfile", "=", (Object)appFileId);
        return BackgroundSurveyDomainService.getServiceHelper().query(backgroundSurveyQFilter.toArray(), " createtime desc");
    }

    public static DynamicObject getBackgroundSurveyByAppFile(Long appFileId) {
        DynamicObject[] list = BackgroundSurveyDomainService.getBackgroundSurveysByAppFile(appFileId);
        if (list != null && list.length > 0) {
            return list[0];
        }
        return null;
    }

    public static DynamicObject getBackgroundSurveyById(Object id) {
        return BackgroundSurveyDomainService.getServiceHelper().loadSingle(id);
    }

    public static OprecordMessageModel getBackgroundsurveyOMM(DynamicObject backgroundsurvey) {
        OpDefEnum opDefEnum = OpDefEnum.ENTER_BGSUR_RESULT;
        DynamicObject appFile = backgroundsurvey.getDynamicObject("appfile");
        String appFileName = appFile.getString("name");
        Long appFileId = (Long)appFile.getPkValue();
        DynamicObject appFileDynamicObject = AppFileHelper.queryOne(appFileId);
        String positionName = appFileDynamicObject.getString("position.name");
        String oprtext = null;
        if (backgroundsurvey.getLong("id") > 0L) {
            opDefEnum = OpDefEnum.UPDATE_BGSUR_RESULT;
        }
        oprtext = String.format("%s%s\u4e86\u5e94\u8058%s\u7684%s%s\u7684\u80cc\u8c03\u7ed3\u679c", RequestContext.get().getUserName(), BackgroundSurveyDomainService.getOperatePrefix(opDefEnum.getName()), positionName, "\u5019\u9009\u4eba", appFileName);
        OprecordMessageModel omm = BackgroundSurveyDomainService.getOpRecordMessageModel(appFileId, appFileName, oprtext);
        if (backgroundsurvey.getLong("id") > 0L) {
            opDefEnum = OpDefEnum.UPDATE_BGSUR_RESULT;
            ArrayList changeModelList = Lists.newArrayListWithCapacity((int)16);
            OprecordChangeModel changeModel = new OprecordChangeModel();
            changeModel.setFieldkey("cmbconclusion");
            changeModel.setFieldname("\u80cc\u666f\u8c03\u67e5\u7ed3\u8bba");
            DynamicObject origin = BackgroundSurveyDomainService.getBackgroundSurveyById(backgroundsurvey.getPkValue());
            changeModel.setOriginalvalue(BackGroundSurveyConEnum.valueOf((String)origin.getString("cmbconclusion")).getName());
            changeModel.setNewvalue(BackGroundSurveyConEnum.valueOf((String)backgroundsurvey.getString("cmbconclusion")).getName());
            changeModelList.add(changeModel);
            omm.setChangeList((List)changeModelList);
        }
        omm.setOpnumber(opDefEnum.getCode());
        return omm;
    }

    private static OprecordMessageModel getOpRecordMessageModel(Long pkValue, String appFileName, String oprtext) {
        OprecordMessageModel message = new OprecordMessageModel();
        message.setOperator(Long.valueOf(TSCRequestContext.getUserId()));
        message.setOperatorname(RequestContext.get().getUserName());
        message.setOperatorrole("\u62db\u8058\u4e13\u5458");
        message.setBizobjrole("\u5019\u9009\u4eba");
        message.setBizobjname(appFileName);
        message.setBizentry("tssrm_bakgroundsurvey");
        message.setBizobj(pkValue.longValue());
        message.setOptime(HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        message.setOprtext(oprtext);
        return message;
    }

    public static void sendAttachOperateRecord(Long pkValue, Long appFileId, List<Map<String, Object>> originAttachments) {
        ArrayList<OprecordMessageModel> msgList = new ArrayList<OprecordMessageModel>(8);
        List newAttachments = AttachmentServiceHelper.getAttachments((String)"tssrm_bakgroundsurvey", (Object)pkValue, (String)"attachmentpanelap");
        if (originAttachments != null && originAttachments.size() > 0) {
            if (newAttachments != null && newAttachments.size() > 0) {
                for (int i = 0; i < originAttachments.size(); ++i) {
                    Map<String, Object> originAttach = originAttachments.get(i);
                    Long originKey = (Long)originAttach.get("attPkId");
                    for (int j = 0; j < newAttachments.size(); ++j) {
                        Map newAttach = (Map)newAttachments.get(j);
                        Long newKey = (Long)newAttach.get("attPkId");
                        if (!originKey.equals(newKey)) continue;
                        originAttachments.remove(i--);
                        newAttachments.remove(j--);
                    }
                }
                if (originAttachments != null && originAttachments.size() > 0) {
                    OprecordMessageModel omm = BackgroundSurveyDomainService.getAttachOperateRecordItem(appFileId, OpDefEnum.DELETE_BGSUR_REPORT, originAttachments);
                    msgList.add(omm);
                }
                if (newAttachments != null && newAttachments.size() > 0) {
                    OprecordMessageModel omm = BackgroundSurveyDomainService.getAttachOperateRecordItem(appFileId, OpDefEnum.UPLOAD_BGSUR_REPORT, newAttachments);
                    msgList.add(omm);
                }
            } else if (originAttachments != null && originAttachments.size() > 0) {
                OprecordMessageModel omm = BackgroundSurveyDomainService.getAttachOperateRecordItem(appFileId, OpDefEnum.DELETE_BGSUR_REPORT, originAttachments);
                msgList.add(omm);
            }
        } else if (newAttachments != null && newAttachments.size() > 0) {
            OprecordMessageModel omm = BackgroundSurveyDomainService.getAttachOperateRecordItem(appFileId, OpDefEnum.UPLOAD_BGSUR_REPORT, newAttachments);
            msgList.add(omm);
        }
        if (msgList != null && msgList.size() > 0) {
            OprecordMQ.sendOpRecordChangeMessage(msgList);
        }
    }

    public static void sendDeleteAttachOperateRecord(Long pkValue, Long appFileId, String fileName) {
        BackgroundSurveyDomainService.sendSingleAttachOperateRecord(pkValue, appFileId, fileName, OpDefEnum.DELETE_BGSUR_REPORT);
    }

    public static void sendDownloadOperateRecord(Long pkValue, Long appFileId, List<Map<String, Object>> attachments) {
        if (attachments != null && attachments.size() > 0) {
            for (int i = 0; i < attachments.size(); ++i) {
                Object attPkId = attachments.get(i).get("attPkId");
                if (attPkId != null) continue;
                attachments.remove(i--);
            }
            if (attachments != null && attachments.size() > 0) {
                ArrayList<OprecordMessageModel> msgList = new ArrayList<OprecordMessageModel>(8);
                OprecordMessageModel omm = BackgroundSurveyDomainService.getAttachOperateRecordItem(appFileId, OpDefEnum.DOWNLOAD_BGSUR_REPORT, attachments);
                msgList.add(omm);
                OprecordMQ.sendOpRecordChangeMessage(msgList);
            }
        }
    }

    public static void sendSingleAttachOperateRecord(Long pkValue, Long appFileId, String fileName, OpDefEnum opDefEnum) {
        DynamicObject appFileDynamicObject = AppFileHelper.queryOne(appFileId);
        String appFileName = appFileDynamicObject.getString("name");
        String positionName = appFileDynamicObject.getString("position.name");
        String oprtext = String.format("%s%s\u4e86\u5e94\u8058%s\u7684%s%s\u7684\u80cc\u8c03\u62a5\u544a", RequestContext.get().getUserName(), BackgroundSurveyDomainService.getOperatePrefix(opDefEnum.getName()), positionName, "\u5019\u9009\u4eba", appFileName);
        StringBuilder buf = new StringBuilder();
        buf.append(oprtext);
        buf.append("\u300a");
        buf.append(fileName);
        buf.append("\u300b");
        OprecordMessageModel omm = BackgroundSurveyDomainService.getOpRecordMessageModel(appFileId, appFileName, buf.toString());
        omm.setOpnumber(opDefEnum.getCode());
        ArrayList<OprecordMessageModel> msgList = new ArrayList<OprecordMessageModel>(8);
        msgList.add(omm);
        OprecordMQ.sendOpRecordChangeMessage(msgList);
    }

    public static String removeAttachCache(String uid, String attachJson) {
        List originAttachments;
        String attachCache = "";
        if (attachJson != null && (originAttachments = (List)JSON.parse((String)attachJson)) != null) {
            for (int j = 0; j < originAttachments.size(); ++j) {
                Map originAttachment = (Map)originAttachments.get(j);
                if (!uid.equals(originAttachment.get("uid"))) continue;
                originAttachments.remove(j);
            }
            attachCache = JSON.toJSONString((Object)originAttachments);
        }
        return attachCache;
    }

    private static OprecordMessageModel getAttachOperateRecordItem(Long appFileId, OpDefEnum opDefEnum, List<Map<String, Object>> newAttachments) {
        DynamicObject appFileDynamicObject = AppFileHelper.queryOne(appFileId);
        String appFileName = appFileDynamicObject.getString("name");
        String positionName = appFileDynamicObject.getString("position.name");
        String oprtext = String.format("%s%s\u4e86\u5e94\u8058%s\u7684%s%s\u7684\u80cc\u8c03\u62a5\u544a", RequestContext.get().getUserName(), BackgroundSurveyDomainService.getOperatePrefix(opDefEnum.getName()), positionName, "\u5019\u9009\u4eba", appFileName);
        StringBuilder buf = new StringBuilder();
        buf.append(oprtext);
        for (int i = 0; i < newAttachments.size(); ++i) {
            Map<String, Object> map = newAttachments.get(i);
            buf.append("\u300a");
            buf.append(String.valueOf(map.get("name")));
            buf.append("\u300b");
            if (i >= newAttachments.size() - 1) continue;
            buf.append(BackgroundSurveyConst.OPERATION_REPORT_SPLIT);
        }
        OprecordMessageModel omm = BackgroundSurveyDomainService.getOpRecordMessageModel(appFileId, appFileName, buf.toString());
        omm.setOpnumber(opDefEnum.getCode());
        return omm;
    }

    private static String getOperatePrefix(String operateType) {
        if (operateType != null) {
            return operateType.substring(0, 2);
        }
        return operateType;
    }
}

