/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.ThirdPartSystemEnum;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class SyncHcfHelper {
    private static final Log logger = LogFactory.getLog(SyncHcfHelper.class);
    public static final String DESCRIPTION = "description";
    public static final String CUSTOMFILENAME = "customfilename";
    private static final int MAX_THREADS = 2 * Runtime.getRuntime().availableProcessors() + 1;
    private static ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"SyncHcfHelper_threadPool", (int)MAX_THREADS);

    public static boolean updateArfToCandidate(Long appFileId, Boolean isAdd) {
        DynamicObject appFile = AppFileHelper.queryOne(appFileId, "arfrsm, number, name");
        DynamicObject candidate = (DynamicObject)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateByNumberAppFileId", (Object[])new Object[]{appFile.getString("number"), appFileId});
        if (!isAdd.booleanValue() && candidate == null) {
            return false;
        }
        long arfId = appFile.getLong("arfrsm.id");
        Map<String, Object> candidateSyncMap = SyncHcfHelper.generateCandidateSyncVO(appFile, arfId);
        if (candidateSyncMap == null) {
            return false;
        }
        THREAD_POOL.execute(() -> HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"saveOrUpdateCandidate", (Object[])new Object[]{candidateSyncMap}));
        THREAD_POOL.execute(() -> SyncHcfHelper.updateArfAttachmentToHcf(appFileId, isAdd, arfId));
        return true;
    }

    public static void updateArfAttachmentToHcf(Long appfileId, Boolean isAdd, Long arfRsmId) {
        DynamicObject candidate = (DynamicObject)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateByNumberAppFileId", (Object[])new Object[]{null, appfileId});
        if (!isAdd.booleanValue() && candidate == null) {
            logger.info("candidate is null");
            return;
        }
        DynamicObject[] arfAttachs = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"ARFRsmServiceApi", (String)"queryAttachmentInfoByArfRsmId", (Object[])new Object[]{arfRsmId});
        logger.info("get arfAttachs success {}", (Object)arfAttachs);
        if (arfAttachs == null) {
            return;
        }
        List offerAttachs = (List)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"attachmentServiceApi", (String)"getOfferAttachmentList", (Object[])new Object[]{appfileId, 1000});
        logger.info("get offerAttachs success {}", (Object)offerAttachs);
        List<Object> attachs = new ArrayList();
        if (offerAttachs != null) {
            for (DynamicObject dynamicObject : arfAttachs) {
                boolean flag = false;
                for (Map offerAttach : offerAttachs) {
                    logger.info("get descAttachs success {}/{}", offerAttach.get(DESCRIPTION), (Object)dynamicObject.getString(CUSTOMFILENAME));
                    if (!HRStringUtils.equals((String)String.valueOf(offerAttach.get(DESCRIPTION)), (String)dynamicObject.getString(CUSTOMFILENAME))) continue;
                    flag = true;
                }
                if (flag) continue;
                attachs.add(dynamicObject);
            }
        } else {
            attachs = Arrays.asList((Object[])arfAttachs.clone());
        }
        logger.info("candidate attachs\uff1a{}", attachs);
        Long candidateId = candidate.getLong("id");
        DynamicObject baseInfoDyn = (DynamicObject)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCurrentCanBaseInfoByCandidateId", (Object[])new Object[]{candidateId});
        AttachmentServiceHelper.remove((String)"hcf_canbaseinfo", (Object)baseInfoDyn.getPkValue());
        for (DynamicObject dynamicObject : attachs) {
            HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"uploadAttachment", (Object[])new Object[]{Long.parseLong(baseInfoDyn.getPkValue().toString()), dynamicObject});
        }
    }

    public static Map<String, Object> generateCandidateSyncVO(DynamicObject appFile, Long arfId) {
        Map<String, Object> appArfMap = SyncHcfHelper.getAppArfMap(arfId);
        logger.info("generateCandidateSyncVO appArfBo is");
        if (appArfMap == null) {
            return null;
        }
        SyncHcfHelper.loadAllListData(appArfMap);
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        dynColl.add((Object)((DynamicObject)appArfMap.get("rsm")));
        Map dyoCollMap = (Map)appArfMap.get("dyoCollMap");
        List collect = dyoCollMap.values().stream().collect(Collectors.toList());
        collect.add(dynColl);
        Long appFileId = appFile.getLong("id");
        String number = appFile.getString("number");
        String name = appFile.getString("name");
        HashMap<String, Object> candidateSyncMap = new HashMap<String, Object>(16);
        candidateSyncMap.put("apply", "arf");
        candidateSyncMap.put("name", name);
        candidateSyncMap.put("number", number);
        candidateSyncMap.put("billNo", number);
        candidateSyncMap.put("dynCollList", collect);
        candidateSyncMap.put("appFileId", appFileId);
        logger.info("generateCandidateSyncVO candidateSyncVo is");
        return candidateSyncMap;
    }

    public static Map<String, Object> getAppArfMap(Long arfId) {
        DynamicObject arfDt = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_arfrsm").queryOne((Object)arfId);
        if (arfDt != null) {
            HashMap appArfMap = Maps.newHashMap();
            appArfMap.put("rsm", arfDt);
            HashMap dyoCollMap = new HashMap(16);
            appArfMap.put("dyoCollMap", dyoCollMap);
            return appArfMap;
        }
        return null;
    }

    public static void loadAllListData(Map<String, Object> appArfMap) {
        DynamicObject rsm = (DynamicObject)appArfMap.get("rsm");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_mtdobjtable");
        QFilter qFilter = new QFilter("formtype", "=", (Object)"7");
        qFilter.and("recrutyp", "=", (Object)1020L);
        qFilter.and("ecosystem", "=", (Object)ThirdPartSystemEnum.MK.getTpSys());
        qFilter.and("ismainentity", "=", (Object)false);
        DynamicObject[] arfPages = serviceHelper.query("entitykey", qFilter.toArray());
        Map dyoCollMap = (Map)appArfMap.get("dyoCollMap");
        for (DynamicObject subpage : arfPages) {
            dyoCollMap.put(subpage.getString("entitykey"), SyncHcfHelper.getRsmList(rsm, subpage.getString("entitykey")));
        }
    }

    public static DynamicObjectCollection getRsmList(DynamicObject rsm, String pageNum) {
        if (rsm == null || rsm.getLong("id") == 0L || !rsm.getDataEntityState().getFromDatabase()) {
            return new DynamicObjectCollection();
        }
        long rsmId = rsm.getLong("id");
        QFilter qFilter = new QFilter("rsm", "=", (Object)rsmId);
        DynamicObject[] eduExps = ServiceHelperCache.getHrBaseServiceHelper((String)pageNum).loadDynamicObjectArray(pageNum, qFilter.toArray());
        DynamicObjectCollection eduExpList = new DynamicObjectCollection();
        eduExpList.addAll(Arrays.asList(eduExps));
        return eduExpList;
    }
}

