/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;

public class HireAppFileDataUpdateService {
    private static final Map<String, String> RECOMMEND_APPFILE_UPDATEMAP = Maps.newHashMap();
    private static final Map<String, String> JOBRANK_APPFILE_UPDATEMAP = Maps.newHashMap();
    private static final Map<String, String> SALARY_APPFILE_UPDATEMAP = Maps.newHashMap();
    private static final Map<String, Map<Object, Object>> APPFILEKEY_HIREVAL_APPFILEVAL = Maps.newHashMap();

    public static void updateRecommend(List<DynamicObject> recommendDyns) {
        ArrayList updateColumn = Lists.newArrayListWithExpectedSize((int)2);
        updateColumn.add("createtime");
        updateColumn.add("feedbackresult");
        HireAppFileDataUpdateService.updateAppFileMsg(recommendDyns, updateColumn, "appfile", RECOMMEND_APPFILE_UPDATEMAP);
    }

    public static void updateJobRank(List<DynamicObject> jobRankDyns) {
        ArrayList updateColumn = Lists.newArrayListWithExpectedSize((int)2);
        updateColumn.add("createtime");
        updateColumn.add("handlestatus");
        HireAppFileDataUpdateService.updateAppFileMsg(jobRankDyns, updateColumn, "appfile", JOBRANK_APPFILE_UPDATEMAP);
    }

    public static void updateSalary(List<DynamicObject> salaryDyns) {
        ArrayList updateColumn = Lists.newArrayListWithExpectedSize((int)2);
        updateColumn.add("createtime");
        updateColumn.add("handlestatus");
        HireAppFileDataUpdateService.updateAppFileMsg(salaryDyns, updateColumn, "appfile", SALARY_APPFILE_UPDATEMAP);
    }

    private static void updateAppFileMsg(List<DynamicObject> dynamicObjects, List<String> updateColumns, String appFileKey, Map<String, String> dynAppFileUpdateMap) {
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return;
        }
        List<Long> appFileIds = HireAppFileDataUpdateService.getAppFileIdByDyn(dynamicObjects, appFileKey);
        DynamicObject[] appFileDyns = AppFileDataHelper.queryHireInfoAppFile(appFileIds);
        if (appFileDyns.length == 0) {
            return;
        }
        HashMap appFileIdAndDyn = Maps.newHashMapWithExpectedSize((int)appFileDyns.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long appFileIdFromHire = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)"appfile");
            appFileIdAndDyn.put(appFileIdFromHire, dynamicObject);
        }
        for (DynamicObject appFileDyn : appFileDyns) {
            Long appFileId = appFileDyn.getLong("id");
            DynamicObject dynamicObject = (DynamicObject)appFileIdAndDyn.get(appFileId);
            for (String updateColumn : updateColumns) {
                String columnForAppFile = dynAppFileUpdateMap.get(updateColumn);
                if (HRStringUtils.isEmpty((String)columnForAppFile)) continue;
                Object updateVal = dynamicObject.get(updateColumn);
                appFileDyn.set(columnForAppFile, HireAppFileDataUpdateService.convertVal(columnForAppFile, updateVal));
            }
        }
        AppFileDataHelper.updateHireInfoAppFile(appFileDyns);
    }

    private static List<Long> getAppFileIdByDyn(List<DynamicObject> dynamicObjects, String appFileKey) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long appFileIdFromHire = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)appFileKey);
            appFileIds.add(appFileIdFromHire);
        }
        return appFileIds;
    }

    private static Object convertVal(String hireKey, Object updateVal) {
        Map<Object, Object> dyValAndAppFileVal = APPFILEKEY_HIREVAL_APPFILEVAL.get(hireKey);
        if (dyValAndAppFileVal == null) {
            return updateVal;
        }
        return dyValAndAppFileVal.get(updateVal);
    }

    static {
        RECOMMEND_APPFILE_UPDATEMAP.put("createtime", "employrecomnewesttime");
        RECOMMEND_APPFILE_UPDATEMAP.put("feedbackresult", "empolyfeedbackresult");
        JOBRANK_APPFILE_UPDATEMAP.put("createtime", "lasthirejobrankstarttime");
        JOBRANK_APPFILE_UPDATEMAP.put("handlestatus", "jobrankstatus");
        HashMap jobRankMap = Maps.newHashMapWithExpectedSize((int)4);
        jobRankMap.put("I", "I");
        jobRankMap.put("S", "S");
        jobRankMap.put("A", "W");
        jobRankMap.put("C", "W");
        APPFILEKEY_HIREVAL_APPFILEVAL.put("jobrankstatus", jobRankMap);
        SALARY_APPFILE_UPDATEMAP.put("createtime", "lasthiresalarystartime");
        SALARY_APPFILE_UPDATEMAP.put("handlestatus", "setsalarystatus");
        HashMap salaryMap = Maps.newHashMapWithExpectedSize((int)4);
        salaryMap.put("I", "I");
        salaryMap.put("S", "S");
        salaryMap.put("A", "W");
        salaryMap.put("C", "W");
        APPFILEKEY_HIREVAL_APPFILEVAL.put("setsalarystatus", salaryMap);
    }
}

