/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.servicehelper.AttachmentServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HireAttachmentFileService {
    private static final Logger logger = LoggerFactory.getLogger(HireAttachmentFileService.class);
    private static final int FILE_TIME_OUT = 60;

    public static void removeAllFile(String entity, Object pkId, String fileKey) {
        List attachments = AttachmentServiceHelper.getAttachments((String)entity, (Object)pkId, (String)fileKey);
        for (Map attachment : attachments) {
            String uid = (String)attachment.get("uid");
            AttachmentServiceHelper.remove((String)entity, (Object)pkId, (Object)uid);
        }
    }

    public static void copyAttachmentFileByAttachMsgForNew(List<Map<String, Object>> attachmentFileMsgs, String appId, String entity, Object pkId, String fileKey) throws Exception {
        ArrayList attachmentInfos = Lists.newArrayListWithExpectedSize((int)attachmentFileMsgs.size());
        for (Map<String, Object> attachMsg : attachmentFileMsgs) {
            String filePath = (String)attachMsg.get("url");
            HashMap newFileMsg = Maps.newHashMapWithExpectedSize((int)attachMsg.size());
            newFileMsg.putAll(attachMsg);
            newFileMsg.put("uid", ID.genStringId());
            newFileMsg.put("url", filePath);
            newFileMsg.put("entityNum", entity);
            newFileMsg.put("billPkId", pkId);
            newFileMsg.put("lastModified", null);
            attachmentInfos.add(newFileMsg);
        }
        HashMap saveMap = Maps.newHashMapWithExpectedSize((int)1);
        saveMap.put(fileKey, attachmentInfos);
        DynamicObjectCollection collection = AttachmentServiceHelper.saveTempAttachments((String)entity, (Object)pkId, (String)appId, (Map)saveMap);
        if (collection.size() != attachmentFileMsgs.size()) {
            HireAttachmentFileService.removeAllFile(entity, pkId, fileKey);
            logger.error("HireAttachmentFileService.copyAttachmentFileByAttachMsgForNew copy file error");
            throw new KDException(new ErrorCode("", "copy file error"), new Object[]{"copy file error"});
        }
    }

    public static void copyAttachmentFileByAttachMsgForLoad(List<Map<String, Object>> attachmentFileMsgs, String appId, String entity, Object pkId, String fileKey) throws Exception {
        ArrayList attachmentInfos = Lists.newArrayListWithExpectedSize((int)attachmentFileMsgs.size());
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (Map<String, Object> attachMsg : attachmentFileMsgs) {
            Long createTimestamp = (Long)attachMsg.get("createdate");
            String filePath = (String)attachMsg.get("url");
            URL soapUrl = null;
            URLConnection conn = null;
            InputStream inputStream = null;
            try {
                soapUrl = new URL(filePath);
                conn = soapUrl.openConnection();
                inputStream = conn.getInputStream();
                String tempFileUrl = fileCache.saveAsFullUrl(ID.genStringId(), inputStream, 60);
                HashMap newFileMsg = Maps.newHashMapWithExpectedSize((int)attachMsg.size());
                newFileMsg.put("name", attachMsg.get("name"));
                newFileMsg.put("size", attachMsg.get("size"));
                newFileMsg.put("status", attachMsg.get("status"));
                newFileMsg.put("type", attachMsg.get("type"));
                newFileMsg.put("uid", ID.genStringId());
                newFileMsg.put("url", tempFileUrl);
                newFileMsg.put("uploadTime", createTimestamp);
                newFileMsg.put("entityNum", entity);
                newFileMsg.put("billPkId", pkId);
                newFileMsg.put("client", "web");
                newFileMsg.put("createdate", createTimestamp);
                newFileMsg.put("creator", attachMsg.get("creator"));
                newFileMsg.put("endProgress", Boolean.TRUE);
                newFileMsg.put("lastModified", null);
                attachmentInfos.add(newFileMsg);
            }
            catch (Exception e) {
                HireAttachmentFileService.removeAllFile(entity, pkId, fileKey);
                logger.error("HireAttachmentFileService.copyAttachmentFileByAttachMsgForLoad copy file error");
                throw new KDException((Throwable)e, new ErrorCode("", "copy file error"), new Object[]{"copy file error"});
            }
            finally {
                try {
                    if (null == inputStream) continue;
                    inputStream.close();
                }
                catch (Exception e) {
                    logger.error("HireAttachmentFileService.copyAttachmentFileByAttachMsgForLoad copy file error");
                }
            }
        }
        HashMap saveMap = Maps.newHashMapWithExpectedSize((int)1);
        saveMap.put(fileKey, attachmentInfos);
        DynamicObjectCollection collection = AttachmentServiceHelper.saveTempAttachments((String)entity, (Object)pkId, (String)appId, (Map)saveMap);
        if (collection.size() != attachmentFileMsgs.size()) {
            HireAttachmentFileService.removeAllFile(entity, pkId, fileKey);
            logger.error("HireAttachmentFileService.copyAttachmentFileByAttachMsgForLoad copy file error");
            throw new KDException(new ErrorCode("", "copy file error"), new Object[]{"copy file error"});
        }
    }
}

