/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.hire.common.HireAppFileDataUpdateService;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireDataHelper {
    private static final Log LOG = LogFactory.getLog(HireDataHelper.class);

    public static Map<String, Integer> getHandleStatusNumByHire(String entity, Long appFileId) {
        HashMap statusNum = Maps.newHashMapWithExpectedSize((int)5);
        statusNum.put("S", 0);
        statusNum.put("W", 0);
        statusNum.put("A", 0);
        statusNum.put("I", 0);
        statusNum.put("C", 0);
        HRBaseServiceHelper hireService = ServiceHelperCache.getHrBaseServiceHelper((String)entity);
        QFilter filter = new QFilter("appfile", "=", (Object)appFileId);
        DataSet data = hireService.queryDataSet("getHandleStatusNumByHire_0", "handlestatus", filter.toArray());
        GroupbyDataSet groupbyDataSet = data.groupBy(new String[]{"handlestatus"});
        DataSet finish = groupbyDataSet.count("count").finish();
        for (Row row : finish) {
            statusNum.put(row.getString("handlestatus"), row.getInteger("count"));
        }
        try {
            finish.close();
            data.close();
        }
        catch (Exception e) {
            LOG.error("HireDataHelper.getHandleStatusNumByHire close dataset error", (Throwable)e);
        }
        return statusNum;
    }

    public static DynamicObject[] getNeedInvalidDyByHire(String entity, List<DynamicObject> hireDys) {
        DynamicObject[] hireDysFromDB;
        if (hireDys == null || hireDys.isEmpty()) {
            return new DynamicObject[0];
        }
        HashSet allAppFileIds = Sets.newHashSetWithExpectedSize((int)hireDys.size());
        hireDys.forEach(hireDy -> allAppFileIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDy, (String)"appfile")));
        HRBaseServiceHelper hireService = ServiceHelperCache.getHrBaseServiceHelper((String)entity);
        QFilter handlerQFilter = new QFilter("handlestatus", "=", (Object)"S");
        QFilter appFileQFilter = new QFilter("appfile", "in", (Object)allAppFileIds);
        for (DynamicObject hireDy2 : hireDysFromDB = hireService.loadDynamicObjectArray(new QFilter[]{handlerQFilter, appFileQFilter})) {
            hireDy2.set("handlestatus", (Object)"A");
        }
        return hireDysFromDB;
    }

    public static Map<Long, DynamicObject> getSuccessHireDyn(String entity, List<Long> appFileIds) {
        if (appFileIds == null || appFileIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap appFileIdAndSuccessDy = Maps.newHashMapWithExpectedSize((int)appFileIds.size());
        appFileIds.forEach(aLong -> {
            DynamicObject cfr_ignored_0 = appFileIdAndSuccessDy.put(aLong, null);
        });
        QFilter appFileQFilter = new QFilter("appfile", "in", appFileIds);
        QFilter statusQFilter = new QFilter("handlestatus", "=", (Object)"S");
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entity);
        DynamicObject[] hireDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{appFileQFilter, statusQFilter});
        for (int i = 0; i < hireDys.length; ++i) {
            DynamicObject hireDy = hireDys[i];
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDy, (String)"appfile");
            appFileIdAndSuccessDy.put(appFileId, hireDy);
        }
        return appFileIdAndSuccessDy;
    }

    public static Map<Long, DynamicObject> getLatestHireHireDynByAppFileId(String entity, List<Long> appFileIds, List<String> selectColumn) {
        if (appFileIds == null) {
            return Collections.emptyMap();
        }
        if (selectColumn == null) {
            selectColumn = Lists.newArrayList();
        }
        if (!selectColumn.contains("createtime")) {
            selectColumn.add("createtime");
        }
        if (!selectColumn.contains("appfile")) {
            selectColumn.add("appfile");
        }
        String queryColumn = String.join((CharSequence)",", selectColumn);
        String orderBy = "appfile DESC,createtime DESC";
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)appFileIds.size());
        QFilter appFileFilter = new QFilter("appfile", "in", appFileIds);
        LOG.info("HireDataHelper.getLatestHireHireDynByAppFileId query filter {}", (Object)appFileFilter);
        HRBaseServiceHelper dbServiceHire = new HRBaseServiceHelper(entity);
        DataSet dataSet = dbServiceHire.queryDataSet("getLatestHireHireDynByAppFileId_1", queryColumn, appFileFilter.toArray(), orderBy);
        Long lastAppFileId = 0L;
        Date lastDate = null;
        try {
            lastDate = HRDateTimeUtils.parseDate((String)"1900-01-01");
        }
        catch (ParseException e) {
            LOG.error("HireDataHelper.getLatestHireHireDynByAppFileId error data convert", (Throwable)e);
        }
        for (Row row : dataSet) {
            Long appFile = row.getLong("appfile");
            LOG.info("HireDataHelper.getLatestHireHireDynByAppFileId row loop appFileId:{}", (Object)appFile);
            if (appFile == null || appFile.equals(0L)) continue;
            Date date = row.getDate("createtime");
            LOG.info("HireDataHelper.getLatestHireHireDynByAppFileId row loop date:{}", (Object)date);
            if (appFile.equals(lastAppFileId) && lastDate.compareTo(date) == 0) {
                KDBizException ex = new KDBizException("error data.hire  had same createTime and appFileId");
                LOG.error("HireDataHelper.getLatestHireHireDynByAppFileId  error data.hire  had same createTime and appFileId", (Throwable)ex);
                throw ex;
            }
            if (!appFile.equals(lastAppFileId)) {
                DynamicObject dyn = dbServiceHire.generateEmptyDynamicObject();
                for (String column : selectColumn) {
                    dyn.set(column, row.get(column));
                }
                returnData.put(appFile, dyn);
            }
            lastAppFileId = appFile;
            lastDate = date;
        }
        return returnData;
    }

    public static Long getJobScmIdFromJobId(Long jobId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        DynamicObject jobDyn = serviceHelper.queryOne("jobscm", (Object)jobId);
        if (jobDyn == null) {
            return null;
        }
        return HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)jobDyn, (String)"jobscm");
    }

    public static DynamicObject[] extendedDataEntityToDynamicObjectArr(ExtendedDataEntity[] dataEntities, Map<Long, DynamicObject> idAndAppFileDys) {
        int index = dataEntities.length;
        DynamicObject[] dyArr = new DynamicObject[dataEntities.length];
        for (int i = 0; i < index; ++i) {
            DynamicObject dy;
            dyArr[i] = dy = dataEntities[i].getDataEntity();
            DynamicObject appFileDy = dy.getDynamicObject("appfile");
            Long id = (Long)dy.getPkValue();
            idAndAppFileDys.put(id, appFileDy);
        }
        return dyArr;
    }

    public static void saveHireData(String entity, DynamicObject[] saveDys, DynamicObject[] updateDys) {
        LOG.info("HireDataHelper.saveHireData begin {}", (Object)entity);
        if (saveDys == null) {
            saveDys = new DynamicObject[]{};
        }
        if (updateDys == null) {
            updateDys = new DynamicObject[]{};
        }
        HRBaseServiceHelper hireService = ServiceHelperCache.getHrBaseServiceHelper((String)entity);
        try (TXHandle tx = TX.required();){
            if (saveDys != null && saveDys.length > 0) {
                hireService.save(saveDys);
            }
            if (updateDys != null && updateDys.length > 0) {
                hireService.update(updateDys);
            }
            ArrayList updateAppFileDy = Lists.newArrayListWithExpectedSize((int)(saveDys.length + updateDys.length));
            updateAppFileDy.addAll(Lists.newArrayList((Object[])saveDys));
            updateAppFileDy.addAll(Lists.newArrayList((Object[])updateDys));
            if (HRStringUtils.equals((String)entity, (String)"tspr_jobrank")) {
                HireAppFileDataUpdateService.updateJobRank(updateAppFileDy);
            } else if (HRStringUtils.equals((String)entity, (String)"tspr_hiresalary")) {
                HireAppFileDataUpdateService.updateSalary(updateAppFileDy);
            }
        }
        LOG.info("HireDataHelper.saveHireData succes");
    }

    public static String checkInProcess(String entity, DynamicObject hireBill, String errorMsg) {
        if (HRObjectUtils.isEmpty((Object)hireBill)) {
            return HireCommonKDStringHelper.missData();
        }
        HRBaseServiceHelper hireBillService = new HRBaseServiceHelper(entity);
        DynamicObject hireDataDy = hireBillService.queryOne((Object)hireBill.getLong("id"));
        String string = hireDataDy.getString("handlestatus");
        if (!HRStringUtils.equals((String)string, (String)"I")) {
            DynamicObject userDy = hireDataDy.getDynamicObject("modifier");
            return String.format(Locale.ROOT, errorMsg, userDy.getString("name"));
        }
        return null;
    }
}

