/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFParticipantEntity;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.thread.HireThreadPoolHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFAuditInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFProcessInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFUserInfo;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowImpl;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowInterface;

public class HireFreeWorkFlowService {
    private static final Log logger = LogFactory.getLog(HireFreeWorkFlowService.class);
    public static final String CONSENT = "Consent";
    private static FreeFlowInterface freeFlow = FreeFlowImpl.freeFlowImpl;

    public static void buildHireTask(final DynamicObject[] hireDyns, final String targetPage) {
        HireThreadPoolHelper.runApprovalTask(new Runnable(){

            @Override
            public void run() {
                DynamicObject[] upDateDyns;
                HashMap idAndFreeWorkMap = Maps.newHashMapWithExpectedSize((int)hireDyns.length);
                ArrayList hireIds = Lists.newArrayListWithExpectedSize((int)hireDyns.length);
                for (DynamicObject hireDyn : hireDyns) {
                    WFProcess wfProcess = freeFlow.initProcess(WFProcessInfo.init().setEntraBill(hireDyn.getString("billno")).setEntraBillId(hireDyn.getString("id")).setEntraBillName(hireDyn.getString("name")));
                    WFUserTask wfUserTask = freeFlow.initWFUserTask(wfProcess, WFUserInfo.init());
                    wfProcess.addNextNode((WFFlowNode)wfUserTask);
                    ArrayList<WFParticipantEntity> participant = new ArrayList<WFParticipantEntity>();
                    DynamicObject person = hireDyn.getDynamicObject("handler");
                    String personId = person.getLong("id") + "";
                    participant.add(HireFreeWorkFlowService.setParticipant(personId));
                    logger.debug("HireFreeWorkFlowService.buildHireTask send personId,{}", (Object)personId);
                    HashMap extPropMap = Maps.newHashMapWithExpectedSize((int)1);
                    HashMap extPropMapDetail = Maps.newHashMapWithExpectedSize((int)1);
                    extPropMapDetail.put("processingPage", targetPage);
                    extPropMap.put("properties", extPropMapDetail);
                    WFAuditInfo wfAuditInfo = WFAuditInfo.init().setParticipant(participant).setFormKey(targetPage).setExtProps((Map)extPropMap).setDecisionOptions(HireFreeWorkFlowService.initWFDecisionOptions());
                    WFAuditTask wfAuditTask = freeFlow.initWFAuditTask(wfProcess, wfAuditInfo);
                    wfUserTask.addNextNode((WFFlowNode)wfAuditTask);
                    idAndFreeWorkMap.put(hireDyn.getLong("id"), wfAuditTask.getId());
                    hireIds.add(hireDyn.getLong("id"));
                    freeFlow.startFreeFlow(targetPage, wfProcess.getEntraBillId(), wfProcess, "submit", (Map)Maps.newHashMap());
                }
                HRBaseServiceHelper targetPageService = new HRBaseServiceHelper(targetPage);
                for (DynamicObject upDateDyn : upDateDyns = targetPageService.loadDynamicObjectArray(new QFilter("id", "in", (Object)hireIds).toArray())) {
                    upDateDyn.set("flowtasknum", idAndFreeWorkMap.get(upDateDyn.getLong("id")));
                }
                targetPageService.update(upDateDyns);
            }
        });
    }

    public static void completeTaskByHireId(List<Long> hireIds, String entity) {
        DynamicObject[] hireDys;
        for (DynamicObject hireDy : hireDys = ServiceHelperCache.getHrBaseServiceHelper((String)entity).query("id,flowtasknum", new QFilter("id", "in", hireIds).toArray())) {
            HireFreeWorkFlowService.completeTask(hireDy.getLong("id") + "", hireDy.getString("flowtasknum"));
        }
    }

    public static void cancelTaskByHireId(List<Long> hireIds, String entity) {
        DynamicObject[] hireDys;
        for (DynamicObject hireDy : hireDys = ServiceHelperCache.getHrBaseServiceHelper((String)entity).query("id,billno", new QFilter("id", "in", hireIds).toArray())) {
            WorkflowServiceHelper.abandonByBusienssKey((String)hireDy.getString("id"));
        }
    }

    private static void completeTask(String billId, String workFlowNum) {
        freeFlow.completeTask(billId, workFlowNum, Long.valueOf(TSCRequestContext.getUserId()), CONSENT, HireFreeWorkFlowService.getAgree(), false);
    }

    private static WFParticipantEntity setParticipant(String dealPersonId) {
        WFParticipantEntity paritcipant = new WFParticipantEntity();
        paritcipant.setType("person");
        paritcipant.setValue(dealPersonId);
        return paritcipant;
    }

    private static List<WFDecisionOption> initWFDecisionOptions() {
        ArrayList<WFDecisionOption> decisionOptions = new ArrayList<WFDecisionOption>();
        WFDecisionOption agreeOption = new WFDecisionOption();
        agreeOption.setAuditType("approve");
        agreeOption.setDefaultDecision(true);
        agreeOption.setNumber(CONSENT);
        LocaleString localeString = new LocaleString();
        localeString.put(Lang.zh_CN.name(), (Object)HireFreeWorkFlowService.getAgree());
        agreeOption.setName(localeString);
        decisionOptions.add(agreeOption);
        return decisionOptions;
    }

    private static String getAgree() {
        return HireCommonKDStringHelper.agreeStr();
    }
}

