/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.hire.common.HireHandleKeyFieldChangeKDStringHelper;

public class HireHandleKeyFieldChangeService {
    private static final String DELIMITER = "\u3001";
    public static final String BASE_DATA_DIRTY_FIX = "_id";
    private static final Map<String, String> JOBRANKMAP = Maps.newHashMap();
    private static final Map<String, String> SALARYMAP = Maps.newHashMap();
    private static final Map<String, String> APPROVALMAP = Maps.newHashMap();

    public static String jobRankHandleKeyFieldChange(DynamicObject dy) {
        return HireHandleKeyFieldChangeService.handleKeyFieldChange(dy, JOBRANKMAP);
    }

    public static String salaryHandleKeyFieldChange(DynamicObject dy) {
        return HireHandleKeyFieldChangeService.handleKeyFieldChange(dy, SALARYMAP);
    }

    public static Map<Long, String> approvalHandleKeyFieldChange(DynamicObject[] dyArr) {
        HashMap supplementMap = Maps.newHashMapWithExpectedSize((int)dyArr.length);
        for (DynamicObject dy : dyArr) {
            DynamicObject appFileDy = dy.getDynamicObject("appfile");
            if (appFileDy == null) continue;
            String auditStatus = dy.getString("billstatus");
            if (HRStringUtils.equals((String)auditStatus, (String)"G") || HRStringUtils.equals((String)auditStatus, (String)"A")) {
                supplementMap.put(appFileDy.getLong("id"), HireHandleKeyFieldChangeService.handleKeyFieldChange(dy, APPROVALMAP));
                continue;
            }
            supplementMap.put(appFileDy.getLong("id"), null);
        }
        return supplementMap;
    }

    private static String handleKeyFieldChange(DynamicObject dy, Map<String, String> map) {
        Iterable bizChangedProperties = dy.getDataEntityState().getBizChangedProperties();
        Iterator bizChangeProps = bizChangedProperties.iterator();
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        while (bizChangeProps.hasNext()) {
            IDataEntityProperty next = (IDataEntityProperty)bizChangeProps.next();
            String key = next.getName();
            if (!map.containsKey(key)) continue;
            list.add(map.get(key));
            if (!HRStringUtils.equals((String)key, (String)"formalcurrency_id")) continue;
            list.add(HireHandleKeyFieldChangeKDStringHelper.feeCurrency());
            list.add(HireHandleKeyFieldChangeKDStringHelper.probCurrency());
        }
        return list.size() > 0 ? String.join((CharSequence)DELIMITER, list) : null;
    }

    static {
        JOBRANKMAP.put("position_id", HireHandleKeyFieldChangeKDStringHelper.position());
        JOBRANKMAP.put("dept_id", HireHandleKeyFieldChangeKDStringHelper.dept());
        JOBRANKMAP.put("jobscm_id", HireHandleKeyFieldChangeKDStringHelper.jobScm());
        JOBRANKMAP.put("job_id", HireHandleKeyFieldChangeKDStringHelper.job());
        JOBRANKMAP.put("joblevel_id", HireHandleKeyFieldChangeKDStringHelper.jobLevel());
        JOBRANKMAP.put("jobgrade_id", HireHandleKeyFieldChangeKDStringHelper.jobGradle());
        JOBRANKMAP.put("workaddr_id", HireHandleKeyFieldChangeKDStringHelper.workAddr());
        JOBRANKMAP.put("posttype_id", HireHandleKeyFieldChangeKDStringHelper.postType());
        JOBRANKMAP.put("labrelstatuscls_id", HireHandleKeyFieldChangeKDStringHelper.labRelStatusCls());
        JOBRANKMAP.put("isprobation", HireHandleKeyFieldChangeKDStringHelper.isProbation());
        JOBRANKMAP.put("probationnum", HireHandleKeyFieldChangeKDStringHelper.proBationNum());
        SALARYMAP.put("formalcurrency_id", HireHandleKeyFieldChangeKDStringHelper.formalCurrency());
        SALARYMAP.put("basicwage", HireHandleKeyFieldChangeKDStringHelper.basicWage());
        SALARYMAP.put("positionwage", HireHandleKeyFieldChangeKDStringHelper.positionWage());
        SALARYMAP.put("achievementwage", HireHandleKeyFieldChangeKDStringHelper.achievementWage());
        SALARYMAP.put("yearendbonus", HireHandleKeyFieldChangeKDStringHelper.yearEndBonus());
        SALARYMAP.put("trafficfee", HireHandleKeyFieldChangeKDStringHelper.trafficFee());
        SALARYMAP.put("restaurantfee", HireHandleKeyFieldChangeKDStringHelper.restaurantFee());
        SALARYMAP.put("communicationfee", HireHandleKeyFieldChangeKDStringHelper.communicationFee());
        SALARYMAP.put("rentfee", HireHandleKeyFieldChangeKDStringHelper.rentFee());
        SALARYMAP.put("housingfee", HireHandleKeyFieldChangeKDStringHelper.housingFee());
        SALARYMAP.put("rssharnum", HireHandleKeyFieldChangeKDStringHelper.rssHarNum());
        SALARYMAP.put("yearsharnum", HireHandleKeyFieldChangeKDStringHelper.yearsHarNum());
        SALARYMAP.put("opsharnum", HireHandleKeyFieldChangeKDStringHelper.opsHarNum());
        SALARYMAP.put("opvalnum", HireHandleKeyFieldChangeKDStringHelper.opvalNum());
        SALARYMAP.put("probmonthlysalary", HireHandleKeyFieldChangeKDStringHelper.probMonthlySalary());
        APPROVALMAP.putAll(JOBRANKMAP);
        APPROVALMAP.putAll(SALARYMAP);
    }
}

