/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.position.service.HbssJobAdapter;
import kd.tsc.tspr.common.enums.TSPRPreDataEnum;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.ControlledDataCommonHelper;

public class HireQFilterService {
    public static List<QFilter> getPosttypeFilter() {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)1);
        filters.add(new QFilter("postcategory", "in", (Object)Lists.newArrayList((Object[])new Long[]{TSPRPreDataEnum.POSTCATEGORY_FULLTIME.getId(), TSPRPreDataEnum.POSTCATEGORY_PARTTIME.getId()})));
        return filters;
    }

    public static List<QFilter> getLaborrelTypeClsFilter() {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)3);
        QFilter syspresetQfilter = new QFilter("enable", "=", (Object)"1");
        filters.add(syspresetQfilter);
        return filters;
    }

    public static List<QFilter> getPositionFilter(Long appFileId) {
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appFileDyn = appFileService.queryOne("adminorg", (Object)appFileId);
        if (appFileDyn == null) {
            return Collections.singletonList(new QFilter("id", "=", (Object)0));
        }
        Long adminOrgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)appFileDyn, (String)"adminorg");
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)3);
        if (adminOrgId.equals(0L)) {
            filters.add(new QFilter("id", "=", (Object)0L));
            return filters;
        }
        filters.add(new QFilter("adminorg", "=", (Object)adminOrgId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        return filters;
    }

    public static List<QFilter> getGradeFilter(DynamicObject job) {
        ArrayList returnQFilters = Lists.newArrayList();
        Long low = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"lowjobgrade");
        Long height = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"highjobgrade");
        if (low.equals(0L) || height.equals(0L)) {
            QFilter unMatchQFilter = new QFilter("id", "=", (Object)0L);
            returnQFilters.add(unMatchQFilter);
            return returnQFilters;
        }
        List<Long> gradeRangeByGradeId = HbssJobAdapter.getJobGradeRangeByGradeId(job.getLong("id"));
        if (gradeRangeByGradeId != null && !gradeRangeByGradeId.isEmpty()) {
            returnQFilters.add(new QFilter("id", "in", gradeRangeByGradeId));
        } else {
            returnQFilters.add(new QFilter("id", "=", (Object)0L));
        }
        return returnQFilters;
    }

    public static List<QFilter> getLevelFilter(DynamicObject job) {
        ArrayList returnQFilters = Lists.newArrayList();
        Long low = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"lowjoblevel");
        Long height = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)job, (String)"highjoblevel");
        if (low.equals(0L) || height.equals(0L)) {
            QFilter unMatchQFilter = new QFilter("id", "=", (Object)0L);
            returnQFilters.add(unMatchQFilter);
            return returnQFilters;
        }
        List<Long> jobLevelRangeByLevelId = HbssJobAdapter.getJobLevelRangeByLevelId(job.getLong("id"));
        if (jobLevelRangeByLevelId != null && !jobLevelRangeByLevelId.isEmpty()) {
            returnQFilters.add(new QFilter("id", "in", jobLevelRangeByLevelId));
        } else {
            returnQFilters.add(new QFilter("id", "=", (Object)0L));
        }
        return returnQFilters;
    }

    public static List<QFilter> getSocAreaFilter(Long appFileId) {
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appFileDyn = appFileService.queryOne("createorg", (Object)appFileId);
        if (appFileDyn != null) {
            return ControlledDataCommonHelper.getEnableAndPassStatusQFilter((String)"hbpm", (String)"hbss_socarea", (Long)appFileDyn.getLong("createorg.id"));
        }
        return Collections.singletonList(new QFilter("id", "=", (Object)0));
    }

    public static List<QFilter> getJobScmFilter(Long appFileId) {
        return Collections.emptyList();
    }

    public static List<QFilter> getJobFilter(Long jobScmId) {
        QFilter qFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        return Lists.newArrayList((Object[])new QFilter[]{qFilter});
    }

    public static List<QFilter> getJobRankAdminOrgFilter(String appId, String entityNumber) {
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)appId, (String)entityNumber, (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"id");
        return userAdminOrgFilter == null ? Collections.emptyList() : Collections.singletonList(userAdminOrgFilter);
    }
}

