/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileHireHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileService;
import kd.tsc.tspr.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.common.HireOpRecordService;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tspr.common.constants.hire.HireInitDataConstants;
import kd.tsc.tspr.common.hire.HireVerifyResult;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.TscHrPersonHelper;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class HireService {
    public static Map<Long, DynamicObject> getRandomDeptCharge(List<Long> appFileIds) {
        return Collections.emptyMap();
    }

    public static Map<Long, Long> getAppFileIdAndOrgMap(List<Long> appFileIds) {
        DynamicObject[] appFileDys;
        HashMap result = Maps.newHashMapWithExpectedSize((int)appFileIds.size());
        String org = "createorg.id";
        for (DynamicObject appFileDy : appFileDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile").query(org, new QFilter("id", "in", appFileIds).toArray())) {
            result.put(appFileDy.getLong("id"), appFileDy.getLong(org));
        }
        return result;
    }

    public static boolean verifyHirePerm(List<Long> appFileIds, String permItem) {
        Map<Long, Boolean> perms = AppFileRightHelper.hasRight(appFileIds, "tssrm", (Long)TSCRequestContext.getUserId(), permItem);
        Collection<Boolean> values = perms.values();
        for (Boolean value : values) {
            if (value.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void initHireCommonMsg(List<DynamicObject> hireDys, String entity, boolean isDirect) {
        if (hireDys == null || hireDys.isEmpty()) {
            return;
        }
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        long[] genLongIds = ORM.create().genLongIds(entity, hireDys.size());
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (int i = 0; i < hireDys.size(); ++i) {
            String type;
            DynamicObject hireDy = hireDys.get(i);
            DataEntityPropertyCollection dpc = hireDy.getDataEntityType().getProperties();
            Set<String> allFields = dpc.stream().map(IMetadata::getName).collect(Collectors.toSet());
            long pkId = hireDy.getLong("id");
            if (pkId == 0L) {
                HireService.setValIfDyExistName(hireDy, "id", (Object)genLongIds[i], allFields);
            }
            HireService.setValIfDyExistName(hireDy, "createtime", (Object)now, allFields);
            HireService.setValIfDyExistName(hireDy, "creator", (Object)TSCRequestContext.getUserId(), allFields);
            HireService.setValIfDyExistName(hireDy, "modifytime", (Object)now, allFields);
            HireService.setValIfDyExistName(hireDy, "modifier", (Object)TSCRequestContext.getUserId(), allFields);
            String handleStatus = isDirect ? "S" : "I";
            HireService.setValIfDyExistName(hireDy, "handlestatus", (Object)handleStatus, allFields);
            String string = type = isDirect ? "D" : "S";
            if (isDirect) {
                HireService.setValIfDyExistName(hireDy, "handler", (Object)TSCRequestContext.getUserId(), allFields);
                HireService.setValIfDyExistName(hireDy, "handletime", (Object)now, allFields);
            }
            HireService.setValIfDyExistName(hireDy, "type", (Object)type, allFields);
            DynamicObject appFileDyn = hireDy.getDynamicObject("appfile");
            if (appFileDyn == null) continue;
            DynamicObject appFileFull = appFileService.queryOriginalOne("createorg,adminorg", appFileDyn.getPkValue());
            Long createOrgId = appFileFull.getLong("createorg");
            HireService.setValIfDyExistName(hireDy, "createorg", (Object)createOrgId, allFields);
            Long adminOrgId = appFileFull.getLong("adminorg");
            HireService.setValIfDyExistName(hireDy, "adminorg", (Object)adminOrgId, allFields);
        }
    }

    public static void setValIfDyExistName(DynamicObject hireDy, String key, Object val, Set<String> allFields) {
        if (allFields.contains(key) || "id".equals(key)) {
            hireDy.set(key, val);
        }
    }

    public static void setValIfDyExistName(DynamicObject hireDy, String key, Object val, DataEntityPropertyCollection fileList) {
        if (fileList.contains((Object)key) || "id".equals(key)) {
            hireDy.set(key, val);
        }
    }

    public static void changeDyToCancelStatus(DynamicObject[] hireDys) {
        if (hireDys == null) {
            return;
        }
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Long userId = TSCRequestContext.getUserId();
        for (DynamicObject hireDy : hireDys) {
            hireDy.set("modifytime", (Object)now);
            hireDy.set("modifier", (Object)userId);
            hireDy.set("handlestatus", (Object)"C");
        }
    }

    public static String serializerOperationResult(OperationResult operationResult) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        return DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
    }

    public static void copyHireSalaryExptValToHireDyn(List<DynamicObject> hireDys, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (hireDys == null || hireDys.isEmpty()) {
            return;
        }
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)hireDys.size());
        for (DynamicObject hireDy : hireDys) {
            appFileIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDy, (String)"appfile"));
        }
        QFilter filter = new QFilter("appfile", "in", (Object)appFileIds);
        DynamicObject[] salaryExptDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_hiresalaryexpt").loadDynamicObjectArray(filter.toArray());
        block1: for (DynamicObject hireDy : hireDys) {
            Long hireDyAppFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDy, (String)"appfile");
            for (DynamicObject salaryExptDy : salaryExptDys) {
                salaryExptDy.set("salaryexptcur", salaryExptDy.get("currency"));
                Long salaryExptAppFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)salaryExptDy, (String)"appfile");
                if (!hireDyAppFileId.equals(salaryExptAppFileId)) continue;
                HRDynamicObjectUtils.copy((DynamicObject)salaryExptDy, (DynamicObject)hireDy, ignoreKeys, transKeyMap);
                continue block1;
            }
        }
    }

    public static Map<Long, DynamicObject> getFullPositionDyns(List<Long> positionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        DynamicObject[] positionDyns = serviceHelper.loadDynamicObjectArray(positionIds.toArray());
        HashMap fullPosition = Maps.newHashMapWithExpectedSize((int)positionDyns.length);
        for (DynamicObject positionDyn : positionDyns) {
            fullPosition.put(positionDyn.getLong("id"), positionDyn);
        }
        return fullPosition;
    }

    public static boolean judgeLinkJobByPositionDyn(DynamicObject positionDyn) {
        if (positionDyn == null) {
            return false;
        }
        Long jobId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDyn, (String)"job");
        return !jobId.equals(0L);
    }

    public static HireVerifyResult mergeVerifyAppFileConditionResult(HireVerifyResult ... hireVerifyResults) {
        HireVerifyResult[] resultsArr = hireVerifyResults;
        HireVerifyResult allVerify = new HireVerifyResult();
        HashSet successAppFileIds = Sets.newHashSetWithExpectedSize((int)resultsArr.length);
        HashSet failAppFileIds = Sets.newHashSetWithExpectedSize((int)resultsArr.length);
        HashMap failReason = Maps.newHashMapWithExpectedSize((int)resultsArr.length);
        for (HireVerifyResult eachVerify : hireVerifyResults) {
            successAppFileIds.addAll(eachVerify.getSuccessAppFileId());
        }
        for (HireVerifyResult eachVerify : hireVerifyResults) {
            successAppFileIds.removeAll(eachVerify.getFailAppFileId());
            failAppFileIds.addAll(eachVerify.getFailAppFileId());
            Map eachVerifyFailReason = eachVerify.getFailReason();
            for (Map.Entry entry : eachVerifyFailReason.entrySet()) {
                Long appFileId = (Long)entry.getKey();
                List reason = (List)entry.getValue();
                List allReason = (List)failReason.get(appFileId);
                if (allReason != null) {
                    allReason.addAll(reason);
                    failReason.put(appFileId, allReason);
                    continue;
                }
                failReason.put(appFileId, reason);
            }
        }
        allVerify.setSuccessAppFileId((Set)successAppFileIds);
        allVerify.setFailAppFileId((Set)failAppFileIds);
        allVerify.setFailReason((Map)failReason);
        return allVerify;
    }

    public static HireVerifyResult verifyAppFileStatus(List<DynamicObject> appFileDyns) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)appFileDyns.size());
        appFileDyns.forEach(appFileDyn -> appFileIds.add(appFileDyn.getLong("id")));
        ValidateResult validateResult = AppFileService.getInstance().validateAppFileInProcessAndLocked(appFileIds, ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"HireCommonKDStringHelper_33", (String)"tsc-tspr-business", (Object[])new Object[0]));
        HireVerifyResult verifyResult = HireService.convertValidateResultToHireVerifyResult(validateResult);
        return verifyResult;
    }

    public static HireVerifyResult verifyAppFileStatusWithMsg(List<DynamicObject> appFileDyns, String errorMsg) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)appFileDyns.size());
        appFileDyns.forEach(appFileDyn -> appFileIds.add(appFileDyn.getLong("id")));
        ValidateResult validateResult = AppFileService.getInstance().validateAppFileInProcessAndLocked(appFileIds, errorMsg);
        HireVerifyResult verifyResult = HireService.convertValidateResultToHireVerifyResult(validateResult);
        return verifyResult;
    }

    public static HireVerifyResult verifyAppFileBlackList(List<DynamicObject> appFileDyns, String opName, String ... blackListStr) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)appFileDyns.size());
        HashMap appFileNameMap = Maps.newHashMapWithExpectedSize((int)appFileDyns.size());
        appFileDyns.forEach(appFileDyn -> {
            appFileIds.add(appFileDyn.getLong("id"));
            appFileNameMap.put(appFileDyn.getLong("id"), appFileDyn.getString("name"));
        });
        Map<Long, Boolean> longBooleanMap = HireService.checkBlackList(appFileIds);
        HireVerifyResult verifyResult = new HireVerifyResult();
        if (longBooleanMap == null) {
            return verifyResult;
        }
        HashSet successIds = Sets.newHashSet();
        HashSet failIds = Sets.newHashSet();
        HashMap failReason = Maps.newHashMap();
        longBooleanMap.forEach((key, value) -> {
            if (value.booleanValue()) {
                failIds.add(key);
                String reason = blackListStr != null && blackListStr.length > 0 ? String.format(Locale.ROOT, blackListStr[0], opName) : String.format(HireCommonKDStringHelper.AppfileBlackListStr(), appFileNameMap.get(key), opName);
                ArrayList<String> rl = new ArrayList<String>();
                rl.add(reason);
                failReason.put(key, rl);
            } else {
                successIds.add(key);
            }
        });
        verifyResult.setFailAppFileId((Set)failIds);
        verifyResult.setFailReason((Map)failReason);
        verifyResult.setSuccessAppFileId((Set)successIds);
        return verifyResult;
    }

    public static HireVerifyResult convertValidateResultToHireVerifyResult(ValidateResult validateResult) {
        HireVerifyResult verifyResult = new HireVerifyResult();
        if (validateResult == null) {
            return verifyResult;
        }
        HashSet successIds = Sets.newHashSet();
        HashSet failIds = Sets.newHashSet();
        HashMap failReason = Maps.newHashMap();
        validateResult.getSuccessPkIds().forEach(successId -> successIds.add((Long)successId));
        List allErrorInfo = validateResult.getAllErrorInfo();
        if (allErrorInfo != null && !allErrorInfo.isEmpty()) {
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                Long id = (Long)errorInfo.getPkValue();
                failIds.add(id);
                List oldReason = (List)failReason.get(id);
                if (oldReason == null) {
                    oldReason = Lists.newArrayList();
                }
                oldReason.add(errorInfo.getMessage());
                failReason.put(id, oldReason);
            }
        }
        verifyResult.setSuccessAppFileId((Set)successIds);
        verifyResult.setFailAppFileId((Set)failIds);
        verifyResult.setFailReason((Map)failReason);
        return verifyResult;
    }

    public static ValidateResult convertHireVerifyResultToValidateResult(HireVerifyResult appFileVerify, List<DynamicObject> appFileList) {
        HashMap appFileIdAndNo = Maps.newHashMapWithExpectedSize((int)appFileList.size());
        for (DynamicObject appFileDy : appFileList) {
            appFileIdAndNo.put(appFileDy.getLong("id"), appFileDy.getString("number"));
        }
        ValidateResult validateResult = new ValidateResult();
        ArrayList successPkId = Lists.newArrayListWithExpectedSize((int)appFileVerify.getSuccessAppFileId().size());
        successPkId.addAll(appFileVerify.getSuccessAppFileId());
        validateResult.setSuccessPkIds((List)successPkId);
        ArrayList operateErrorInfos = Lists.newArrayListWithExpectedSize((int)appFileVerify.getFailAppFileId().size());
        Map failReason = appFileVerify.getFailReason();
        failReason.forEach((appFileId, reasonDetails) -> reasonDetails.forEach(reasonDetail -> {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue(appFileId);
            errorInfo.setMessage((String)appFileIdAndNo.get(appFileId) + ":" + reasonDetail);
            errorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfos.add(errorInfo);
        }));
        validateResult.setAllErrorInfo((List)operateErrorInfos);
        return validateResult;
    }

    public static OperationResult getOperationResult(HireVerifyResult hireVerifyResult) {
        OperationResult operationResult = new OperationResult();
        Set successAppFileId = hireVerifyResult.getSuccessAppFileId();
        Set failAppFileId = hireVerifyResult.getFailAppFileId();
        Map failReason = hireVerifyResult.getFailReason();
        operationResult.setSuccess(failAppFileId.isEmpty());
        operationResult.setBillCount(successAppFileId.size() + failAppFileId.size());
        ArrayList successIds = Lists.newArrayListWithExpectedSize((int)successAppFileId.size());
        successIds.addAll(successAppFileId);
        operationResult.setSuccessPkIds((List)successIds);
        if (failAppFileId.isEmpty()) {
            operationResult.setMessage(HireCommonKDStringHelper.opSuccess());
        }
        ArrayList failCollection = Lists.newArrayListWithExpectedSize((int)failAppFileId.size());
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject[] allAppFileDyns = appFileService.query("id,name", new QFilter("id", "in", (Object)failAppFileId).toArray());
        for (Long failCheckAppFileId : failAppFileId) {
            List detailReason;
            boolean findName = false;
            String failMsg = "";
            for (DynamicObject allAppFileDyn : allAppFileDyns) {
                Long appFileId = allAppFileDyn.getLong("id");
                if (!failCheckAppFileId.equals(appFileId)) continue;
                failMsg = allAppFileDyn.getString("name");
                findName = true;
                break;
            }
            if (!findName) {
                failMsg = failCheckAppFileId.toString();
            }
            if ((detailReason = (List)failReason.get(failCheckAppFileId)) != null) {
                failMsg = failMsg + ":" + String.join((CharSequence)";", detailReason);
            }
            failCollection.add(failMsg);
        }
        ArrayList errorInfos = Lists.newArrayListWithExpectedSize((int)failCollection.size());
        for (String failMsg : failCollection) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(failMsg);
            operateErrorInfo.setLevel(ErrorLevel.Error);
            errorInfos.add(operateErrorInfo);
        }
        operationResult.setAllErrorInfo((List)errorInfos);
        return operationResult;
    }

    public static void sendHireCancelMessage(DynamicObject[] billDys, String entity, String title, String tag, String MessageContentStr) {
        Long sendId = TSCRequestContext.getUserId();
        String userName = RequestContext.get().getUserName();
        ArrayList pkIds = Lists.newArrayListWithExpectedSize((int)billDys.length);
        for (DynamicObject billDy : billDys) {
            pkIds.add(billDy.getLong("id"));
        }
        DynamicObject[] handlerMsgs = ServiceHelperCache.getHrBaseServiceHelper((String)entity).query("handler", new QFilter("id", "in", (Object)pkIds).toArray());
        HashMap pkIdAndHandler = Maps.newHashMapWithExpectedSize((int)handlerMsgs.length);
        for (DynamicObject handlerMsg : handlerMsgs) {
            Long pkId = handlerMsg.getLong("id");
            DynamicObject handler = handlerMsg.getDynamicObject("handler");
            pkIdAndHandler.put(pkId, handler);
        }
        for (DynamicObject dy : billDys) {
            MessageInfo messageInfo = new MessageInfo();
            DynamicObject appFileDy = dy.getDynamicObject("appfile");
            String name = appFileDy.getString("name");
            LocaleString messageTitle = new LocaleString();
            messageTitle.setLocaleValue(name + title);
            messageInfo.setMessageTitle((ILocaleString)messageTitle);
            LocaleString messageContent = new LocaleString();
            messageContent.setLocaleValue(userName + MessageContentStr);
            messageInfo.setMessageContent((ILocaleString)messageContent);
            ArrayList userIds = Lists.newArrayListWithExpectedSize((int)1);
            DynamicObject handler = (DynamicObject)pkIdAndHandler.get(dy.getLong("id"));
            if (handler != null) {
                userIds.add(handler.getLong("id"));
            }
            messageInfo.setUserIds((List)userIds);
            messageInfo.setType("notice");
            messageInfo.setEntityNumber(entity);
            messageInfo.setTag(tag);
            messageInfo.setSenderId(sendId);
            messageInfo.setBizDataId(Long.valueOf(dy.getLong("id")));
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    public static void sendHireCompleteMessage(DynamicObject[] billDys, String entity, String title, String tag, String MessageContentStr) {
        Long sendId = TSCRequestContext.getUserId();
        for (DynamicObject dy : billDys) {
            MessageInfo messageInfo = new MessageInfo();
            DynamicObject appFileDy = dy.getDynamicObject("appfile");
            String name = appFileDy.getString("name");
            Long appFileId = appFileDy.getLong("id");
            LocaleString messageContent = new LocaleString();
            messageContent.setLocaleValue(name + MessageContentStr);
            messageInfo.setMessageContent((ILocaleString)messageContent);
            String clientUrl = UrlService.getDomainContextUrl();
            String url = clientUrl + "/index.html?formId=tssrm_appfile_viewm&pkId=" + appFileId + "&type=base";
            messageInfo.setContentUrl(url);
            LocaleString messageTitle = new LocaleString();
            messageTitle.setLocaleValue(name + title);
            messageInfo.setMessageTitle((ILocaleString)messageTitle);
            ArrayList userIds = Lists.newArrayListWithExpectedSize((int)1);
            userIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"creator"));
            messageInfo.setType("notice");
            messageInfo.setUserIds((List)userIds);
            messageInfo.setEntityNumber(entity);
            messageInfo.setSenderId(sendId);
            messageInfo.setTag(tag);
            messageInfo.setBizDataId(Long.valueOf(dy.getLong("id")));
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    public static List<DynamicObject> getAppFileInfo(List<Long> appFileIds) {
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject[] appFilesArr = appFileService.loadDynamicObjectArray(appFileIds.toArray());
        return Arrays.asList(appFilesArr);
    }

    public static HireVerifyResult verifyApprovalStatus(List<DynamicObject> appFileDyns, String msg) {
        return HireService.verifyApprovalStatusCommon(appFileDyns, HireInitDataConstants.getNohireApprovalstatus(), msg);
    }

    public static HireVerifyResult verifyApprovalStatusForEdit(List<DynamicObject> appFileDyns, String msg) {
        return HireService.verifyApprovalStatusCommon(appFileDyns, HireInitDataConstants.getNohireApprovalstatus(), msg);
    }

    public static HireVerifyResult verifyApprovalStatusForEdit(List<DynamicObject> appFileDyns) {
        return HireService.verifyApprovalStatusCommon(appFileDyns, HireInitDataConstants.getNohireApprovalstatus(), HireCommonKDStringHelper.verifyApprovalStatusForEditOperateError());
    }

    private static HireVerifyResult verifyApprovalStatusCommon(List<DynamicObject> appFileDyns, Set<String> set, String msg) {
        HireVerifyResult appFileResult = new HireVerifyResult();
        ArrayList appFileIdList = Lists.newArrayListWithExpectedSize((int)appFileDyns.size());
        for (DynamicObject appFileDyn : appFileDyns) {
            appFileIdList.add(appFileDyn.getLong("id"));
        }
        Map approvalStatusMap = (Map)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"hireApprovalServiceApi", (String)"getHireApprovalState", (Object[])new Object[]{appFileIdList});
        for (DynamicObject appFileDyn : appFileDyns) {
            Long appFileId = appFileDyn.getLong("id");
            String status = (String)approvalStatusMap.get(appFileId);
            if (status != null && set.contains(status)) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{msg}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static HireVerifyResult editVerify(List<Long> pkIds, String entity) {
        DynamicObject[] hireDys = ServiceHelperCache.getHrBaseServiceHelper((String)entity).query("appfile,handlestatus,handler,type", new QFilter("id", "in", pkIds).toArray());
        return HireService.editVerify(hireDys);
    }

    public static HireVerifyResult editVerify(DynamicObject[] hireDys) {
        HireVerifyResult hireVerifyResult = new HireVerifyResult();
        for (DynamicObject hireDy : hireDys) {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDy, (String)"appfile");
            if (!HireService.isEdit(hireDy)) {
                hireVerifyResult.getFailAppFileId().add(appFileId);
                hireVerifyResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireCommonKDStringHelper.editVerifyOperateError()}));
                continue;
            }
            hireVerifyResult.getSuccessAppFileId().add(appFileId);
        }
        return hireVerifyResult;
    }

    public static Map<Long, Boolean> isEditForApproval(Map<Long, DynamicObject> successHireDynMap) {
        HashMap isEditMap = Maps.newHashMapWithExpectedSize((int)successHireDynMap.size());
        for (Map.Entry<Long, DynamicObject> entry : successHireDynMap.entrySet()) {
            Long appFileId = entry.getKey();
            DynamicObject dy = entry.getValue();
            isEditMap.put(appFileId, HireService.isEdit(dy));
        }
        return isEditMap;
    }

    public static boolean isEdit(DynamicObject dy) {
        if (dy == null) {
            return true;
        }
        Long userId = TSCRequestContext.getUserId();
        Long handleId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"handler");
        String type = dy.getString("type");
        return HRStringUtils.equals((String)"D", (String)type) && userId.compareTo(handleId) == 0;
    }

    public static List<DynamicObject> getFullAppFileInfoByHireDy(DynamicObject[] hireDys) {
        Object[] appFileIds = new Long[hireDys.length];
        for (int i = 0; i < hireDys.length; ++i) {
            DynamicObject hireDy = hireDys[i];
            DynamicObject appFileDyn = (DynamicObject)hireDy.get("appfile");
            if (appFileDyn == null) continue;
            appFileIds[i] = appFileDyn.getLong("id");
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_appfile");
        Object[] dynamicObjects = serviceHelper.loadDynamicObjectArray(appFileIds);
        return Lists.newArrayList((Object[])dynamicObjects);
    }

    public static DynamicObject getAppFileDynamicObject(Long appFileId) {
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        return appFileService.loadSingle((Object)appFileId);
    }

    public static void lockAppFiles(DynamicObject[] dyArr) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)dyArr.length);
        for (DynamicObject dy : dyArr) {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"appfile");
            if (appFileId.equals(0L)) continue;
            appFileIds.add(appFileId);
        }
        AppFileService.getInstance().lockAppFiles(appFileIds, TSCRequestContext.getUserId());
    }

    public static void lockAppFiles(DynamicObject[] dyArr, AppFileOperateEnum appFileOperateEnum, boolean directLock) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)dyArr.length);
        for (DynamicObject dy : dyArr) {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"appfile");
            if (appFileId.equals(0L)) continue;
            appFileIds.add(appFileId);
        }
        AppFileService.getInstance().lockAppFiles(appFileIds, TSCRequestContext.getUserId(), appFileOperateEnum, directLock);
    }

    public static void hireOpRecord(DynamicObject[] dyArr, OpDefEnum opDefEnum) {
        HireService.hireOpRecord(dyArr, opDefEnum, null);
    }

    public static void hireOpRecord(DynamicObject[] dyArr, OpDefEnum opDefEnum, Map<Long, String> supplementMap) {
        ArrayList appFileIdList = Lists.newArrayListWithExpectedSize((int)dyArr.length);
        for (DynamicObject hireDy : dyArr) {
            DynamicObject appFileDy = hireDy.getDynamicObject("appfile");
            if (appFileDy == null) continue;
            appFileIdList.add((Long)appFileDy.getPkValue());
        }
        HireService.sendHireOpRecord(opDefEnum, appFileIdList, supplementMap);
    }

    public static void hireOpRecord(DynamicObject dy, OpDefEnum opDefEnum, String supplementStr) {
        ArrayList appFileIdList = Lists.newArrayListWithExpectedSize((int)1);
        HashMap supplementMap = Maps.newHashMapWithExpectedSize((int)1);
        DynamicObject appFileDy = dy.getDynamicObject("appfile");
        if (appFileDy != null) {
            Long appFileId = (Long)appFileDy.getPkValue();
            appFileIdList.add(appFileId);
            supplementMap.put(appFileId, supplementStr);
        }
        HireService.sendHireOpRecord(opDefEnum, appFileIdList, supplementMap);
    }

    private static void sendHireOpRecord(OpDefEnum opDefEnum, List<Long> appFileIdList, Map<Long, String> supplementMap) {
        HireOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), opDefEnum, appFileIdList, supplementMap, null);
    }

    public static boolean existenceHireData(long appFileId, String entity) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entity);
        QFilter appFileQFilter = new QFilter("appfile", "=", (Object)appFileId);
        DynamicObject hireDy = serviceHelper.queryOne("id", new QFilter[]{appFileQFilter});
        return hireDy != null;
    }

    public static boolean inNumRange(int low, int height, int compareNum) {
        return compareNum >= low && compareNum <= height;
    }

    public static List<Long> getAppFileByHireId(String entity, List<Long> hirePkIds) {
        HRBaseServiceHelper hrBaseServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entity);
        DynamicObject[] hireDys = hrBaseServiceHelper.query("appfile", new QFilter("id", "in", hirePkIds).toArray());
        if (hireDys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList appFIleIds = Lists.newArrayListWithExpectedSize((int)hireDys.length);
        for (DynamicObject hireDy : hireDys) {
            appFIleIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDy, (String)"appfile"));
        }
        return appFIleIds;
    }

    public static Set<String> getOperateErrorTitle(ValidateResultCollection validateResult) {
        if (validateResult == null) {
            return Collections.emptySet();
        }
        HashSet titles = Sets.newHashSet();
        List validateErrors = validateResult.getValidateErrors();
        if (validateErrors != null) {
            for (ValidateResult validateError : validateErrors) {
                List allErrorInfo = validateError.getAllErrorInfo();
                if (allErrorInfo == null) continue;
                for (OperateErrorInfo errorInfo : allErrorInfo) {
                    titles.add(errorInfo.getTitle());
                }
            }
        }
        return titles;
    }

    public static String getModifyName(String entity, Object pkId) {
        DynamicObject dynamicObject = ServiceHelperCache.getHrBaseServiceHelper((String)entity).queryOne("modifier", new QFilter("id", "=", pkId));
        if (dynamicObject != null) {
            return dynamicObject.getString("modifier.name");
        }
        return "";
    }

    public static HireVerifyResult verifyHireStatus(String entity, List<Long> pkIds, Set<String> verifyStatus, String tipMsg) {
        DynamicObject[] hireDys;
        HireVerifyResult appFileResult = new HireVerifyResult();
        HRBaseServiceHelper hrBaseServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entity);
        for (DynamicObject hireDy : hireDys = hrBaseServiceHelper.query("handlestatus,appfile", new QFilter("id", "in", pkIds).toArray())) {
            String handleStatus = hireDy.getString("handlestatus");
            Long appFileId = hireDy.getLong("appfile.id");
            if (!verifyStatus.contains(handleStatus)) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{tipMsg}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static boolean checkAppFileStatusOfPro(List<Long> appFileIds) {
        Map<Long, String> statusMap = AppFileHireHelper.returnAppFileStatus(appFileIds);
        Collection<String> values = statusMap.values();
        List<AppFileStatusEnum> status = Collections.singletonList(AppFileStatusEnum.IN_PROCESS);
        List statusStr = status.stream().map(AppFileStatusEnum::getValue).collect(Collectors.toList());
        for (String str : statusStr) {
            if (!values.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, Boolean> checkBlackList(List<Long> appFileIds) {
        return AppFileStdRsmHelper.getBlackListMap(appFileIds);
    }

    public static QFilter getBlackListQFilter() {
        return AppFileHireHelper.isNotInBlackList("");
    }

    public static void convertHrPersonToBosUser(List<DynamicObject> dys, String hrPersonKey, String bosUserKey) {
        HashSet hrPersonIds = Sets.newHashSetWithExpectedSize((int)dys.size());
        for (DynamicObject dy : dys) {
            Long hrPersonId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)hrPersonKey);
            hrPersonIds.add(hrPersonId);
        }
        TscHrPersonHelper helper = new TscHrPersonHelper();
        Map hrIdAndBosUserIdMap = helper.getSysPerByPerId((Set)hrPersonIds);
        for (DynamicObject dy : dys) {
            Long hrPersonId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)hrPersonKey);
            dy.set(bosUserKey, hrIdAndBosUserIdMap.get(hrPersonId));
        }
    }

    public static void convertHrPersonToBosUser(DynamicObjectCollection dyCollection, String hrPersonKey, String bosUserKey) {
        ArrayList dys = Lists.newArrayListWithExpectedSize((int)dyCollection.size());
        for (DynamicObject dynamicObject : dyCollection) {
            dys.add(dynamicObject);
        }
        HireService.convertHrPersonToBosUser(dys, hrPersonKey, bosUserKey);
    }
}

