/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.form.AppFileFormHelper;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankKDStringHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;

public class HireViewService {
    private static final Log logger = LogFactory.getLog(HireViewService.class);
    private static final String KEY_HEAD_LAP = "head_lap";
    private static final String KEY_APPRESUME = "appresume";
    private static final String KEY_ORIRESUME = "oriresume";
    private static final String KEY_EVINFO = "evinfo";
    private static final String NULL_KEY_WORD = "hirenullkeyword";
    private static final String EMPTY_KEY_WORD = "- -";
    private static final String KEY_PANEL_HIRERECOMMEND = "panel_hirerecommend";

    public static void attachFileFromEntityToView(String sourceEntity, Object pkId, String sourceControlKey, IFormView targetView, String targetControlKey) {
        List sourceAttachments = AttachmentServiceHelper.getAttachments((String)sourceEntity, (Object)pkId, (String)sourceControlKey);
        AttachmentPanel attachmentPanel = (AttachmentPanel)targetView.getControl(targetControlKey);
        attachmentPanel.bindData(sourceAttachments);
    }

    public static Long getAppFileInHireModel(IDataModel dataModel) {
        Long appFileId = null;
        DynamicObject appFileDy = (DynamicObject)dataModel.getValue("appfile");
        if (appFileDy != null) {
            appFileId = appFileDy.getLong("id");
        }
        return appFileId;
    }

    public static List<Long> getAppFileInHireModel(IDataModel dataModel, String entryKey) {
        DynamicObjectCollection entryData = dataModel.getEntryEntity(entryKey);
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)entryData.size());
        for (DynamicObject entryDatum : entryData) {
            DynamicObject appFileDy = entryDatum.getDynamicObject("appfile");
            if (appFileDy == null) continue;
            appFileIds.add(appFileDy.getLong("id"));
        }
        return appFileIds;
    }

    public static Boolean initHireSelectInAppFile(String entity, IFormView formView, IDataModel dataModel, Long appFileId, String unComKeySelect, String comKeySelect) {
        String status;
        boolean result = false;
        Map<String, Integer> handleStatusNumByHire = HireDataHelper.getHandleStatusNumByHire(entity, appFileId);
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)3);
        Integer numS = handleStatusNumByHire.get("S");
        Integer numI = handleStatusNumByHire.get("I");
        Integer numA = handleStatusNumByHire.get("A");
        Integer numC = handleStatusNumByHire.get("C");
        if (!numS.equals(0)) {
            status = String.format(Locale.ROOT, HireCommonKDStringHelper.statusS(), numS);
            comboItems.add(HireViewService.genStatusComboItem(status, "S"));
        }
        if (!numI.equals(0)) {
            status = String.format(Locale.ROOT, HireCommonKDStringHelper.statusI(), numI);
            comboItems.add(HireViewService.genStatusComboItem(status, "I"));
            result = true;
        }
        if (!numA.equals(0)) {
            status = String.format(Locale.ROOT, HireCommonKDStringHelper.statusA(), numA);
            comboItems.add(HireViewService.genStatusComboItem(status, "A"));
        }
        if (!numC.equals(0)) {
            status = String.format(Locale.ROOT, HireCommonKDStringHelper.statusC(), numC);
            comboItems.add(HireViewService.genStatusComboItem(status, "C"));
        }
        if (comboItems.size() == 0) {
            return null;
        }
        String controlKey = result ? unComKeySelect : comKeySelect;
        ComboEdit comboEdit = (ComboEdit)formView.getControl(controlKey);
        comboEdit.setComboItems((List)comboItems);
        if (!comboItems.isEmpty()) {
            dataModel.setValue(controlKey, (Object)((ComboItem)comboItems.get(0)).getValue());
        }
        return result;
    }

    public static void setVisble(IFormView formView, Boolean isInProcess, String unComHireFlex, String comHireFlex) {
        if (isInProcess == null) {
            HireViewService.setVisble(formView, unComHireFlex);
            HireViewService.setVisble(formView, comHireFlex);
            return;
        }
        String hireSalaryFlex = isInProcess != false ? comHireFlex : unComHireFlex;
        HireViewService.setVisble(formView, hireSalaryFlex);
    }

    public static void setVisble(IFormView formView, String hireFlex) {
        HashMap data = Maps.newHashMap();
        data.put("vi", Boolean.FALSE);
        formView.updateControlMetadata(hireFlex, (Map)data);
    }

    private static ComboItem genStatusComboItem(String status, String val) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(status));
        comboItem.setValue(val);
        return comboItem;
    }

    public static void initHead(Long appFileId, IFormView iFormView) {
        AppFileFormHelper.showAppFileHeaderForm(iFormView, appFileId, KEY_HEAD_LAP, null);
    }

    public static void showAppResPage(Long appFileId, IFormView iFormView) {
        DynamicObject appFileDyn = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile").loadSingle((Object)appFileId);
        DynamicObject appRes = appFileDyn.getDynamicObject("appres");
        if (appRes != null) {
            BaseShowParameter appResShowParameter = new BaseShowParameter();
            appResShowParameter.setPkId(appRes.getPkValue());
            appResShowParameter.setFormId("tstpm_srrsm_layout");
            OperationStatus status = OperationStatus.VIEW;
            appResShowParameter.setStatus(status);
            appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            appResShowParameter.setSendToClient(true);
            appResShowParameter.getOpenStyle().setTargetKey(KEY_APPRESUME);
            iFormView.showForm((FormShowParameter)appResShowParameter);
            String originResUrl = appRes.getString("resumestoadd");
            if (HRStringUtils.isNotEmpty((String)originResUrl)) {
                iFormView.setVisible(Boolean.TRUE, new String[]{KEY_ORIRESUME});
                HireViewService.previewOriginalResume(originResUrl, iFormView);
            } else {
                iFormView.setVisible(Boolean.FALSE, new String[]{KEY_ORIRESUME});
            }
        }
    }

    public static void previewOriginalResume(String filePath, IFormView iFormView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_ORIRESUME);
        showParameter.setSendToClient(true);
        showParameter.setFormId("tssrm_originalresume");
        showParameter.setCustomParam("resumestoadd", (Object)filePath);
        iFormView.showForm(showParameter);
    }

    public static void initInterviewAssess(long appFileId, IFormView iFormView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tssrm_assessment");
        showParameter.setCustomParam("applicationid", (Object)String.valueOf(appFileId));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("panel_interview");
        showParameter.setSendToClient(true);
        showParameter.setStatus(OperationStatus.VIEW);
        iFormView.showForm(showParameter);
    }

    public static void initFilterFeedback(long appFileId, IFormView iFormView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsivp_rsmfl_feedbacklist");
        showParameter.setCustomParam("appFileId", (Object)appFileId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setTargetKey(KEY_EVINFO);
        iFormView.showForm(showParameter);
    }

    public static void initHireRecommend(long appFileId, IFormView iFormView, String openFormId) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("appFileId", appFileId);
        ListShowParameter recommendForm = FormShowHelper.createListFormShowParameter((String)"tssrm_otherappfilelist", (String)KEY_PANEL_HIRERECOMMEND, (String)openFormId, (ShowType)ShowType.InContainer, (Map)params);
        iFormView.showForm((FormShowParameter)recommendForm);
    }

    public static void openInvalidOrCancelOrInProcess(IFormView iFormView, String entity, String val, String key) {
        if ("A".equals(val) || "C".equals(val) || "I".equals(val)) {
            Long appFileId = (Long)iFormView.getFormShowParameter().getCustomParam("appFileId");
            HashMap openParam = Maps.newHashMapWithExpectedSize((int)1);
            openParam.put("handlestatus", val);
            openParam.put("appFileId", appFileId);
            ListShowParameter jobRankForm = FormShowHelper.createListFormShowParameter((String)"tssrm_otherappfilelist", (String)key, (String)entity, (ShowType)ShowType.InContainer, (Map)openParam);
            iFormView.showForm((FormShowParameter)jobRankForm);
        }
    }

    public static void openFinish(IFormView iFormView, String entity, String viewEntity, String val, String key) {
        if ("S".equals(val)) {
            BaseShowParameter hireForm = FormShowHelper.createBaseFormShowParameter((String)viewEntity, (String)key, (ShowType)ShowType.InContainer, Collections.emptyMap());
            Long appFileId = (Long)iFormView.getFormShowParameter().getCustomParam("appFileId");
            Map<Long, DynamicObject> successHireDyn = HireDataHelper.getSuccessHireDyn(entity, Collections.singletonList(appFileId));
            DynamicObject successHireDy = successHireDyn.get(appFileId);
            if (successHireDy != null && HRStringUtils.equals((String)"S", (String)successHireDy.getString("handlestatus"))) {
                hireForm.setPkId(successHireDy.getPkValue());
                hireForm.setStatus(OperationStatus.VIEW);
                iFormView.showForm((FormShowParameter)hireForm);
            }
        }
    }

    public static boolean verifyExistAppFileVal(IFormView formView, DynamicObjectCollection entryData) {
        if (entryData == null) {
            formView.showTipNotification(HireCommonKDStringHelper.missAppFile());
            return false;
        }
        for (DynamicObject entryDatum : entryData) {
            DynamicObject appFile = (DynamicObject)entryDatum.get("appfile");
            if (appFile != null) continue;
            formView.showTipNotification(HireCommonKDStringHelper.missAppFile());
            return false;
        }
        return true;
    }

    public static boolean verifyEntryHandlerVal(IFormView formView, DynamicObjectCollection entryData) {
        if (entryData == null) {
            return false;
        }
        for (DynamicObject entryDatum : entryData) {
            DynamicObject appFile = (DynamicObject)entryDatum.get("appfile");
            DynamicObject handler = (DynamicObject)entryDatum.get("personhandler");
            if (appFile == null || handler != null) continue;
            String msg = HireCommonKDStringHelper.missHandler();
            formView.showTipNotification(msg);
            return false;
        }
        return true;
    }

    public static DynamicObject getHireDyInWorkFlow(IFormView formView, String entity) {
        Long taskId = (Long)formView.getFormShowParameter().getCustomParam("taskId");
        Long pkId = null;
        pkId = taskId == null ? (Long)((BillShowParameter)formView.getFormShowParameter()).getPkId() : Long.valueOf(ServiceHelperCache.getHrBaseServiceHelper((String)"wf_hitaskinst").queryOne((Object)taskId).getLong("businesskey"));
        return ServiceHelperCache.getHrBaseServiceHelper((String)entity).loadSingle((Object)pkId);
    }

    public static void copyHireDyToTargetView(DynamicObject sourceDy, IDataModel dataModel, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (sourceDy == null) {
            return;
        }
        DynamicObject dataEntity = dataModel.getDataEntity();
        if (sourceDy == dataEntity) {
            throw new KDBizException(HireCommonKDStringHelper.canNotSameClass());
        }
        DataEntityPropertyCollection sourceDpc = sourceDy.getDataEntityType().getProperties();
        Set sourceDpcSet = sourceDpc.stream().map(IMetadata::getName).collect(Collectors.toSet());
        Set sourceAllFields = EntityMetadataCache.getDataEntityType((String)sourceDy.getDataEntityType().getName()).getAllFields().keySet();
        IDataEntityType targetEntityType = dataModel.getDataEntity().getDataEntityType();
        Set targetAllFields = EntityMetadataCache.getDataEntityType((String)targetEntityType.getName()).getAllFields().keySet();
        Set targetDpcSet = targetEntityType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        for (String hireField : sourceAllFields) {
            BigDecimal basicWage;
            if (HRStringUtils.equals((String)"basicwage", (String)hireField) && !ignoreKeys.contains(hireField) && (HRObjectUtils.isEmpty((Object)(basicWage = sourceDy.getBigDecimal(hireField))) || basicWage.compareTo(BigDecimal.ZERO) == 0) || !targetAllFields.contains(hireField) || !sourceDpcSet.contains(hireField) || !targetDpcSet.contains(hireField) || ignoreKeys.contains(hireField)) continue;
            dataModel.setValue(hireField, sourceDy.get(hireField));
        }
        transKeyMap.forEach((sourceKey, targetKey) -> {
            if (sourceAllFields.contains(sourceKey) && targetKey.contains((CharSequence)sourceKey) && !ignoreKeys.contains(sourceKey)) {
                dataModel.setValue(targetKey, sourceDy.get(sourceKey));
            }
        });
    }

    public static void packageDataForNull(PackageDataEvent event, Set<String> handleKeyWord, Set<String> handleEmptyWord) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Object val = event.getFormatValue();
        if (val != null && NULL_KEY_WORD.equals(val.toString())) {
            String exceptionMsg = String.format(Locale.ROOT, HireJobRankKDStringHelper.keyWordException(), NULL_KEY_WORD);
            KDBizException exception = new KDBizException(exceptionMsg);
            logger.error(exceptionMsg, (Throwable)exception);
        }
        if (val == null || HRStringUtils.isEmpty((String)val.toString())) {
            if (handleKeyWord.contains(fieldKey)) {
                event.setFormatValue((Object)NULL_KEY_WORD);
            }
            if (handleEmptyWord.contains(fieldKey)) {
                event.setFormatValue((Object)EMPTY_KEY_WORD);
            }
        }
    }

    public static boolean verifyPerm(String clickKey, List<Long> appFileIds, IFormView formView, Set<String> add, Set<String> edit, Set<String> view) {
        HashMap verifyAll = Maps.newHashMapWithExpectedSize((int)3);
        if (add.contains(clickKey)) {
            verifyAll.put("add", HireService.verifyHirePerm(appFileIds, "47156aff000000ac"));
        }
        if (edit.contains(clickKey)) {
            verifyAll.put("edit", HireService.verifyHirePerm(appFileIds, "4715a0df000000ac"));
        }
        if (view.contains(clickKey)) {
            verifyAll.put("view", HireService.verifyHirePerm(appFileIds, "47150e89000000ac"));
        }
        return HireViewService.handleShowMsg(verifyAll, formView);
    }

    public static String verifyPerm(Long appFileId) {
        boolean viewPerm;
        List<Long> appFileIdList = Collections.singletonList(appFileId);
        boolean editPerm = HireService.verifyHirePerm(appFileIdList, "4715a0df000000ac");
        String perValue = "";
        if (editPerm) {
            perValue = perValue + "EDIT";
        }
        if (viewPerm = HireService.verifyHirePerm(appFileIdList, "47150e89000000ac")) {
            perValue = perValue + "VIEW";
        }
        return perValue;
    }

    private static boolean handleShowMsg(Map<String, Boolean> verifyAll, IFormView formView) {
        Boolean add = verifyAll.get("add");
        Boolean edit = verifyAll.get("edit");
        Boolean view = verifyAll.get("view");
        boolean result = true;
        if (Boolean.FALSE.equals(add)) {
            formView.showErrorNotification(HireCommonKDStringHelper.verifyAppFilePermAdd());
            result = false;
        }
        if (Boolean.FALSE.equals(edit)) {
            formView.showErrorNotification(HireCommonKDStringHelper.verifyAppFilePermEdit());
            result = false;
        }
        if (Boolean.FALSE.equals(view)) {
            formView.showErrorNotification(HireCommonKDStringHelper.verifyAppFilePermView());
            result = false;
        }
        return result;
    }
}

