/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.jobrank;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.hire.common.HireAppFileDataUpdateService;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HireJobRankDataHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HireJobRankDataHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean commitJobRankDataForTypeSend(List<DynamicObject> jobRanks, List<DynamicObject> jobRankBills) {
        HRBaseServiceHelper jobRankService = new HRBaseServiceHelper("tspr_jobrank");
        HRBaseServiceHelper jobRankBillService = new HRBaseServiceHelper("tspr_jobrankbillmodel");
        DynamicObject[] jobRankLoads = HireDataHelper.getNeedInvalidDyByHire("tspr_jobrank", jobRanks);
        DynamicObject[] jobRanksArr = new DynamicObject[jobRanks.size()];
        jobRanks.toArray(jobRanksArr);
        DynamicObject[] jobRankBillsArr = new DynamicObject[jobRanks.size()];
        jobRankBills.toArray(jobRankBillsArr);
        try (TXHandle tx = TX.required();){
            jobRankService.update(jobRankLoads);
            jobRankService.save(jobRanksArr);
            jobRankBillService.save(jobRankBillsArr);
            HireAppFileDataUpdateService.updateJobRank(jobRanks);
            HireService.lockAppFiles(jobRanksArr, AppFileOperateEnum.HIREJOBRANK, false);
            HireService.hireOpRecord(jobRanksArr, OpDefEnum.HIRE_JOB_RANK_INIT);
            LOGGER.info("HireJobRankDataHelper.commitJobRankDataForTypeSend handle new jobRank data success.");
        }
        LOGGER.info("HireJobRankDataHelper.commitJobRankDataForTypeSend  HireJobRank batch init success. Update old jobRank data size:{}.Add  jobRank data size:{}. Add jobRankBill size{}", new Object[]{jobRankLoads.length, jobRanks.size(), jobRankBills.size()});
        return true;
    }
}

