/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.jobrank;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankKDStringHelper;
import kd.tsc.tspr.common.constants.hire.HireInitDataConstants;
import kd.tsc.tspr.common.hire.HireVerifyResult;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HireJobRankService {
    private static final Logger logger = LoggerFactory.getLogger(HireJobRankService.class);

    public static boolean needForProbationInfo(String radioValue) {
        return HRStringUtils.equals((String)radioValue, (String)"1");
    }

    public static HireVerifyResult verifyAppFileLinkJobRankVersion(Map<Long, Date> appFileIdAndJobRankModifyDate) {
        if (appFileIdAndJobRankModifyDate == null) {
            appFileIdAndJobRankModifyDate = Collections.emptyMap();
        }
        HireVerifyResult appFileResult = new HireVerifyResult();
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdAndJobRankModifyDate.size());
        appFileIdAndJobRankModifyDate.forEach((appFileId, time) -> appFileIds.add(appFileId));
        ArrayList column = Lists.newArrayListWithExpectedSize((int)1);
        column.add("modifytime");
        Map<Long, DynamicObject> appFileIdAndAppFileDyn = HireDataHelper.getLatestHireHireDynByAppFileId("tspr_jobrank", appFileIds, column);
        for (Map.Entry<Long, Date> entry : appFileIdAndJobRankModifyDate.entrySet()) {
            Long appFileId2 = entry.getKey();
            Date verifyDate = entry.getValue();
            logger.info("HireJobRankService.verifyAppFileLinkJobRankVersion verify appFileId,verifyDate,{},{}", (Object)appFileId2, (Object)verifyDate);
            DynamicObject jobRankDyn = appFileIdAndAppFileDyn.get(appFileId2);
            if (verifyDate == null && jobRankDyn == null) {
                appFileResult.getSuccessAppFileId().add(appFileId2);
                logger.info("HireJobRankService.verifyAppFileLinkJobRankVersion  verifyDate and dbversion is null");
                continue;
            }
            Long verifyTimestamp = verifyDate == null ? 0L : verifyDate.getTime();
            Long jobRankModifyTime = jobRankDyn == null ? 0L : jobRankDyn.getDate("modifytime").getTime();
            logger.info("HireJobRankService.verifyAppFileLinkJobRankVersion  verifyTimestamp , jobRankModifyTime:{},{}", (Object)verifyTimestamp, (Object)jobRankModifyTime);
            if (!verifyTimestamp.equals(jobRankModifyTime)) {
                appFileResult.getFailAppFileId().add(appFileId2);
                appFileResult.getFailReason().put(appFileId2, Lists.newArrayList((Object[])new String[]{HireJobRankKDStringHelper.dataVersionChange()}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId2);
        }
        return appFileResult;
    }

    public static HireVerifyResult verifyAppFileJobRankStatus(List<DynamicObject> appFileDyns, Set<String> verifyStatus, String tipMsg) {
        HireVerifyResult appFileResult = new HireVerifyResult();
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)appFileDyns.size());
        appFileDyns.forEach(appFileDyn -> appFileIds.add(appFileDyn.getLong("id")));
        for (DynamicObject appFileDyn2 : appFileDyns) {
            String jobRankStatus = appFileDyn2.getString("jobrankstatus");
            Long appFileId = appFileDyn2.getLong("id");
            if (!verifyStatus.contains(jobRankStatus)) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{tipMsg}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static HireVerifyResult verifyProbation(List<DynamicObject> jobRankDyns) {
        HireVerifyResult appFileResult = new HireVerifyResult();
        for (DynamicObject jobRankDyn : jobRankDyns) {
            Long appFileId = jobRankDyn.getLong("appfile.id");
            Integer probationNum = jobRankDyn.getInt("probationnum");
            String probationType = jobRankDyn.getString("probationtype");
            String singleRadio = jobRankDyn.getString("isprobation");
            if (HRStringUtils.equals((String)singleRadio, (String)"1")) {
                if (probationNum.equals(0)) {
                    appFileResult.getFailAppFileId().add(appFileId);
                    appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireJobRankKDStringHelper.probationVerify()}));
                    continue;
                }
                if ("M".equals(probationType) && !HireService.inNumRange(1, 6, probationNum)) {
                    appFileResult.getFailAppFileId().add(appFileId);
                    appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireJobRankKDStringHelper.probationVerifyMonth()}));
                    continue;
                }
                if ("W".equals(probationType) && !HireService.inNumRange(1, HireInitDataConstants.getProbationnumWeekHeight(), probationNum)) {
                    appFileResult.getFailAppFileId().add(appFileId);
                    appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireJobRankKDStringHelper.probationVerifyWeek()}));
                    continue;
                }
                if ("D".equals(probationType) && !HireService.inNumRange(1, HireInitDataConstants.getProbationnumDayHeight(), probationNum)) {
                    appFileResult.getFailAppFileId().add(appFileId);
                    appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireJobRankKDStringHelper.probationVerifyDay()}));
                    continue;
                }
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static HireVerifyResult verifyPositionAndJob(List<DynamicObject> jobRankDyns) {
        HireVerifyResult appFileResult = new HireVerifyResult();
        for (DynamicObject jobRankDyn : jobRankDyns) {
            DynamicObject position = jobRankDyn.getDynamicObject("position");
            DynamicObject job = jobRankDyn.getDynamicObject("job");
            Long appFileId = jobRankDyn.getLong("appfile.id");
            DynamicObject deptDy = jobRankDyn.getDynamicObject("dept");
            ArrayList failReasons = Lists.newArrayList();
            boolean passCheck = true;
            if (position != null) {
                passCheck = HireJobRankService.verifyPositionAndJob_1(position, job, deptDy, failReasons);
            } else {
                if (job == null) {
                    failReasons.add(HireJobRankKDStringHelper.positionAndJobAtLeastOne());
                    passCheck = false;
                }
                if (deptDy == null) {
                    failReasons.add(HireJobRankKDStringHelper.jobRankAdminOrgMustInput());
                    passCheck = false;
                }
            }
            if (!passCheck) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, failReasons);
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    private static boolean verifyPositionAndJob_1(DynamicObject position, DynamicObject job, DynamicObject deptDy, List<String> failReasons) {
        DynamicObject jobFromPosition = position.getDynamicObject("job");
        DynamicObject adminFromPosition = position.getDynamicObject("adminorg");
        boolean passCheck = true;
        if (jobFromPosition != null && job != null && jobFromPosition.getLong("id") != job.getLong("id")) {
            failReasons.add(HireJobRankKDStringHelper.linkPositionSelectJobError());
            passCheck = false;
        }
        if (adminFromPosition != null && adminFromPosition.getLong("id") != deptDy.getLong("id")) {
            failReasons.add(HireJobRankKDStringHelper.linkPositionSelectAdminOrgError());
            passCheck = false;
        }
        return passCheck;
    }

    public static List<DynamicObject> convertJobRankToJobRankBill(List<DynamicObject> jobRanks) {
        if (jobRanks == null || jobRanks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList jobRankBills = Lists.newArrayListWithExpectedSize((int)jobRanks.size());
        HRBaseServiceHelper jobRankBillService = new HRBaseServiceHelper("tspr_jobrankbillmodel");
        long[] genLongIds = ORM.create().genLongIds("tspr_jobrankbillmodel", jobRanks.size());
        long[] genLongIdsForBillNo = ORM.create().genLongIds("tspr_jobrankbillmodel", jobRanks.size());
        for (int i = 0; i < jobRanks.size(); ++i) {
            DynamicObject jobRank = jobRanks.get(i);
            DynamicObject jobRankBill = jobRankBillService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)jobRank, (DynamicObject)jobRankBill);
            jobRankBill.set("id", (Object)genLongIds[i]);
            jobRankBill.set("billno", (Object)genLongIdsForBillNo[i]);
            jobRankBill.set("isexistsworkflow", (Object)Boolean.TRUE);
            jobRankBill.set("jobrank", jobRank.getPkValue());
            String billName = HireJobRankKDStringHelper.jobRankTaskName();
            DynamicObject appFileDyn = jobRank.getDynamicObject("appfile");
            jobRankBill.set("name", (Object)(appFileDyn.getString("name") + billName));
            jobRankBills.add(jobRankBill);
        }
        return jobRankBills;
    }

    public static Set<Long> repeatAppFileId(List<DynamicObject> jobRankDyns) {
        HashSet repeatAppFileId = Sets.newHashSetWithExpectedSize((int)jobRankDyns.size());
        HashSet appFileIds = Sets.newHashSetWithExpectedSize((int)jobRankDyns.size());
        for (DynamicObject jobRankDyn : jobRankDyns) {
            Long appFileId = jobRankDyn.getLong("appfile.id");
            if (appFileIds.contains(appFileId)) {
                repeatAppFileId.add(appFileId);
                continue;
            }
            appFileIds.add(appFileId);
        }
        return repeatAppFileId;
    }

    public static void convertProbationValSave(DynamicObject jobRank) {
        String singleRadio = jobRank.getString("isprobation");
        Boolean visibleForProbationInfo = HireJobRankService.needForProbationInfo(singleRadio);
        if (!visibleForProbationInfo.booleanValue()) {
            jobRank.set("probationtype", null);
            jobRank.set("probationnum", null);
        }
    }

    public static void convertPositionAndJobValSave(DynamicObject jobRank) {
        DynamicObject position = jobRank.getDynamicObject("position");
        boolean needSaveJobMsg = true;
        if (position != null) {
            Set<String> allFields = EntityMetadataCache.getDataEntityType((String)jobRank.getDataEntityType().getName()).getAllFields().keySet();
            Long jobIdFromPosition = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)position, (String)"job");
            if (jobIdFromPosition != null && !jobIdFromPosition.equals(0L)) {
                needSaveJobMsg = false;
            }
            HireService.setValIfDyExistName(jobRank, "dept", null, allFields);
        }
        logger.info("HireJobRankService.convertPositionAndJobValSave position is link job:{}", (Object)needSaveJobMsg);
        if (!needSaveJobMsg) {
            jobRank.set("job", null);
        }
    }

    public static void updateJobRankBillInfoForComplete(DynamicObject[] jobRankBills) {
        Long userId = TSCRequestContext.getUserId();
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject jobRankBill : jobRankBills) {
            jobRankBill.set("handler", (Object)userId);
            jobRankBill.set("handletime", (Object)now);
            jobRankBill.set("modifier", (Object)userId);
            jobRankBill.set("modifytime", (Object)now);
            jobRankBill.set("handlestatus", (Object)"S");
            String singleRadio = jobRankBill.getString("isprobation");
            if (!HRStringUtils.equals((String)singleRadio, (String)"0")) continue;
            jobRankBill.set("probationnum", null);
            jobRankBill.set("probationtype", null);
        }
        HireService.copyHireSalaryExptValToHireDyn(Lists.newArrayList((Object[])jobRankBills), HireInitDataConstants.getSalaryexptUnCopyVal(), Collections.emptyMap());
    }

    public static DynamicObject[] getUpdateJobRankBaseByJobRankBill(DynamicObject[] jobRankBills, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        Object[] jobRankBaseIds = new Long[jobRankBills.length];
        for (int i = 0; i < jobRankBills.length; ++i) {
            jobRankBaseIds[i] = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)jobRankBills[i], (String)"jobrank");
        }
        DynamicObject[] jobRankBaseDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_jobrank").loadDynamicObjectArray(jobRankBaseIds);
        for (DynamicObject jobRankBill : jobRankBills) {
            Long appFileIdBill = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)jobRankBill, (String)"appfile");
            for (DynamicObject jobRankBaseDy : jobRankBaseDys) {
                Long appFileIdBase = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)jobRankBaseDy, (String)"appfile");
                if (appFileIdBill == 0L || appFileIdBase == 0L) continue;
                HRDynamicObjectUtils.copy((DynamicObject)jobRankBill, (DynamicObject)jobRankBaseDy, ignoreKeys, transKeyMap);
            }
        }
        for (DynamicObject jobRankBaseDy : jobRankBaseDys) {
            HireJobRankService.convertPositionAndJobValSave(jobRankBaseDy);
            HireJobRankService.convertProbationValSave(jobRankBaseDy);
        }
        return jobRankBaseDys;
    }

    public static void initPositionAndJobInfoModelByHireDyn(List<DynamicObject> hireDyns) {
        if (hireDyns == null || hireDyns.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> jobInfo = HireJobRankService.getJobInfoByHireDy(hireDyns);
        for (DynamicObject hireDyn : hireDyns) {
            if (hireDyn == null) continue;
            Set<String> allFields = EntityMetadataCache.getDataEntityType((String)hireDyn.getDataEntityType().getName()).getAllFields().keySet();
            DynamicObject positionDyn = hireDyn.getDynamicObject("position");
            if (positionDyn != null) {
                logger.info("HireJobRankService.initPositionAndJobInfoModelByHireDyn position is not null:");
                HireService.setValIfDyExistName(hireDyn, "dept", (Object)positionDyn.getDynamicObject("adminorg"), allFields);
            }
            Long jobId = positionDyn == null ? Long.valueOf(0L) : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDyn, (String)"job");
            logger.info("HireJobRankService.initPositionAndJobInfoModelByHireDyn position is link job:{}", (Object)(!jobId.equals(0L) ? 1 : 0));
            DynamicObject jobDy = jobInfo.get(jobId = jobId.equals(0L) ? HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDyn, (String)"job") : jobId);
            if (jobDy == null) continue;
            HireService.setValIfDyExistName(hireDyn, "job", (Object)jobDy, allFields);
            HireService.setValIfDyExistName(hireDyn, "jobscm", (Object)jobDy.getDynamicObject("jobscm"), allFields);
            HireService.setValIfDyExistName(hireDyn, "jobseq", (Object)jobDy.getDynamicObject("jobseq"), allFields);
            HireService.setValIfDyExistName(hireDyn, "jobfamily", (Object)jobDy.getDynamicObject("jobfamily"), allFields);
            HireService.setValIfDyExistName(hireDyn, "jobclass", (Object)jobDy.getDynamicObject("jobclass"), allFields);
        }
    }

    public static Map<Long, DynamicObject> getJobInfoByHireDy(List<DynamicObject> hireDys) {
        if (hireDys == null || hireDys.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList jobId = Lists.newArrayListWithExpectedSize((int)hireDys.size());
        for (DynamicObject hireDyn : hireDys) {
            jobId.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hireDyn, (String)"job"));
            DynamicObject position = hireDyn.getDynamicObject("position");
            if (position == null) continue;
            jobId.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)position, (String)"job"));
        }
        HRBaseServiceHelper dbServiceHbssJob = new HRBaseServiceHelper("hbjm_jobhr");
        DynamicObject[] jobDyns = dbServiceHbssJob.query("jobscm,jobclass,jobfamily,jobseq", new QFilter("id", "in", (Object)jobId).toArray());
        HashMap jobIdAndDynMap = Maps.newHashMapWithExpectedSize((int)jobDyns.length);
        for (DynamicObject jobDyn : jobDyns) {
            jobIdAndDynMap.put(jobDyn.getLong("id"), jobDyn);
        }
        return jobIdAndDynMap;
    }

    public static Map<Long, Boolean> getSuccessJobRankForHireDomain(List<DynamicObject> targetDys, Set<String> ignoreKey, Map<String, String> transKey) {
        HashMap existJobRank = Maps.newHashMapWithExpectedSize((int)targetDys.size());
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)targetDys.size());
        for (DynamicObject targetDy : targetDys) {
            appFileIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)targetDy, (String)"appfile"));
        }
        Map<Long, DynamicObject> successHireDyn = HireDataHelper.getSuccessHireDyn("tspr_jobrank", appFileIds);
        HRBaseServiceHelper jobRankService = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_jobrank");
        for (DynamicObject targetDy : targetDys) {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)targetDy, (String)"appfile");
            DynamicObject jobRankDy = successHireDyn.get(appFileId);
            existJobRank.put(appFileId, Boolean.TRUE);
            if (jobRankDy == null) {
                jobRankDy = jobRankService.generateEmptyDynamicObject();
                jobRankDy.set("probationtype", (Object)"M");
                logger.info("HireJobRankService.getSuccessJobRankForHireDomain generateEmptyDynamicObject");
                existJobRank.put(appFileId, Boolean.FALSE);
            }
            HRDynamicObjectUtils.copy((DynamicObject)jobRankDy, (DynamicObject)targetDy, ignoreKey, transKey);
        }
        for (DynamicObject targetDy : targetDys) {
            Long num = targetDy.getLong("probationnum");
            num = num == 0L ? null : num;
            targetDy.set("probationnum", (Object)num);
        }
        HireJobRankService.initPositionAndJobInfoModelByHireDyn(Lists.newArrayList(targetDys));
        return existJobRank;
    }
}

