/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.jobrank;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireFreeWorkFlowService;
import kd.tsc.tspr.business.domain.hire.common.HireQFilterService;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.common.HireViewService;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankDataHelper;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankKDStringHelper;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankService;
import kd.tsc.tspr.business.domain.hire.recommend.HireRecommendService;
import kd.tsc.tspr.common.constants.hire.HireInitDataConstants;
import kd.tsc.tspr.common.hire.HireVerifyResult;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireJobRankViewService {
    private static final Log logger = LogFactory.getLog(HireJobRankViewService.class);
    public static final String KEY_ENTRYENTITY = "entryentity";
    public static final String KEY_PROBATIONFLEX = "probationflex";
    public static final String KEY_REPTIP = "reptip";
    public static final String KEY_SINGLESELECTFLEX = "singleselectflex";
    public static final String RADIO_YES = "1";
    public static final String RADIO_NO = "0";
    public static Long ID_LABORRELTYPECLS = 1040L;
    public static Long ID_LABRELSTATUSCLS_YES = 1010L;
    public static Long ID_LABRELSTATUSCLS_NO = 1020L;

    public static boolean verifyPositionAndJob(IFormView formView, IDataModel dataModel) {
        HireVerifyResult verifyResult;
        List fails;
        DynamicObject appFileDy = (DynamicObject)dataModel.getValue("appfile");
        if (appFileDy != null && (fails = (List)(verifyResult = HireJobRankService.verifyPositionAndJob(Collections.singletonList(dataModel.getDataEntity()))).getFailReason().get(appFileDy.getLong("id"))) != null) {
            formView.showTipNotification(String.join((CharSequence)",", fails));
            return false;
        }
        return true;
    }

    public static List<QFilter> handleAppFileF7(List<Long> filterAppFileId) {
        ArrayList appFileQFilter = Lists.newArrayListWithExpectedSize((int)3);
        appFileQFilter.add(AppFileListHelper.getIsInProcessQFilter());
        appFileQFilter.add(AppFileListHelper.getFlowLockQFilter());
        QFilter jobRankStatusQFilter = new QFilter("jobrankstatus", "in", Arrays.asList("W", "S"));
        appFileQFilter.add(jobRankStatusQFilter);
        QFilter hireApprlStatusQFilter = new QFilter("employapprlsatatus", "in", Arrays.asList("F", " "));
        appFileQFilter.add(hireApprlStatusQFilter);
        if (filterAppFileId != null && !filterAppFileId.isEmpty()) {
            QFilter appFileNotInFilter = new QFilter("id", "not in", filterAppFileId);
            appFileQFilter.add(appFileNotInFilter);
        }
        return appFileQFilter;
    }

    public static List<QFilter> handleSocAreaF7(Long appFileId) {
        return HireQFilterService.getSocAreaFilter(appFileId);
    }

    public static List<QFilter> handleJobScmF7(Long appFileId) {
        return HireQFilterService.getJobScmFilter(appFileId);
    }

    public static List<QFilter> handleJobF7(Long appFileId, IDataModel dataModel) {
        DynamicObject jobScm = (DynamicObject)dataModel.getValue("jobscm");
        Long jobScmId = 0L;
        if (jobScm != null) {
            jobScmId = jobScm.getLong("id");
        }
        return HireQFilterService.getJobFilter(jobScmId);
    }

    public static List<QFilter> handlePositionF7(Long appFileId) {
        return HireQFilterService.getPositionFilter(appFileId);
    }

    public static List<QFilter> handleJobLevelF7(IDataModel dataModel) {
        DynamicObject job = (DynamicObject)dataModel.getValue("job");
        if (job != null) {
            return HireQFilterService.getLevelFilter(job);
        }
        return Collections.emptyList();
    }

    public static List<QFilter> handleJobGradeF7(IDataModel dataModel) {
        DynamicObject job = (DynamicObject)dataModel.getValue("job");
        if (job != null) {
            return HireQFilterService.getGradeFilter(job);
        }
        return Collections.emptyList();
    }

    public static List<QFilter> handlePosttypeF7Select() {
        return HireQFilterService.getPosttypeFilter();
    }

    public static List<QFilter> handleLaborrelTypeClsF7() {
        return HireQFilterService.getLaborrelTypeClsFilter();
    }

    public static List<QFilter> handleJobRankAdminOrgF7(String appId, String entityNumber) {
        return HireQFilterService.getJobRankAdminOrgFilter(appId, entityNumber);
    }

    public static void handleEmployInfoVisibleAndEnable(IFormView formView, IDataModel dataModel) {
        DynamicObject laborreltypeClsDy = (DynamicObject)dataModel.getValue("laborreltypecls");
        if (laborreltypeClsDy == null) {
            formView.setEnable(Boolean.FALSE, new String[]{KEY_SINGLESELECTFLEX});
        } else {
            formView.setEnable(Boolean.valueOf(laborreltypeClsDy.getLong("id") != ID_LABORRELTYPECLS.longValue()), new String[]{KEY_SINGLESELECTFLEX});
        }
        String singleRadio = (String)dataModel.getValue("isprobation");
        Boolean visibleForProbationInfo = HireJobRankService.needForProbationInfo(singleRadio);
        formView.setVisible(visibleForProbationInfo, new String[]{KEY_PROBATIONFLEX});
        DecimalEdit probationNum = (DecimalEdit)formView.getControl("probationnum");
        probationNum.setMustInput(visibleForProbationInfo.booleanValue());
        ComboEdit probationType = (ComboEdit)formView.getControl("probationtype");
        probationType.setMustInput(visibleForProbationInfo.booleanValue());
    }

    public static void handelPositionJobInfoVisibleAndEnableForAdd(IFormView formView, IDataModel dataModel) {
        Long jobId;
        DynamicObject positionDyn = (DynamicObject)dataModel.getValue("position");
        Long l = jobId = positionDyn == null ? Long.valueOf(0L) : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDyn, (String)"job");
        if (!jobId.equals(0L)) {
            formView.setEnable(Boolean.FALSE, new String[]{"jobscm", "job", "jobclass", "jobfamily", "jobseq"});
            formView.setEnable(Boolean.TRUE, new String[]{"joblevel", "jobgrade"});
        } else {
            formView.setEnable(Boolean.TRUE, new String[]{"jobscm"});
            DynamicObject jobScmDy = (DynamicObject)dataModel.getValue("jobscm");
            formView.setEnable(Boolean.valueOf(jobScmDy != null), new String[]{"job", "joblevel", "jobgrade"});
        }
        formView.setEnable(Boolean.valueOf(positionDyn == null), new String[]{"dept"});
    }

    public static void initEmployInfoModel(IDataModel dataModel, DynamicObject appFileDyn) {
        String laborrelType = "position.laborreltype";
        String posttype = "position.holdofftyp";
        DynamicObject laborreltypeclsDy = appFileDyn.getDynamicObject(laborrelType);
        DynamicObject postTypeDy = appFileDyn.getDynamicObject(posttype);
        if (laborreltypeclsDy != null) {
            Long laborreltypeclsId = laborreltypeclsDy.getLong("id");
            dataModel.setValue("laborreltypecls", (Object)laborreltypeclsId);
            if (laborreltypeclsId.equals(ID_LABORRELTYPECLS)) {
                dataModel.setValue("isprobation", (Object)RADIO_NO);
                dataModel.setValue("labrelstatuscls", (Object)ID_LABRELSTATUSCLS_NO);
            } else {
                dataModel.setValue("isprobation", (Object)RADIO_YES);
                dataModel.setValue("labrelstatuscls", (Object)ID_LABRELSTATUSCLS_YES);
            }
        }
        if (postTypeDy != null) {
            dataModel.setValue("posttype", (Object)postTypeDy);
        }
    }

    public static void initJobRankNecessaryInfo(IDataModel dataModel, DynamicObject appFileDyn) {
        dataModel.setValue("createorg", (Object)appFileDyn.getDynamicObject("createorg"));
    }

    public static void initPositionAndJobInfoModelForRecommend(IDataModel dataModel, DynamicObject appFileDyn) {
        Long appFileId = (Long)appFileDyn.getPkValue();
        Map<Long, DynamicObject> jobRankDyInfoByRecommend = HireJobRankViewService.getJobRankDyInfoByRecommend(Collections.singletonList(appFileId));
        DynamicObject jobRankInfoByRec = jobRankDyInfoByRecommend.get(appFileId);
        DynamicObject jobRankDy = ServiceHelperCache.getHrBaseServiceHelper((String)dataModel.getDataEntityType().getName()).generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dataModel.getDataEntity(), (DynamicObject)jobRankDy);
        if (jobRankInfoByRec != null) {
            HRDynamicObjectUtils.copy((DynamicObject)jobRankInfoByRec, (DynamicObject)jobRankDy, (Set)HireInitDataConstants.getRecommendUnCopyVal());
        }
        HireJobRankService.initPositionAndJobInfoModelByHireDyn(Collections.singletonList(jobRankDy));
        HireViewService.copyHireDyToTargetView(jobRankDy, dataModel, Collections.emptySet(), Collections.emptyMap());
    }

    public static void initPositionAndJobInfoModelByHireDyn(IDataModel dataModel, DynamicObject hireDyn) {
        if (hireDyn == null) {
            return;
        }
        DynamicObject copyDyn = ServiceHelperCache.getHrBaseServiceHelper((String)hireDyn.getDataEntityType().getName()).generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)hireDyn, (DynamicObject)copyDyn);
        HireJobRankService.initPositionAndJobInfoModelByHireDyn(Collections.singletonList(copyDyn));
        HireViewService.copyHireDyToTargetView(copyDyn, dataModel, Collections.emptySet(), Collections.emptyMap());
    }

    public static void handleSubmitForEntry(IFormView formView, IDataModel dataModel, String workFlowEntity) {
        DynamicObjectCollection entryData = dataModel.getEntryEntity(KEY_ENTRYENTITY);
        if (!HireViewService.verifyExistAppFileVal(formView, entryData)) {
            return;
        }
        if (!HireViewService.verifyEntryHandlerVal(formView, entryData)) {
            return;
        }
        HireService.convertHrPersonToBosUser(entryData, "personhandler", "handler");
        HireVerifyResult allVerifyResult = HireJobRankViewService.beforeOperateDataVerifyResult(entryData);
        List<DynamicObject> jobRankDyns = HireJobRankViewService.convertDynCollectionToJobRankDyn(entryData, allVerifyResult);
        HireService.initHireCommonMsg(jobRankDyns, "tspr_jobrank", false);
        List<DynamicObject> jobRankBillDyn = HireJobRankService.convertJobRankToJobRankBill(jobRankDyns);
        boolean commitResult = HireJobRankDataHelper.commitJobRankDataForTypeSend(jobRankDyns, jobRankBillDyn);
        if (!commitResult) {
            Set appFileNeedHandle = allVerifyResult.getSuccessAppFileId();
            allVerifyResult.getFailAppFileId().addAll(appFileNeedHandle);
            for (Long aLong : appFileNeedHandle) {
                allVerifyResult.getFailReason().put(aLong, Lists.newArrayList((Object[])new String[]{HireCommonKDStringHelper.dataBaseOperateError()}));
            }
            allVerifyResult.getSuccessAppFileId().removeAll(allVerifyResult.getSuccessAppFileId());
        }
        OperationResult operationResult = HireService.getOperationResult(allVerifyResult);
        HireFreeWorkFlowService.buildHireTask(jobRankBillDyn.toArray(new DynamicObject[0]), workFlowEntity);
        formView.returnDataToParent((Object)HireService.serializerOperationResult(operationResult));
        formView.close();
    }

    private static HireVerifyResult beforeOperateDataVerifyResult(DynamicObjectCollection entryData) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)entryData.size());
        HashMap appFileIdAndLinkDate = Maps.newHashMapWithExpectedSize((int)entryData.size());
        entryData.forEach(entry -> {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entry, (String)"appfile");
            if (!appFileId.equals(0L)) {
                appFileIds.add(appFileId);
                appFileIdAndLinkDate.put(appFileId, entry.getDate("linkmodifytime"));
            }
        });
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject[] appFilesArr = appFileService.loadDynamicObjectArray(appFileIds.toArray());
        List<DynamicObject> fullAppFileDyns = Arrays.asList(appFilesArr);
        HireVerifyResult appFileVerify = HireService.verifyAppFileStatus(fullAppFileDyns);
        HireVerifyResult jobRankVerify = HireJobRankService.verifyAppFileJobRankStatus(fullAppFileDyns, HireInitDataConstants.getUnInprocessStatus(), HireJobRankKDStringHelper.inJobRankBlock());
        HireVerifyResult versionVerify = HireJobRankService.verifyAppFileLinkJobRankVersion(appFileIdAndLinkDate);
        HireVerifyResult blackListVerify = HireService.verifyAppFileBlackList(fullAppFileDyns, HireCommonKDStringHelper.JobRankStr(), HireCommonKDStringHelper.AppfileBlackListStr2());
        HireVerifyResult allVerify = HireService.mergeVerifyAppFileConditionResult(appFileVerify, jobRankVerify, versionVerify, blackListVerify);
        return allVerify;
    }

    private static List<DynamicObject> convertDynCollectionToJobRankDyn(DynamicObjectCollection entryData, HireVerifyResult verifyResult) {
        if (entryData == null) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper jobRankService = new HRBaseServiceHelper("tspr_jobrank");
        ArrayList jobRankDyns = Lists.newArrayListWithExpectedSize((int)entryData.size());
        for (DynamicObject entryDatum : entryData) {
            DynamicObject appFileDyn = entryDatum.getDynamicObject("appfile");
            if (appFileDyn == null || !verifyResult.getSuccessAppFileId().contains(appFileDyn.getLong("id"))) continue;
            DynamicObject jobRank = jobRankService.generateEmptyDynamicObject();
            jobRank.set("appfile", (Object)appFileDyn);
            jobRank.set("handler", (Object)entryDatum.getDynamicObject("handler"));
            DynamicObject positionDyn = entryDatum.getDynamicObject("position");
            jobRank.set("position", (Object)positionDyn);
            boolean positionLinkJob = HireService.judgeLinkJobByPositionDyn(positionDyn);
            if (!positionLinkJob) {
                DynamicObject jobDyn = entryDatum.getDynamicObject("job");
                jobRank.set("job", (Object)jobDyn);
            }
            jobRank.set("joblevel", (Object)entryDatum.getDynamicObject("joblevel"));
            jobRank.set("jobgrade", (Object)entryDatum.getDynamicObject("jobgrade"));
            jobRankDyns.add(jobRank);
        }
        return jobRankDyns;
    }

    public static void beforeCreateNewDataForBase(IFormView formView, IDataModel dataModel) {
        Long appFileId = (Long)formView.getFormShowParameter().getCustomParam("appFileId");
        dataModel.setValue("appfile", (Object)appFileId);
        dataModel.setValue("type", (Object)"D");
        dataModel.setValue("handlestatus", (Object)"S");
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appFileDyn = appFileService.queryOne("createorg,adminorg", (Object)appFileId);
        if (appFileDyn != null) {
            dataModel.setValue("createorg", appFileDyn.get("createorg"));
            dataModel.setValue("adminorg", appFileDyn.get("adminorg"));
        }
        HireJobRankViewService.setLinkModifyTimeToModel(appFileId, dataModel);
    }

    public static void setLinkModifyTimeToModel(Long appFileId, IDataModel dataModel) {
        ArrayList queryColumn = Lists.newArrayListWithExpectedSize((int)1);
        queryColumn.add("modifytime");
        Map<Long, DynamicObject> appFileAndLatestJobRankDyn = HireDataHelper.getLatestHireHireDynByAppFileId("tspr_jobrank", Collections.singletonList(appFileId), queryColumn);
        DynamicObject linkJobRankDyn = appFileAndLatestJobRankDyn.get(appFileId);
        if (linkJobRankDyn != null) {
            dataModel.setValue("linkmodifytime", (Object)linkJobRankDyn.getDate("modifytime"));
        }
    }

    public static void setAdminOrgCharge(Long appFileId, IDataModel dataModel) {
        Map<Long, DynamicObject> appFileIdAndPerson = HireService.getRandomDeptCharge(Collections.singletonList(appFileId));
        DynamicObject person = appFileIdAndPerson.get(appFileId);
        if (person != null) {
            dataModel.setValue("personhandler", (Object)person);
        }
    }

    public static void beforeCreateNewDataForEntry(IFormView formView, IDataModel dataModel) {
        List appFiles = (List)formView.getFormShowParameter().getCustomParam("appFileId");
        if (appFiles == null || appFiles.isEmpty()) {
            return;
        }
        int[] rowIndex = dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY, appFiles.size());
        HireJobRankViewService.setJobRankValToEntry(dataModel, appFiles, rowIndex);
    }

    static void setJobRankValToEntry(IDataModel dataModel, List<Long> appFiles, int[] rowIndex) {
        ArrayList queryColumn = Lists.newArrayListWithExpectedSize((int)1);
        queryColumn.add("modifytime");
        Map<Long, DynamicObject> appFileAndLatestJobRankDyn = HireDataHelper.getLatestHireHireDynByAppFileId("tspr_jobrank", appFiles, queryColumn);
        Map<Long, DynamicObject> appFileAndJobRank = HireJobRankViewService.getJobRankDyInfoByRecommend(appFiles);
        Map<Long, DynamicObject> appFileAndPerson = HireService.getRandomDeptCharge(appFiles);
        Map<Long, Long> appFileIdAndOrgMap = HireService.getAppFileIdAndOrgMap(appFiles);
        logger.info("HireJobRankViewService.setJobRankValToEntry appFileIds,size:{}", (Object)appFiles.size());
        for (int i = 0; i < appFiles.size(); ++i) {
            Long appFileId = appFiles.get(i);
            dataModel.setValue("appfile", (Object)appFileId, rowIndex[i]);
            dataModel.setValue("org", (Object)appFileIdAndOrgMap.get(appFileId));
            DynamicObject linkJobRankDyn = appFileAndLatestJobRankDyn.get(appFileId);
            if (linkJobRankDyn != null) {
                Date linkTime = linkJobRankDyn.getDate("modifytime");
                logger.info("HireJobRankViewService.setJobRankValToEntry linkTime:{}", (Object)linkTime);
                dataModel.setValue("linkmodifytime", (Object)linkTime, rowIndex[i]);
            }
            dataModel.setValue("handler", (Object)appFileAndPerson.get(appFileId));
            DynamicObject jobRankInitData = appFileAndJobRank.get(appFileId);
            HireJobRankViewService.initDataToJobRankInitEntry(dataModel, jobRankInitData, rowIndex[i]);
        }
    }

    private static Map<Long, DynamicObject> getJobRankDyInfoByRecommend(List<Long> appFiles) {
        Map<Long, DynamicObject> appFileIdAndRecommendDys = HireRecommendService.readRecommendDataToJobRank(appFiles);
        HashMap appFileAndJobRank = Maps.newHashMapWithExpectedSize((int)appFiles.size());
        ArrayList jobRankDys = Lists.newArrayListWithExpectedSize((int)appFiles.size());
        HRBaseServiceHelper jobRankService = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_jobrank");
        appFileIdAndRecommendDys.forEach((appFile, recDy) -> {
            DynamicObject jobRankEmptyDy = jobRankService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)recDy, (DynamicObject)jobRankEmptyDy, (Set)HireInitDataConstants.getRecommendUnCopyVal());
            jobRankEmptyDy.set("appfile", recDy.get("appfile"));
            jobRankDys.add(jobRankEmptyDy);
        });
        HireJobRankService.initPositionAndJobInfoModelByHireDyn(jobRankDys);
        for (DynamicObject jobRankDy : jobRankDys) {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)jobRankDy, (String)"appfile");
            appFileAndJobRank.put(appFileId, jobRankDy);
        }
        return appFileAndJobRank;
    }

    private static void initDataToJobRankInitEntry(IDataModel dataModel, DynamicObject jobRankDyn, int rowIndex) {
        if (jobRankDyn != null) {
            Set recFields = EntityMetadataCache.getDataEntityType((String)"tspr_hirerecommendmodel").getAllFields().keySet();
            Set initJobFields = EntityMetadataCache.getDataEntityType((String)dataModel.getDataEntity().getDataEntityType().getName()).getAllFields().keySet();
            for (String field : recFields) {
                if (HireInitDataConstants.getRecommendUnCopyVal().contains(field) || !initJobFields.contains(field)) continue;
                logger.info("HireJobRankViewService.initDataToJobRankInitEntry set val fileld:{}", (Object)field);
                dataModel.setValue(field, jobRankDyn.get(field), rowIndex);
            }
        }
    }

    public static void handleLaborrelTypeClsChange(IFormView formView, IDataModel dataModel, Object newVal, Object oldVal) {
        Long newId;
        DynamicObject newValue = (DynamicObject)newVal;
        DynamicObject oldValue = (DynamicObject)oldVal;
        Long oldId = oldValue == null ? Long.valueOf(0L) : (Long)oldValue.getPkValue();
        Long l = newId = newValue == null ? Long.valueOf(0L) : (Long)newValue.getPkValue();
        if (!oldId.equals(newId)) {
            if (newId.equals(ID_LABORRELTYPECLS)) {
                dataModel.setValue("isprobation", (Object)RADIO_NO);
                formView.setEnable(Boolean.FALSE, new String[]{KEY_SINGLESELECTFLEX});
                formView.setVisible(Boolean.FALSE, new String[]{KEY_PROBATIONFLEX});
            } else if (newId.equals(0L)) {
                dataModel.setValue("isprobation", null);
                formView.setEnable(Boolean.FALSE, new String[]{KEY_SINGLESELECTFLEX});
                formView.setVisible(Boolean.FALSE, new String[]{KEY_PROBATIONFLEX});
            } else {
                dataModel.setValue("isprobation", (Object)RADIO_YES);
                formView.setEnable(Boolean.TRUE, new String[]{KEY_SINGLESELECTFLEX});
                formView.setVisible(Boolean.TRUE, new String[]{KEY_PROBATIONFLEX});
            }
        }
    }

    public static void handleSelectResChange(IFormView formView, IDataModel dataModel, Object newVal, Object oldVal) {
        String oldValue = (String)oldVal;
        String newValue = (String)newVal;
        if (!HRStringUtils.equals((String)oldValue, (String)newValue)) {
            if (HRStringUtils.equals((String)newValue, (String)RADIO_YES)) {
                dataModel.setValue("probationtype", (Object)"M");
                dataModel.setValue("labrelstatuscls", (Object)ID_LABRELSTATUSCLS_YES);
                formView.setEnable(Boolean.TRUE, new String[]{KEY_SINGLESELECTFLEX});
                formView.setVisible(Boolean.TRUE, new String[]{KEY_PROBATIONFLEX});
                DecimalEdit probationnum = (DecimalEdit)formView.getControl("probationnum");
                probationnum.setMustInput(true);
                ComboEdit probationtype = (ComboEdit)formView.getControl("probationtype");
                probationtype.setMustInput(true);
            } else {
                dataModel.setValue("labrelstatuscls", (Object)ID_LABRELSTATUSCLS_NO);
                dataModel.setValue("probationnum", null);
                dataModel.setValue("probationtype", (Object)"M");
                formView.setEnable(Boolean.TRUE, new String[]{KEY_SINGLESELECTFLEX});
                formView.setVisible(Boolean.FALSE, new String[]{KEY_PROBATIONFLEX});
                DecimalEdit probationnum = (DecimalEdit)formView.getControl("probationnum");
                probationnum.setMustInput(false);
                ComboEdit probationtype = (ComboEdit)formView.getControl("probationtype");
                probationtype.setMustInput(false);
            }
        }
    }

    public static void handleAppFileChangeForEntry(IFormView formView, IDataModel dataModel, Integer rowIndex, Object newVal, Object oldVal) {
        DynamicObject appFileNew = (DynamicObject)newVal;
        if (appFileNew != null) {
            Long appFileId = (Long)appFileNew.getPkValue();
            HireJobRankViewService.setJobRankValToEntry(dataModel, Collections.singletonList(appFileId), new int[]{rowIndex});
        }
        DynamicObjectCollection entryData = dataModel.getEntryEntity(KEY_ENTRYENTITY);
        HireJobRankViewService.handleAddNewAppFileEnable(entryData, rowIndex, formView);
        formView.setVisible(Boolean.valueOf(HireJobRankViewService.existJobRankSuccessStatus(entryData)), new String[]{KEY_REPTIP});
    }

    public static boolean existJobRankSuccessStatus(DynamicObjectCollection entry) {
        boolean showTip = false;
        for (DynamicObject dyData : entry) {
            String jobRankStatus;
            DynamicObject appFileDy = (DynamicObject)dyData.get("appfile");
            if (appFileDy == null || !"S".equals(jobRankStatus = appFileDy.getString("jobrankstatus"))) continue;
            showTip = true;
            break;
        }
        return showTip;
    }

    public static void handleAddNewAppFileEnable(DynamicObjectCollection entryData, int seqNo, IFormView formView) {
        DynamicObject data = (DynamicObject)entryData.get(seqNo);
        DynamicObject appFileDy = data.getDynamicObject("appfile");
        if (appFileDy == null) {
            formView.setEnable(Boolean.FALSE, seqNo, new String[]{"position", "jobscm", "job", "joblevel", "jobgrade"});
        } else {
            formView.setEnable(Boolean.FALSE, seqNo, new String[]{"appfile"});
            formView.setEnable(Boolean.TRUE, seqNo, new String[]{"position"});
            formView.setEnable(Boolean.TRUE, seqNo, new String[]{"handler"});
        }
        DynamicObject position = data.getDynamicObject("position");
        Boolean lockJobScm = position != null && position.getDynamicObject("job") != null;
        formView.setEnable(Boolean.valueOf(lockJobScm == false), seqNo, new String[]{"jobscm"});
        DynamicObject jobScm = data.getDynamicObject("jobscm");
        formView.setEnable(Boolean.valueOf(jobScm != null && lockJobScm == false), seqNo, new String[]{"job"});
        DynamicObject job = data.getDynamicObject("job");
        formView.setEnable(Boolean.valueOf(job != null), seqNo, new String[]{"joblevel", "jobgrade"});
    }

    public static void handlePositionChange(IFormView formView, IDataModel dataModel, Integer rowIndex, Object newVal, Object oldVal) {
        DynamicObject positionDynNew = (DynamicObject)newVal;
        Long jobIdNew = positionDynNew == null ? Long.valueOf(0L) : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDynNew, (String)"job");
        DynamicObject positionDynOld = (DynamicObject)oldVal;
        Long jobIdOld = positionDynOld == null ? Long.valueOf(0L) : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionDynOld, (String)"job");
        HireJobRankViewService.setEnable(formView, "jobscm", Boolean.TRUE, rowIndex);
        HireJobRankViewService.setEnable(formView, "job", Boolean.TRUE, rowIndex);
        if (!jobIdNew.equals(0L)) {
            Long jobScmId = HireDataHelper.getJobScmIdFromJobId(jobIdNew);
            HireJobRankViewService.setDataModel(dataModel, "jobscm", jobScmId, rowIndex);
            HireJobRankViewService.setDataModel(dataModel, "job", jobIdNew, rowIndex);
            HireJobRankViewService.lockJobInfo(true, true, rowIndex, formView);
        } else {
            DynamicObject jobScm = (DynamicObject)HireJobRankViewService.getVal(dataModel, "jobscm", rowIndex);
            HireJobRankViewService.lockJobInfo(false, jobScm == null, rowIndex, formView);
        }
        HireJobRankViewService.handleCleanJobInfo(jobIdOld, jobIdNew, rowIndex, formView, dataModel);
    }

    public static void handlePositionChangeForAdminOrg(IFormView formView, IDataModel dataModel, Object newVal, Object oldVal) {
        DynamicObject positionDynNew = (DynamicObject)newVal;
        DynamicObject positionDynOld = (DynamicObject)oldVal;
        if (positionDynOld != null && positionDynNew == null) {
            dataModel.setValue("dept", null);
            formView.setEnable(Boolean.TRUE, new String[]{"dept"});
        }
        if (positionDynNew != null) {
            dataModel.setValue("dept", (Object)positionDynNew.getDynamicObject("adminorg"));
            formView.setEnable(Boolean.FALSE, new String[]{"dept"});
        }
    }

    public static void handleJobScmChange(IFormView formView, IDataModel dataModel, Integer rowIndex, Object newVal, Object oldVal) {
        Long jobFromPosition;
        boolean needLinkChange = true;
        DynamicObject position = (DynamicObject)dataModel.getValue("position");
        if (position != null && !(jobFromPosition = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)position, (String)"job")).equals(0L)) {
            needLinkChange = false;
        }
        if (needLinkChange) {
            long jobScmOldId;
            DynamicObject jobScmNew = (DynamicObject)newVal;
            DynamicObject jobScmOld = (DynamicObject)oldVal;
            long jobScmNewId = jobScmNew == null ? 0L : jobScmNew.getLong("id");
            long l = jobScmOldId = jobScmOld == null ? 0L : jobScmOld.getLong("id");
            if (jobScmNewId != jobScmOldId) {
                HireJobRankViewService.setDataModel(dataModel, "job", null, rowIndex);
            }
            boolean lock = jobScmNew != null;
            HireJobRankViewService.setEnable(formView, "job", lock, rowIndex);
        }
    }

    public static void handleJobChange(IFormView formView, IDataModel dataModel, Integer rowIndex, Object newVal, Object oldVal) {
        DynamicObject jobNew = (DynamicObject)newVal;
        HireJobRankViewService.setEnable(formView, "joblevel", jobNew != null, rowIndex);
        HireJobRankViewService.setEnable(formView, "jobgrade", jobNew != null, rowIndex);
        HireJobRankViewService.setDataModel(dataModel, "joblevel", null, rowIndex);
        HireJobRankViewService.setDataModel(dataModel, "jobgrade", null, rowIndex);
    }

    public static void handelJobChangeForClassFamilySeq(IFormView formView, IDataModel dataModel, Object newVal, Object oldVal) {
        DynamicObject jobNew = (DynamicObject)newVal;
        DynamicObject jobOld = (DynamicObject)oldVal;
        if (jobOld != null && jobNew == null) {
            dataModel.setValue("jobclass", null);
            dataModel.setValue("jobfamily", null);
            dataModel.setValue("jobseq", null);
        }
        if (jobNew != null) {
            dataModel.setValue("jobclass", (Object)jobNew.getDynamicObject("jobclass"));
            dataModel.setValue("jobfamily", (Object)jobNew.getDynamicObject("jobfamily"));
            dataModel.setValue("jobseq", (Object)jobNew.getDynamicObject("jobseq"));
        }
    }

    public static boolean handleProbationChange(IFormView formView, IDataModel dataModel) {
        String singleRadio = (String)dataModel.getValue("isprobation");
        if (!HireJobRankService.needForProbationInfo(singleRadio)) {
            return true;
        }
        String probationType = (String)dataModel.getValue("probationtype");
        Integer probationNum = (Integer)dataModel.getValue("probationnum");
        FieldTip fieldTip = null;
        if ("M".equals(probationType) && !HireService.inNumRange(1, 6, probationNum)) {
            fieldTip = new FieldTip();
            fieldTip.setTip(HireJobRankKDStringHelper.probationErrorM());
        } else if ("W".equals(probationType) && !HireService.inNumRange(1, HireInitDataConstants.PROBATIONNUM_WEEK_HEIGHT, probationNum)) {
            fieldTip = new FieldTip();
            fieldTip.setTip(HireJobRankKDStringHelper.probationErrorW());
        }
        if ("D".equals(probationType) && !HireService.inNumRange(1, HireInitDataConstants.getProbationnumDayHeight(), probationNum)) {
            fieldTip = new FieldTip();
            fieldTip.setTip(HireJobRankKDStringHelper.probationErrorD());
        }
        if (fieldTip != null) {
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            fieldTip.setFieldKey("probationnum");
            DeleteRule deleteRule = new DeleteRule();
            deleteRule.setAction("isChange");
            deleteRule.setFields(Collections.singletonList("probationnum"));
            fieldTip.setDeleteRule(deleteRule);
            formView.showFieldTip(fieldTip);
            return false;
        }
        return true;
    }

    private static void lockJobInfo(boolean lockScm, boolean lockJob, Integer rowIndex, IFormView formView) {
        HireJobRankViewService.setEnable(formView, "jobscm", !lockScm, rowIndex);
        HireJobRankViewService.setEnable(formView, "job", !lockJob, rowIndex);
    }

    private static void handleCleanJobInfo(Long jobIdOld, Long jobIdNew, Integer rowIndex, IFormView formView, IDataModel dataModel) {
        if (!jobIdOld.equals(0L) && jobIdNew.equals(0L)) {
            HireJobRankViewService.setDataModel(dataModel, "jobscm", null, rowIndex);
            HireJobRankViewService.setDataModel(dataModel, "job", null, rowIndex);
            HireJobRankViewService.lockJobInfo(false, true, rowIndex, formView);
        }
    }

    private static void setDataModel(IDataModel dataModel, String key, Object val, Integer rowIndex) {
        if (rowIndex != null) {
            dataModel.setValue(key, val, rowIndex.intValue());
        } else {
            dataModel.setValue(key, val);
        }
    }

    private static void setEnable(IFormView formView, String key, Boolean enable, Integer rowIndex) {
        if (rowIndex != null) {
            formView.setEnable(enable, rowIndex.intValue(), new String[]{key});
        } else {
            formView.setEnable(enable, new String[]{key});
        }
    }

    private static Object getVal(IDataModel dataModel, String key, Integer rowIndex) {
        if (rowIndex != null) {
            return dataModel.getValue(key, rowIndex.intValue());
        }
        return dataModel.getValue(key);
    }
}

