/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.recommend;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankService;
import kd.tsc.tspr.business.domain.hire.recommend.HireRecommendKDStringHelper;
import kd.tsc.tspr.common.hire.HireVerifyResult;

public class HireRecommendService {
    public static void initRecommendBillMsg(List<DynamicObject> recommendDys) {
        long[] genLongIds = ORM.create().genLongIds("tspr_hirerecommendmodel", recommendDys.size());
        for (int i = 0; i < recommendDys.size(); ++i) {
            DynamicObject hireDy = recommendDys.get(i);
            hireDy.set("billno", (Object)genLongIds[i]);
            hireDy.set("isexistsworkflow", (Object)Boolean.TRUE);
            String billName = HireRecommendKDStringHelper.recommendTaskName();
            DynamicObject appFileDyn = hireDy.getDynamicObject("appfile");
            hireDy.set("name", (Object)(appFileDyn.getString("name") + billName));
            hireDy.set("feedbackresult", (Object)"U");
        }
    }

    public static HireVerifyResult verifyRecommendInitStatus(List<DynamicObject> appFileDyns) {
        HireVerifyResult appFileResult = new HireVerifyResult();
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)appFileDyns.size());
        appFileDyns.forEach(appFileDyn -> appFileIds.add(appFileDyn.getLong("id")));
        for (DynamicObject appFileDyn2 : appFileDyns) {
            String feedbackResult = appFileDyn2.getString("empolyfeedbackresult");
            Long appFileId = appFileDyn2.getLong("id");
            if (!HRStringUtils.isEmpty((String)feedbackResult) && !"W".equals(feedbackResult)) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireRecommendKDStringHelper.unEmptyAndNotWaitError()}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static Map<Long, DynamicObject> readRecommendDataToJobRank(List<Long> appFileIds) {
        if (appFileIds == null || appFileIds.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList queryColumn = Lists.newArrayListWithExpectedSize((int)1);
        queryColumn.add("id");
        queryColumn.add("handlestatus");
        Map<Long, DynamicObject> hireRecommends = HireDataHelper.getLatestHireHireDynByAppFileId("tspr_hirerecommendmodel", appFileIds, queryColumn);
        ArrayList pkIds = Lists.newArrayListWithExpectedSize((int)appFileIds.size());
        hireRecommends.forEach((appFile, recDy) -> {
            if ("S".equals(recDy.getString("handlestatus"))) {
                pkIds.add(recDy.getLong("id"));
            }
        });
        HRBaseServiceHelper dbService = new HRBaseServiceHelper("tspr_hirerecommendmodel");
        Object[] fullColumnRecDy = dbService.loadDynamicObjectArray((Object[])pkIds.toArray(new Long[0]));
        HireJobRankService.initPositionAndJobInfoModelByHireDyn(Lists.newArrayList((Object[])fullColumnRecDy));
        HashMap resultData = Maps.newHashMapWithExpectedSize((int)appFileIds.size());
        for (Object dynamicObject : fullColumnRecDy) {
            Long id = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)"appfile");
            resultData.put(id, dynamicObject);
        }
        return resultData;
    }

    public static void handleRecInfoForCompleteTask(DynamicObject[] recommendDys) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject recommendDy : recommendDys) {
            recommendDy.set("handletime", (Object)nowTime);
            recommendDy.set("handlestatus", (Object)"S");
            HireJobRankService.convertPositionAndJobValSave(recommendDy);
        }
    }

    public static boolean existenceHireRecommend(long appFileId) {
        return HireService.existenceHireData(appFileId, "tspr_hirerecommendmodel");
    }
}

