/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.recommend;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.common.HireFreeWorkFlowService;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.common.HireViewService;
import kd.tsc.tspr.business.domain.hire.recommend.HireRecommendDataHelper;
import kd.tsc.tspr.business.domain.hire.recommend.HireRecommendService;
import kd.tsc.tspr.common.hire.HireVerifyResult;

public class HireRecommendViewService {
    private static final String KEY_ENTRYENTITY = "entryentity";

    public static void handleSubmitForEntry(IFormView formView, IDataModel dataModel, String wfEntity) {
        DynamicObjectCollection entryData = dataModel.getEntryEntity(KEY_ENTRYENTITY);
        boolean verifyResult = HireViewService.verifyEntryHandlerVal(formView, entryData);
        if (!verifyResult) {
            return;
        }
        HireService.convertHrPersonToBosUser(entryData, "personhandler", "handler");
        HireVerifyResult allVerifyResult = HireRecommendViewService.beforeOperateDataVerifyResultForEntry(entryData);
        List<DynamicObject> recommendDys = HireRecommendViewService.convertDynCollectionToRecommendDyn(entryData, allVerifyResult);
        HireService.initHireCommonMsg(recommendDys, "tspr_hirerecommendmodel", false);
        OperationResult operationResult = HireRecommendViewService.operateDy(allVerifyResult, recommendDys, wfEntity);
        operationResult.setMessage(HireCommonKDStringHelper.submitSuccess());
        formView.returnDataToParent((Object)HireService.serializerOperationResult(operationResult));
        formView.close();
    }

    public static void handleSubmit(IFormView formView, IDataModel dataModel, String wfEntity) {
        DynamicObject viewDy = dataModel.getDataEntity();
        if (viewDy == null) {
            return;
        }
        HireService.convertHrPersonToBosUser(Lists.newArrayList((Object[])new DynamicObject[]{viewDy}), "personhandler", "handler");
        Long appFileId = (Long)formView.getFormShowParameter().getCustomParam("appFileId");
        HireVerifyResult allVerifyResult = HireRecommendViewService.beforeOperateDataVerifyResult(Collections.singletonList(appFileId));
        ArrayList recommendDys = Lists.newArrayListWithExpectedSize((int)1);
        if (!allVerifyResult.getSuccessAppFileId().isEmpty()) {
            HRBaseServiceHelper recommendService = new HRBaseServiceHelper("tspr_hirerecommendmodel");
            DynamicObject recommendDy = recommendService.generateEmptyDynamicObject();
            recommendDy.set("appfile", dataModel.getValue("appfile"));
            recommendDy.set("handler", (Object)viewDy.getDynamicObject("handler"));
            recommendDys.add(recommendDy);
            HireService.initHireCommonMsg(recommendDys, "tspr_hirerecommendmodel", false);
        }
        OperationResult operationResult = HireRecommendViewService.operateDy(allVerifyResult, recommendDys, wfEntity);
        operationResult.setMessage(HireCommonKDStringHelper.submitSuccess());
        formView.returnDataToParent((Object)HireService.serializerOperationResult(operationResult));
        formView.close();
    }

    private static OperationResult operateDy(HireVerifyResult allVerifyResult, List<DynamicObject> recommendDys, String wfEntity) {
        HireRecommendService.initRecommendBillMsg(recommendDys);
        boolean commitResult = HireRecommendDataHelper.commitRecommendDataForTypeSend(recommendDys);
        if (!commitResult) {
            Set appFileNeedHandle = allVerifyResult.getSuccessAppFileId();
            allVerifyResult.getFailAppFileId().addAll(appFileNeedHandle);
            for (Long aLong : appFileNeedHandle) {
                allVerifyResult.getFailReason().put(aLong, Lists.newArrayList((Object[])new String[]{HireCommonKDStringHelper.dataBaseOperateError()}));
            }
            allVerifyResult.getSuccessAppFileId().removeAll(allVerifyResult.getSuccessAppFileId());
        }
        OperationResult operationResult = HireService.getOperationResult(allVerifyResult);
        HireFreeWorkFlowService.buildHireTask(recommendDys.toArray(new DynamicObject[0]), wfEntity);
        return operationResult;
    }

    private static HireVerifyResult beforeOperateDataVerifyResultForEntry(DynamicObjectCollection entryData) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)entryData.size());
        entryData.forEach(entry -> {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entry, (String)"appfile");
            if (!appFileId.equals(0L)) {
                appFileIds.add(appFileId);
            }
        });
        HireVerifyResult allVerify = HireRecommendViewService.beforeOperateDataVerifyResult(appFileIds);
        return allVerify;
    }

    private static HireVerifyResult beforeOperateDataVerifyResult(List<Long> appFileIds) {
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject[] appFilesArr = appFileService.loadDynamicObjectArray(appFileIds.toArray());
        List<DynamicObject> fullAppFileDyns = Arrays.asList(appFilesArr);
        HireVerifyResult appFileVerify = HireService.verifyAppFileStatusWithMsg(fullAppFileDyns, ResManager.loadKDString((String)"\u5f55\u7528\u63a8\u8350", (String)"HireRecommendKDStringHelper_7", (String)"tsc-tspr-business", (Object[])new Object[0]));
        HireVerifyResult recommendVerify = HireRecommendService.verifyRecommendInitStatus(fullAppFileDyns);
        HireVerifyResult hireVerifyResult = HireService.verifyAppFileBlackList(fullAppFileDyns, HireCommonKDStringHelper.HireConfirmStr(), HireCommonKDStringHelper.AppfileBlackListStr2());
        return HireService.mergeVerifyAppFileConditionResult(appFileVerify, recommendVerify, hireVerifyResult);
    }

    private static List<DynamicObject> convertDynCollectionToRecommendDyn(DynamicObjectCollection entryData, HireVerifyResult verifyResult) {
        if (entryData == null) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper recommendService = new HRBaseServiceHelper("tspr_hirerecommendmodel");
        ArrayList recommendDys = Lists.newArrayListWithExpectedSize((int)entryData.size());
        for (DynamicObject entryDatum : entryData) {
            DynamicObject appFileDyn = entryDatum.getDynamicObject("appfile");
            if (appFileDyn == null || !verifyResult.getSuccessAppFileId().contains(appFileDyn.getLong("id"))) continue;
            DynamicObject recommendDy = recommendService.generateEmptyDynamicObject();
            recommendDy.set("appfile", (Object)appFileDyn);
            recommendDy.set("handler", (Object)entryDatum.getDynamicObject("handler"));
            recommendDys.add(recommendDy);
        }
        return recommendDys;
    }
}

