/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.salary;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.hire.common.HireAppFileDataUpdateService;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class HireSalaryDataHelper {
    private static final Log LOG = LogFactory.getLog(HireSalaryDataHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean commitSalaryDataForTypeSend(List<DynamicObject> salaryList, List<DynamicObject> salaryBills, boolean isDirect) {
        LOG.info("HireSalaryDataHelper.commitSalaryDataForTypeSend type={}", (Object)isDirect);
        HRBaseServiceHelper salaryService = new HRBaseServiceHelper("tspr_hiresalary");
        HRBaseServiceHelper salaryBillService = new HRBaseServiceHelper("tspr_hiresalarybill");
        DynamicObject[] salaryLoads = HireDataHelper.getNeedInvalidDyByHire("tspr_hiresalary", salaryList);
        DynamicObject[] salaryArr = new DynamicObject[salaryList.size()];
        salaryList.toArray(salaryArr);
        DynamicObject[] salaryBillsArr = new DynamicObject[salaryBills.size()];
        salaryBills.toArray(salaryBillsArr);
        try (TXHandle tx = TX.required();){
            OpDefEnum opDefEnum = OpDefEnum.DIRECT_SALARY;
            salaryService.update(salaryLoads);
            salaryService.save(salaryArr);
            if (!isDirect) {
                salaryBillService.save(salaryBillsArr);
                opDefEnum = OpDefEnum.HIRE_SALARY_TASK;
            }
            HireAppFileDataUpdateService.updateSalary(salaryList);
            HireService.lockAppFiles(salaryArr, AppFileOperateEnum.HIRESALARY, false);
            HireService.hireOpRecord(salaryArr, opDefEnum);
        }
        LOG.info("HireSalaryDataHelper.commitSalaryDataForTypeSend  HireSalary batch init success. Update old salary data size:{}.Add  salary data size:{}. Add salaryBill size{}", new Object[]{salaryLoads.length, salaryList.size(), salaryBills.size()});
        return true;
    }
}

