/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.salary;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankService;
import kd.tsc.tspr.business.domain.hire.salary.HireSalaryKDStringHelper;
import kd.tsc.tspr.common.constants.hire.HireInitDataConstants;
import kd.tsc.tspr.common.constants.hire.HireSalaryInitDataConstants;
import kd.tsc.tspr.common.hire.HireVerifyResult;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class HireSalaryService {
    private static final Log LOG = LogFactory.getLog(HireSalaryService.class);
    private static final String VALUE_D = "D";
    private static final String VALUE_M = "M";
    private static final Map<String, String> JOBRANK_SALARY_TRANS_KEY = Maps.newHashMap();

    public static HireVerifyResult beforeOperateDataVerifyResultForEdit(DynamicObject[] salaryArr) {
        LOG.info("HireSalaryService.beforeOperateDataVerifyResultForEdit");
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)salaryArr.length);
        Map<Long, Date> appFileIdAndLinkDate = HireSalaryService.getAppFileIdAndLinkDate(salaryArr, appFileIds);
        HireVerifyResult versionVerify = HireSalaryService.verifyAppFileLinkSalaryVersion(appFileIdAndLinkDate, appFileIds);
        List<DynamicObject> fullAppFileDys = HireService.getAppFileInfo(appFileIds);
        HireVerifyResult appFileVerify = HireService.verifyAppFileStatus(fullAppFileDys);
        HireVerifyResult approvalVerify = HireService.verifyApprovalStatusForEdit(fullAppFileDys, HireSalaryKDStringHelper.verifyApprovalStatusForEditOperateError());
        return HireService.mergeVerifyAppFileConditionResult(versionVerify, appFileVerify, approvalVerify);
    }

    public static HireVerifyResult beforeOperateDataVerifyResult(DynamicObject[] salaryArr, boolean isInProcess) {
        LOG.info("HireSalaryService.beforeOperateDataVerifyResult");
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)salaryArr.length);
        Map<Long, Date> appFileIdAndLinkDate = HireSalaryService.getAppFileIdAndLinkDate(salaryArr, appFileIds);
        List<DynamicObject> fullAppFileDys = HireService.getAppFileInfo(appFileIds);
        HireVerifyResult appFileVerify = HireService.verifyAppFileStatus(fullAppFileDys);
        HireVerifyResult salaryVerify = new HireVerifyResult();
        if (!isInProcess) {
            salaryVerify = HireSalaryService.verifySalaryStatus(fullAppFileDys);
        }
        HireVerifyResult versionVerify = HireSalaryService.verifyAppFileLinkSalaryVersion(appFileIdAndLinkDate, appFileIds);
        HireVerifyResult approvalVerify = HireService.verifyApprovalStatus(fullAppFileDys, HireSalaryKDStringHelper.verifyApprovalStatusOperateError());
        HireVerifyResult blackListVerify = HireService.verifyAppFileBlackList(fullAppFileDys, HireCommonKDStringHelper.SalaryStr(), HireCommonKDStringHelper.AppfileBlackListStr2());
        return HireService.mergeVerifyAppFileConditionResult(appFileVerify, salaryVerify, versionVerify, approvalVerify, blackListVerify);
    }

    private static Map<Long, Date> getAppFileIdAndLinkDate(DynamicObject[] salaryArr, List<Long> appFileIds) {
        LOG.info("HireSalaryViewService.getAppFileIdAndLinkDate");
        HashMap appFileIdAndLinkDate = Maps.newHashMapWithExpectedSize((int)salaryArr.length);
        for (DynamicObject dy : salaryArr) {
            Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"appfile");
            if (appFileId.equals(0L)) continue;
            appFileIds.add(appFileId);
            appFileIdAndLinkDate.put(appFileId, dy.getDate("linkmodifytime"));
        }
        return appFileIdAndLinkDate;
    }

    public static HireVerifyResult verifySalaryStatus(List<DynamicObject> appFileDyns) {
        LOG.info("HireSalaryService.verifySalaryStatus: appFileDyns:{} ", appFileDyns);
        return HireSalaryService.verifySalaryStatus(appFileDyns, HireSalaryKDStringHelper.inSalary());
    }

    public static HireVerifyResult verifySalaryStatus(List<DynamicObject> appFileDyns, String notifyMsg) {
        LOG.info("HireSalaryService.verifySalaryStatus: appFileDyns:{} ", appFileDyns);
        HireVerifyResult appFileResult = new HireVerifyResult();
        for (DynamicObject appFileDyn : appFileDyns) {
            String salaryStatus = appFileDyn.getString("setsalarystatus");
            Long appFileId = appFileDyn.getLong("id");
            if ("I".equals(salaryStatus)) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{notifyMsg}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static HireVerifyResult verifySalaryStatusInProcess(List<DynamicObject> appFileDyns, String message) {
        LOG.info("HireSalaryService.verifySalaryStatusInProcess: appFileDyns:{} ", appFileDyns);
        HireVerifyResult appFileResult = new HireVerifyResult();
        for (DynamicObject appFileDyn : appFileDyns) {
            String salaryStatus = appFileDyn.getString("setsalarystatus");
            Long appFileId = appFileDyn.getLong("id");
            if (!"I".equals(salaryStatus)) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{message}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static HireVerifyResult verifyAppFileLinkSalaryVersion(Map<Long, Date> appFileIdAndSalaryModifyDate, List<Long> appFileIds) {
        LOG.info("HireSalaryService.verifyAppFileLinkSalaryVersion: appFileIdAndSalaryModifyDate:{} ", appFileIdAndSalaryModifyDate);
        if (appFileIdAndSalaryModifyDate == null) {
            appFileIdAndSalaryModifyDate = Collections.emptyMap();
        }
        HireVerifyResult appFileResult = new HireVerifyResult();
        ArrayList column = Lists.newArrayListWithExpectedSize((int)4);
        column.add("modifytime");
        Map<Long, DynamicObject> appFileIdAndAppFileDyn = HireDataHelper.getLatestHireHireDynByAppFileId("tspr_hiresalary", appFileIds, column);
        for (Map.Entry<Long, Date> entry : appFileIdAndSalaryModifyDate.entrySet()) {
            Long newestSalaryModifyTime;
            Date verifyDate = entry.getValue();
            Long appFileId = entry.getKey();
            DynamicObject salaryDyn = appFileIdAndAppFileDyn.get(appFileId);
            if (salaryDyn == null && verifyDate == null) {
                appFileResult.getSuccessAppFileId().add(appFileId);
                continue;
            }
            Long verifyTimestamp = verifyDate == null ? 0L : verifyDate.getTime();
            if (!verifyTimestamp.equals(newestSalaryModifyTime = Long.valueOf(salaryDyn == null ? 0L : salaryDyn.getDate("modifytime").getTime()))) {
                appFileResult.getFailAppFileId().add(appFileId);
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireSalaryKDStringHelper.dataVersionChange()}));
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }

    public static List<DynamicObject> convertSalaryToSalaryBill(List<DynamicObject> salaryDys) {
        LOG.info("HireSalaryService.convertSalaryToSalaryBill");
        if (salaryDys == null || salaryDys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList salaryBills = Lists.newArrayListWithExpectedSize((int)salaryDys.size());
        HRBaseServiceHelper salaryBillService = new HRBaseServiceHelper("tspr_hiresalarybill");
        long[] genLongIds = ORM.create().genLongIds("tspr_hiresalarybill", salaryDys.size());
        long[] genLongIdsForBillNo = ORM.create().genLongIds("tspr_hiresalarybill", salaryDys.size());
        for (int i = 0; i < salaryDys.size(); ++i) {
            DynamicObject salary = salaryDys.get(i);
            DynamicObject salaryBill = salaryBillService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)salary, (DynamicObject)salaryBill);
            salaryBill.set("salary", salary.getPkValue());
            salaryBill.set("id", (Object)genLongIds[i]);
            salaryBill.set("billno", (Object)genLongIdsForBillNo[i]);
            salaryBill.set("isexistsworkflow", (Object)Boolean.TRUE);
            String billName = HireSalaryKDStringHelper.salaryTaskName();
            DynamicObject appFileDyn = salary.getDynamicObject("appfile");
            salaryBill.set("name", (Object)(appFileDyn.getString("name") + billName));
            salaryBills.add(salaryBill);
        }
        return salaryBills;
    }

    public static void supplementSalaryBillInfoForComplete(DynamicObject[] salaryBills) {
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Long userId = TSCRequestContext.getUserId();
        for (DynamicObject dy : salaryBills) {
            dy.set("handler", (Object)userId);
            dy.set("handletime", (Object)now);
            dy.set("modifytime", (Object)now);
            dy.set("modifier", (Object)userId);
            dy.set("handlestatus", (Object)"S");
        }
        HireSalaryService.setSalaryBillValue(salaryBills);
        HireSalaryService.setSalaryBillValueOfSalaryExp(salaryBills);
    }

    public static Map<Long, Boolean> setSalaryBillValue(DynamicObject[] salaryBills) {
        List<DynamicObject> salaryBillList = Arrays.asList(salaryBills);
        Map<Long, Boolean> existJobRank = HireJobRankService.getSuccessJobRankForHireDomain(salaryBillList, HireInitDataConstants.getJobrankbaseUnCopyVal(), JOBRANK_SALARY_TRANS_KEY);
        return existJobRank;
    }

    public static void setSalaryBillValueOfSalaryExp(DynamicObject[] salaryBills) {
        List<DynamicObject> salaryBillList = Arrays.asList(salaryBills);
        HireService.copyHireSalaryExptValToHireDyn(Lists.newArrayList(salaryBillList), HireInitDataConstants.getSalaryexptUnCopyVal(), Collections.emptyMap());
    }

    public static DynamicObject[] setSalaryBySalaryBill(DynamicObject[] salaryBills) {
        DynamicObject[] salaryDys;
        Object[] salaryIds = new Long[salaryBills.length];
        HashMap map = Maps.newHashMapWithExpectedSize((int)salaryBills.length);
        for (int i = 0; i < salaryBills.length; ++i) {
            DynamicObject salaryBill = salaryBills[i];
            Long salaryId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)salaryBill, (String)"salary");
            salaryIds[i] = salaryId;
            map.put(salaryId, salaryBill);
        }
        for (DynamicObject salaryDy : salaryDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_hiresalary").loadDynamicObjectArray(salaryIds)) {
            Long salaryId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)salaryDy, (String)"id");
            DynamicObject salaryBill = (DynamicObject)map.get(salaryId);
            if (salaryBill == null) continue;
            HRDynamicObjectUtils.copy((DynamicObject)salaryBill, (DynamicObject)salaryDy, (Set)HireSalaryInitDataConstants.SALARYBILL_UN_COPY_VAL, (Map)Maps.newHashMap());
        }
        return salaryDys;
    }

    public static Map<Long, DynamicObject> getSuccessHireDynMap(List<DynamicObject> approvalDys) {
        ArrayList appFileIdList = Lists.newArrayListWithExpectedSize((int)approvalDys.size());
        for (DynamicObject dy : approvalDys) {
            appFileIdList.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"appfile"));
        }
        return HireDataHelper.getSuccessHireDyn("tspr_hiresalary", appFileIdList);
    }

    public static DynamicObject[] getHireSalaryData(List<Long> idList) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_hiresalary");
        return serviceHelper.loadDynamicObjectArray((Object[])idList.toArray(new Long[idList.size()]));
    }

    public static void saveHireSalaryData(List<DynamicObject> saveList, List<DynamicObject> editList) {
        HRBaseServiceHelper hireSalaryServiceHelper = new HRBaseServiceHelper("tspr_hiresalary");
        hireSalaryServiceHelper.save(saveList.toArray(new DynamicObject[saveList.size()]));
        hireSalaryServiceHelper.update(editList.toArray(new DynamicObject[editList.size()]));
    }

    public static void sendHireCancelMessage(DynamicObject[] salaryBillDys) {
        String tag = HireSalaryKDStringHelper.cancelSalaryTag();
        String MessageContentStr = HireSalaryKDStringHelper.cancelSalaryMessageContent();
        HireService.sendHireCancelMessage(salaryBillDys, "tspr_hiresalarybill", HireSalaryKDStringHelper.cancelSalary(), tag, MessageContentStr);
    }

    public static void sendHireCompleteMessage(DynamicObject[] salaryBillDys) {
        String tag = HireSalaryKDStringHelper.completeSalaryTag();
        String MessageContentStr = HireSalaryKDStringHelper.completeSalaryMessageContent();
        HireService.sendHireCompleteMessage(salaryBillDys, "tspr_hiresalarybill", HireSalaryKDStringHelper.completeSalary(), tag, MessageContentStr);
    }

    public static void setDefaultFeeValue(DynamicObject salaryDy) {
        salaryDy.set("trafficfeecompany", (Object)VALUE_D);
        salaryDy.set("restaurantfeecompany", (Object)VALUE_D);
        salaryDy.set("communicafeecompany", (Object)VALUE_M);
        salaryDy.set("rentfeecompany", (Object)VALUE_M);
        salaryDy.set("housingfeecompany", (Object)VALUE_M);
    }

    static {
        JOBRANK_SALARY_TRANS_KEY.put("createorg", "jobscmorg");
    }
}

