/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.salary;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.common.HireFreeWorkFlowService;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.salary.HireSalaryDataHelper;
import kd.tsc.tspr.business.domain.hire.salary.HireSalaryKDStringHelper;
import kd.tsc.tspr.business.domain.hire.salary.HireSalaryService;
import kd.tsc.tspr.common.constants.hire.HireSalaryInitDataConstants;
import kd.tsc.tspr.common.hire.HireVerifyResult;

public class HireSalaryViewService {
    private static final Log LOG = LogFactory.getLog(HireSalaryViewService.class);
    public static final String KEY_ENTRYENTITY = "entryentity";
    public static final String KEY_LINKMODIFYTIME = "linkmodifytime";
    private static final String VALUE_EMPTY = "";
    public static final String VALUE_P = "P";
    private static final String VALUE_DEFAULT_VALUE = " ";
    private static final String KEY_AMTPRECISION = "amtprecision";
    private static final String MAX_NUM = "9999999999";
    private static final BigDecimal MAXVALUE = new BigDecimal("9999999999.99");
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private static final String[] MONTHLY = new String[]{"basicwage", "achievementwage", "positionwage"};
    private static final String[] PROBMONTHLYSALARY = new String[]{"probbasicwage", "probachievementwage", "probpositionwage"};

    public static void handleAppFileF7(BeforeF7SelectEvent beforeF7SelectEvent, List<Long> filterAppFileId) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if ("appfile".equals(key)) {
            ArrayList appFileQFilter = Lists.newArrayListWithExpectedSize((int)3);
            appFileQFilter.add(AppFileListHelper.getIsInProcessQFilter());
            appFileQFilter.add(AppFileListHelper.getFlowLockQFilter());
            QFilter jobRankStatusQFilter = new QFilter("setsalarystatus", "in", Arrays.asList("W", "S"));
            appFileQFilter.add(jobRankStatusQFilter);
            appFileQFilter.add(HireService.getBlackListQFilter());
            QFilter hireApprlStatusQFilter = new QFilter("employapprlsatatus", "in", Arrays.asList("F", VALUE_DEFAULT_VALUE));
            appFileQFilter.add(hireApprlStatusQFilter);
            if (filterAppFileId != null && !filterAppFileId.isEmpty()) {
                QFilter appFileNotInFilter = new QFilter("id", "not in", filterAppFileId);
                appFileQFilter.add(appFileNotInFilter);
            }
            beforeF7SelectEvent.setCustomQFilters((List)appFileQFilter);
        }
    }

    public static void beforeCreateNewDataForBase(IFormView formView, IDataModel dataModel) {
        Long appFileId = (Long)formView.getFormShowParameter().getCustomParam("appFileId");
        LOG.info("HireSalaryViewService.beforeCreateNewDataForBase appFileId={}", (Object)appFileId);
        if (HRObjectUtils.isEmpty((Object)appFileId)) {
            return;
        }
        HRBaseServiceHelper appFileService = new HRBaseServiceHelper("tspr_appfile");
        String selectProperties = "createorg,adminorg,position";
        DynamicObject appFileDyn = appFileService.queryOne(selectProperties, (Object)appFileId);
        dataModel.setValue("appfile", (Object)appFileDyn);
        dataModel.setValue("type", (Object)"D");
        dataModel.setValue("handlestatus", (Object)"S");
        dataModel.setValue("createorg", appFileDyn.get("createorg"));
        dataModel.setValue("adminorg", appFileDyn.get("adminorg"));
        HireSalaryViewService.setLinkModifyTimeToModel(appFileId, dataModel);
    }

    public static Map<Long, DynamicObject> getAppFileModifyTime(List<Long> appFileIds) {
        LOG.info("HireSalaryViewService.getAppFileModifyTime appFileIds={}", appFileIds);
        ArrayList queryColumn = Lists.newArrayListWithExpectedSize((int)1);
        queryColumn.add("modifytime");
        queryColumn.add("handlestatus");
        return HireDataHelper.getLatestHireHireDynByAppFileId("tspr_hiresalary", appFileIds, queryColumn);
    }

    public static void setKeyLinkModifyTimeAndAppFileBatch(IFormView formView, IDataModel dataModel) {
        List appFiles = (List)formView.getFormShowParameter().getCustomParam("appFileId");
        LOG.info("HireSalaryViewService.setKeyLinkModifyTimeAndAppFileBatch appFileIds={}", (Object)appFiles);
        if (appFiles == null || appFiles.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> appFileAndLatestSalaryDyn = HireSalaryViewService.getAppFileModifyTime(appFiles);
        int[] rowIndex = dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY, appFiles.size());
        for (int i = 0; i < appFiles.size(); ++i) {
            Long appFileId = (Long)appFiles.get(i);
            DynamicObject linkSalaryDyn = appFileAndLatestSalaryDyn.get(appFileId);
            if (linkSalaryDyn != null) {
                dataModel.setValue(KEY_LINKMODIFYTIME, (Object)linkSalaryDyn.getDate("modifytime"), rowIndex[i]);
            }
            dataModel.setValue("appfile", (Object)appFileId, rowIndex[i]);
        }
    }

    public static void setKeyLinkModifyTimeAndAppFile(Long appFileId, IFormView formView, IDataModel dataModel, boolean isShow) {
        LOG.info("HireSalaryViewService.setKeyLinkModifyTimeAndAppFile appFileId={}", (Object)appFileId);
        Map<Long, DynamicObject> appFileAndLatestSalaryDyn = HireSalaryViewService.getAppFileModifyTime(Collections.singletonList(appFileId));
        dataModel.setValue("appfile", (Object)appFileId);
        DynamicObject linkSalaryDyn = appFileAndLatestSalaryDyn.get(appFileId);
        if (linkSalaryDyn != null) {
            dataModel.setValue(KEY_LINKMODIFYTIME, (Object)linkSalaryDyn.getDate("modifytime"));
            if (isShow) {
                String salaryStatus = linkSalaryDyn.getString("handlestatus");
                formView.setVisible(Boolean.valueOf("S".equals(salaryStatus)), new String[]{"tipflex"});
            }
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"tipflex"});
        }
    }

    public static void setLinkModifyTimeToModel(Long appFileId, IDataModel dataModel) {
        LOG.info("HireSalaryViewService.setLinkModifyTimeToModel appFileId={}", (Object)appFileId);
        Map<Long, DynamicObject> appFileAndLatestSalaryDyn = HireSalaryViewService.getAppFileModifyTime(Collections.singletonList(appFileId));
        DynamicObject linkSalaryDyn = appFileAndLatestSalaryDyn.get(appFileId);
        if (linkSalaryDyn != null) {
            dataModel.setValue(KEY_LINKMODIFYTIME, (Object)linkSalaryDyn.getDate("modifytime"));
        }
    }

    private static List<DynamicObject> dealWith(IDataModel dataModel, boolean isBatch) {
        if (isBatch) {
            DynamicObjectCollection entryData = dataModel.getEntryEntity(KEY_ENTRYENTITY);
            return entryData.getInsertRows();
        }
        DynamicObject dataEntity = dataModel.getDataEntity();
        if (dataEntity == null) {
            return Lists.newArrayList();
        }
        ArrayList<DynamicObject> entryDataList = new ArrayList<DynamicObject>();
        entryDataList.add(dataEntity);
        return entryDataList;
    }

    public static void handleSubmitForEntry(IFormView formView, IDataModel dataModel, boolean isBatch, String targetPage) {
        LOG.info("HireSalaryViewService.handleSubmitForEntry start_salary");
        List<DynamicObject> entryDataList = HireSalaryViewService.dealWith(dataModel, isBatch);
        if (entryDataList == null || entryDataList.size() == 0) {
            return;
        }
        boolean verifyResult = HireSalaryViewService.verifyEntryHandlerVal(entryDataList, formView);
        if (!verifyResult) {
            return;
        }
        HireService.convertHrPersonToBosUser(entryDataList, "personhandler", "handler");
        DynamicObject[] salaryArr = new DynamicObject[entryDataList.size()];
        entryDataList.toArray(salaryArr);
        HireVerifyResult allVerifyResult = HireSalaryService.beforeOperateDataVerifyResult(salaryArr, false);
        boolean isNext = HireSalaryViewService.dealWithCheckResult(allVerifyResult, formView);
        if (!isNext) {
            LOG.info("HireSalaryViewService.handleSubmitForEntry have not success data");
            return;
        }
        List<DynamicObject> salaryDys = HireSalaryViewService.convertDynCollectionToSalary(entryDataList, allVerifyResult);
        HireService.initHireCommonMsg(salaryDys, "tspr_hiresalary", false);
        List<DynamicObject> salaryBills = HireSalaryService.convertSalaryToSalaryBill(salaryDys);
        boolean commitResult = HireSalaryDataHelper.commitSalaryDataForTypeSend(salaryDys, salaryBills, false);
        boolean isWorkFlow = HireSalaryViewService.dealWithCommitResult(allVerifyResult, commitResult);
        if (isWorkFlow) {
            LOG.info("HireSalaryViewService.handleSubmitForEntry start_work_flow");
            HireFreeWorkFlowService.buildHireTask(salaryBills.toArray(new DynamicObject[0]), targetPage);
        }
        OperationResult operationResult = HireService.getOperationResult(allVerifyResult);
        if (commitResult) {
            operationResult.setMessage(HireSalaryKDStringHelper.opSuccess());
        } else {
            operationResult.setMessage(HireSalaryKDStringHelper.opFail());
        }
        formView.returnDataToParent((Object)HireService.serializerOperationResult(operationResult));
        operationResult.setShowMessage(false);
        formView.close();
    }

    private static boolean dealWithCheckResult(HireVerifyResult allVerifyResult, IFormView formView) {
        boolean noSuccess;
        Set successAppFileId = allVerifyResult.getSuccessAppFileId();
        boolean bl = noSuccess = successAppFileId == null || successAppFileId.isEmpty();
        if (noSuccess) {
            OperationResult operationResult = HireService.getOperationResult(allVerifyResult);
            formView.returnDataToParent((Object)HireService.serializerOperationResult(operationResult));
            operationResult.setShowMessage(false);
            formView.close();
            return false;
        }
        return true;
    }

    private static boolean dealWithCommitResult(HireVerifyResult allVerifyResult, boolean commitResult) {
        LOG.info("HireSalaryViewService.dealWithCommitResult");
        if (!commitResult) {
            Set appFileNeedHandle = allVerifyResult.getSuccessAppFileId();
            allVerifyResult.getFailAppFileId().addAll(appFileNeedHandle);
            for (Long aLong : appFileNeedHandle) {
                allVerifyResult.getFailReason().put(aLong, Lists.newArrayList((Object[])new String[]{HireSalaryKDStringHelper.dataBaseOperateError()}));
            }
            allVerifyResult.getSuccessAppFileId().removeAll(allVerifyResult.getSuccessAppFileId());
            return false;
        }
        return true;
    }

    public static String handleSubmitForEntry(DynamicObject[] salaryArr) {
        LOG.info("HireSalaryViewService.handleSubmitForEntry direct_salary");
        String result = VALUE_EMPTY;
        HireVerifyResult allVerifyResult = HireSalaryService.beforeOperateDataVerifyResult(salaryArr, false);
        Set failAppFileId = allVerifyResult.getFailAppFileId();
        StringBuilder sb = new StringBuilder();
        boolean isReturn = false;
        if (failAppFileId != null && !failAppFileId.isEmpty()) {
            for (Long aLong : failAppFileId) {
                isReturn = true;
                List strList = (List)allVerifyResult.getFailReason().get(aLong);
                for (String str : strList) {
                    sb.append(str);
                }
            }
        }
        if (isReturn) {
            return sb.toString();
        }
        ArrayList<DynamicObject> salaryList = new ArrayList<DynamicObject>(salaryArr.length);
        Collections.addAll(salaryList, salaryArr);
        HireService.initHireCommonMsg(salaryList, "tspr_hiresalary", true);
        ArrayList<DynamicObject> salaryBills = new ArrayList<DynamicObject>();
        boolean commitResult = HireSalaryDataHelper.commitSalaryDataForTypeSend(salaryList, salaryBills, true);
        if (!commitResult) {
            result = HireSalaryKDStringHelper.dataBaseOperateError();
        }
        return result;
    }

    private static List<DynamicObject> convertDynCollectionToSalary(List<DynamicObject> entryDataList, HireVerifyResult verifyResult) {
        LOG.info("HireSalaryViewService.convertDynCollectionToSalary data_to_salaryData");
        HRBaseServiceHelper salaryService = new HRBaseServiceHelper("tspr_hiresalary");
        ArrayList salaryList = Lists.newArrayListWithExpectedSize((int)entryDataList.size());
        Map<Long, DynamicObject> currencyMap = HireSalaryViewService.getCurrencyMap(entryDataList);
        DynamicObject defaultCurrency = HireSalaryViewService.getDefaultCurrency();
        for (DynamicObject entryDatum : entryDataList) {
            DynamicObject appFileDyn = entryDatum.getDynamicObject("appfile");
            boolean contains = verifyResult.getSuccessAppFileId().contains(appFileDyn.getLong("id"));
            if (!contains || HRObjectUtils.isEmpty((Object)appFileDyn)) continue;
            DynamicObject salary = salaryService.generateEmptyDynamicObject();
            salary.set("appfile", (Object)appFileDyn);
            salary.set("handler", (Object)entryDatum.getDynamicObject("handler"));
            Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)appFileDyn, (String)"position");
            DynamicObject currency = currencyMap.get(positionId);
            if (currency == null) {
                salary.set("formalcurrency", (Object)defaultCurrency);
                salary.set("yearsharcur", (Object)defaultCurrency);
                salary.set("opvalcur", (Object)defaultCurrency);
            } else {
                salary.set("formalcurrency", (Object)currency);
                salary.set("yearsharcur", (Object)currency);
                salary.set("opvalcur", (Object)currency);
            }
            HireSalaryService.setDefaultFeeValue(salary);
            salaryList.add(salary);
        }
        return salaryList;
    }

    public static DynamicObject getDefaultCurrency() {
        HRBaseServiceHelper currencyService = new HRBaseServiceHelper("bd_currency");
        QFilter numberQFilter = new QFilter("number", "=", (Object)"CNY");
        QFilter[] qFilters = new QFilter[]{numberQFilter};
        DynamicObject[] dynamicObjects = currencyService.loadDynamicObjectArray(qFilters);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        LOG.info("HireSalaryViewService.getDefaultCurrency no data");
        return currencyService.generateEmptyDynamicObject();
    }

    private static Map<Long, DynamicObject> getCurrencyMap(List<DynamicObject> entryDataList) {
        LOG.info("HireSalaryViewService.getCurrencyMap");
        ArrayList positionIdList = Lists.newArrayListWithExpectedSize((int)1);
        for (DynamicObject entryDatum : entryDataList) {
            DynamicObject appFileDyn = entryDatum.getDynamicObject("appfile");
            Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)appFileDyn, (String)"position");
            positionIdList.add(positionId);
        }
        Object[] positionArr = new Long[positionIdList.size()];
        positionIdList.toArray(positionArr);
        HRBaseServiceHelper positionService = new HRBaseServiceHelper("tspr_position");
        DynamicObject[] positionDys = positionService.loadDynamicObjectArray(positionArr);
        HashMap map = Maps.newHashMapWithExpectedSize((int)positionDys.length);
        for (DynamicObject dy : positionDys) {
            map.put(dy.getLong("id"), dy.getDynamicObject("currency"));
        }
        return map;
    }

    public static Boolean showSalaryInfo(DynamicObject salaryBill) {
        LOG.info("HireSalaryViewService_showSalaryInfo");
        String handleStatus = salaryBill.getString("handlestatus");
        if (!HRStringUtils.equals((String)"I", (String)handleStatus)) {
            Object position = salaryBill.get("position");
            Object dept = salaryBill.get("dept");
            return !HRObjectUtils.isEmpty((Object)position) || !HRObjectUtils.isEmpty((Object)dept);
        }
        DynamicObject[] salaryBills = new DynamicObject[]{salaryBill};
        HireSalaryService.setSalaryBillValueOfSalaryExp(salaryBills);
        Map<Long, Boolean> existJobRank = HireSalaryService.setSalaryBillValue(salaryBills);
        Long appFileId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)salaryBill, (String)"appfile");
        return existJobRank.get(appFileId);
    }

    public static boolean verifyEntryHandlerVal(List<DynamicObject> entryDataList, IFormView formView) {
        for (DynamicObject entryDatum : entryDataList) {
            DynamicObject appFile = (DynamicObject)entryDatum.get("appfile");
            DynamicObject handler = (DynamicObject)entryDatum.get("personhandler");
            if (HRObjectUtils.isEmpty((Object)appFile)) {
                formView.showErrorNotification(HireCommonKDStringHelper.missAppFile());
                return false;
            }
            if (!HRObjectUtils.isEmpty((Object)handler)) continue;
            formView.showErrorNotification(HireSalaryKDStringHelper.missHandle());
            return false;
        }
        return true;
    }

    public static void setSalaryDefaultInfoForApproval(DynamicObject approvalDy, DynamicObject salaryDy) {
        HireSalaryService.setDefaultFeeValue(salaryDy);
        DynamicObject appFileDy = approvalDy.getDynamicObject("appfile");
        if (HRObjectUtils.isEmpty((Object)appFileDy)) {
            return;
        }
        DynamicObject currency = HireSalaryViewService.getCurrency(appFileDy);
        salaryDy.set("formalcurrency", (Object)currency);
        salaryDy.set("probcurrency", (Object)currency);
        salaryDy.set("feecurrency", (Object)currency);
        salaryDy.set("yearsharcur", (Object)currency);
        salaryDy.set("opvalcur", (Object)currency);
    }

    public static void setCurrencyInfo(DynamicObject appFileDyn, IDataModel model) {
        Object opValCur;
        DynamicObject currency = HireSalaryViewService.getCurrency(appFileDyn);
        Object formalCurrency = model.getValue("formalcurrency");
        if (HRObjectUtils.isEmpty((Object)formalCurrency)) {
            model.setValue("formalcurrency", (Object)currency);
            model.setValue("probcurrency", (Object)currency);
            model.setValue("feecurrency", (Object)currency);
        } else {
            model.setValue("probcurrency", formalCurrency);
            model.setValue("feecurrency", formalCurrency);
        }
        Object yearsHarCur = model.getValue("yearsharcur");
        if (HRObjectUtils.isEmpty((Object)yearsHarCur)) {
            model.setValue("yearsharcur", (Object)currency);
        }
        if (HRObjectUtils.isEmpty((Object)(opValCur = model.getValue("opvalcur")))) {
            model.setValue("opvalcur", (Object)currency);
        }
    }

    public static DynamicObject getCurrency(DynamicObject appFileDyn) {
        DynamicObject currency;
        HRBaseServiceHelper positionService = new HRBaseServiceHelper("tspr_position");
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)appFileDyn, (String)"position");
        Object[] positionArr = new Long[]{positionId};
        DynamicObject[] positionDys = positionService.loadDynamicObjectArray(positionArr);
        if (positionDys != null && positionDys.length > 0 && !HRObjectUtils.isEmpty((Object)(currency = positionDys[0].getDynamicObject("currency")))) {
            return currency;
        }
        return HireSalaryViewService.getDefaultCurrency();
    }

    public static void afterBindData(IFormView formView, IDataModel model) {
        DynamicObject appFile = (DynamicObject)model.getValue("appfile");
        HireSalaryViewService.setCurrencyInfo(appFile, model);
        HireSalaryViewService.setVisible(formView, model);
    }

    public static void setVisible(IFormView formView, IDataModel model) {
        String payType = (String)model.getValue("paytype");
        if (HRStringUtils.isEmpty((String)payType)) {
            HireSalaryViewService.setDefaultPayNumVisible(formView);
            return;
        }
        boolean isShow = HRStringUtils.equalsIgnoreCase((String)VALUE_P, (String)payType);
        HireSalaryViewService.setPayNumVisible(formView, isShow);
    }

    public static void setPayNumVisible(IFormView formView, boolean isShow) {
        formView.setVisible(Boolean.valueOf(isShow), new String[]{"paynum", "labelap3"});
        formView.setEnable(Boolean.valueOf(!isShow), PROBMONTHLYSALARY);
    }

    public static void setDefaultPayNumVisible(IFormView formView) {
        formView.setVisible(Boolean.FALSE, new String[]{"paynum", "labelap3"});
        formView.setEnable(Boolean.FALSE, PROBMONTHLYSALARY);
    }

    public static List<String> hireSalaryCheckResult(DynamicObject dy) {
        BigDecimal probMonthlySalary;
        BigDecimal yearEndBounds;
        ArrayList<String> resultList = new ArrayList<String>();
        BigDecimal maxNum = HireSalaryViewService.getMaxNum(dy);
        BigDecimal monthlySalary = dy.getBigDecimal("monthlysalary");
        if (monthlySalary.compareTo(maxNum) > 0) {
            resultList.add(String.format(Locale.ROOT, HireSalaryKDStringHelper.monthSalaryDataError(), maxNum));
        }
        if ((yearEndBounds = dy.getBigDecimal("yearendbonus")).compareTo(maxNum) > 0) {
            resultList.add(String.format(Locale.ROOT, HireSalaryKDStringHelper.yearSalaryDataError(), maxNum));
        }
        if ((probMonthlySalary = dy.getBigDecimal("probmonthlysalary")).compareTo(maxNum) > 0) {
            resultList.add(String.format(Locale.ROOT, HireSalaryKDStringHelper.probMonthlySalaryDataError(), maxNum));
        }
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkTrafficFee(dy, maxNum));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkRestaurantfee(dy, maxNum));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkCommunicationFee(dy, maxNum));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkRentFee(dy, maxNum));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkHoursFee(dy, maxNum));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkRssHarNum(dy, MAXVALUE));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkYearsHarNum(dy, maxNum));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkOpsHarNum(dy, MAXVALUE));
        HireSalaryViewService.dealWithResult(resultList, HireSalaryViewService.checkOpValNum(dy, maxNum));
        DynamicObject formalCurrency = dy.getDynamicObject("formalcurrency");
        if (HRObjectUtils.isEmpty((Object)formalCurrency)) {
            resultList.add(HireSalaryKDStringHelper.formalCurrencyDataError());
        }
        return resultList;
    }

    private static void dealWithResult(List<String> resultList, String msg) {
        if (!HRStringUtils.equals((String)VALUE_EMPTY, (String)msg)) {
            resultList.add(msg);
        }
    }

    private static BigDecimal getMaxNum(DynamicObject dataEntity) {
        return new BigDecimal(HireSalaryViewService.getMaxNumStr(dataEntity));
    }

    private static String getMaxNumStr(DynamicObject dataEntity) {
        DynamicObject currency = dataEntity.getDynamicObject("formalcurrency");
        int amtPrecision = 4;
        if (!HRObjectUtils.isEmpty((Object)currency)) {
            amtPrecision = currency.getInt(KEY_AMTPRECISION);
        }
        if (amtPrecision > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(MAX_NUM);
            sb.append(".");
            for (int i = 0; i < amtPrecision; ++i) {
                sb.append("9");
            }
            return sb.toString();
        }
        return MAX_NUM;
    }

    public static void setAndCheckSalaryData(IFormView formView, IDataModel dataModel, String changeKey, Object newValue, Object oldValue) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        if (HRStringUtils.equals((String)"formalcurrency", (String)changeKey)) {
            HireSalaryViewService.dealWithCur(dataEntity, formView, dataModel, newValue, oldValue);
        } else if (HRStringUtils.equals((String)"yearendbonus", (String)changeKey)) {
            HireSalaryViewService.dealWithYearEndBonus(dataEntity, formView, dataModel);
        } else {
            HireSalaryViewService.dealWithSalaryData(formView, dataModel, changeKey, dataEntity);
        }
    }

    private static void dealWithCur(DynamicObject dataEntity, IFormView formView, IDataModel dataModel, Object newValue, Object oldValue) {
        DynamicObject formalCurrency = dataEntity.getDynamicObject("formalcurrency");
        if (!HRObjectUtils.isEmpty((Object)oldValue) && !HRObjectUtils.equals((Object)newValue, (Object)oldValue)) {
            formView.showTipNotification(HireSalaryKDStringHelper.currencyChangeInfo());
        }
        if (formalCurrency != null) {
            dataModel.setValue("probcurrency", (Object)formalCurrency);
            dataModel.setValue("feecurrency", (Object)formalCurrency);
        }
    }

    private static void dealWithYearEndBonus(DynamicObject dataEntity, IFormView formView, IDataModel dataModel) {
        if (!HireSalaryViewService.checkSalary(dataEntity, "yearendbonus", dataModel)) {
            formView.showTipNotification(String.format(Locale.ROOT, HireSalaryKDStringHelper.yearSalaryDataError(), HireSalaryViewService.getMaxNumStr(dataEntity)));
        }
    }

    private static void dealWithSalaryData(IFormView formView, IDataModel dataModel, String changeKey, DynamicObject dataEntity) {
        if (HireSalaryInitDataConstants.CHECK_MONTH_KEY.contains(changeKey)) {
            HireSalaryViewService.dealWithSalaryMonthInfo(formView, dataModel, changeKey, dataEntity);
        } else if (HireSalaryInitDataConstants.CHECK_FEE_KEY.contains(changeKey)) {
            HireSalaryViewService.checkFeeInfo(formView, changeKey, dataEntity);
        } else if (HireSalaryInitDataConstants.CHECK_EXCITATION_KEY.contains(changeKey)) {
            HireSalaryViewService.checkExcitationInfo(formView, changeKey, dataEntity);
        }
    }

    private static void dealWithSalaryMonthInfo(IFormView formView, IDataModel dataModel, String changeKey, DynamicObject dataEntity) {
        if (!HireSalaryViewService.checkAndSetSalary(dataEntity, MONTHLY, "monthlysalary", dataModel)) {
            formView.updateView();
            formView.showTipNotification(String.format(Locale.ROOT, HireSalaryKDStringHelper.monthSalaryDataError(), HireSalaryViewService.getMaxNumStr(dataEntity)));
            return;
        }
        HireSalaryViewService.setProMonthSalaryInfo(formView, dataModel, dataEntity, changeKey);
        if (!HireSalaryViewService.checkAndSetSalary(dataEntity, PROBMONTHLYSALARY, "probmonthlysalary", dataModel)) {
            formView.updateView();
            formView.showTipNotification(String.format(Locale.ROOT, HireSalaryKDStringHelper.probMonthlySalaryDataError(), HireSalaryViewService.getMaxNumStr(dataEntity)));
        }
    }

    private static void setProMonthSalaryInfo(IFormView formView, IDataModel dataModel, DynamicObject dataEntity, String changeKey) {
        String payType = dataEntity.getString("paytype");
        if (payType == null || HRStringUtils.equals((String)payType, (String)VALUE_DEFAULT_VALUE)) {
            HireSalaryViewService.setDefaultPayNumVisible(formView);
            HireSalaryViewService.setProMonthSalaryInfo(dataModel);
            return;
        }
        boolean isShow = HRStringUtils.equals((String)VALUE_P, (String)payType);
        if (isShow) {
            int payNum = dataEntity.getInt("paynum");
            int anInt = dataEntity.getDynamicObject("formalcurrency").getInt(KEY_AMTPRECISION);
            dataModel.setValue("probbasicwage", (Object)HireSalaryViewService.calculation(payNum, dataEntity.getBigDecimal("basicwage"), anInt));
            dataModel.setValue("probachievementwage", (Object)HireSalaryViewService.calculation(payNum, dataEntity.getBigDecimal("achievementwage"), anInt));
            dataModel.setValue("probpositionwage", (Object)HireSalaryViewService.calculation(payNum, dataEntity.getBigDecimal("positionwage"), anInt));
            dataModel.setValue("probmonthlysalary", (Object)HireSalaryViewService.calculation(payNum, dataEntity.getBigDecimal("monthlysalary"), anInt));
        } else if (HRStringUtils.equals((String)"paytype", (String)changeKey)) {
            HireSalaryViewService.setProMonthSalaryInfo(dataModel);
        }
        HireSalaryViewService.setPayNumVisible(formView, isShow);
    }

    private static void setProMonthSalaryInfo(IDataModel dataModel) {
        dataModel.setValue("probbasicwage", null);
        dataModel.setValue("probachievementwage", null);
        dataModel.setValue("probpositionwage", null);
        dataModel.setValue("probmonthlysalary", null);
        dataModel.setValue("paynum", null);
    }

    private static void checkFeeInfo(IFormView formView, String changeKey, DynamicObject dataEntity) {
        String checkResult = VALUE_EMPTY;
        BigDecimal maxNum = HireSalaryViewService.getMaxNum(dataEntity);
        switch (changeKey) {
            case "trafficfee": 
            case "trafficfeecompany": {
                checkResult = HireSalaryViewService.checkTrafficFee(dataEntity, maxNum);
                break;
            }
            case "restaurantfee": 
            case "restaurantfeecompany": {
                checkResult = HireSalaryViewService.checkRestaurantfee(dataEntity, maxNum);
                break;
            }
            case "communicationfee": 
            case "communicafeecompany": {
                checkResult = HireSalaryViewService.checkCommunicationFee(dataEntity, maxNum);
                break;
            }
            case "rentfee": 
            case "rentfeecompany": {
                checkResult = HireSalaryViewService.checkRentFee(dataEntity, maxNum);
                break;
            }
            case "housingfee": 
            case "housingfeecompany": {
                checkResult = HireSalaryViewService.checkHoursFee(dataEntity, maxNum);
                break;
            }
        }
        if (!HRStringUtils.equals((String)VALUE_EMPTY, (String)checkResult)) {
            formView.showTipNotification(checkResult);
        }
    }

    private static String checkTrafficFee(DynamicObject dataEntity, BigDecimal maxNum) {
        return HireSalaryViewService.checkFee(dataEntity, "trafficfee", "trafficfeecompany", HireSalaryKDStringHelper.trafficFeeDataError(), HireSalaryKDStringHelper.trafficFeeComDataError(), maxNum);
    }

    private static String checkRestaurantfee(DynamicObject dataEntity, BigDecimal maxNum) {
        return HireSalaryViewService.checkFee(dataEntity, "restaurantfee", "restaurantfeecompany", HireSalaryKDStringHelper.restaurantFeeDataError(), HireSalaryKDStringHelper.restaurantFeeComDataError(), maxNum);
    }

    private static String checkCommunicationFee(DynamicObject dataEntity, BigDecimal maxNum) {
        return HireSalaryViewService.checkFee(dataEntity, "communicationfee", "communicafeecompany", HireSalaryKDStringHelper.communicationFeeDataError(), HireSalaryKDStringHelper.communicationFeeComDataError(), maxNum);
    }

    private static String checkRentFee(DynamicObject dataEntity, BigDecimal maxNum) {
        return HireSalaryViewService.checkFee(dataEntity, "rentfee", "rentfeecompany", HireSalaryKDStringHelper.rentFeeDataError(), HireSalaryKDStringHelper.rentFeeComDataError(), maxNum);
    }

    private static String checkHoursFee(DynamicObject dataEntity, BigDecimal maxNum) {
        return HireSalaryViewService.checkFee(dataEntity, "housingfee", "housingfeecompany", HireSalaryKDStringHelper.housingFeeDataError(), HireSalaryKDStringHelper.housingFeeComDataError(), maxNum);
    }

    private static void checkExcitationInfo(IFormView formView, String changeKey, DynamicObject dataEntity) {
        String checkResult = VALUE_EMPTY;
        BigDecimal maxNum = HireSalaryViewService.getMaxNum(dataEntity);
        switch (changeKey) {
            case "rssharnum": {
                checkResult = HireSalaryViewService.checkRssHarNum(dataEntity, MAXVALUE);
                break;
            }
            case "yearsharnum": 
            case "yearsharcur": {
                checkResult = HireSalaryViewService.checkYearsHarNum(dataEntity, maxNum);
                break;
            }
            case "opsharnum": {
                checkResult = HireSalaryViewService.checkOpsHarNum(dataEntity, MAXVALUE);
                break;
            }
            case "opvalnum": 
            case "opvalcur": {
                checkResult = HireSalaryViewService.checkOpValNum(dataEntity, maxNum);
                break;
            }
        }
        if (!HRStringUtils.equals((String)VALUE_EMPTY, (String)checkResult)) {
            formView.showTipNotification(checkResult);
        }
    }

    private static String checkRssHarNum(DynamicObject dataEntity, BigDecimal maxNum) {
        return HireSalaryViewService.checkExcitation(dataEntity, "rssharnum", HireSalaryKDStringHelper.rssHarNumDataError(), maxNum);
    }

    private static String checkYearsHarNum(DynamicObject dataEntity, BigDecimal maxNum) {
        String yearsHarNum = HireSalaryViewService.checkExcitation(dataEntity, "yearsharnum", HireSalaryKDStringHelper.yearHarNumDataError(), maxNum);
        if (!HRStringUtils.equals((String)VALUE_EMPTY, (String)yearsHarNum)) {
            return yearsHarNum;
        }
        BigDecimal yearsharnum = dataEntity.getBigDecimal("yearsharnum");
        DynamicObject yearsHarCur = dataEntity.getDynamicObject("yearsharcur");
        if (yearsharnum != null && yearsharnum.compareTo(BigDecimal.ZERO) != 0 && HRObjectUtils.isEmpty((Object)yearsHarCur)) {
            return HireSalaryKDStringHelper.yearsHarNumComDataError();
        }
        return VALUE_EMPTY;
    }

    private static String checkOpsHarNum(DynamicObject dataEntity, BigDecimal maxNum) {
        return HireSalaryViewService.checkExcitation(dataEntity, "opsharnum", HireSalaryKDStringHelper.opsHarNumDataError(), maxNum);
    }

    private static String checkOpValNum(DynamicObject dataEntity, BigDecimal maxNum) {
        String opValNum = HireSalaryViewService.checkExcitation(dataEntity, "opvalnum", HireSalaryKDStringHelper.opValNumDataError(), maxNum);
        if (!HRStringUtils.equals((String)VALUE_EMPTY, (String)opValNum)) {
            return opValNum;
        }
        BigDecimal opvalnum = dataEntity.getBigDecimal("opvalnum");
        DynamicObject opValCur = dataEntity.getDynamicObject("opvalcur");
        if (opvalnum != null && opvalnum.compareTo(BigDecimal.ZERO) != 0 && HRObjectUtils.isEmpty((Object)opValCur)) {
            return HireSalaryKDStringHelper.opValNumComDataError();
        }
        return VALUE_EMPTY;
    }

    private static BigDecimal calculation(int payNum, BigDecimal bigDecimal, int anInt) {
        if (HRObjectUtils.isEmpty((Object)bigDecimal)) {
            return null;
        }
        return bigDecimal.multiply(new BigDecimal(String.valueOf(payNum))).divide(HUNDRED).setScale(anInt, 4);
    }

    private static boolean checkAndSetSalary(DynamicObject dataEntity, String[] keys, String monthSalary, IDataModel dataModel) {
        BigDecimal sum = BigDecimal.ZERO;
        for (String key : keys) {
            BigDecimal bigDecimal = HRObjectUtils.isEmpty((Object)dataEntity.getBigDecimal(key)) ? BigDecimal.ZERO : dataEntity.getBigDecimal(key);
            sum = sum.add(bigDecimal);
        }
        if (sum.compareTo(HireSalaryViewService.getMaxNum(dataEntity)) > 0) {
            for (String key : keys) {
                dataModel.beginInit();
                dataModel.setValue(key, null);
                dataModel.endInit();
            }
            return false;
        }
        dataModel.setValue(monthSalary, (Object)sum);
        return true;
    }

    private static boolean checkSalary(DynamicObject dataEntity, String key, IDataModel dataModel) {
        BigDecimal value = dataEntity.getBigDecimal(key);
        if (value.compareTo(HireSalaryViewService.getMaxNum(dataEntity)) > 0) {
            dataModel.setValue(key, null);
            return false;
        }
        return true;
    }

    private static String checkFee(DynamicObject dataEntity, String feeKey, String feeCompanyKey, String msg, String companyMsg, BigDecimal maxNum) {
        BigDecimal bigDecimal = dataEntity.getBigDecimal(feeKey);
        if (HRObjectUtils.isEmpty((Object)bigDecimal) || bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return VALUE_EMPTY;
        }
        if (bigDecimal.compareTo(maxNum) > 0) {
            return String.format(Locale.ROOT, msg, maxNum);
        }
        String company = dataEntity.getString(feeCompanyKey);
        if (HRStringUtils.isEmpty((String)company)) {
            return companyMsg;
        }
        return VALUE_EMPTY;
    }

    private static String checkExcitation(DynamicObject dataEntity, String feeKey, String msg, BigDecimal maxNum) {
        BigDecimal bigDecimal = dataEntity.getBigDecimal(feeKey);
        if (HRObjectUtils.isEmpty((Object)bigDecimal) || bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return VALUE_EMPTY;
        }
        if (bigDecimal.compareTo(maxNum) > 0) {
            return String.format(Locale.ROOT, msg, maxNum);
        }
        return VALUE_EMPTY;
    }

    public static boolean existSalarySuccessStatus(DynamicObjectCollection entry) {
        for (DynamicObject dyData : entry) {
            String salaryStatus;
            DynamicObject appFileDy = (DynamicObject)dyData.get("appfile");
            if (appFileDy == null || !"S".equals(salaryStatus = appFileDy.getString("setsalarystatus"))) continue;
            return true;
        }
        return false;
    }
}

