/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.salaryexpt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.hire.common.HireDataHelper;
import kd.tsc.tspr.business.domain.hire.salaryexpt.HireSalaryExpectKDStringHelper;
import kd.tsc.tspr.common.hire.HireVerifyResult;

public class HireSalaryExpectService {
    private static final Log LOG = LogFactory.getLog(HireSalaryExpectService.class);

    public static Map<Long, DynamicObject> getAppFileModifyTime(List<Long> appFileIds) {
        LOG.info("HireSalaryViewService.getAppFileModifyTime appFileIds={}", appFileIds);
        ArrayList queryColumn = Lists.newArrayListWithExpectedSize((int)1);
        queryColumn.add("modifytime");
        return HireDataHelper.getLatestHireHireDynByAppFileId("tspr_hiresalaryexpt", appFileIds, queryColumn);
    }

    public static HireVerifyResult verifyAppFileLinkSalaryExpectVersion(Map<Long, Date> appFileIdAndSalaryExpectModifyDate, List<Long> appFileIds) {
        LOG.info("HireSalaryExpectService.verifyAppFileLinkSalaryExpectVersion: :{} ", appFileIdAndSalaryExpectModifyDate);
        if (appFileIdAndSalaryExpectModifyDate == null) {
            appFileIdAndSalaryExpectModifyDate = Collections.emptyMap();
        }
        ArrayList column = Lists.newArrayListWithExpectedSize((int)4);
        column.add("modifytime");
        Map<Long, DynamicObject> appFileIdAndAppFileDyn = HireDataHelper.getLatestHireHireDynByAppFileId("tspr_hiresalaryexpt", appFileIds, column);
        Iterator<Map.Entry<Long, Date>> it = appFileIdAndSalaryExpectModifyDate.entrySet().iterator();
        HireVerifyResult appFileResult = new HireVerifyResult();
        while (it.hasNext()) {
            Map.Entry<Long, Date> entry = it.next();
            Date verifyDate = entry.getValue();
            Long appFileId = entry.getKey();
            DynamicObject salaryExpectDyn = appFileIdAndAppFileDyn.get(appFileId);
            LOG.info("HireSalaryExpectService.verifyAppFileLinkSalaryExpectVersion verify appFileId,verifyDate,{},{}", (Object)appFileId, (Object)verifyDate);
            if (salaryExpectDyn == null && verifyDate == null) {
                appFileResult.getSuccessAppFileId().add(appFileId);
                continue;
            }
            Long newestSalaryExpectModifyTime = salaryExpectDyn == null ? 0L : salaryExpectDyn.getDate("modifytime").getTime();
            Long verifyTimestamp = verifyDate == null ? 0L : verifyDate.getTime();
            LOG.info("HireSalaryExpectService.verifyAppFileLinkSalaryExpectVersion  verifyTimestamp , newestSalaryExpectModifyTime:{},{}", (Object)verifyTimestamp, (Object)newestSalaryExpectModifyTime);
            if (!verifyTimestamp.equals(newestSalaryExpectModifyTime)) {
                appFileResult.getFailReason().put(appFileId, Lists.newArrayList((Object[])new String[]{HireSalaryExpectKDStringHelper.dataVersionChange()}));
                appFileResult.getFailAppFileId().add(appFileId);
                continue;
            }
            appFileResult.getSuccessAppFileId().add(appFileId);
        }
        return appFileResult;
    }
}

