/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.hire.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.validate.ValidateResult;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.hire.common.HireCommonKDStringHelper;
import kd.tsc.tspr.business.domain.hire.common.HireService;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankKDStringHelper;
import kd.tsc.tspr.business.domain.hire.jobrank.HireJobRankService;
import kd.tsc.tspr.business.domain.hire.recommend.HireRecommendKDStringHelper;
import kd.tsc.tspr.business.domain.hire.recommend.HireRecommendService;
import kd.tsc.tspr.business.domain.hire.salary.HireSalaryKDStringHelper;
import kd.tsc.tspr.business.domain.hire.salary.HireSalaryService;
import kd.tsc.tspr.common.constants.hire.HireInitDataConstants;
import kd.tsc.tspr.common.hire.HireVerifyResult;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireAppFileService {
    public static final String EVENT_HIRE_JOBRANK = "hireJobRank";
    public static final String EVENT_HIRE_SALARY = "hireSalary";
    public static final String EVENT_HIRE_APPROVAL = "hireApproval";
    public static final String EVENT_HIRE_RECOMMEND = "hireRecommend";

    public static ValidateResult filterAppFileByEvent(String event, List<Long> appFileIds) {
        switch (event) {
            case "hireRecommend": {
                return HireAppFileService.handleRecommend(appFileIds);
            }
            case "hireJobRank": {
                return HireAppFileService.handleJobRank(appFileIds);
            }
            case "hireSalary": {
                return HireAppFileService.handleSalary(appFileIds);
            }
            case "hireApproval": {
                return HireAppFileService.handleApproval(appFileIds);
            }
        }
        return new ValidateResult();
    }

    private static ValidateResult handleApproval(List<Long> appFileIds) {
        Object[] appFileDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile").loadDynamicObjectArray(appFileIds.toArray());
        ArrayList appFileList = Lists.newArrayList((Object[])appFileDys);
        HireVerifyResult allVerify = AppFileHelper.verifyApprovalBatch(appFileIds);
        return HireService.convertHireVerifyResultToValidateResult(allVerify, appFileList);
    }

    private static ValidateResult handleRecommend(List<Long> appFileIds) {
        Object[] appFileDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile").loadDynamicObjectArray(appFileIds.toArray());
        ArrayList appFileList = Lists.newArrayList((Object[])appFileDys);
        HireVerifyResult verifyResult = HireRecommendService.verifyRecommendInitStatus(appFileList);
        HireVerifyResult appFileVerify = HireService.verifyAppFileStatus(appFileList);
        HireVerifyResult approvalVerify = HireService.verifyApprovalStatus(appFileList, HireRecommendKDStringHelper.verifyApprovalStatusOperateError());
        HireVerifyResult allVerify = HireService.mergeVerifyAppFileConditionResult(verifyResult, appFileVerify, approvalVerify);
        return HireService.convertHireVerifyResultToValidateResult(allVerify, appFileList);
    }

    private static ValidateResult handleJobRank(List<Long> appFileIds) {
        Object[] appFileDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile").loadDynamicObjectArray(appFileIds.toArray());
        ArrayList appFileList = Lists.newArrayList((Object[])appFileDys);
        HireVerifyResult verifyResult = HireJobRankService.verifyAppFileJobRankStatus(appFileList, HireInitDataConstants.getUnInprocessStatus(), HireJobRankKDStringHelper.inJobRankBlock());
        HireVerifyResult appFileVerify = HireService.verifyAppFileStatus(appFileList);
        HireVerifyResult approvalVerify = HireService.verifyApprovalStatus(appFileList, HireJobRankKDStringHelper.verifyApprovalStatusOperateError());
        HireVerifyResult blackListVerify = HireService.verifyAppFileBlackList(appFileList, HireCommonKDStringHelper.JobRankStr(), new String[0]);
        HireVerifyResult allVerify = HireService.mergeVerifyAppFileConditionResult(verifyResult, appFileVerify, approvalVerify, blackListVerify);
        return HireService.convertHireVerifyResultToValidateResult(allVerify, appFileList);
    }

    private static ValidateResult handleSalary(List<Long> appFileIds) {
        Object[] appFileDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile").loadDynamicObjectArray(appFileIds.toArray());
        ArrayList appFileList = Lists.newArrayList((Object[])appFileDys);
        HireVerifyResult appFileVerify = HireService.verifyAppFileStatus(appFileList);
        HireVerifyResult salaryVerify = HireSalaryService.verifySalaryStatus(appFileList);
        HireVerifyResult approvalVerify = HireService.verifyApprovalStatus(appFileList, HireSalaryKDStringHelper.verifyApprovalStatusOperateError());
        HireVerifyResult blackListVerify = HireService.verifyAppFileBlackList(appFileList, HireCommonKDStringHelper.SalaryStr(), new String[0]);
        HireVerifyResult allVerify = HireService.mergeVerifyAppFileConditionResult(salaryVerify, appFileVerify, approvalVerify, blackListVerify);
        return HireService.convertHireVerifyResultToValidateResult(allVerify, appFileList);
    }
}

