/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intreco.service;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.intreco.service.IntrecoPageHelper;
import kd.tsc.tspr.business.domain.intreco.service.RecommendRecordHelper;
import kd.tsc.tspr.business.domain.intreco.service.RewardRuleService;
import kd.tsc.tspr.business.domain.position.service.PositionDataHelper;
import kd.tsc.tspr.business.domain.position.service.PositionModelAdapter;
import kd.tsc.tspr.common.util.IntvDateUtil;
import kd.tsc.tsrbd.common.constants.ChannelConstants;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.EveryRecruitAddRsmInVo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.business.domain.rsm.service.AddResumeBizServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import org.apache.commons.collections.CollectionUtils;

public final class IntrecoBusinessHelper {
    private static final String ACCEPT_OFFER_STATUS = "1020030";
    private static final String MODULE = IntrecoBusinessHelper.class.getName();
    private static final Log LOGGER = LogFactory.getLog(IntrecoBusinessHelper.class);
    private static HRBaseServiceHelper intrecoAdvDao = new HRBaseServiceHelper("tspr_advertdetailex");
    private static HRBaseServiceHelper bizCountServiceHelper = new HRBaseServiceHelper("tspr_bizcount");
    private static HRBaseServiceHelper recommendRecordHelper = new HRBaseServiceHelper("tspr_intreco_record");
    private static AddResumeBizServiceHelper addResumeBizServiceHelper = AddResumeBizServiceHelper.getInstance();

    private IntrecoBusinessHelper() {
    }

    public static List<Map<String, Object>> fetchForScrollList(Integer limit) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(limit);
        String fieldStr = "id, fullname, isurgent, isreward, workaddr, poscategory, reqorg, status, istop, refreshtime,reward,rewardcurrency,rewardpoint";
        QFilter q1 = new QFilter("status", "=", (Object)"S");
        QFilter q2 = new QFilter("channel", "=", (Object)ChannelConstants.INTRECO_CHANNEL_ID);
        String order = "istop DESC, isurgent DESC, refreshtime DESC";
        DynamicObject[] query = intrecoAdvDao.query(fieldStr, new QFilter[]{q1, q2}, order, limit.intValue());
        if (HRObjectUtils.isEmpty((Object)query)) {
            return result;
        }
        for (DynamicObject dyo : query) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", dyo.getLong("id") + "");
            data.put("name", dyo.getString("fullname"));
            boolean isUrgent = dyo.getBoolean("isurgent");
            if (isUrgent) {
                data.put("urgenttext", ResManager.loadKDString((String)"\u6025\u8058", (String)(MODULE + "_4"), (String)"tsc-tspr-business", (Object[])new Object[0]));
            }
            data.put("isurgent", isUrgent);
            boolean isTop = dyo.getBoolean("istop");
            if (isTop) {
                data.put("toptext", ResManager.loadKDString((String)"\u7f6e\u9876", (String)(MODULE + "_5"), (String)"tsc-tspr-business", (Object[])new Object[0]));
            }
            data.put("istop", isTop);
            String workAddrNo = ResManager.loadKDString((String)"\u6682\u65e0\u5de5\u4f5c\u5730\u70b9", (String)(MODULE + "_0"), (String)"tsc-tspr-business", (Object[])new Object[0]);
            data.put("workaddr", HRStringUtils.isEmpty((String)IntrecoBusinessHelper.getDistinctWorkName("city", dyo)) ? workAddrNo : IntrecoBusinessHelper.getDistinctWorkName("city", dyo));
            DynamicObject posCategory = dyo.getDynamicObject("poscategory");
            if (HRObjectUtils.isEmpty((Object)posCategory)) {
                data.put("poscategoryName", "");
            } else {
                data.put("poscategoryName", posCategory.getString("name"));
            }
            data.put("reqorg", dyo.getString("reqorg"));
            long reward = dyo.getLong("reward");
            if (reward > 0L) {
                String rewardTpl = IntrecoPageHelper.getRewardTpl(dyo);
                data.put("rewardtext", String.format(Locale.ROOT, rewardTpl, reward));
                data.put("isreward", true);
            } else {
                data.put("isreward", false);
            }
            long rewardPoint = dyo.getLong("rewardpoint");
            if (rewardPoint > 0L) {
                data.put("rewardpointtext", IntrecoPageHelper.getRewardPointTpl(dyo));
                data.put("isrewardpoint", true);
            } else {
                data.put("isrewardpoint", false);
            }
            Date refreshTime = dyo.getDate("refreshtime");
            if (!HRObjectUtils.isEmpty((Object)refreshTime)) {
                data.put("createtime", IntvDateUtil.getIntvDate((Date)refreshTime));
            }
            result.add(data);
        }
        return result;
    }

    public static String getDistinctWorkName(String fieldKey, DynamicObject rowData) {
        DynamicObjectCollection docs;
        if (HRStringUtils.isEmpty((String)fieldKey)) {
            return "";
        }
        if (fieldKey.contains(".")) {
            fieldKey = fieldKey.substring(fieldKey.indexOf(".") + 1, fieldKey.lastIndexOf("."));
        }
        if (HRObjectUtils.isEmpty((Object)(docs = rowData.getDynamicObjectCollection("workaddr")))) {
            return "";
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (DynamicObject doc : docs) {
            DynamicObject baseData = doc.getDynamicObject("fbasedataid");
            if (HRObjectUtils.isEmpty((Object)baseData)) continue;
            String result = baseData.getDynamicObject(fieldKey).getString("name");
            Long id = baseData.getDynamicObject(fieldKey).getLong("id");
            map.putIfAbsent(id, result);
        }
        return String.join((CharSequence)";", map.values());
    }

    public static void gotoIntrecoList(IFormView view, Map<String, Object> params) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("tsirp_intrecoadvlistex");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("bos_list");
        if (params != null && params.size() > 0) {
            params.forEach((key, val) -> listShowParameter.setCustomParam(key, val));
        }
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static DynamicObject queryById(Long advertId) {
        return intrecoAdvDao.queryOne((Object)advertId);
    }

    public static void addSuccessRecommend(Long appfileId, String offerStatus) {
        if (!HRStringUtils.equals((String)offerStatus, (String)ACCEPT_OFFER_STATUS)) {
            return;
        }
        String selectProps = "id,creator";
        QFilter qf = new QFilter("canappfile", "=", (Object)appfileId);
        DynamicObject recommend = recommendRecordHelper.queryOne(selectProps, new QFilter[]{qf});
        if (HRObjectUtils.isEmpty((Object)recommend)) {
            return;
        }
        DynamicObject creator = recommend.getDynamicObject("creator");
        Long creatorId = creator.getLong("id");
        String name = creator.getString("name");
        QFilter qMark = new QFilter("bizmark", "=", (Object)"intreco_recommend");
        QFilter qStaff = new QFilter("bizstaff", "=", (Object)creatorId);
        DynamicObject bizCount = bizCountServiceHelper.queryOne("id,bizmark,bizstaff,bizstaffname,count", new QFilter[]{qMark, qStaff});
        if (HRObjectUtils.isEmpty((Object)bizCount)) {
            bizCount = bizCountServiceHelper.generateEmptyDynamicObject();
            bizCount.set("bizmark", (Object)"intreco_recommend");
            bizCount.set("bizstaff", (Object)creatorId);
            bizCount.set("bizstaffname", (Object)name);
            bizCount.set("count", (Object)1);
            bizCountServiceHelper.saveOne(bizCount);
            return;
        }
        bizCount.set("count", (Object)(bizCount.getInt("count") + 1));
        bizCountServiceHelper.updateOne(bizCount);
    }

    public static void updateBizCountByList(ArrayList<Map<String, Object>> list) {
        for (Map<String, Object> data : list) {
            Long appFileId = (Long)data.get("appFileId");
            String offerStatus = String.valueOf(data.get("offerStatus"));
            IntrecoBusinessHelper.addSuccessRecommend(appFileId, offerStatus);
        }
    }

    public static DynamicObject[] rangeTopRecommend(int top) {
        QFilter qf = new QFilter("bizmark", "=", (Object)"intreco_recommend");
        String order = "count DESC";
        DynamicObject[] query = bizCountServiceHelper.query("id,bizmark,bizstaff,bizstaffname,count", qf.toArray(), order, top);
        return query;
    }

    public static void updateRecommendStatusDate(Long appFileId, Date now) {
        try {
            QFilter qf = new QFilter("canappfile", "=", (Object)appFileId);
            DynamicObject recommendRecord = recommendRecordHelper.queryOne("id,modifystatusdate", qf.toArray());
            if (HRObjectUtils.isEmpty((Object)recommendRecord)) {
                return;
            }
            recommendRecord.set("modifystatusdate", (Object)now);
            recommendRecordHelper.updateOne(recommendRecord);
        }
        catch (Exception e) {
            LOGGER.error("\u5019\u9009\u4eba\u72b6\u6001\u8f6c\u79fb\u65f6\u95f4\u66f4\u65b0\u5931\u8d25\uff0c", (Throwable)e);
        }
    }

    public static FormShowParameter openIntrecoDetail(HyperLinkClickArgs args, String parentViewId) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow curRow = billList.getCurrentSelectedRowInfo();
        Long advertPk = (Long)curRow.getPrimaryKeyValue();
        FormShowParameter parameter = IntrecoBusinessHelper.openIntrecoDetail(advertPk, parentViewId + advertPk);
        return parameter;
    }

    public static FormShowParameter openIntrecoDetail(Long advertPk, String pageId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("tsirp_intrecoadvdetail");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("id", (Object)advertPk.toString());
        DynamicObject intrecoAdv = intrecoAdvDao.queryOne((Object)advertPk);
        parameter.setCustomParam("name", (Object)intrecoAdv.getString("fullname"));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPageId(pageId);
        return parameter;
    }

    public static String getPosPrincipal(DynamicObject manageInfo) {
        if (HRObjectUtils.isEmpty((Object)manageInfo)) {
            return "";
        }
        DynamicObjectCollection prins = manageInfo.getDynamicObjectCollection("posprin");
        if (CollectionUtils.isEmpty((Collection)prins)) {
            return "";
        }
        HashSet<String> namedSet = new HashSet<String>();
        for (DynamicObject prin : prins) {
            DynamicObject baseData = prin.getDynamicObject("fbasedataid");
            if (HRObjectUtils.isEmpty((Object)baseData)) continue;
            String name = baseData.getString("name");
            namedSet.add(name);
        }
        return String.join((CharSequence)";", namedSet);
    }

    public static void giveRewardByIds(Object[] pkIds, Map<String, Object> rewardData) {
        String selectProps = "id,reward,rewardpoint,givestate";
        QFilter qf = new QFilter("id", "in", (Object)pkIds);
        DynamicObject[] recommendRecords = recommendRecordHelper.query(selectProps, qf.toArray());
        Arrays.stream(recommendRecords).forEach(rr -> {
            String givestate;
            Integer point;
            Integer reward = (Integer)rewardData.get("reward");
            if (reward >= 0) {
                rr.set("reward", (Object)reward);
            }
            if ((point = (Integer)rewardData.get("rewardpoint")) >= 0) {
                rr.set("rewardpoint", (Object)point);
            }
            if (HRStringUtils.isNotEmpty((String)(givestate = (String)rewardData.get("givestate")))) {
                rr.set("givestate", (Object)givestate);
            }
        });
        recommendRecordHelper.update(recommendRecords);
    }

    public static DynamicObject getIntrecoRecordDyById(Long pkId) {
        String selectProps = "id,totalcost,totalpoint,reward,rewardpoint,givestate";
        QFilter qf = new QFilter("id", "=", (Object)pkId);
        DynamicObject[] recommendRecords = recommendRecordHelper.query(selectProps, qf.toArray());
        return recommendRecords[0];
    }

    public static SaveCandidateResult beforeDeliveryOperation(IFormView formView, String PAGE_CACHE_ID) {
        SaveCandidateResult saveCandidateResult = null;
        try {
            IPageCache pageCache = formView.getPageCache();
            IDataModel model = formView.getModel();
            String cacheString = pageCache.get(PAGE_CACHE_ID);
            AppResumeBo resumeBo = null;
            if (HRStringUtils.isNotEmpty((String)cacheString)) {
                resumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)cacheString);
                resumeBo = ResumeUtilsHelper.copyResumeBo((AppResumeBo)resumeBo);
            } else {
                ResumeInfo resumeInfo = new ResumeInfo();
                resumeInfo.setName(((OrmLocaleValue)model.getValue("name")).getLocaleValue());
                resumeInfo.setPhone((String)model.getValue("canphone"));
                resumeInfo.setEmail((String)model.getValue("canmail"));
                DynamicObject rsm = addResumeBizServiceHelper.generateResumeInfo(resumeInfo);
                resumeBo = new AppResumeBo(rsm);
            }
            DynamicObject positionRef = model.getDataEntity(true).getDynamicObject("position");
            LOGGER.info("\u63a8\u8350\u7684\u804c\u4f4d\u4fe1\u606f\u4e3a:{}", (Object)positionRef);
            EveryRecruitAddRsmInVo param = new EveryRecruitAddRsmInVo();
            if (!HRObjectUtils.isEmpty((Object)positionRef)) {
                param.setPositionId(Long.valueOf(positionRef.getLong("id")));
            }
            param.setResumeBo(resumeBo);
            LOGGER.info("\u63a8\u8350\u7684\u5019\u9009\u4eba\u4fe1\u606f:{},\u59d3\u540d\u4e3a:{}", (Object)resumeBo.getRsm(), resumeBo.getRsm().get("fullname"));
            saveCandidateResult = (SaveCandidateResult)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"rsmServiceApi", (String)"everyRecruitAddRsm", (Object[])new Object[]{param});
            LOGGER.info("\u5185\u63a8\u6dfb\u52a0\u5019\u9009\u4eba\u53cd\u9988\u7ed3\u679c\uff0c{}", (Object)JSON.toJSONString((Object)saveCandidateResult));
        }
        catch (Exception e) {
            if (null == saveCandidateResult) {
                saveCandidateResult = new SaveCandidateResult();
            }
            saveCandidateResult.setSuccess(false);
            LOGGER.error("\u63a8\u8350\u5019\u9009\u4eba\uff0c\u7b80\u5386\u6295\u9012\u5931\u8d25:", (Throwable)e);
        }
        return saveCandidateResult;
    }

    public static DynamicObject getRsmByAppFileId(DynamicObject appFile) {
        HRBaseServiceHelper resumeHelper = new HRBaseServiceHelper("tstpm_rsm");
        QFilter qFilter = new QFilter("appfile", "=", appFile.get("id"));
        String selectProps = "id,resumestoadd";
        DynamicObject rsm = resumeHelper.queryOne(selectProps, qFilter.toArray());
        return rsm;
    }

    public static void updateCandidateNumByPositionId(DynamicObject positionRef) {
        if (!HRObjectUtils.isEmpty((Object)positionRef)) {
            try {
                Long positionId = positionRef.getLong("id");
                Long candidateNum = PositionModelAdapter.getCountBySinglePositionId(positionId);
                PositionDataHelper.updateCandidateNumByPositionId(positionId, candidateNum);
            }
            catch (Exception e) {
                LOGGER.error("RecommendAddCandidateNumByPositionId.error", (Throwable)e);
            }
        }
    }

    public static void filterContainerInitPoscategory(FilterContainerInitArgs filterContainerInitArgs) {
        DynamicObject[] allPubAdvert = IntrecoBusinessHelper.getAllPubAdvert("id", "poscategory");
        DynamicObject[] allUsedPoscategory = IntrecoBusinessHelper.getAllUsedByName(allPubAdvert, "poscategory");
        List<Map<String, String>> nameValues = RecommendRecordHelper.getNameValues(allUsedPoscategory);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameValues, "poscategory.name", ResManager.loadKDString((String)"\u804c\u4f4d\u7c7b\u522b", (String)(MODULE + "_2"), (String)"tsc-tspr-business", (Object[])new Object[0]), 0, null, false, true);
    }

    private static DynamicObject[] getAllUsedByName(DynamicObject[] allIntrecoAdvs, String fileName) {
        if (allIntrecoAdvs == null || allIntrecoAdvs.length == 0) {
            return new DynamicObject[0];
        }
        HashSet<Long> memo = new HashSet<Long>();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject intreco : allIntrecoAdvs) {
            DynamicObject dyo = intreco.getDynamicObject(fileName);
            if (HRObjectUtils.isEmpty((Object)dyo) || memo.contains(dyo.getLong("id"))) continue;
            result.add(dyo);
            memo.add(dyo.getLong("id"));
        }
        return result.toArray(new DynamicObject[result.size()]);
    }

    public static void filterContainerInitHoldofftyp(FilterContainerInitArgs filterContainerInitArgs) {
        DynamicObject[] allPubAdvert = IntrecoBusinessHelper.getAllPubAdvert("id", "holdofftyp");
        DynamicObject[] allUsedHoldofftyp = IntrecoBusinessHelper.getAllUsedByName(allPubAdvert, "holdofftyp");
        List<Map<String, String>> nameValues = RecommendRecordHelper.getNameValues(allUsedHoldofftyp);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameValues, "holdofftyp.name", ResManager.loadKDString((String)"\u4efb\u804c\u7c7b\u578b", (String)(MODULE + "_3"), (String)"tsc-tspr-business", (Object[])new Object[0]), 3, null, false, true);
    }

    public static DynamicObject[] getAllPubAdvert(String ... selectProps) {
        QFilter qStatus = new QFilter("status", "=", (Object)"S");
        QFilter qChannel = new QFilter("channel", "=", (Object)ChannelConstants.INTRECO_CHANNEL_ID);
        QFilter and = qChannel.and(qStatus);
        String props = String.join((CharSequence)",", selectProps);
        DynamicObject[] adverts = intrecoAdvDao.query(props, and.toArray());
        return adverts;
    }

    public static void recommendAfterAddAppfile(IFormView view, SaveCandidateResult scResult) {
        view.getModel().setValue("canappfile", (Object)scResult.getAppFileId());
        view.getModel().setValue("rsm", (Object)scResult.getRsmId());
        DynamicObject positionRef = view.getModel().getDataEntity(true).getDynamicObject("position");
        IntrecoBusinessHelper.updateCandidateNumByPositionId(positionRef);
        view.invokeOperation("save");
        DynamicObject appFile = AppFileHelper.queryOne(scResult.getAppFileId());
        RewardRuleService.getInstance().addRewardDetailByAppfile(new DynamicObject[]{appFile});
        view.returnDataToParent((Object)true);
        view.close();
    }

    public static void createNewRecommend(IFormView view) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        view.getModel().setValue("modifystatusdate", (Object)nowTime);
        view.invokeOperation("save");
    }
}

