/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intreco.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.dto.MapSelectPointOption;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import org.apache.commons.collections.CollectionUtils;

public final class IntrecoPageHelper {
    public static final String CACHE_RECOMMEND_ID = "cache_recommend_page_id";
    public static final String CACHE_ANALYSIS_RESULT = "mark_analysis_result";
    public static final String MODULE = IntrecoPageHelper.class.getName();
    public static final String HZ_REGIX = "[^\\x00-\\xff]";
    public static final String ICON_POSITION = "icon_position_";
    private static final Log LOGGER = LogFactory.getLog(IntrecoPageHelper.class);

    private IntrecoPageHelper() {
    }

    public static Map<String, Object> generateReviewHeadData(AppResumeBo resumeBo, String cacheId) {
        DynamicObject highestEduCation;
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("pagecacheid", cacheId);
        DynamicObject rsm = resumeBo.getRsm();
        returnData.put("fullname", rsm.getString("fullname"));
        returnData.put("age", rsm.getString("age"));
        returnData.put("gender", rsm.getDynamicObject("gender").getLong("id"));
        returnData.put("workingyears", rsm.getString("workingyears"));
        returnData.put("photo", rsm.getString("photo"));
        returnData.put("resumestoadd", rsm.getString("resumestoadd"));
        DynamicObject highestEduSchool = rsm.getDynamicObject("highesteduschool");
        if (highestEduSchool != null) {
            returnData.put("schoolname", highestEduSchool.getString("name"));
        }
        if ((highestEduCation = rsm.getDynamicObject("highesteducation")) != null) {
            returnData.put("education", highestEduCation.getString("name"));
        }
        returnData.put("specialtyname", rsm.getString("highestspecialty"));
        returnData.put("companyname", rsm.getString("recentcompany"));
        returnData.put("positionname", rsm.getString("recentposition"));
        returnData.put("view", OperationStatus.VIEW.getValue());
        return returnData;
    }

    public static void asyncUpdateCustomStyle(IFormView formView, String customStyle, String ... controlIds) {
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("cstyles", customStyle);
        for (String controlId : controlIds) {
            formView.updateControlMetadata(controlId, ctrl);
        }
    }

    public static OperationStatus getPageStatus(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        return formShowParameter.getStatus();
    }

    public static String getFileNameByPath(String path) {
        if (HRStringUtils.isEmpty((String)path)) {
            return "";
        }
        int pos = path.lastIndexOf(47) + 1;
        if (pos >= path.length()) {
            return "";
        }
        String fileName = path.substring(pos);
        return fileName;
    }

    public static String getFileNameByRsm(DynamicObject rsm) {
        String fileName = null;
        if (!HRObjectUtils.isEmpty((Object)rsm)) {
            String path = rsm.getString("resumestoadd");
            fileName = IntrecoPageHelper.getFileNameByPath(path);
        }
        return fileName;
    }

    public static <T> void setObjData2Cache(T dynamicObject, String cacheId, IPageCache pageCache) {
        String cacheString = SerializationUtils.serializeToBase64(dynamicObject);
        pageCache.put(cacheId, cacheString);
    }

    public static <T> T getPageCache(String cacheId, IPageCache pageCache) {
        String cacheString = pageCache.get(cacheId);
        if (HRStringUtils.isEmpty((String)cacheString)) {
            return null;
        }
        return (T)SerializationUtils.deSerializeFromBase64((String)cacheString);
    }

    public static boolean hasPassedAttach(IPageCache pageCache) {
        String resumeCacheString = pageCache.get(CACHE_RECOMMEND_ID);
        String analysisResult = pageCache.get(CACHE_ANALYSIS_RESULT);
        if (HRStringUtils.isNotEmpty((String)resumeCacheString) && HRStringUtils.isNotEmpty((String)analysisResult) && Boolean.parseBoolean(analysisResult)) {
            return true;
        }
        return HRStringUtils.isEmpty((String)resumeCacheString) && HRStringUtils.isEmpty((String)analysisResult);
    }

    public static boolean isTakeViewLock(IFormView formView, String opNumber) {
        BillShowParameter parameter = (BillShowParameter)formView.getFormShowParameter();
        StringBuilder errMsg = new StringBuilder();
        boolean isLock = MutexHelper.require((IFormView)formView, (String)formView.getEntityId(), (Object)parameter.getPkId(), (String)opNumber, (boolean)true, (StringBuilder)errMsg);
        if (!isLock) {
            formView.showTipNotification(errMsg.toString());
        }
        return isLock;
    }

    public static void isShowElement(IFormView view, String booleanEle, String ... pageEle) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Object isShow = dataEntity.get(booleanEle);
        if (isShow instanceof Boolean) {
            Boolean flag = (Boolean)isShow;
            if (flag.booleanValue()) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        } else if (isShow instanceof Long) {
            long flag = (Long)isShow;
            if (flag > 0L) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        } else if (isShow instanceof Integer) {
            int flag = (Integer)isShow;
            if (flag > 0) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        } else if (isShow instanceof BigDecimal) {
            BigDecimal flag = (BigDecimal)isShow;
            if (flag.compareTo(BigDecimal.ZERO) > 0) {
                view.setVisible(Boolean.TRUE, pageEle);
            } else {
                view.setVisible(Boolean.FALSE, pageEle);
            }
        }
    }

    public static void setCanData(ResumeInfo resumeInfo, IDataModel dataModel) {
        if (HRObjectUtils.isEmpty((Object)resumeInfo)) {
            dataModel.setValue("name", null);
            dataModel.setValue("canphone", null);
            dataModel.setValue("canmail", null);
        } else {
            dataModel.setValue("name", (Object)new LocaleString(resumeInfo.getName()));
            dataModel.setValue("canphone", (Object)resumeInfo.getPhone());
            dataModel.setValue("canmail", (Object)resumeInfo.getEmail());
        }
    }

    public static DynamicObjectCollection markWorkAddrOnMap(DynamicObjectCollection workAddrs, MapControl mapCtl, int index) {
        LOGGER.info("\u5de5\u4f5c\u5730\u70b9\u6570\u636e\uff1a{}", (Object)workAddrs);
        if (CollectionUtils.isEmpty((Collection)workAddrs)) {
            return workAddrs;
        }
        DynamicObject firstAddr = ((DynamicObject)workAddrs.get(index)).getDynamicObject("fbasedataid");
        LOGGER.info("\u9009\u4e2d\u7684\u5de5\u4f5c\u5730\u70b9\u6570\u636e\uff1a{}", (Object)firstAddr);
        BigDecimal lon = firstAddr.getBigDecimal("longitude");
        BigDecimal lat = firstAddr.getBigDecimal("latitude");
        if ("0E-10".equals(lon.toString()) && "0E-10".equals(lat.toString())) {
            lon = BigDecimal.valueOf(116.403963);
            lat = BigDecimal.valueOf(39.915119);
        }
        MapSelectPointOption selectPoint = new MapSelectPointOption();
        selectPoint.setTitle(firstAddr.getString("name"));
        selectPoint.setLng(Double.parseDouble(lon.toString()));
        selectPoint.setLat(Double.parseDouble(lat.toString()));
        selectPoint.setAddress(firstAddr.getString("detailedaddr"));
        selectPoint.setCity(firstAddr.getDynamicObject("city").getString("name"));
        mapCtl.selectPoint(selectPoint);
        return workAddrs;
    }

    public static VectorAp genAddrIcon(int number) {
        VectorAp vector = new VectorAp();
        vector.setfontClass("kdfont kdfont-dizhidingwei");
        vector.setKey(ICON_POSITION + number);
        vector.setFontSize(22);
        vector.setClickable(false);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("10px");
        margin.setRight("5px");
        vector.setStyle(style);
        return vector;
    }

    public static QFilter getFilterByWorkAddr(QFilter qFilter, String fieldName) {
        QFilter newFilter = new QFilter(fieldName, qFilter.getCP(), qFilter.getValue());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_workaddr");
        DynamicObject[] workAddrs = serviceHelper.query("id", newFilter.toArray());
        List workAddrIdList = Arrays.stream(workAddrs).map(wa -> wa.getLong("id")).collect(Collectors.toList());
        return new QFilter("workaddr.fbasedataid", "in", workAddrIdList);
    }

    public static void getFilterByArea(List<QFilter> qFilters, String filterName, String cityOrCountry) {
        Iterator<QFilter> iterator = qFilters.iterator();
        ArrayList<QFilter> newQFilters = new ArrayList<QFilter>();
        while (iterator.hasNext()) {
            QFilter qFilter = iterator.next();
            String property = qFilter.getProperty();
            if (!HRStringUtils.equals((String)filterName, (String)property)) continue;
            QFilter filterByWorkAddr = IntrecoPageHelper.getFilterByWorkAddr(qFilter, cityOrCountry);
            newQFilters.add(filterByWorkAddr);
            iterator.remove();
            break;
        }
        qFilters.addAll(newQFilters);
    }

    public static int getWordCount(String inputStr) {
        inputStr = inputStr.replaceAll(HZ_REGIX, "**");
        return inputStr.length();
    }

    public static String getRewardTpl(DynamicObject advertDetail) {
        String sign = advertDetail.getString("rewardcurrency.sign");
        String text = sign == null ? "%s" : sign + "%s";
        return ResManager.loadKDString((String)"\u60ac\u8d4f", (String)(MODULE + "_0"), (String)"tsc-tspr-business", (Object[])new Object[0]) + text;
    }

    public static String getRewardPointTpl(DynamicObject advertDetail) {
        long rewardPoint = advertDetail.getLong("rewardpoint");
        return ResManager.loadKDString((String)"\u79ef\u5206", (String)(MODULE + "_2"), (String)"tsc-tspr-business", (Object[])new Object[0]) + rewardPoint;
    }

    public static String getSomeNum() {
        return ResManager.loadKDString((String)"\u82e5\u5e72", (String)(MODULE + "_1"), (String)"tsc-tspr-business", (Object[])new Object[0]);
    }
}

