/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intreco.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.advertising.service.AdvertTplExDataHelper;
import kd.tsc.tspr.business.domain.intreco.service.RecommendRecordHelper;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.ArrayUtils;

public class RRecordDetailHelper
extends HRBaseServiceHelper {
    private static final String MODULE = RRecordDetailHelper.class.getName();

    private RRecordDetailHelper() {
        super("tspr_rrecord_detail");
    }

    public static RRecordDetailHelper getInstance() {
        return RRecordDetailHelperHolder.RECORD_DETAIL_HELPER;
    }

    public QFilter getAllRpDetailOrg(String filterKey) {
        HashSet memo = Sets.newHashSetWithExpectedSize((int)16);
        try (DataSet dataSet = this.queryDataSet("RRecordDetail.queryAll", "id,recommendrecprd.rporg.id,recommendrecprd.rporg.name", this.getDefaultDataQFilterArr());){
            for (Row row : dataSet) {
                Long orgId = row.getLong("recommendrecprd.rporg.id");
                if (HRObjectUtils.isEmpty((Object)orgId)) continue;
                memo.add(orgId);
            }
        }
        return new QFilter(filterKey, "in", (Object)memo);
    }

    public DynamicObject[] getAllRecByName(String fieldName) {
        Object[] recordDetails = this.query("id," + fieldName, this.getDefaultDataQFilterArr());
        if (ArrayUtils.isEmpty((Object[])recordDetails)) {
            return new DynamicObject[0];
        }
        HashSet memo = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (Object recordDetail : recordDetails) {
            DynamicObject dynamicObject = recordDetail.getDynamicObject(fieldName);
            if (HRObjectUtils.isEmpty((Object)dynamicObject) || memo.contains(dynamicObject.getLong("id"))) continue;
            result.add(dynamicObject);
            memo.add(dynamicObject.getLong("id"));
        }
        return result.toArray(new DynamicObject[result.size()]);
    }

    public QFilter[] getDefaultDataQFilterArr() {
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tssrm", (String)"tssrm_position_add", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"position.adminorgs.fbasedataid.id");
        boolean isSuperMan = AdvertTplExDataHelper.getAdvertOrgPerm();
        if (!isSuperMan) {
            List<Long> allPermOrgIds = RecommendRecordHelper.getAllPermOrgIds("tssrm_position_add");
            QFilter busUnitQFilter = new QFilter("position.createorg.id", "in", allPermOrgIds);
            userAdminOrgFilter = userAdminOrgFilter == null ? busUnitQFilter : userAdminOrgFilter.and(busUnitQFilter);
        }
        return userAdminOrgFilter == null ? new QFilter[]{} : userAdminOrgFilter.toArray();
    }

    public FormShowParameter goToRewardOrPoint(Object primaryKeyValue, String fieldName) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setCustomParam("id", primaryKeyValue);
        String formId = "tspr_rreward_detail";
        if (HRStringUtils.equals((String)fieldName, (String)"totalpoint")) {
            formId = "tspr_rpoint_detail";
        }
        parameter.setBillFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setShowTitle(true);
        parameter.setLookUp(true);
        parameter.setMultiSelect(false);
        parameter.getListFilterParameter().setFilter(RRecordDetailHelper.getQFilterByRecommendId(primaryKeyValue, fieldName));
        return parameter;
    }

    public static QFilter getQFilterByRecommendId(Object recommendId, String fieldName) {
        QFilter recommendQ = new QFilter("recommendrecprd", "=", recommendId);
        if (fieldName.equals("totalcost")) {
            recommendQ.and(new QFilter("rewardtype", "=", (Object)"A"));
        } else if (fieldName.equals("totalpoint")) {
            recommendQ.and(new QFilter("rewardtype", "=", (Object)"B"));
        }
        return recommendQ;
    }

    public void filterContainerInitRecrustgAll(FilterContainerInitArgs filterContainerInitArgs, String fieldName) {
        DynamicObject[] allUsedRecrustg = this.getAllRecByName("recrustg");
        List<Map<String, String>> nameAndVals = RecommendRecordHelper.getNameValues(allUsedRecrustg);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameAndVals, fieldName, ResManager.loadKDString((String)"\u62db\u8058\u73af\u8282", (String)"RecommendRecordHelper_3", (String)"tsc-tspr-business", (Object[])new Object[0]), 3, null, false, true);
    }

    public void filterContainerInitRecrustatAll(FilterContainerInitArgs filterContainerInitArgs, String fieldName) {
        DynamicObject[] allUsedRecrustat = this.getAllRecByName("recrustat");
        List<Map<String, String>> nameAndVals = RecommendRecordHelper.getNameValues(allUsedRecrustat);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameAndVals, fieldName, ResManager.loadKDString((String)"\u62db\u8058\u72b6\u6001", (String)(MODULE + "_0"), (String)"tsc-tspr-business", (Object[])new Object[0]), 4, null, false, true);
    }

    public DynamicObject[] queryByStageStatus(List<DynamicObject> appFiles, Map<Long, DynamicObject> appFileMappingRecommend, long stageId, long statusId) {
        int size = appFiles.size();
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)size);
        ArrayList ruleId = Lists.newArrayListWithExpectedSize((int)size);
        for (DynamicObject appFile : appFiles) {
            appFileIds.add(appFile.getLong("id"));
            DynamicObject recommendRecord = appFileMappingRecommend.get(appFile.getLong("id"));
            long rewardRuleId = recommendRecord.getDynamicObject("manageinfo").getLong("rewardrule.id");
            ruleId.add(rewardRuleId);
        }
        QFilter qFilter1 = new QFilter("recommendrecprd.canappfile.id", "in", (Object)appFileIds);
        QFilter qFilter2 = new QFilter("rewardrule", "in", (Object)ruleId);
        QFilter qFilter3 = new QFilter("recrustg", "=", (Object)stageId);
        QFilter qFilter4 = new QFilter("recrustat", "=", (Object)statusId);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
    }

    private static class RRecordDetailHelperHolder {
        private static final RRecordDetailHelper RECORD_DETAIL_HELPER = new RRecordDetailHelper();

        private RRecordDetailHelperHolder() {
        }
    }
}

