/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intreco.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.advertising.service.AdvertTplExDataHelper;
import kd.tsc.tspr.business.domain.intreco.service.IntrecoBusinessHelper;
import kd.tsc.tspr.common.constants.position.PositionManageConstants;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.HRStructureTreeOrgHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class RecommendRecordHelper {
    private static final String MODULE = RecommendRecordHelper.class.getName();
    private static HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("tsirp_intreco_record");

    private RecommendRecordHelper() {
    }

    public static FormShowParameter getParamForHyperLinkClick(String fieldName, HyperLinkClickArgs args, IFormView view) {
        BillList source = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = source.getFocusRowPkId();
        DynamicObject recommendRecord = SERVICE_HELPER.queryOne(pkId);
        Long advertPk = recommendRecord.getDynamicObject("advertId").getLong("id");
        BaseShowParameter showParameter = null;
        if (HRStringUtils.equals((String)fieldName, (String)"name")) {
            showParameter = new BaseShowParameter();
            showParameter.setFormId("tsirp_intreco_record");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId(pkId);
            String msg = ResManager.loadKDString((String)"\u5019\u9009\u4eba-", (String)(MODULE + "_0"), (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(msg + recommendRecord.getString("name"));
            showParameter.setCustomParam("advertId", (Object)advertPk);
            DynamicObject pos = recommendRecord.getDynamicObject("position");
            showParameter.setCustomParam("positionid", (Object)pos);
        } else if (HRStringUtils.equals((String)fieldName, (String)"advertid_fullname")) {
            showParameter = IntrecoBusinessHelper.openIntrecoDetail(advertPk, view.getPageId() + advertPk);
            showParameter.setCustomParam("from", (Object)"intreco_rr_list");
        }
        return showParameter;
    }

    public static List<Long> getUsersIdByNumber(QFilter filter) {
        HRBaseServiceHelper bosUserHelper = new HRBaseServiceHelper("bos_user");
        QFilter qFilter = new QFilter("id", filter.getCP(), filter.getValue());
        DynamicObject[] users = bosUserHelper.query("id", qFilter.toArray());
        List<Long> userIdList = Arrays.stream(users).map(ur -> ur.getLong("id")).collect(Collectors.toList());
        return userIdList;
    }

    public static QFilter getPosPrinByUser(QFilter filter) {
        Object userIds = filter.getValue();
        HRBaseServiceHelper posManageHelper = new HRBaseServiceHelper("tspr_positionmanage");
        QFilter qFilter = new QFilter("posprin.fbasedataid", filter.getCP(), userIds);
        Object[] positions = posManageHelper.query("position", qFilter.toArray());
        if (ArrayUtils.isEmpty((Object[])positions)) {
            return new QFilter("position", filter.getCP(), null);
        }
        List posIdList = Arrays.stream(positions).map(pos -> pos.getLong("position.id")).collect(Collectors.toList());
        return new QFilter("position", filter.getCP(), posIdList);
    }

    public static List<Long> getAllPermOrgIds(String entityId) {
        Pair hrStructureOrgAndAllPermOrgs = HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserPermOrg((String)"tssrm", (String)entityId, (String)"47150e89000000ac");
        List value = (List)hrStructureOrgAndAllPermOrgs.getValue();
        return value;
    }

    public static DynamicObject[] getAllPermOrgs(String entityId) {
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org");
        List<Long> value = RecommendRecordHelper.getAllPermOrgIds(entityId);
        QFilter qFilter = new QFilter("id", "in", value);
        DynamicObject[] bosOrgInfos = bosOrgHelper.query("name", qFilter.toArray());
        if (bosOrgInfos.length < 1) {
            return new DynamicObject[0];
        }
        return bosOrgInfos;
    }

    public static QFilter getPositionBizQFilter(String entityId) {
        List<Long> currentUserOrgIdList = RecommendRecordHelper.getAllPermOrgIds(entityId);
        currentUserOrgIdList.sort((o1, o2) -> (int)(o1 - o2));
        QFilter qFilter = new QFilter("id", "in", currentUserOrgIdList);
        return qFilter;
    }

    public static void setComboItems(FilterContainerInitArgs filterContainerInitArgs, List<Map<String, String>> nameAndVals, String fieldName, String captionName, int index, String defaultVal, boolean mustInput, boolean multi) {
        List filterColumnList = filterContainerInitArgs.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn();
        commonFilterColumn.setFieldName(fieldName);
        commonFilterColumn.setCaption(new LocaleString(captionName));
        commonFilterColumn.setMustInput(mustInput);
        commonFilterColumn.setEntityField(true);
        commonFilterColumn.setMulti(multi);
        commonFilterColumn.setDefaultValue(defaultVal);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        if (nameAndVals != null && !nameAndVals.isEmpty()) {
            for (Map<String, String> nameAndVal : nameAndVals) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(nameAndVal.get("name")));
                item.setValue(nameAndVal.get("value"));
                combos.add(item);
            }
        }
        commonFilterColumn.setComboItems(combos);
        commonFilterColumn.setType("enum");
        filterColumnList.add(index, commonFilterColumn);
    }

    public static QFilter getDefaultDataQFilter() {
        QFilter userAdminOrgFilter = TSCBizDataPermService.getUserAdminOrgsQFilter((Long)TSCRequestContext.getUserId(), (String)"tssrm", (String)"tssrm_position_add", (String)"47150e89000000ac", (String)"adminorg", Collections.emptyMap(), (String)"posorgid");
        boolean isSuperMan = AdvertTplExDataHelper.getAdvertOrgPerm();
        if (!isSuperMan) {
            List<Long> allPermOrgIds = RecommendRecordHelper.getAllPermOrgIds("tssrm_position_add");
            QFilter busUnitQFilter = new QFilter("posbizid", "in", allPermOrgIds);
            if (userAdminOrgFilter != null) {
                userAdminOrgFilter = userAdminOrgFilter.and(busUnitQFilter);
            } else {
                return busUnitQFilter;
            }
        }
        return userAdminOrgFilter;
    }

    public static void setFilterByField(List<QFilter> qFilters) {
        Iterator<QFilter> iterator = qFilters.iterator();
        ArrayList<QFilter> newQFilters = new ArrayList<QFilter>();
        while (iterator.hasNext()) {
            QFilter qFilter = iterator.next();
            String property = qFilter.getProperty();
            if (!HRStringUtils.equals((String)"posprin.id", (String)property)) continue;
            QFilter prinQFilter = RecommendRecordHelper.getPosPrinByUser(qFilter);
            newQFilters.add(prinQFilter);
            iterator.remove();
            break;
        }
        qFilters.addAll(newQFilters);
    }

    public static void deleteRecommendById(Object pkId) {
        SERVICE_HELPER.deleteOne(pkId);
    }

    public static void filterContainerInitRecrustg(FilterContainerInitArgs filterContainerInitArgs) {
        DynamicObject[] allUsedRecrustg = RecommendRecordHelper.getAllUsedByName(TSCRequestContext.getUserId(), "recrustg");
        List<Map<String, String>> nameAndVals = RecommendRecordHelper.getNameValues(allUsedRecrustg);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameAndVals, "canappfile.recrustg.name", ResManager.loadKDString((String)"\u62db\u8058\u73af\u8282", (String)(MODULE + "_3"), (String)"tsc-tspr-business", (Object[])new Object[0]), 0, null, false, true);
    }

    public static void filterContainerInitRecrustgAll(FilterContainerInitArgs filterContainerInitArgs, String fieldName) {
        DynamicObject[] allUsedRecrustg = RecommendRecordHelper.getAllUsedByName("recrustg");
        List<Map<String, String>> nameAndVals = RecommendRecordHelper.getNameValues(allUsedRecrustg);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameAndVals, fieldName, ResManager.loadKDString((String)"\u62db\u8058\u73af\u8282", (String)(MODULE + "_3"), (String)"tsc-tspr-business", (Object[])new Object[0]), 3, null, false, true);
    }

    public static void filterContainerInitRecrustat(FilterContainerInitArgs filterContainerInitArgs) {
        DynamicObject[] allUsedRecrustat = RecommendRecordHelper.getAllUsedByName(TSCRequestContext.getUserId(), "recrustat");
        List<Map<String, String>> nameAndVals = RecommendRecordHelper.getNameValues(allUsedRecrustat);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameAndVals, "canappfile.recrustat.name", ResManager.loadKDString((String)"\u62db\u8058\u72b6\u6001", (String)(MODULE + "_4"), (String)"tsc-tspr-business", (Object[])new Object[0]), 0, null, false, true);
    }

    public static void filterContainerInitRecrustatAll(FilterContainerInitArgs filterContainerInitArgs, String fieldName) {
        DynamicObject[] allUsedRecrustat = RecommendRecordHelper.getAllUsedByName("recrustat");
        List<Map<String, String>> nameAndVals = RecommendRecordHelper.getNameValues(allUsedRecrustat);
        RecommendRecordHelper.setComboItems(filterContainerInitArgs, nameAndVals, fieldName, ResManager.loadKDString((String)"\u62db\u8058\u72b6\u6001", (String)(MODULE + "_4"), (String)"tsc-tspr-business", (Object[])new Object[0]), 4, null, false, true);
    }

    public static List<Map<String, String>> getNameValues(DynamicObject[] dynamicObjects) {
        ArrayList<Map<String, String>> nameAndVals = new ArrayList<Map<String, String>>(dynamicObjects.length);
        if (null != dynamicObjects && dynamicObjects.length > 0) {
            Arrays.sort(dynamicObjects, (o1, o2) -> {
                long diff = o1.getLong("id") - o2.getLong("id");
                if (diff > 0L) {
                    return 1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return -1;
            });
            for (int i = 0; i < dynamicObjects.length; ++i) {
                HashMap nameAndVal = Maps.newHashMapWithExpectedSize((int)2);
                nameAndVal.put("name", dynamicObjects[i].getString("name"));
                nameAndVal.put("value", dynamicObjects[i].getString("id"));
                nameAndVals.add(nameAndVal);
            }
        }
        return nameAndVals;
    }

    private static DynamicObject[] getAllUsedByName(String fileName) {
        return RecommendRecordHelper.getAllUsedByName(null, fileName);
    }

    private static DynamicObject[] getAllUsedByName(Long userId, String fileName) {
        QFilter qFilter;
        if (HRObjectUtils.isEmpty((Object)userId)) {
            qFilter = new QFilter("1", "=", (Object)1);
            QFilter userAdminOrgFilter = RecommendRecordHelper.getDefaultDataQFilter();
            if (userAdminOrgFilter != null) {
                qFilter = qFilter.and(userAdminOrgFilter);
            }
        } else {
            qFilter = new QFilter("creator", "=", (Object)userId);
        }
        DynamicObject[] records = SERVICE_HELPER.query("canappfile,id", qFilter.toArray());
        if (records == null || records.length == 0) {
            return new DynamicObject[0];
        }
        List appFileList = Arrays.stream(records).filter(af -> null != af && af.getLong("id") != 0L).map(rr -> rr.getDynamicObject("canappfile")).collect(Collectors.toList());
        List appFileIds = appFileList.stream().map(af -> af.getLong("id")).collect(Collectors.toList());
        qFilter = new QFilter("id", "in", appFileIds);
        HRBaseServiceHelper appfileHelper = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject[] appfiles = appfileHelper.query("id," + fileName, qFilter.toArray());
        HashSet memo = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject appfile : appfiles) {
            DynamicObject recrustg = appfile.getDynamicObject(fileName);
            if (HRObjectUtils.isEmpty((Object)recrustg) || memo.contains(recrustg.getLong("id"))) continue;
            result.add(recrustg);
            memo.add(recrustg.getLong("id"));
        }
        return result.toArray(new DynamicObject[result.size()]);
    }

    public static void filterContainerInitSecLevel(FilterContainerInitArgs args, String fieldName) {
        CommonFilterColumn secLevelColumn = (CommonFilterColumn)args.getFilterColumn(fieldName);
        if (SecConfHelper.querySecurityConf((Long)PositionManageConstants.SECLEVEL_NUMBER)) {
            secLevelColumn.setDefaultValue("");
            DynamicObject[] col = SecConfHelper.querySecLevel();
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(col.length);
            for (DynamicObject dynamicObject : col) {
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(dynamicObject.getPkValue()));
                item.setCaption(new LocaleString(dynamicObject.getString("codelevel")));
                item.setValue(String.valueOf(dynamicObject.getPkValue()));
                combos.add(item);
            }
            secLevelColumn.setComboItems(combos);
            List commonFilterColumns = args.getCommonFilterColumns();
            commonFilterColumns.remove(secLevelColumn);
            commonFilterColumns.add(2, secLevelColumn);
        } else {
            args.getCommonFilterColumns().remove(secLevelColumn);
            args.getSchemeFilterColumns().remove(secLevelColumn);
        }
    }

    public static DynamicObject[] queryByAppfileId(DynamicObject[] appfiles) {
        List appfileIds = Arrays.stream(appfiles).map(af -> af.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("canappfile", "in", appfileIds);
        return SERVICE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static void save(List<DynamicObject> recommendRecordList) {
        if (CollectionUtils.isEmpty(recommendRecordList)) {
            return;
        }
        SERVICE_HELPER.save(recommendRecordList.toArray(new DynamicObject[recommendRecordList.size()]));
    }
}

