/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intreco.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intreco.service.RRecordDetailHelper;
import kd.tsc.tspr.business.domain.intreco.service.RecommendRecordHelper;
import kd.tsc.tspr.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleDataHelper;
import kd.tsc.tsrbd.common.entity.RewardResult;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RewardRuleService {
    private static final String MODULE = RewardRuleService.class.getName();
    private RewardRuleDataHelper rewardRuleDataService = RewardRuleDataHelper.getInstance();
    private RRecordDetailHelper rRecordDetailHelper = RRecordDetailHelper.getInstance();

    private RewardRuleService() {
    }

    public static RewardRuleService getInstance() {
        return RewardRuleServiceHolder.REWARD_RULE_SERVICE;
    }

    public void addRewardDetailByAppfile(DynamicObject[] appFiles) {
        List rewardRuleIds;
        Object[] rewardRules;
        DynamicObject[] recommendRecords = RecommendRecordHelper.queryByAppfileId(appFiles);
        if (HRObjectUtils.isEmpty((Object)recommendRecords)) {
            return;
        }
        Pair<List<DynamicObject>, Map<Long, DynamicObject>> filterAppFiles = this.filterHasRecommendAppFile(appFiles, recommendRecords);
        List intrecoAppFiles = (List)filterAppFiles.getLeft();
        if (CollectionUtils.isEmpty((Collection)intrecoAppFiles)) {
            return;
        }
        Map appFileMappingRecommend = (Map)filterAppFiles.getRight();
        List<DynamicObject> hasNoRDetailAppFiles = this.filterHasRecordDetailAppFile(intrecoAppFiles, appFileMappingRecommend);
        if (CollectionUtils.isEmpty(hasNoRDetailAppFiles)) {
            return;
        }
        Object stage = hasNoRDetailAppFiles.get(0).get("recrustg");
        Map offerMapping = Maps.newHashMapWithExpectedSize((int)hasNoRDetailAppFiles.size());
        boolean isOnBoard = this.isOnboardData(stage);
        if (isOnBoard) {
            List reqOfferAppFileIds = hasNoRDetailAppFiles.stream().map(af -> String.valueOf(af.getLong("id"))).collect(Collectors.toList());
            offerMapping = (Map)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerBaseServiceApi", (String)"getOfferJobInfoBatch", (Object[])new Object[]{reqOfferAppFileIds});
        }
        if (ArrayUtils.isEmpty((Object[])(rewardRules = this.rewardRuleDataService.queryRewardRuleByIds(rewardRuleIds = appFileMappingRecommend.values().stream().map(recommend -> recommend.getDynamicObject("manageinfo").getLong("rewardrule.id")).collect(Collectors.toList()))))) {
            return;
        }
        Map<Long, RewardResult> appFileMapReward = this.mapAppFileToRewardRule((DynamicObject[])rewardRules, hasNoRDetailAppFiles, offerMapping, appFileMappingRecommend, isOnBoard);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)appFileMapReward.size());
        ArrayList recommendRecordList = Lists.newArrayListWithExpectedSize((int)appFileMapReward.size());
        for (Map.Entry<Long, RewardResult> rewardProcessEntry : appFileMapReward.entrySet()) {
            Long appFileId = rewardProcessEntry.getKey();
            RewardResult rewardResult = rewardProcessEntry.getValue();
            if (null == rewardResult) continue;
            DynamicObject recommendRecord = (DynamicObject)appFileMappingRecommend.get(appFileId);
            result.add(this.setValueToDetail(recommendRecord, rewardResult, offerMapping, isOnBoard));
            recommendRecordList.add(this.updateTotalAmount(recommendRecord, rewardResult));
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            this.rRecordDetailHelper.save(result.toArray(new DynamicObject[result.size()]));
        }
        if (CollectionUtils.isNotEmpty((Collection)recommendRecordList)) {
            RecommendRecordHelper.save(recommendRecordList);
        }
    }

    private DynamicObject updateTotalAmount(DynamicObject recommendRecord, RewardResult rewardResult) {
        int totalcost = recommendRecord.getInt("totalcost");
        int totalpoint = recommendRecord.getInt("totalpoint");
        if (!HRObjectUtils.isEmpty((Object)rewardResult)) {
            String item = rewardResult.getRewardItem();
            if (HRStringUtils.equals((String)item, (String)"A")) {
                totalcost += rewardResult.getRewardVal().intValue();
                recommendRecord.set("rewardcurrency", (Object)rewardResult.getCurrencyId());
            } else if (HRStringUtils.equals((String)item, (String)"B")) {
                totalpoint += rewardResult.getRewardVal().intValue();
            }
            int reward = recommendRecord.getInt("reward");
            int rewardpoint = recommendRecord.getInt("rewardpoint");
            if (reward == totalcost && rewardpoint == totalpoint) {
                recommendRecord.set("givestate", (Object)"A");
            } else if (reward == 0 && rewardpoint == 0) {
                recommendRecord.set("givestate", (Object)"B");
            } else {
                recommendRecord.set("givestate", (Object)"C");
            }
            recommendRecord.set("totalcost", (Object)totalcost);
            recommendRecord.set("totalpoint", (Object)totalpoint);
        }
        return recommendRecord;
    }

    private List<DynamicObject> filterHasRecordDetailAppFile(List<DynamicObject> intrecoAppFiles, Map<Long, DynamicObject> appFileMappingRecommend) {
        long stageId = this.getId(intrecoAppFiles.get(0).get("recrustg"));
        long statusId = this.getId(intrecoAppFiles.get(0).get("recrustat"));
        DynamicObject[] recordDetails = this.rRecordDetailHelper.queryByStageStatus(intrecoAppFiles, appFileMappingRecommend, stageId, statusId);
        Map appFileMappingRecordDetails = Arrays.stream(recordDetails).collect(HashMap::new, (map, rd) -> map.put(rd.getLong("recommendrecprd.canappfile.id"), rd), HashMap::putAll);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)intrecoAppFiles.size());
        for (DynamicObject appFile : intrecoAppFiles) {
            DynamicObject recordDetail = (DynamicObject)appFileMappingRecordDetails.get(appFile.getLong("id"));
            if (!HRObjectUtils.isEmpty((Object)recordDetail)) continue;
            result.add(appFile);
        }
        return result;
    }

    private Map<Long, RewardResult> mapAppFileToRewardRule(DynamicObject[] rewardRules, List<DynamicObject> hasNoRDetailAppFiles, Map<Long, Map<String, Object>> appFileMappingOffer, Map<Long, DynamicObject> appFileMappingReward, boolean isOnBoard) {
        int size = hasNoRDetailAppFiles.size();
        Map rewardRuleOfId = Arrays.stream(rewardRules).collect(HashMap::new, (map, rr) -> map.put(rr.getLong("id"), rr), HashMap::putAll);
        HashMap result = Maps.newHashMapWithExpectedSize((int)size);
        ThreeTuple<DynamicObject[], DynamicObject[], DynamicObject[]> jobLevelAndGrade = null;
        if (isOnBoard) {
            jobLevelAndGrade = this.getJobLevelAndGrade(appFileMappingOffer);
        }
        for (DynamicObject appFile : hasNoRDetailAppFiles) {
            RewardResult rewardProcess;
            long appFileId = appFile.getLong("id");
            DynamicObject recommend = appFileMappingReward.get(appFileId);
            long rewardRuleId = recommend.getDynamicObject("manageinfo").getLong("rewardrule.id");
            DynamicObject rewardRule = (DynamicObject)rewardRuleOfId.get(rewardRuleId);
            if (HRObjectUtils.isEmpty((Object)rewardRule)) continue;
            Object stage = appFile.get("recrustg");
            Object status = appFile.get("recrustat");
            if (isOnBoard) {
                DynamicObjectCollection onBoards = rewardRule.getDynamicObjectCollection("entryentity1");
                Map<String, Object> offerResult = appFileMappingOffer.get(appFileId);
                rewardProcess = this.getOnBoardBySta(onBoards, stage, status, rewardRule, offerResult, jobLevelAndGrade);
            } else {
                DynamicObjectCollection processes = rewardRule.getDynamicObjectCollection("entryentity");
                rewardProcess = this.getProcessBySta(processes, stage, status, rewardRule);
            }
            result.put(appFileId, rewardProcess);
        }
        return result;
    }

    private ThreeTuple<DynamicObject[], DynamicObject[], DynamicObject[]> getJobLevelAndGrade(Map<Long, Map<String, Object>> appFileMappingOffer) {
        HRBaseServiceHelper gradeHelper = new HRBaseServiceHelper("hbjm_jobgradehr");
        HRBaseServiceHelper levelHelper = new HRBaseServiceHelper("hbjm_joblevelhr");
        HRBaseServiceHelper jobscmhrHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        Collection<Map<String, Object>> gradeAndLevels = appFileMappingOffer.values();
        ArrayList jobGradeIds = Lists.newArrayListWithExpectedSize((int)appFileMappingOffer.size());
        ArrayList jobLevelIds = Lists.newArrayListWithExpectedSize((int)appFileMappingOffer.size());
        ArrayList jobScmIds = Lists.newArrayListWithExpectedSize((int)appFileMappingOffer.size());
        for (Map<String, Object> gradeAndLevel : gradeAndLevels) {
            Long jobLevelId = (Long)gradeAndLevel.get("joblevel");
            Long jobGradeId = (Long)gradeAndLevel.get("jobgrade");
            Long jobScmId = (Long)gradeAndLevel.get("jobscm");
            if (null != jobGradeId && jobGradeId != 0L) {
                jobGradeIds.add(jobGradeId);
            }
            if (null != jobLevelId && jobLevelId != 0L) {
                jobLevelIds.add(jobLevelId);
            }
            if (null == jobScmId || jobScmId == 0L) continue;
            jobScmIds.add(jobScmId);
        }
        DynamicObject[] jobGrades = gradeHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)jobGradeIds)});
        DynamicObject[] jobLevels = levelHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)jobLevelIds)});
        DynamicObject[] jobScmhrs = jobscmhrHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)jobScmIds)});
        return new ThreeTuple((Object)jobScmhrs, (Object)jobLevels, (Object)jobGrades);
    }

    private RewardResult getOnBoardBySta(DynamicObjectCollection onBoardCollection, Object stage, Object status, DynamicObject rewardRule, Map<String, Object> offerResult, ThreeTuple<DynamicObject[], DynamicObject[], DynamicObject[]> jobLevelAndGrade) {
        long appFileStageId = this.getId(stage);
        long appFileStatusId = this.getId(status);
        for (DynamicObject onBoard : onBoardCollection) {
            long stat = onBoard.getLong("recrustatnew1.id");
            long stg = onBoard.getLong("recrustgnew1.id");
            boolean isMatch = false;
            if (appFileStageId == stg && appFileStatusId == stat) {
                boolean flag = onBoard.getBoolean("jobscmhrswitch1");
                isMatch = flag ? this.isMatchLevelAndGrade(offerResult, jobLevelAndGrade, onBoard) : true;
            }
            if (!isMatch) continue;
            return RewardResult.rewardResultByOnBoard((DynamicObject)onBoard, (long)rewardRule.getLong("id"), (long)rewardRule.getLong("recrutyp.id"));
        }
        return null;
    }

    private boolean isMatchLevelAndGrade(Map<String, Object> offerResult, ThreeTuple<DynamicObject[], DynamicObject[], DynamicObject[]> jobLevelAndGrade, DynamicObject onBoard) {
        Long jobGradeId;
        Long jobLevelId;
        boolean isMatch = false;
        if (MapUtils.isNotEmpty(offerResult) && offerResult.containsKey("joblevel") && offerResult.containsKey("jobgrade") && this.isValidaData(jobLevelId = (Long)offerResult.get("joblevel"), jobGradeId = (Long)offerResult.get("jobgrade")) && this.rewardRuleDataService.jobLeveAndGradeWithin(onBoard, jobLevelId, jobGradeId, jobLevelAndGrade)) {
            isMatch = true;
        }
        return isMatch;
    }

    private boolean isValidaData(Long jobLevelId, Long jobGradeId) {
        return null != jobGradeId && jobGradeId != 0L && null != jobLevelId && jobLevelId != 0L;
    }

    private RewardResult getProcessBySta(DynamicObjectCollection processCollection, Object stage, Object status, DynamicObject rewardRule) {
        long appFileStageId = this.getId(stage);
        long appFileStatusId = this.getId(status);
        for (DynamicObject process : processCollection) {
            long stat = process.getLong("recrustatnew.id");
            long stg = process.getLong("recrustgnew.id");
            if (appFileStageId != stg || appFileStatusId != stat) continue;
            RewardResult rewardResult = RewardResult.rewardResultByProcess((DynamicObject)process, (long)rewardRule.getLong("id"), (long)rewardRule.getLong("recrutyp.id"));
            return rewardResult;
        }
        return null;
    }

    private long getId(Object baseData) {
        long id = baseData instanceof DynamicObject ? ((DynamicObject)baseData).getLong("id") : ((Long)baseData).longValue();
        return id;
    }

    private DynamicObject setValueToDetail(DynamicObject recommendRecord, RewardResult rewardResult, Map<Long, Map<String, Object>> offerMapping, boolean isOnBoard) {
        Map<String, Object> value;
        DynamicObject recordDetail = this.genRecordDetailByProcess(rewardResult, recommendRecord);
        if (isOnBoard && MapUtils.isNotEmpty(value = offerMapping.get(recommendRecord.getLong("canappfile.id")))) {
            recordDetail.set("joblevel", value.get("joblevel"));
            recordDetail.set("jobgrade", value.get("jobgrade"));
        }
        return recordDetail;
    }

    private boolean isOnboardData(Object recrustg) {
        long stageId = this.getId(recrustg);
        return TSRBDPreDataEnum.RECRUSTGNEW_ONBOARD.getId() == stageId;
    }

    private Pair<List<DynamicObject>, Map<Long, DynamicObject>> filterHasRecommendAppFile(DynamicObject[] appFiles, DynamicObject[] recommendRecords) {
        ArrayList target = Lists.newArrayListWithExpectedSize((int)recommendRecords.length);
        HashMap appFileMappingRecommend = Maps.newHashMapWithExpectedSize((int)recommendRecords.length);
        block0: for (DynamicObject recommendRecord : recommendRecords) {
            long appFileId = recommendRecord.getLong("canappfile.id");
            for (DynamicObject appFile : appFiles) {
                long id = appFile.getLong("id");
                if (id != appFileId) continue;
                target.add(appFile);
                appFileMappingRecommend.put(id, recommendRecord);
                continue block0;
            }
        }
        return Pair.of((Object)target, (Object)appFileMappingRecommend);
    }

    private DynamicObject genRecordDetailByProcess(RewardResult rewardProcess, DynamicObject recommend) {
        DynamicObject recordDetail = this.rRecordDetailHelper.generateEmptyDynamicObject();
        recordDetail.set("recrustg", (Object)rewardProcess.getRecruStgNew());
        recordDetail.set("recrustat", (Object)rewardProcess.getRecruStatNew());
        String rewardType = rewardProcess.getRewardItem();
        recordDetail.set("rewardtype", (Object)rewardType);
        if (HRStringUtils.equals((String)rewardType, (String)"A")) {
            recordDetail.set("detailreward", (Object)rewardProcess.getRewardVal());
            recordDetail.set("detailcurrency", (Object)rewardProcess.getCurrencyId());
        } else if (HRStringUtils.equals((String)rewardType, (String)"B")) {
            recordDetail.set("detailpoint", (Object)rewardProcess.getRewardVal());
        }
        recordDetail.set("recommendrecprd", (Object)recommend.getLong("id"));
        recordDetail.set("manageinfo", (Object)recommend.getDynamicObject("manageinfo"));
        recordDetail.set("position", recommend.get("position"));
        recordDetail.set("reccategory", (Object)rewardProcess.getRecruTyp());
        recordDetail.set("rewardrule", (Object)rewardProcess.getId());
        return recordDetail;
    }

    public Pair<Long, DynamicObject> getRewardResultByPos(DynamicObject position) {
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(position.getLong("id"));
        if (HRObjectUtils.isEmpty((Object)manageInfo)) {
            return null;
        }
        DynamicObject rewardRule = manageInfo.getDynamicObject("rewardrule");
        if (!HRObjectUtils.isEmpty((Object)rewardRule)) {
            DynamicObjectCollection rewardResults = rewardRule.getDynamicObjectCollection("entryentity2");
            long posRecProcId = manageInfo.getLong("recruproc.id");
            for (DynamicObject rewardResult : rewardResults) {
                long recProcId = rewardResult.getLong("rqmtproc.id");
                if (recProcId != posRecProcId) continue;
                return Pair.of((Object)rewardRule.getLong("id"), (Object)rewardResult);
            }
        }
        return null;
    }

    private static class RewardRuleServiceHolder {
        private static final RewardRuleService REWARD_RULE_SERVICE = new RewardRuleService();

        private RewardRuleServiceHolder() {
        }
    }
}

