/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intreco.service.title;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intreco.service.IntrecoBusinessHelper;
import kd.tsc.tspr.business.domain.intreco.service.IntrecoPageHelper;

public interface AdvDetailTitleBillInterface {
    public static final Log LOGGER = LogFactory.getLog(AdvDetailTitleBillInterface.class);
    public static final String MODULE = AdvDetailTitleBillInterface.class.getName();
    public static final String RECRUITNUM_VALUE = "recruitnum_value";
    public static final String WORKADDR_CITY = "workaddr_city";
    public static final String TITLE_REWARD = "title_reward";
    public static final String TITLE_REWARD_POINT = "title_rewardpoint";
    public static final String PUBLISH_TIME = "publishtime";
    public static final String HOLDOFFTYP_VALUE = "holdofftyp_value";
    public static final String HOLDOFFTYP_TITLE = "holdofftyp_title";
    public static final String REQORG_VALUE = "reqorg_value";
    public static final String NAME_VALUE = "name_value";
    public static final String REWARD_FLEX = "reawrdflex";
    public static final String POSCATEGORY_VALUE = "poscategory_value";

    default public void init(IFormView formView) {
        IDataModel dataModel = formView.getModel();
        DynamicObject dyo = dataModel.getDataEntity(true);
        String entityName = dyo.getDataEntityType().getName();
        if (!HRStringUtils.equals((String)entityName, (String)"tsirp_intrecoadvdetail")) {
            try {
                FormShowParameter param = formView.getFormShowParameter();
                Long advertId = (Long)param.getCustomParam("advertId");
                dyo = IntrecoBusinessHelper.queryById(advertId);
            }
            catch (Exception ignored) {
                LOGGER.error("\u63a8\u8350\u5019\u9009\u4eba\u83b7\u53d6\u5e7f\u544a\u4fe1\u606f\u5931\u8d25", (Throwable)ignored);
            }
        }
        this.showRecruitNum(dataModel, dyo);
        this.showWorkAddr(dataModel, dyo);
        this.showReward(formView, dyo);
        this.showTopAndUrgent(formView, dyo);
        this.showOtherField(formView, dyo);
    }

    default public void showOtherField(IFormView formView, DynamicObject dyo) {
        IDataModel dataModel = formView.getModel();
        OrmLocaleValue reqOrg = (OrmLocaleValue)dyo.get("reqorg");
        Date date = dyo.getDate("refreshtime");
        DynamicObject holdOfftyp = dyo.getDynamicObject("holdofftyp");
        OrmLocaleValue name = (OrmLocaleValue)dyo.get("fullname");
        dataModel.setValue(REQORG_VALUE, (Object)reqOrg.getLocaleValue());
        dataModel.setValue(PUBLISH_TIME, (Object)date);
        if (HRObjectUtils.isEmpty((Object)holdOfftyp)) {
            formView.setVisible(Boolean.FALSE, new String[]{HOLDOFFTYP_TITLE});
        } else {
            dataModel.setValue(HOLDOFFTYP_VALUE, (Object)holdOfftyp.getLocaleString("name"));
        }
        dataModel.setValue(NAME_VALUE, (Object)name);
        DynamicObject posCategory = dyo.getDynamicObject("poscategory");
        LOGGER.info("\u804c\u4f4d\u7c7b\u522b\u5bf9\u8c61:{}", (Object)posCategory);
        if (!HRObjectUtils.isEmpty((Object)posCategory)) {
            OrmLocaleValue posCategoryName = (OrmLocaleValue)posCategory.get("name");
            dataModel.setValue(POSCATEGORY_VALUE, (Object)posCategoryName.getDefaultItem());
        }
    }

    default public void showRecruitNum(IDataModel dataModel, DynamicObject dyo) {
        if (dyo.getBoolean("isrecnumlimit")) {
            dataModel.setValue(RECRUITNUM_VALUE, (Object)IntrecoPageHelper.getSomeNum());
        } else {
            dataModel.setValue(RECRUITNUM_VALUE, (Object)dyo.getInt("recruitnum"));
        }
    }

    default public void showWorkAddr(IDataModel dataModel, DynamicObject dyo) {
        String distinctWorkName = IntrecoBusinessHelper.getDistinctWorkName("city", dyo);
        String msg = ResManager.loadKDString((String)"\u6682\u65e0\u5de5\u4f5c\u57ce\u5e02\u4fe1\u606f", (String)(MODULE + "_1"), (String)"tsc-tspr-formplugin", (Object[])new Object[0]);
        distinctWorkName = HRStringUtils.isNotEmpty((String)distinctWorkName) ? distinctWorkName : msg;
        dataModel.setValue(WORKADDR_CITY, (Object)distinctWorkName);
    }

    default public void showReward(IFormView formView, DynamicObject dyo) {
        boolean isReward = dyo.getBoolean("isreward");
        formView.setVisible(Boolean.valueOf(isReward), new String[]{REWARD_FLEX});
        if (!isReward) {
            return;
        }
        long reward = dyo.getLong("reward");
        if (reward > 0L) {
            String formatVal = IntrecoPageHelper.getRewardTpl(dyo);
            Label rewardLabel = (Label)formView.getControl(TITLE_REWARD);
            rewardLabel.setText(String.format(formatVal, reward));
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{TITLE_REWARD});
        }
        long rewardPoint = dyo.getLong("rewardpoint");
        if (rewardPoint > 0L) {
            String rewardPointText = IntrecoPageHelper.getRewardPointTpl(dyo);
            Label rewardPointLabel = (Label)formView.getControl(TITLE_REWARD_POINT);
            rewardPointLabel.setText(rewardPointText);
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{TITLE_REWARD_POINT});
        }
    }

    default public void showTopAndUrgent(IFormView view, DynamicObject dyo) {
        view.setVisible(Boolean.valueOf(dyo.getBoolean("istop")), new String[]{"title_istop"});
        view.setVisible(Boolean.valueOf(dyo.getBoolean("isurgent")), new String[]{"title_isurgent"});
    }
}

