/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileService;
import kd.tsc.tspr.business.domain.intv.service.BosUserServiceHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvevlEntity;
import kd.tsc.tspr.business.domain.intv.service.calendar.ChannelRelationServiceHelper;
import kd.tsc.tspr.business.domain.intv.service.calendar.NotifyYzjOperateHelper;
import kd.tsc.tspr.business.domain.intv.service.interveranswer.HandOverWorkflowAndMailEntity;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailEditorHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailUrgedHelper;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvTaskChangeEntity;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateHelper;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateParamEntity;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tspr.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tspr.business.domain.intv.service.task.ArgIntvFreeFlowTask;
import kd.tsc.tspr.business.domain.intv.service.util.IntvDetailUtil;
import kd.tsc.tspr.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tspr.common.entity.intv.AppFileUser;
import kd.tsc.tspr.common.entity.intv.calendar.YzjCreateMeetingBean;
import kd.tsc.tspr.common.entity.intv.calendar.YzjMeetingBean;
import kd.tsc.tspr.common.entity.intv.calendar.YzjModifyMeetingBean;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tspr.common.enums.TSPRPreDataEnum;
import kd.tsc.tspr.common.enums.intv.InterviewMailType;
import kd.tsc.tspr.common.enums.oprecord.ORStructText;
import kd.tsc.tspr.common.util.IntvDateUtil;
import kd.tsc.tsrbd.business.domain.intvfile.IntvFileHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ArgIntvHelper {
    private static final Log logger = LogFactory.getLog(ArgIntvHelper.class);
    private static final QFilter ENABLEFILTER = new QFilter("enable", "=", (Object)"1");
    private static final HRBaseServiceHelper ARGINTVSERVICEHELPER = new HRBaseServiceHelper("tspr_argintv");
    private static final HRBaseServiceHelper APPFILESERVICEHELPER = new HRBaseServiceHelper("tspr_appfile");
    public static final String BD_ADMINDIVISION = "bd_admindivision";
    public static final String ARG_INTV_HELPER = "ArgIntvHelper";
    public static final String INTV_UPDATA_CHANGETYPE_ADD = "Add";
    public static final String INTV_UPDATA_CHANGETYPE_DELETE = "Delete";
    public static final String INTV_UPDATA_CHANGETYPE_NOCHANGE = "NoChange";
    public static final ThreadPool INTV_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"arrangeInterviewExecuteTasks", (int)1, (int)5, (String)"tsc");
    public static final ArgIntvHelper INSTANCE = new ArgIntvHelper();
    private DynamicObject[] deleteOrChangeIntvTasks;

    public static ArgIntvHelper getInstance() {
        return INSTANCE;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return ARGINTVSERVICEHELPER.generateEmptyDynamicObject();
    }

    public static DynamicObject[] selectAllColumn(String queryColumn) {
        return ArgIntvHelper.selectAllColumnList(Collections.singletonList(queryColumn));
    }

    public static DynamicObject[] selectAllColumnList(List<String> queryColumnList) {
        String queryColumnStr = StringEscapeUtils.unescapeJava((String)StringUtils.join(queryColumnList, (String)","));
        return ARGINTVSERVICEHELPER.query(queryColumnStr, ENABLEFILTER.toArray());
    }

    public DynamicObject selectIntvStatusById(Long id) {
        Object[] dynamicObjects = ARGINTVSERVICEHELPER.query("id,interviewstatus", new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return ARGINTVSERVICEHELPER.generateEmptyDynamicObject();
        }
        return dynamicObjects[0];
    }

    public static DynamicObjectCollection selectIntvEvlByTaskId(Long taskId, List<String> queryColumnList) {
        return IntvEvlHelper.getInstance().queryOriginalCollection(taskId, queryColumnList);
    }

    public static DynamicObject selectById(Long id, String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        return helper.queryOne((Object)id);
    }

    public static DynamicObject[] getInterviews(Collection<Long> ids) {
        return ARGINTVSERVICEHELPER.loadDynamicObjectArray(ids.toArray());
    }

    public DynamicObject getAppFileByAppFileId(Long appFileId) {
        QFilter qFilter = new QFilter("id", "=", (Object)appFileId);
        return this.getAppFile(qFilter);
    }

    public DynamicObject getAppFile(Long appFileId) {
        return APPFILESERVICEHELPER.queryOne((Object)appFileId);
    }

    public DynamicObject getPositionByAppFileId(Long appFileId) {
        QFilter qFilter = new QFilter("id", "=", (Object)appFileId);
        return APPFILESERVICEHELPER.loadDynamicObject(qFilter).getDynamicObject("position");
    }

    public DynamicObject getRecrustgByAppFileId(Long appFileId) {
        QFilter qFilter = new QFilter("id", "=", (Object)appFileId);
        return APPFILESERVICEHELPER.loadDynamicObject(qFilter).getDynamicObject("recrustg");
    }

    public DynamicObject getAppFile(QFilter qFilters) {
        return APPFILESERVICEHELPER.loadDynamicObject(qFilters).getDynamicObject("appres");
    }

    public DynamicObject getIntvMethod(Long id) {
        return new HRBaseServiceHelper("tsrbd_intvmthd").loadSingle((Object)id);
    }

    public DynamicObject[] getAppFile(List<Long> appFileIds) {
        QFilter qFilter = new QFilter("id", "in", appFileIds);
        return APPFILESERVICEHELPER.query("id,number,name,status,filestatus,appres.photo,appres.fullname", qFilter.toArray());
    }

    public DynamicObject getIntvDataEntiry(Long id) {
        return ARGINTVSERVICEHELPER.loadSingle((Object)id);
    }

    public DynamicObject[] getAppFileAllFields(List<Long> appFileIds) {
        QFilter qFilter = new QFilter("id", "in", appFileIds);
        return APPFILESERVICEHELPER.query("id,number,name,status,position,appres,gender", qFilter.toArray());
    }

    public List<DynamicObject> getDynamicObjects(DynamicObject dataEntity, ArgIntvHelper argIntvHelper) {
        DynamicObjectCollection intvcandate = dataEntity.getDynamicObjectCollection("intvcandate");
        int size = intvcandate.size();
        long[] intvIds = ID.genLongIds((int)size);
        long[] roundIds = ID.genLongIds((int)size);
        long[] groupIds = ID.genLongIds((int)size);
        ArrayList argIntvDataEntitys = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            long intvId = intvIds[i];
            long roundId = roundIds[i];
            long groupId = groupIds[i];
            DynamicObject argIntvDataEntity = argIntvHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)argIntvDataEntity);
            argIntvDataEntity.set("id", (Object)intvId);
            if (i > 0) {
                argIntvDataEntity.set("number", null);
            }
            DynamicObjectCollection roundCollections = argIntvDataEntity.getDynamicObjectCollection("tspr_intvroundentry");
            DynamicObject round = (DynamicObject)roundCollections.get(0);
            round.set("id", (Object)roundId);
            DynamicObjectCollection groupEntry = round.getDynamicObjectCollection("tspr_intvgroupentry");
            DynamicObject group = (DynamicObject)groupEntry.get(i);
            group.set("id", (Object)groupId);
            groupEntry.clear();
            groupEntry.add(0, group);
            round.set("tspr_intvgroupentry", (Object)groupEntry);
            roundCollections.clear();
            roundCollections.add(0, round);
            argIntvDataEntity.set("tspr_intvroundentry", (Object)roundCollections);
            DynamicObjectCollection dynamicObjectCollection = argIntvDataEntity.getDynamicObjectCollection("intvcandate");
            dynamicObjectCollection.clear();
            DynamicObject groupCandate = (DynamicObject)intvcandate.get(i);
            dynamicObjectCollection.add((Object)groupCandate);
            argIntvDataEntity.set("intvcandate", (Object)dynamicObjectCollection);
            String name = groupCandate.getDynamicObject("fbasedataid").getString("name");
            String string = argIntvDataEntity.getString("interviewtitle");
            argIntvDataEntity.set("interviewtitle", (Object)(name + " - " + string));
            String string1 = argIntvDataEntity.getString("interviewtitle");
            if (string1.length() > 100) {
                argIntvDataEntity.set("interviewtitle", (Object)string1.substring(0, 100));
            }
            argIntvDataEntitys.add(argIntvDataEntity);
        }
        if (argIntvDataEntitys.size() > 1) {
            List dynamicObjects = argIntvDataEntitys.subList(1, argIntvDataEntitys.size());
            CodeRuleServiceHelper.injectNumbers((String)"tspr_argintv", dynamicObjects);
        }
        return argIntvDataEntitys;
    }

    public DynamicObject[] getDeleteOrChangeIntvTasks() {
        return this.deleteOrChangeIntvTasks;
    }

    public void setDeleteOrChangeIntvTasks(DynamicObject[] deleteOrChangeIntvTasks) {
        this.deleteOrChangeIntvTasks = deleteOrChangeIntvTasks;
    }

    public void generateFlowOfIntv(DynamicObject dataEntity, boolean isAddNew) {
        QFilter qFilterTask = new QFilter("argintv", "=", (Object)dataEntity.getLong("id")).and("taskstatus", "=", (Object)"A");
        DynamicObject[] intvTasksOld = IntvTaskHelper.getInstance().getIntvTasks(qFilterTask);
        DynamicObject[] intvelDOs = ArgIntvUpdateHelper.getIntvIntvels(dataEntity.getLong("id"));
        DynamicObject[] appfileTaskDOs = ArgIntvUpdateHelper.getAppfileTasks(dataEntity.getLong("id"));
        DynamicObjectCollection roundCollections = dataEntity.getDynamicObjectCollection("tspr_intvroundentry");
        ArrayList<ArgIntvUpdateResultEntity> argIntvUpdateResult = new ArrayList();
        if (!isAddNew) {
            ArgIntvUpdateParamEntity argIntvUpParamm = new ArgIntvUpdateParamEntity();
            argIntvUpParamm.setArgIntvId(dataEntity.getLong("id"));
            argIntvUpParamm.setRoundsNew(roundCollections);
            argIntvUpParamm.setIntvTasksOld(intvTasksOld);
            argIntvUpParamm.setIntvelsOld(intvelDOs);
            argIntvUpParamm.setAppfileTaskDOs(appfileTaskDOs);
            argIntvUpdateResult = ArgIntvUpdateHelper.getIntvChange(argIntvUpParamm);
            DynamicObject[] deleteOrChangeIntvTasksParams = ArgIntvUpdateHelper.getDeleteIntvTask(argIntvUpdateResult);
            DynamicObject[] deleteOrChangeIntvels = ArgIntvUpdateHelper.getDeleteIntvels(argIntvUpdateResult);
            this.setDeleteOrChangeIntvTasks(deleteOrChangeIntvTasksParams);
            ArgIntvTaskChangeEntity argIntvTaskChange = ArgIntvUpdateHelper.getIntvTaskChange(argIntvUpdateResult);
            ArgIntvUpdateHelper.updateIntvTasks(argIntvTaskChange);
            ArgIntvUpdateHelper.updateIntvels(deleteOrChangeIntvels);
            ArgIntvUpdateHelper.resetTask(argIntvUpdateResult);
        }
        for (DynamicObject round : roundCollections) {
            DynamicObjectCollection groupCollections = round.getDynamicObjectCollection("tspr_intvgroupentry");
            ArrayList intvTaskList = Lists.newArrayList();
            ArrayList intvevlDynamicObjectLists = Lists.newArrayList();
            ArrayList appfileTaskLists = Lists.newArrayList();
            long[] channelRelationIds = ID.genLongIds((int)groupCollections.size());
            AtomicInteger x = new AtomicInteger(0);
            for (DynamicObject groupAdd : groupCollections) {
                DynamicObject group = new DynamicObject(groupAdd.getDynamicObjectType());
                if (!isAddNew) {
                    HRDynamicObjectUtils.copy((DynamicObject)groupAdd, (DynamicObject)group);
                    group.set("id", (Object)groupAdd.getLong("id"));
                    group = ArgIntvUpdateHelper.removeGroupNoChangeInterViewer(group, argIntvUpdateResult);
                } else {
                    group = groupAdd;
                }
                DynamicObjectCollection groupCandates = group.getDynamicObjectCollection("groupcandate");
                DynamicObjectCollection intverCollections = group.getDynamicObjectCollection("intver");
                long[] appfileTaskIds = ArgIntvUpdateHelper.getGroupAppfileTaskIds(appfileTaskDOs, groupCandates, isAddNew);
                DynamicObject finalGroup = group;
                if (isAddNew) {
                    this.generateAppfileTask(dataEntity, round, group, groupCandates, appfileTaskLists, appfileTaskIds);
                    INTV_THREAD_POOL.execute(() -> {
                        String meetingId = this.notifyYzjCreateMeeting(dataEntity, round, finalGroup, intverCollections);
                        logger.info("Yzj -> createMeeting meetingId is {}", (Object)meetingId);
                        if (HRStringUtils.isNotEmpty((String)meetingId)) {
                            this.generateChannelRelation(dataEntity, round, finalGroup, channelRelationIds[x.getAndIncrement()], meetingId);
                        }
                    });
                } else {
                    this.updateAppfileTaskIntvTime(group, groupCandates);
                    argIntvUpdateResult.forEach(argIntvUpdateResultEntity -> {
                        if (argIntvUpdateResultEntity.getGroupId().longValue() == finalGroup.getLong("id")) {
                            List<Long> interViewerIdAdd = argIntvUpdateResultEntity.getInterViewerIdAdd();
                            List<Long> interViewerIdDel = argIntvUpdateResultEntity.getInterViewerIdDelete();
                            boolean groupIntvTimeChange = argIntvUpdateResultEntity.isGroupIntvTimeChange();
                            if (CollectionUtils.isNotEmpty(interViewerIdAdd) || CollectionUtils.isNotEmpty(interViewerIdDel) || groupIntvTimeChange) {
                                this.notifyYzjModifyMeeting(dataEntity, round, finalGroup, intverCollections, interViewerIdAdd, interViewerIdDel);
                            }
                        }
                    });
                }
                this.extracted(dataEntity, intvTaskList, intvevlDynamicObjectLists, round, group, intverCollections, appfileTaskIds);
            }
            IntvTaskHelper.getInstance().save(intvTaskList);
            IntvEvlHelper.getInstance().saveIntvevls(intvevlDynamicObjectLists.toArray(new DynamicObject[0]));
            IntvAppfileTaskHelper.getInstance().updateAppfileTaskAndAppfile(appfileTaskLists.toArray(new DynamicObject[0]));
            logger.info("call processMail service begin ");
            ArrayList<ArgIntvUpdateResultEntity> finalArgIntvUpdateResult = argIntvUpdateResult;
            INTV_THREAD_POOL.execute(() -> {
                if (isAddNew) {
                    InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.ADD);
                    IntvMailHelper.getInstance().processAddNew(dataEntity, intvTaskList, appfileTaskLists, true, interviewNoticeModel, null, new InterviewNoticeModel());
                } else {
                    IntvMailEditorHelper.getInstance().processEditor(dataEntity, finalArgIntvUpdateResult);
                }
            });
            logger.info("call processMail service end ");
        }
    }

    public void arrangeInterviewExecuteTasks(DynamicObject dataEntity) {
        ArgIntvFreeFlowTask.abandon(this.getDeleteOrChangeIntvTasks());
        logger.info("call bindAppFileResume service begin ");
        DynamicObjectCollection intvCandate = dataEntity.getDynamicObjectCollection("intvcandate");
        ArrayList appFileObjects = Lists.newArrayListWithCapacity((int)intvCandate.size());
        for (DynamicObject dynamicObject : intvCandate) {
            appFileObjects.add(dynamicObject.getDynamicObject("fbasedataid"));
        }
        AppFileHelper.bindAppFileResume(appFileObjects.toArray(new DynamicObject[0]));
        logger.info("call bindAppFileResume service end ");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.put("INTERVIEWARRANGERORGID_" + dataEntity.getLong("id"), (Object)(RequestContext.get().getOrgId() + ""), Integer.MAX_VALUE, TimeUnit.DAYS);
        logger.info("call buildFreeFlowTask begin");
        ArgIntvFreeFlowTask.buildFreeFlowTask(dataEntity);
        logger.info("call buildFreeFlowTask end");
        String interviewtitle = dataEntity.getString("interviewtitle");
        DistributeSessionlessCache appCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String isAddNew_intv = (String)appCache.get("isAddNew_Intv" + dataEntity.getLong("id"));
        List<DynamicObject> candates = this.getCandates(dataEntity);
        if (isAddNew_intv.equals("true")) {
            IntvOpRecordService.getInstance().intvCommonOR(candates, OpDefEnum.ARG_INTV, ORStructText.ARG_INTV, interviewtitle);
        } else {
            IntvOpRecordService.getInstance().intvCommonOR(candates, OpDefEnum.MODIFY_INTV, ORStructText.MODIFY_INTV, interviewtitle);
        }
    }

    private List<DynamicObject> getCandates(DynamicObject dataEntity) {
        ArrayList candates = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection roundCollections = dataEntity.getDynamicObjectCollection("tspr_intvroundentry");
        for (DynamicObject round : roundCollections) {
            DynamicObjectCollection groupCollections = round.getDynamicObjectCollection("tspr_intvgroupentry");
            for (DynamicObject groupAdd : groupCollections) {
                DynamicObjectCollection groupCandates = groupAdd.getDynamicObjectCollection("groupcandate");
                for (DynamicObject groupCandate : groupCandates) {
                    DynamicObject candate = groupCandate.getDynamicObject("fbasedataid");
                    candates.add(candate);
                }
            }
        }
        return candates;
    }

    private void extracted(DynamicObject dataEntity, List<DynamicObject> intvTaskList, List<DynamicObject> intvevlDynamicObjectLists, DynamicObject round, DynamicObject group, DynamicObjectCollection intverCollections, long[] appfileTaskIds) {
        Object[] fileIds = group.getDynamicObjectCollection("intverfile").stream().map(file -> file.getLong("fbasedataid_id")).toArray();
        DynamicObject[] userByFileId = IntvFileHelper.getInstance().getUserByFileId(fileIds);
        Map<Long, DynamicObject> intvFileMap = Arrays.stream(userByFileId).collect(Collectors.toMap(file -> file.getDynamicObject("user").getLong("id"), file -> file));
        for (DynamicObject interviewer : intverCollections) {
            DynamicObject intver = interviewer.getDynamicObject("fbasedataid");
            long taskId = ID.genLongId();
            DynamicObject intvTaskDynamicObject = this.generateIntvTask(dataEntity, round, group, intver, taskId, intvFileMap);
            DynamicObjectCollection groupCandateCollections = group.getDynamicObjectCollection("groupcandate");
            DynamicObjectCollection taskIntvevlEntryCollection = intvTaskDynamicObject.getDynamicObjectCollection("tspr_intvevlentry");
            int size = groupCandateCollections.size();
            ArrayList intvevlDynamicObjects = Lists.newArrayListWithExpectedSize((int)size);
            IntvevlEntity intvevlEntity = new IntvevlEntity(dataEntity, round, group, intver, groupCandateCollections, taskIntvevlEntryCollection, intvevlDynamicObjects);
            intvevlEntity.setTaskId(taskId);
            IntStream.range(0, size).forEach(i -> this.generateIntvevl(intvevlEntity, i, appfileTaskIds));
            intvTaskList.add(intvTaskDynamicObject);
            intvevlDynamicObjectLists.addAll(intvevlDynamicObjects);
        }
    }

    private void generateChannelRelation(DynamicObject dataEntity, DynamicObject round, DynamicObject group, long channelRelationId, String meetingId) {
        DynamicObject channelRelationObject = ChannelRelationServiceHelper.generateEmptyDynamicObject();
        channelRelationObject.set("id", (Object)channelRelationId);
        channelRelationObject.set("argintv", (Object)dataEntity);
        channelRelationObject.set("round", (Object)round);
        channelRelationObject.set("intvgroup", (Object)group);
        channelRelationObject.set("channel", (Object)meetingId);
        ChannelRelationServiceHelper.save(channelRelationObject);
    }

    private YzjMeetingBean generateYzjMeeting(DynamicObject dataEntity, DynamicObject round, DynamicObject group, DynamicObjectCollection intverCollections) {
        long interviewArrangerId = dataEntity.getDynamicObject("interviewarranger").getLong("id");
        DynamicObject useropenid = UserServiceHelper.getUserInfoByID((Long)interviewArrangerId, (String)"useropenid");
        String openId = useropenid.getString("useropenid");
        String interviewTitle = dataEntity.getString("interviewtitle");
        Long interviewMethodId = round.getDynamicObject("interviewmethod").getLong("id");
        String interviewLocation = TSPRPreDataEnum.KEY_1010.getId().equals(interviewMethodId) ? group.getString("interviewlocation") : (TSPRPreDataEnum.KEY_1040.getId().equals(interviewMethodId) ? group.getString("intvervedioaddress") : "");
        Date intvDate = group.getDate("intvdate");
        long startTime = group.getLong("intvstarttime");
        long endTime = group.getLong("intvendtime");
        long startLong = IntvDateUtil.getLocalDateTimeOfLong((Date)intvDate, (Long)startTime);
        long endLong = IntvDateUtil.getLocalDateTimeOfLong((Date)intvDate, (Long)endTime);
        List<Long> appfileIds = intverCollections.stream().map(groupCandate -> groupCandate.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject[] queryOpenIdsByUserIds = BosUserServiceHelper.queryOpenIdsByUserIds(appfileIds);
        List userOpenIds = Arrays.stream(queryOpenIdsByUserIds).map(userIds -> userIds.getString("useropenid")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userOpenIds)) {
            logger.info("Yzj -> userOpenIds is null");
            return null;
        }
        int noticeTime = 15;
        return new YzjMeetingBean(openId, interviewTitle, interviewTitle, interviewLocation, startLong, endLong, "", noticeTime, 1, userOpenIds, false);
    }

    private String notifyYzjCreateMeeting(DynamicObject dataEntity, DynamicObject round, DynamicObject group, DynamicObjectCollection intverCollections) {
        YzjMeetingBean yzjMeetingBean = this.generateYzjMeeting(dataEntity, round, group, intverCollections);
        if (HRObjectUtils.isEmpty((Object)yzjMeetingBean)) {
            logger.info("Yzj -> yzjMeetingBean is null");
            return null;
        }
        YzjCreateMeetingBean yzjCreateMeetingBean = new YzjCreateMeetingBean(yzjMeetingBean, null);
        logger.info("Yzj -> interview createMeeting to yunzhijia params is {}", (Object)yzjCreateMeetingBean.toString());
        String meetingId = NotifyYzjOperateHelper.createMeeting(yzjCreateMeetingBean);
        logger.info("Yzj -> interview createMeeting to yunzhijia result meetingId is {}", (Object)meetingId);
        return meetingId;
    }

    private void notifyYzjModifyMeeting(DynamicObject dataEntity, DynamicObject round, DynamicObject group, DynamicObjectCollection intverCollections, List<Long> addList, List<Long> delList) {
        YzjMeetingBean yzjMeetingBean = this.generateYzjMeeting(dataEntity, round, group, intverCollections);
        if (HRObjectUtils.isEmpty((Object)yzjMeetingBean)) {
            logger.info("Yzj -> yzjMeetingBean is null");
            return;
        }
        DynamicObject channelObject = ChannelRelationServiceHelper.queryByGroup(group);
        if (HRObjectUtils.isEmpty((Object)channelObject)) {
            logger.info("Yzj -> channelObject is null");
            return;
        }
        String channelId = channelObject.getString("channel");
        List addActors = Arrays.stream(BosUserServiceHelper.queryOpenIdsByUserIds(addList)).map(mValue -> mValue.getString("useropenid")).collect(Collectors.toList());
        List delActors = Arrays.stream(BosUserServiceHelper.queryOpenIdsByUserIds(delList)).map(mValue -> mValue.getString("useropenid")).collect(Collectors.toList());
        YzjModifyMeetingBean yzjModifyMeetingBean = new YzjModifyMeetingBean(yzjMeetingBean, channelId, addActors, delActors);
        logger.info("Yzj -> interview modifyMeeting to yunzhijia params is {}", (Object)yzjModifyMeetingBean.toString());
        NotifyYzjOperateHelper.modifyMeeting(yzjModifyMeetingBean);
        logger.info("Yzj -> interview modifyMeeting to yunzhijia result meetingId ");
    }

    public void cancelMeetingByArgIntv(DynamicObject argIntv) {
        long interviewArrangerId = argIntv.getDynamicObject("interviewarranger").getLong("id");
        DynamicObject[] queryByIntvs = ChannelRelationServiceHelper.queryByIntv(argIntv);
        logger.info("Yzj -> start call cancelMeeting , interviewArrangerId is {},queryByIntvs size is {}", (Object)interviewArrangerId, (Object)queryByIntvs.length);
        for (DynamicObject queryByIntv : queryByIntvs) {
            NotifyYzjOperateHelper.cancelMeeting(queryByIntv.getString("channel"), interviewArrangerId);
        }
        logger.info("Yzj -> end call cancelMeeting  ");
    }

    public void cancelMeetingByRound(DynamicObject group) {
        DynamicObject queryByGroup = ChannelRelationServiceHelper.queryByGroup(group);
        long interviewArrangerId = queryByGroup.getDynamicObject("interviewarranger").getLong("id");
        logger.info("Yzj -> start call cancelMeeting by round ");
        NotifyYzjOperateHelper.cancelMeeting(queryByGroup.getString("channel"), interviewArrangerId);
        logger.info("Yzj -> end call cancelMeeting by round ");
    }

    private void generateAppfileTask(DynamicObject dataEntity, DynamicObject round, DynamicObject group, DynamicObjectCollection groupCandates, List<DynamicObject> appfileTaskLists, long[] appfileTaskIds) {
        int i = 0;
        ArrayList appfileLongIds = Lists.newArrayListWithCapacity((int)groupCandates.size());
        for (DynamicObject groupCandate : groupCandates) {
            DynamicObject candate = groupCandate.getDynamicObject("fbasedataid");
            long taskId = appfileTaskIds[i];
            ++i;
            DynamicObject candateTaskDynamicObject = IntvAppfileTaskHelper.getInstance().generateEmptyDynamicObject();
            candateTaskDynamicObject.set("id", (Object)taskId);
            candateTaskDynamicObject.set("application", (Object)candate);
            candateTaskDynamicObject.set("intverstatus", (Object)"A");
            candateTaskDynamicObject.set("argintv", (Object)dataEntity);
            candateTaskDynamicObject.set("round", (Object)round);
            candateTaskDynamicObject.set("intvgroup", (Object)group);
            candateTaskDynamicObject.set("signinstatus", (Object)"A");
            candateTaskDynamicObject.set("applicationanswer", (Object)"A");
            candateTaskDynamicObject.set("taskstatus", (Object)"A");
            candateTaskDynamicObject.set("intvtime", (Object)IntvDateUtil.getIntvDateTime((Date)group.getDate("intvdate"), (Long)group.getLong("intvstarttime")));
            candateTaskDynamicObject.set("enable", (Object)"1");
            appfileTaskLists.add(candateTaskDynamicObject);
            appfileLongIds.add(candate.getLong("id"));
        }
        AppFileService.getInstance().lockAppFiles(appfileLongIds, TSCRequestContext.getUserId());
    }

    private void updateAppfileTaskIntvTime(DynamicObject group, DynamicObjectCollection groupCandates) {
        List<Long> appfileIds = groupCandates.stream().map(groupCandate -> groupCandate.getLong("fbasedataid_id")).collect(Collectors.toList());
        long detailId = group.getLong("id");
        DynamicObject[] groupIdAndAppfileId = IntvAppfileTaskHelper.getInstance().getAppfileTaskIntvTimeByGroupIdAndAppfileId(appfileIds, detailId);
        Date intvdate = group.getDate("intvdate");
        Long intvStartTime = group.getLong("intvstarttime");
        Date intvDateTime = IntvDateUtil.getIntvDateTime((Date)intvdate, (Long)intvStartTime);
        for (DynamicObject dynamicObject : groupIdAndAppfileId) {
            dynamicObject.set("intvTime", (Object)intvDateTime);
        }
        IntvAppfileTaskHelper.getInstance().updateAppfileTaskAndAppfile(groupIdAndAppfileId);
    }

    private DynamicObject generateIntvTask(DynamicObject dataEntity, DynamicObject round, DynamicObject group, DynamicObject intver, long taskId, Map<Long, DynamicObject> intvFileMap) {
        DynamicObject intvTaskDynamicObject = IntvTaskHelper.getInstance().generateEmptyDynamicObject();
        intvTaskDynamicObject.set("id", (Object)taskId);
        intvTaskDynamicObject.set("argintv", (Object)dataEntity);
        intvTaskDynamicObject.set("round", (Object)round);
        intvTaskDynamicObject.set("intvgroup", (Object)group);
        intvTaskDynamicObject.set("taskstatus", (Object)"A");
        String intvTitle = dataEntity.getString("interviewtitle");
        if (intvTitle.length() > 100) {
            dataEntity.set("interviewtitle", (Object)intvTitle.substring(0, 100));
        }
        intvTaskDynamicObject.set("name", dataEntity.get("interviewtitle"));
        intvTaskDynamicObject.set("interviewer", (Object)intver);
        intvTaskDynamicObject.set("intverfile", (Object)intvFileMap.get(intver.getLong("id")));
        intvTaskDynamicObject.set("enable", (Object)"1");
        intvTaskDynamicObject.set("interveranswer", (Object)"A");
        return intvTaskDynamicObject;
    }

    private void generateIntvevl(IntvevlEntity intvevlEntity, int i, long[] appfileTaskIds) {
        DynamicObject dataEntity = intvevlEntity.getDataEntity();
        DynamicObject round = intvevlEntity.getRound();
        DynamicObject group = intvevlEntity.getGroup();
        DynamicObject intver = intvevlEntity.getIntver();
        long taskId = intvevlEntity.getTaskId();
        DynamicObjectCollection groupCandateCollections = intvevlEntity.getGroupCandateCollections();
        DynamicObjectCollection taskIntvevlEntryCollection = intvevlEntity.getTaskIntvevlEntryCollection();
        List<DynamicObject> intvevlDynamicObjects = intvevlEntity.getIntvevlDynamicObjects();
        DynamicObject groupCandate = ((DynamicObject)groupCandateCollections.get(i)).getDynamicObject("fbasedataid");
        DynamicObject intvevlDynamicObject = IntvEvlHelper.getInstance().generateEmptyDynamicObject();
        Long intvevlId = ID.genLongId();
        intvevlDynamicObject.set("id", (Object)intvevlId);
        intvevlDynamicObject.set("argintv", (Object)dataEntity);
        intvevlDynamicObject.set("round", (Object)round);
        intvevlDynamicObject.set("intvgroup", (Object)group);
        intvevlDynamicObject.set("appfiletask", (Object)appfileTaskIds[i]);
        intvevlDynamicObject.set("application", (Object)groupCandate);
        intvevlDynamicObject.set("resume", (Object)groupCandate.getDynamicObject("appres"));
        intvevlDynamicObject.set("intvtask", (Object)taskId);
        intvevlDynamicObject.set("interviewer", (Object)intver);
        intvevlDynamicObject.set("interviewstatus", (Object)"A");
        intvevlDynamicObject.set("handlestatus", (Object)"A");
        intvevlDynamicObject.set("enable", (Object)"1");
        intvevlDynamicObjects.add(intvevlDynamicObject);
        DynamicObject dynamicObject = taskIntvevlEntryCollection.addNew();
        dynamicObject.set("intvevl", (Object)intvevlDynamicObject);
    }

    public static DynamicObject[] findIntvTaskByArgIntvId(Long argIntvId) {
        return IntvTaskHelper.getInstance().getIntvTasks(new QFilter("argintv", "=", (Object)argIntvId));
    }

    public Object updateArgintvStatus(DynamicObject argintv, String status) {
        argintv.set("interviewstatus", (Object)status);
        return ARGINTVSERVICEHELPER.updateOne(argintv);
    }

    public Object[] updateIntvTasks(DynamicObject argIntv, String status) {
        DynamicObject[] intvTasks;
        QFilter qFilter = new QFilter("argintv", "=", argIntv.get("id"));
        for (DynamicObject intvTask : intvTasks = IntvTaskHelper.getInstance().getIntvTasks(qFilter)) {
            intvTask.set("taskstatus", (Object)status);
        }
        ArgIntvFreeFlowTask.abandon(intvTasks);
        return IntvTaskHelper.getInstance().updateTasks(intvTasks);
    }

    public List<AppFileUser> getAppFileForIntv(List<Long> appFileIds) {
        DynamicObject[] load = APPFILESERVICEHELPER.query("id,fullname,appres.photo,position.name", new QFilter[]{new QFilter("id", "in", appFileIds)});
        LinkedList<AppFileUser> appFileUsers = new LinkedList<AppFileUser>();
        appFileIds.forEach(appFileId -> Arrays.stream(load).filter(dynamicObject -> appFileId.longValue() == dynamicObject.getLong("id")).forEach(dynamicObject -> this.generateAppFileUser(appFileUsers, (DynamicObject)dynamicObject)));
        return appFileUsers;
    }

    private void generateAppFileUser(List<AppFileUser> appFileUsers, DynamicObject dynamicObject) {
        AppFileUser appFileUser = new AppFileUser();
        appFileUser.setAppFileId(Long.valueOf(dynamicObject.getLong("id")));
        String dbName = dynamicObject.getString("name");
        appFileUser.setName(dbName);
        appFileUser.setPhoto(dynamicObject.getString("appres.photo"));
        appFileUsers.add(appFileUser);
    }

    public DynamicObject[] getAppFileInfo(List<Long> appFileIds, String properties) {
        return APPFILESERVICEHELPER.queryOriginalArray(properties, new QFilter[]{new QFilter("id", "in", appFileIds)});
    }

    public List<AppFileUser> getOneAppFileForIntv(Long appFileIds) {
        DynamicObject dynamicObject = APPFILESERVICEHELPER.queryOne("id,fullname,appres.photo,position.name,appres.email,appres.phone", new QFilter[]{new QFilter("id", "in", (Object)appFileIds)});
        AppFileUser appFileUser = new AppFileUser();
        appFileUser.setAppFileId(Long.valueOf(dynamicObject.getLong("id")));
        String dbName = dynamicObject.getString("name");
        appFileUser.setName(dbName);
        appFileUser.setPhoto(dynamicObject.getString("appres.photo"));
        appFileUser.setPhone(dynamicObject.getString("appres.phone"));
        appFileUser.setEmail(dynamicObject.getString("appres.email"));
        return Lists.newArrayList((Object[])new AppFileUser[]{appFileUser});
    }

    public Boolean setCancelStatus(DynamicObject argIntv) {
        long intvId = argIntv.getLong("id");
        DynamicObject newArgIntv = TsrbsHelper.selectById(intvId, "tspr_argintv");
        if (HRObjectUtils.isEmpty((Object)newArgIntv)) {
            return Boolean.FALSE;
        }
        QFilter qFilter1 = new QFilter("argintv", "=", (Object)newArgIntv.getLong("id"));
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks("id,application,intvtime,taskstatus,intvevlstatus", qFilter1);
        List<DynamicObject> collect = Arrays.stream(appfileTasks).filter(tasks -> !tasks.getString("taskstatus").equals("B")).map(ta -> ta.getDynamicObject("application")).collect(Collectors.toList());
        this.updateArgintvStatus(newArgIntv, "C");
        this.updateIntvTasks(argIntv, "C");
        this.updateAppFileTask(newArgIntv, "B");
        INTV_THREAD_POOL.execute(() -> this.cancelMeetingByArgIntv(argIntv));
        QFilter qFilter = new QFilter("argintv", "=", (Object)intvId);
        List<DynamicObject> evlList = TsrbsHelper.selectByFilter(qFilter.toArray(), "tspr_intvevl");
        boolean flag = evlList.stream().anyMatch(evl -> !"A".equals(evl.getString("handlestatus")) && !"A".equals(evl.getString("interviewstatus")));
        if (flag) {
            return Boolean.FALSE;
        }
        String interviewtitle = argIntv.getString("interviewtitle");
        IntvDetailUtil.updateIntvEvl(evlList, "C");
        IntvDetailUtil.sendMessage(Collections.singletonList(newArgIntv), null, Boolean.FALSE);
        IntvOpRecordService.getInstance().intvCommonOR(collect, OpDefEnum.CANCEL_INTV, ORStructText.CANCEL_INTV, interviewtitle);
        return Boolean.TRUE;
    }

    private void updateAppFileTask(DynamicObject argIntv, String taskStatus) {
        QFilter qFilter = new QFilter("argintv", "=", (Object)argIntv.getLong("id"));
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks("id,application,intvtime,taskstatus,intvevlstatus", qFilter);
        DynamicObject[] appfileArrays = (DynamicObject[])Arrays.stream(appfileTasks).map(appfile -> this.setAppFileTaskStatus((DynamicObject)appfile, taskStatus)).toArray(DynamicObject[]::new);
        IntvAppfileTaskHelper.getInstance().updateAppfileTaskAndAppfile(appfileArrays);
    }

    private DynamicObject setAppFileTaskStatus(DynamicObject appFileTask, String taskStatus) {
        appFileTask.set("taskstatus", (Object)taskStatus);
        return appFileTask;
    }

    public HandOverWorkflowAndMailEntity handOverTo(DynamicObjectCollection intvTasks, DynamicObject passedPerson, DynamicObject intverFile) {
        ArrayList intvTaskList = Lists.newArrayList();
        DynamicObjectCollection intvTasksNew = new DynamicObjectCollection();
        ArrayList intvevlDynamicObjectLists = Lists.newArrayList();
        DynamicObject argintv = this.generateEmptyDynamicObject();
        long[] intvTaskNewIds = ID.genLongIds((int)intvTasks.size());
        long[] intvevlNewIds = ID.genLongIds((int)this.getNewIntvelSize(intvTasks));
        int countTask = 0;
        int countIntvel = 0;
        for (DynamicObject intvTask : intvTasks) {
            long intvTaskNewId = intvTaskNewIds[countTask];
            ++countTask;
            argintv = intvTask.getDynamicObject("argintv");
            DynamicObject round = intvTask.getDynamicObject("round");
            DynamicObject group = intvTask.getDynamicObject("intvgroup");
            DynamicObjectCollection intvers = group.getDynamicObjectCollection("intver");
            intvers.clear();
            DynamicObject newIntvers = intvers.addNew();
            newIntvers.set("fbasedataid", (Object)passedPerson);
            intvers.add((Object)newIntvers);
            ArrayList addList = Lists.newArrayList();
            addList.add(passedPerson.getLong("id"));
            ArrayList delList = Lists.newArrayList();
            delList.add(intvTask.getDynamicObject("interviewer").getLong("id"));
            this.notifyYzjModifyMeeting(argintv, round, group, intvers, addList, delList);
            DynamicObject intvTaskNew = IntvTaskHelper.getInstance().generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)intvTask, (DynamicObject)intvTaskNew);
            intvTaskNew.set("id", (Object)intvTaskNewId);
            intvTaskNew.set("interveranswer", (Object)"A");
            intvTaskNew.set("taskstatus", (Object)"A");
            intvTaskNew.set("interviewer", (Object)passedPerson);
            intvTaskNew.set("intverfile", (Object)intverFile);
            DynamicObjectCollection intvTaskNewDynamicObjectCollection = intvTaskNew.getDynamicObjectCollection("tspr_intvevlentry");
            DynamicObjectCollection intvTaskDynamicObjectCollection = intvTask.getDynamicObjectCollection("tspr_intvevlentry");
            int countIntvelEntry = 0;
            for (DynamicObject intvTaskObject : intvTaskDynamicObjectCollection) {
                long intvelIdNew = intvevlNewIds[countIntvel];
                DynamicObject intvevl = intvTaskObject.getDynamicObject("intvevl");
                DynamicObject intvevlNew = IntvEvlHelper.getInstance().generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)intvevl, (DynamicObject)intvevlNew);
                intvevlNew.set("id", (Object)intvelIdNew);
                intvevlNew.set("intvtask", (Object)intvTaskNew);
                intvevlNew.set("handlestatus", (Object)"A");
                intvevlNew.set("interviewer", (Object)passedPerson);
                intvevlNew.set("enable", (Object)"1");
                intvevlDynamicObjectLists.add(intvevlNew);
                DynamicObject intvevlEntryNew = (DynamicObject)intvTaskNewDynamicObjectCollection.get(countIntvelEntry);
                intvevlEntryNew.set("intvevl", (Object)intvevlNew);
                ++countIntvelEntry;
                ++countIntvel;
            }
            intvTaskNew.set("tspr_intvevlentry", (Object)intvTaskNewDynamicObjectCollection);
            DynamicObject passPersionFromDO = UserServiceHelper.getCurrentUser((String)"name");
            intvTaskNew.set("passedpersonfrom", (Object)passPersionFromDO);
            intvTaskList.add(intvTaskNew);
            intvTasksNew.add((Object)intvTaskNew);
        }
        IntvTaskHelper.getInstance().save(intvTaskList);
        IntvEvlHelper.getInstance().saveIntvevls(intvevlDynamicObjectLists.toArray(new DynamicObject[0]));
        HandOverWorkflowAndMailEntity workflowAndMailParam = new HandOverWorkflowAndMailEntity();
        workflowAndMailParam.setIntvTaskListNew(intvTaskList);
        workflowAndMailParam.setIntvTaskCollectiontNew(intvTasksNew);
        workflowAndMailParam.setArgintv(argintv);
        workflowAndMailParam.setPassedPerson(passedPerson);
        workflowAndMailParam.setIntvTasks(intvTasks);
        return workflowAndMailParam;
    }

    private int getNewIntvelSize(DynamicObjectCollection intvTasks) {
        int size = 0;
        for (DynamicObject intvTask : intvTasks) {
            DynamicObjectCollection intvTaskDynamicObjectCollection = intvTask.getDynamicObjectCollection("tspr_intvevlentry");
            size += intvTaskDynamicObjectCollection.size();
        }
        return size;
    }

    public void handOverWorkflowAndMail(HandOverWorkflowAndMailEntity workflowAndMailParam) {
        for (DynamicObject task : workflowAndMailParam.getIntvTaskListNew()) {
            ArgIntvFreeFlowTask.doBuildFreeFlowTask(task, workflowAndMailParam.getArgintv());
        }
        ArgIntvFreeFlowTask.abandon(workflowAndMailParam.getIntvTasks());
        IntvMailUrgedHelper.getInstance().processTransfer(workflowAndMailParam.getIntvTaskCollectiontNew(), workflowAndMailParam.getPassedPerson());
    }

    public DynamicObject selectPosCat(Long positionId) {
        if (positionId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject positionData = QueryServiceHelper.queryOne((String)"tspr_position", (String)"id,recruscene,reccategory,createorg", (QFilter[])qFilter.toArray());
        return positionData;
    }

    public Long selectPosRecruscene(Long positionId) {
        if (positionId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject positionData = QueryServiceHelper.queryOne((String)"tspr_position", (String)"id,recruscene", (QFilter[])qFilter.toArray());
        if (positionData != null && positionData.get("recruscene") != null) {
            return positionData.getLong("recruscene");
        }
        return null;
    }

    public boolean isExists(Long pkId) {
        return !ARGINTVSERVICEHELPER.isExists((Object)pkId);
    }

    public DynamicObject getArgIntv(QFilter qFilter) {
        return ARGINTVSERVICEHELPER.loadDynamicObject(qFilter);
    }

    public DynamicObject[] getArgIntvs(String fields, QFilter[] qFilters) {
        return ARGINTVSERVICEHELPER.query(fields, qFilters);
    }
}

