/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class BosUserServiceHelper {
    private static final HRBaseServiceHelper BOS_USER = new HRBaseServiceHelper("bos_user");
    private static final String SELECT_PROPERTIES = "useropenid,id";

    public static DynamicObject[] queryUserIdByOpenIds(List<String> openIds) {
        QFilter filter = new QFilter("useropenid", "in", openIds);
        return BOS_USER.query(SELECT_PROPERTIES, new QFilter[]{filter});
    }

    public static DynamicObject[] queryOpenIdsByUserIds(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return BOS_USER.query(SELECT_PROPERTIES, new QFilter[]{filter});
    }

    public DynamicObject[] getUser(List<Long> Ids) {
        return BOS_USER.queryOriginalArray(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"phone", "email", "gender", "id", "name", "number", "entryentity.dpt.id", "entryentity.ispartjob", "useropenid", "picturefield"}), new QFilter[]{new QFilter("id", "in", Ids)});
    }

    public DynamicObject getUser(Long id) {
        return BOS_USER.queryOne(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"phone", "email", "gender", "id", "name", "number", "entryentity.dpt.id", "entryentity.ispartjob", "useropenid", "picturefield"}), new QFilter[]{new QFilter("id", "in", (Object)id)});
    }

    public Map<Long, DynamicObject> getUserMainDept(List<Long> userIds) {
        QFilter idFilter = new QFilter("id", "in", userIds);
        QFilter partFilter = new QFilter("entryentity.ispartjob", "=", (Object)"0");
        DynamicObject[] userDept = BOS_USER.queryOriginalArray("id, entryentity.dpt.id deptid,entryentity.dpt.name name", new QFilter[]{idFilter, partFilter});
        return Arrays.stream(userDept).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
    }

    private BosUserServiceHelper() {
    }

    public static BosUserServiceHelper getInstance() {
        return BosUserServiceHelperHolder.INSTANCE;
    }

    private static class BosUserServiceHelperHolder {
        private static final BosUserServiceHelper INSTANCE = new BosUserServiceHelper();

        private BosUserServiceHelperHolder() {
        }
    }
}

