/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvErrorCode;
import kd.tsc.tspr.common.util.IntvDateUtil;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbs.common.enums.AppfileTaskStatusEnum;
import kd.tsc.tsrbs.common.enums.ApplicationAnswerEnum;
import kd.tsc.tsrbs.common.enums.EvalResultEnum;
import kd.tsc.tsrbs.common.enums.EvalStatusEnum;
import kd.tsc.tsrbs.common.enums.InterviewStatusEnum;
import kd.tsc.tsrbs.common.enums.IntvevlStatusEnum;
import kd.tsc.tsrbs.common.enums.SignStatusEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class IntervEvalHelper {
    private static final Log logger = LogFactory.getLog(IntervEvalHelper.class);

    private IntervEvalHelper() {
    }

    public static DataSet dbIntvevl(String applicationid, String className) {
        QFilter qFilter = QFilter.of((String)"application = ? and enable = ?", (Object[])new Object[]{Long.valueOf(applicationid), "1"});
        HRBaseServiceHelper intvevlHelper = new HRBaseServiceHelper("tspr_intvevl");
        return intvevlHelper.queryDataSet(className, "id,intvgroup,round,interviewcontent,intvevlrslt,interviewstatus,interviewevaluationtime,argintv,resume,interviewer,interviewevaluator,handlestatus", qFilter.toArray());
    }

    public static DataSet dbIntvgroupentry(String className) {
        HRBaseServiceHelper intvgroupHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_intvgroup");
        return intvgroupHelper.queryDataSet(className, "id as groupId,roundid,intvdate,intvstarttime,interviewlocation,interviewroom,admindivision");
    }

    public static DataSet joinDataSet(String className, String applicationid) {
        DataSet intvevlDataSet = IntervEvalHelper.dbIntvevl(applicationid, className);
        DataSet intvgroupDataSet = IntervEvalHelper.dbIntvgroupentry(className);
        DataSet result = null;
        DataSet orderDataSet = null;
        try {
            JoinDataSet join = intvevlDataSet.join(intvgroupDataSet, JoinType.INNER);
            result = join.on("intvgroup", "groupId").select("id,intvgroup,round,interviewcontent,intvevlrslt,interviewstatus,interviewevaluationtime,argintv,resume,interviewer,interviewevaluator,handlestatus".split(","), "id as groupId,roundid,intvdate,intvstarttime,interviewlocation,interviewroom,admindivision".split(",")).finish();
            orderDataSet = result.orderBy(new String[]{"intvdate DESC", "intvstarttime DESC"});
        }
        catch (Exception e) {
            logger.error("\u65b9\u6cd5\u540d:{},\u5e94\u8058\u6863\u6848id:{},\u521b\u5efaDataSet\u5f02\u5e38", new Object[]{"IntervEvalHelper.joinDataSet", applicationid, e});
            throw new KDException((Throwable)e, IntvErrorCode.CREATE_DATASET_ERRORCODE, new Object[]{"IntervEvalHelper.joinDataSet", applicationid, e.getMessage()});
        }
        finally {
            try {
                Optional.ofNullable(result).ifPresent(rv -> rv.close());
            }
            catch (Exception e) {
                logger.error("IntervEvalHelper.joinDataSet\u91ca\u653e\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
            }
            try {
                Optional.ofNullable(intvevlDataSet).ifPresent(rv -> rv.close());
            }
            catch (Exception e) {
                logger.error("IntervEvalHelper.joinDataSet\u91ca\u653e\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
            }
            try {
                Optional.ofNullable(intvgroupDataSet).ifPresent(rv -> rv.close());
            }
            catch (Exception e) {
                logger.error("IntervEvalHelper.joinDataSet\u91ca\u653e\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
            }
        }
        return orderDataSet;
    }

    public static void getOtherFields(Row next, Map<String, Object> resultMap, String applicationid) {
        Long interviewerID = next.getLong("interviewer");
        IntervEvalHelper.dbPersonName(interviewerID, resultMap, "intver");
        Long interviewevaluatorId = next.getLong("interviewevaluator");
        IntervEvalHelper.dbPersonName(interviewevaluatorId, resultMap, "generpeople");
        Long argintvdId = next.getLong("argintv");
        IntervEvalHelper.dbArgintvd(argintvdId, resultMap);
        Long roundId = next.getLong("round");
        IntervEvalHelper.dbRound(roundId, resultMap);
        DynamicObject appFileTaskDt = IntervEvalHelper.queryAppFileTask(argintvdId, applicationid);
        resultMap.put("appfiletask", appFileTaskDt.getString("id"));
        resultMap.put("taskstatus", AppfileTaskStatusEnum.valuesOf((String)appFileTaskDt.getString("taskstatus")));
        resultMap.put("signinstatus", SignStatusEnum.valuesOf((String)appFileTaskDt.getString("signinstatus")));
        String applicationAnswer = appFileTaskDt.getString("applicationanswer");
        resultMap.put("applicationanswer", ResManager.loadKDString((String)"\u5019\u9009\u4eba", (String)"AppFileTask_1", (String)"tsc-tsrbs-business", (Object[])new Object[0]) + ApplicationAnswerEnum.valuesOf((String)applicationAnswer));
        resultMap.put("intvevlstatus", IntvevlStatusEnum.valuesOf((String)appFileTaskDt.getString("intvevlstatus")));
        HRBaseServiceHelper intvroundServiceHelper = new HRBaseServiceHelper("tspr_intvround");
        QFilter entryIdFilter = new QFilter("roundid", "=", (Object)roundId);
        DynamicObject intvRoundDt = (DynamicObject)intvroundServiceHelper.queryOriginalCollection("interviewevl", entryIdFilter.toArray()).get(0);
        resultMap.put("interviewevl", String.valueOf(intvRoundDt.getLong("interviewevl")));
        Long intevId = next.getLong("id");
        resultMap.put("intervpk", String.valueOf(intevId));
        DynamicObjectCollection refuseCouseDtCollection = IntvAppfileTaskHelper.getInstance().queryAppTaskInfo(appFileTaskDt.getLong("id")).getDynamicObjectCollection("recrursn");
        if (CollectionUtils.isEmpty((Collection)refuseCouseDtCollection)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject refuseCouseDt : refuseCouseDtCollection) {
            stringBuilder.append('\uff1a');
            stringBuilder.append(refuseCouseDt.getDynamicObject("fbasedataid").getString("name"));
            stringBuilder.append(',');
        }
        String refuseCouse = stringBuilder.toString();
        refuseCouse = refuseCouse.substring(0, refuseCouse.length() - 1);
        String refuseCouseSpecific = appFileTaskDt.getString("refusalcause");
        if (HRStringUtils.equals((String)applicationAnswer, (String)ApplicationAnswerEnum.NOT_ANTICIPATE.getCode())) {
            if (HRStringUtils.isEmpty((String)refuseCouseSpecific)) {
                resultMap.put("recrursn", refuseCouse);
            } else {
                resultMap.put("recrursn", refuseCouse.concat(",").concat(refuseCouseSpecific));
            }
        }
    }

    public static void getIntvevlMap(Row next, Map<String, Object> resultMap) {
        String interviewstatus = next.getString("interviewstatus");
        resultMap.put("invtevlsts", EvalStatusEnum.valuesOf((String)interviewstatus));
        String handlestatus = next.getString("handlestatus");
        resultMap.put("handlestatus", handlestatus);
        if (HRStringUtils.equals((String)handlestatus, (String)"A")) {
            resultMap.put("invtevlsts", EvalStatusEnum.N_EVAL.getValue());
        }
        String interviewcontent = next.getString("interviewcontent");
        resultMap.put("intvcontent", interviewcontent);
        String intvevlrslt = next.getString("intvevlrslt");
        resultMap.put("intvevlrslt", EvalResultEnum.valuesOf((String)intvevlrslt));
        Date interviewevaluationtime = next.getDate("interviewevaluationtime");
        Optional.ofNullable(interviewevaluationtime).ifPresent(td -> {
            String evalTime = IntvDateUtil.getDate2Str((String)"yyyy-MM-dd HH:mm:ss", (Date)interviewevaluationtime);
            resultMap.put("intvevltime", evalTime);
        });
        Date intvdate = next.getDate("intvdate");
        Long intvstarttime = next.getLong("intvstarttime");
        Optional.ofNullable(intvdate).ifPresent(dt -> {
            String date2Str = IntvDateUtil.getDate2Str((String)"yyyy-MM-dd", (Date)dt);
            Optional.ofNullable(intvstarttime).filter(time -> time >= 0L).ifPresent(aLong -> {
                String intvTime = LocalTime.ofSecondOfDay(aLong).format(DateTimeFormatter.ISO_TIME);
                resultMap.put("intvtime", date2Str + " " + intvTime);
            });
        });
    }

    public static void dbRound(Long roundId, Map<String, Object> resultMap) {
        HRBaseServiceHelper roundHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_intvround");
        DynamicObject round = null;
        try {
            round = roundHelper.queryOne((Object)roundId);
        }
        catch (Exception e) {
            logger.error("data not found", (Throwable)e);
            throw new KDException((Throwable)e, IntvErrorCode.NULL_DATA_ERRORCODE, new Object[]{"IntervEvalHelper.dbRound", "roundID:" + round, e.getMessage()});
        }
        Optional<DynamicObject> OptRound = Optional.ofNullable(round);
        OptRound.map(tv -> tv.getDynamicObject("interviewtheme")).map(cv -> cv.getString("name")).ifPresent(vv -> resultMap.put("intvttype", vv));
        OptRound.map(tv -> tv.getDynamicObject("interviewmethod")).map(cv -> cv.getString("name")).ifPresent(vv -> resultMap.put("intvway", vv));
    }

    public static void dbArgintvd(Long argintvdId, Map<String, Object> resultMap) {
        DynamicObject argintv;
        HRBaseServiceHelper argintvHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_argintv");
        try {
            argintv = argintvHelper.queryOne((Object)argintvdId);
        }
        catch (Exception e) {
            logger.error("data not found", (Throwable)e);
            throw new KDException((Throwable)e, IntvErrorCode.NULL_DATA_ERRORCODE, new Object[]{"IntervEvalHelper.dbRound", "argintvdId:" + argintvdId, e.getMessage()});
        }
        Optional.ofNullable(argintv).ifPresent(arg -> {
            String recruName = arg.getString("recruitmentstage.name");
            String interviewtitle = arg.getString("interviewtitle");
            resultMap.put("intvtit", interviewtitle);
            String interstatus = arg.getString("interviewstatus");
            resultMap.put("intvsts", IntervEvalHelper.getInterviewStatusText(interstatus));
            resultMap.put("recrname", recruName);
        });
    }

    private static String getInterviewStatusText(String interstatus) {
        String resStatusText = InterviewStatusEnum.valuesOf((String)interstatus);
        if (interstatus.equals("A")) {
            resStatusText = ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"InterStatus", (String)"tsc-tspr-business", (Object[])new Object[0]);
        }
        return resStatusText;
    }

    public static void dbPersonName(Long personID, Map<String, Object> resultMap, String flag) {
        String userName = IntervEvalHelper.getUserNameById(personID);
        Optional.ofNullable(userName).ifPresent(un -> resultMap.put(flag, userName));
    }

    public static String getUserNameById(Long userId) {
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds, (String[])new String[]{"name"}, null);
        return Optional.ofNullable(userInfoList).filter(ur -> !ur.isEmpty()).map(map -> (Map)map.get(0)).map(value -> (OrmLocaleValue)value.get("name")).map(OrmLocaleValue::getLocaleValue).orElse(null);
    }

    public static String getCurrentUserName() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        return IntervEvalHelper.getUserNameById(currentUserId);
    }

    public static String geti18nStr(String str) {
        String formatText = ResManager.loadKDString((String)"%s", (String)"IntvTemplatePlugin_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        return String.format(Locale.ROOT, formatText, str);
    }

    public static void dbGroup(Long groupId, Map<String, Object> resultMap) {
        DynamicObject intvgroup;
        HRBaseServiceHelper groupHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_intvgroup");
        try {
            intvgroup = groupHelper.queryOne((Object)groupId);
        }
        catch (Exception e) {
            logger.error("data not found", (Throwable)e);
            throw new KDException((Throwable)e, IntvErrorCode.NULL_DATA_ERRORCODE, new Object[]{"IntervEvalHelper.dbRound", "groupId:" + groupId, e.getMessage()});
        }
        Optional.ofNullable(intvgroup).ifPresent(itv -> {
            String interviewlocation = itv.getString("interviewlocation");
            String interviewroom = itv.getString("interviewroom");
            String admindivision = itv.getString("admindivision");
            String admindivisionName = IntervEvalHelper.getAdminDivisionName(admindivision);
            String vedioAddress = itv.getString("intvervedioaddress");
            resultMap.put("intvaddress", interviewlocation);
            resultMap.put("intvroom", interviewroom);
            resultMap.put("addressname", admindivisionName);
            resultMap.put("intvervedioaddress", vedioAddress);
        });
    }

    public static String getAdminDivisionName(String adminId) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"bd_admindivision");
        if (HRStringUtils.isEmpty((String)adminId)) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(adminId));
        DynamicObject dynamicObject = helper.queryOriginalOne("id,name,fullname,basedatafield.name,parent.name,parent.basedatafield.name,parent.parent.name,parent.parent.basedatafield.name", filter);
        StringBuilder builder = new StringBuilder();
        Optional.ofNullable(dynamicObject).ifPresent(dy -> {
            String oneName = dy.getString("parent.parent.name");
            String twoName = dy.getString("parent.name");
            String threeName = dy.getString("name");
            oneName = Optional.ofNullable(oneName).orElse("");
            twoName = Optional.ofNullable(twoName).orElse("");
            threeName = Optional.ofNullable(threeName).orElse("");
            builder.append(oneName);
            builder.append(twoName);
            builder.append(threeName);
        });
        return builder.toString();
    }

    public static String dbDAName(String applicationid) {
        DynamicObject dynamicObject = new ArgIntvHelper().getRecrustgByAppFileId(Long.parseLong(applicationid));
        String dAName = dynamicObject.getString("name");
        String formatText = ResManager.loadKDString((String)"%s\u73af\u8282", (String)"IntvTemplatePlugin_9", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        return String.format(Locale.ROOT, formatText, dAName);
    }

    public static Pair<Boolean, Boolean> selectIntvStateByPk(String pkId) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_intvevl");
        DynamicObject dynamicObject = helper.queryOne("handlestatus, interviewstatus", (Object)Long.parseLong(pkId));
        Boolean leftFlag = Optional.ofNullable(dynamicObject).map(dy -> dy.getString("handlestatus")).map(val -> val.equals("A")).orElse(Boolean.FALSE);
        Boolean rightFlag = Optional.ofNullable(dynamicObject).map(dy -> dy.getString("interviewstatus")).map(val -> val.equals("A")).orElse(Boolean.FALSE);
        return Pair.of((Object)leftFlag, (Object)rightFlag);
    }

    public static Map<String, Object> selectIntvByPk(String pkId, String intvIndex) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_intvevl");
        DynamicObject dynamicObject = helper.queryOne((Object)Long.parseLong(pkId));
        String evlCont = dynamicObject.getString("interviewcontent");
        String intvRslt = dynamicObject.getString("intvevlrslt");
        Date time = dynamicObject.getDate("interviewevaluationtime");
        String evalTime = IntvDateUtil.getDate2Str((String)"yyyy-MM-dd HH:mm:ss", (Date)time);
        String interviewstatus = dynamicObject.getString("interviewstatus");
        Long argId = dynamicObject.getDynamicObject("argintv").getLong("id");
        DynamicObject argDy = ArgIntvHelper.selectById(argId, "tspr_argintv");
        String intvsts = argDy.getString("interviewstatus");
        String formatInfo = IntervEvalHelper.geti18nStr(IntervEvalHelper.getCurrentUserName());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("intvcontent" + intvIndex, evlCont);
        resultMap.put("invtevlsts" + intvIndex, EvalStatusEnum.valuesOf((String)interviewstatus));
        resultMap.put("intvsts", InterviewStatusEnum.valuesOf((String)intvsts));
        resultMap.put("intvevltime" + intvIndex, evalTime);
        resultMap.put("intvevlrslt" + intvIndex, EvalResultEnum.valuesOf((String)intvRslt));
        resultMap.put("generpeople" + intvIndex, formatInfo);
        return resultMap;
    }

    public static void refreshPage(CardEntry cardEntry, IDataModel dataModel, int currentIndex, Map<String, Object> resultMap, String intvIndex) {
        cardEntry.setChildVisible(false, currentIndex, new String[]{"insteadbutton" + intvIndex, "uninsteadbutton" + intvIndex, "urgebutton" + intvIndex});
        cardEntry.setChildVisible(true, currentIndex, new String[]{"intvevlrslt" + intvIndex, "intvcontent" + intvIndex, "cardentryflexpanelap5" + intvIndex, "viewbtn" + intvIndex, "intvevltime" + intvIndex});
        Long appFileTaskId = Long.valueOf(dataModel.getValue("appfiletask").toString());
        DynamicObject appFileTaskDT = IntervEvalHelper.queryAppFileTask(appFileTaskId);
        String taskStatus = appFileTaskDT.getString("taskstatus");
        String intvevlstatus = appFileTaskDT.getString("intvevlstatus");
        if (HRStringUtils.equals((String)taskStatus, (String)AppfileTaskStatusEnum.ALREADY_COMPLETE.getCode())) {
            cardEntry.setChildVisible(false, currentIndex, new String[]{"taskstatus"});
            cardEntry.setChildVisible(false, currentIndex, new String[]{"combofield"});
            cardEntry.setChildVisible(true, currentIndex, new String[]{"intvevlstatus"});
            dataModel.setValue("intvevlstatus", (Object)IntvevlStatusEnum.valuesOf((String)intvevlstatus), currentIndex);
        } else {
            cardEntry.setChildVisible(true, currentIndex, new String[]{"taskstatus"});
            cardEntry.setChildVisible(false, currentIndex, new String[]{"intvevlstatus"});
        }
        resultMap.forEach((key, value) -> {
            dataModel.setValue(key, value, currentIndex);
            if (key.contains("invtevlsts") && EvalStatusEnum.GENEREVAL.getValue().equals(value)) {
                cardEntry.setChildVisible(true, currentIndex, new String[]{"generpeople" + intvIndex, "letlabel" + intvIndex, "insteval" + intvIndex, "intvcontent" + intvIndex, "intvevltime" + intvIndex});
                cardEntry.setChildVisible(false, currentIndex, new String[]{"invtevlsts" + intvIndex});
            } else if (key.contains("invtevlsts") && EvalStatusEnum.Y_EVAL.getValue().equals(value)) {
                cardEntry.setChildVisible(true, currentIndex, new String[]{"intvcontent" + intvIndex, "intvevltime" + intvIndex});
                cardEntry.setChildVisible(false, currentIndex, new String[]{"insteadbutton" + intvIndex, "uninsteadbutton" + intvIndex, "invtevlsts" + intvIndex});
            } else if (key.contains("intvevlrslt")) {
                IntervEvalHelper.setIntvevlrsltShow(cardEntry, currentIndex, String.valueOf(value), intvIndex);
            }
        });
    }

    public static void db(List<Map<String, Object>> mapList) {
    }

    private static DynamicObject queryAppFileTask(Long argintvdId, String applicationId) {
        HRBaseServiceHelper taskServiceHelper = new HRBaseServiceHelper("tspr_appfiletask");
        QFilter argintvdIdFilter = new QFilter("argintv", "=", (Object)argintvdId);
        QFilter applicationIdFilter = new QFilter("application", "=", (Object)Long.valueOf(applicationId));
        String selecPropertities = "id,taskstatus,signinstatus,applicationanswer,applicationanswerh,recrursn,intvevlstatus,refusalcause";
        return taskServiceHelper.query(selecPropertities, new QFilter[]{argintvdIdFilter, applicationIdFilter})[0];
    }

    public static DynamicObject queryAppFileTask(Long appFileTaskId) {
        HRBaseServiceHelper taskServiceHelper = new HRBaseServiceHelper("tspr_appfiletask");
        return taskServiceHelper.loadSingle((Object)appFileTaskId);
    }

    public static DynamicObject[] queryAppFileTask(List<Long> appFileTaskIds) {
        HRBaseServiceHelper taskServiceHelper = new HRBaseServiceHelper("tspr_appfiletask");
        QFilter appFileTaskIdFilter = new QFilter("id", "in", appFileTaskIds);
        return taskServiceHelper.query("argintv, application, taskstatus, intvevlstatus", new QFilter[]{appFileTaskIdFilter});
    }

    public static void setIntvevlrsltShow(CardEntry cardEntry, int rowIndex, String intvevlrslt, String intvIndex) {
        if (HRStringUtils.equals((String)intvevlrslt, (String)EvalResultEnum.N_EVAL.getValue())) {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"intvevlrslt" + intvIndex});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"pass" + intvIndex});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"wait" + intvIndex});
        } else if (HRStringUtils.equals((String)intvevlrslt, (String)EvalResultEnum.Y_EVAL.getValue())) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"intvevlrslt" + intvIndex});
            cardEntry.setChildVisible(true, rowIndex, new String[]{"pass" + intvIndex});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"wait" + intvIndex});
        } else if (HRStringUtils.equals((String)intvevlrslt, (String)EvalResultEnum.GENEREVAL.getValue())) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"intvevlrslt" + intvIndex});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"pass" + intvIndex});
            cardEntry.setChildVisible(true, rowIndex, new String[]{"wait" + intvIndex});
        }
    }
}

