/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvevlansHelper;
import kd.tsc.tspr.business.domain.intv.service.task.ArgIntvFreeFlowTask;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class IntvEvlHelper {
    private static QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
    private static QFilter handlerstatusFilter = new QFilter("handlestatus", "!=", (Object)"C");
    private static final Log log = LogFactory.getLog(IntvEvlHelper.class);
    private static HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tspr_intvevl");
    private static IntvEvlHelper intvEvlHelper = null;

    private IntvEvlHelper() {
    }

    public static IntvEvlHelper getInstance() {
        if (HRObjectUtils.isEmpty((Object)intvEvlHelper)) {
            return new IntvEvlHelper();
        }
        return intvEvlHelper;
    }

    public Map<Object, Integer> getAllIntvEvlStatus(DynamicObject dataEntity) {
        log.info("IntvEvlHelper.updateArgIntvData.start  ");
        Long argintvId = dataEntity.getDynamicObject("argintv").getLong("id");
        String fields = String.join((CharSequence)",", "interviewstatus", "intvevlrslt", "intvtask", "argintv", "appfiletask", "handlestatus");
        QFilter qFilter = new QFilter("argintv", "=", (Object)argintvId).and(enableFilter).and(handlerstatusFilter);
        DynamicObject[] queryDynamicObjects = this.queryIntvEvl(fields, qFilter, null);
        Map<Object, Integer> map = this.getObjectIntegerMap(queryDynamicObjects, dataEntity);
        map.put("count", queryDynamicObjects.length);
        log.info("IntvEvlHelper.updateArgIntvData.map : {}", (Object)JSON.toJSONString(map));
        log.info("IntvEvlHelper.updateArgIntvData.end  ");
        return map;
    }

    private Map<Object, Integer> getObjectIntegerMap(DynamicObject[] queryDynamicObjects, DynamicObject dataEntity) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)(3 * queryDynamicObjects.length + 1));
        for (DynamicObject dyObj : queryDynamicObjects) {
            String status = dyObj.getString("interviewstatus");
            String handleStatus = dyObj.getString("handlestatus");
            if (HRStringUtils.equals((String)status, (String)"A") || HRStringUtils.equals((String)handleStatus, (String)"A")) {
                this.putMap(map, dyObj.getLong("appfiletask.id"));
                this.putMap(map, dyObj.getLong("intvtask.id"));
                this.putMap(map, dyObj.getLong("argintv.id"));
            }
            String result = dyObj.getString("intvevlrslt");
            if (dataEntity.getLong("appfiletask.id") != dyObj.getLong("appfiletask.id")) continue;
            if (!HRStringUtils.equals((String)result, (String)" ")) {
                this.putMap(map, result);
                this.putMap(map, "effectivecount");
            }
            this.putMap(map, "resultcount");
        }
        return map;
    }

    private void putMap(Map<Object, Integer> map, Object object) {
        map.put(object, map.get(object) == null ? 1 : map.get(object) + 1);
    }

    public void updateAppfileTaskData(Map<Object, Integer> map, DynamicObject appfileTaskDynObj) {
        log.info("IntvEvlHelper.updateAppfileTaskData.start");
        long appfileTaskID = appfileTaskDynObj.getLong("id");
        DynamicObject[] queryAppfiletasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks("id,application,intvtime,taskstatus,intvevlstatus,intverstatus,modifytime,argintv", new QFilter("id", "=", (Object)appfileTaskID));
        DynamicObject queryAppfiletask = queryAppfiletasks[0];
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (map.get(appfileTaskID) == null) {
            queryAppfiletask.set("intverstatus", (Object)"B");
            queryAppfiletask.set("modifytime", (Object)now);
            this.updateAppfileTask(map, queryAppfiletask);
            log.info("IntvEvlHelper.updateAppfileTaskData  update all success");
        } else {
            queryAppfiletask.set("intverstatus", (Object)"C");
            queryAppfiletask.set("modifytime", (Object)now);
            log.info("IntvEvlHelper.updateArgIntvData  update part success");
        }
        DynamicObject[] appfileTasks = new DynamicObject[]{queryAppfiletask};
        IntvAppfileTaskHelper.getInstance().updateAppfileTaskAndAppfile(appfileTasks);
        log.info("IntvEvlHelper.updateAppfileTaskData.end");
    }

    private void updateAppfileTask(Map<Object, Integer> map, DynamicObject appfiletask) {
        Integer resultcount = map.get("resultcount");
        String intvevlstatus = resultcount.equals(map.get("A")) ? "A" : (resultcount.equals(map.get("B")) ? "B" : "C");
        appfiletask.set("intvevlstatus", (Object)intvevlstatus);
        appfiletask.set("taskstatus", (Object)"C");
    }

    public void updateIntvtaskData(Map<Object, Integer> map, DynamicObject intvTaskDynObj) {
        log.info("IntvEvlHelper.updateIntvtaskData.start");
        if (map.get(intvTaskDynObj.get("id")) != null) {
            return;
        }
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tspr_intvtask");
        QFilter qf = new QFilter("id", "=", intvTaskDynObj.get("id")).and(enableFilter);
        String fields = String.join((CharSequence)",", "taskstatus", "modifytime");
        DynamicObject query = hrServiceHelper.queryOne(fields, new QFilter[]{qf});
        query.set("taskstatus", (Object)"B");
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        query.set("modifytime", (Object)now);
        hrServiceHelper.updateOne(query);
        log.info("IntvEvlHelper.updateIntvtaskData  update all success");
        log.info("IntvEvlHelper.updateIntvtaskData.end");
    }

    public void updateArgIntvData(Map<Object, Integer> map, DynamicObject dynamicObject) {
        log.info("IntvEvlHelper.updateArgIntvData.start");
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tspr_argintv");
        long argID = dynamicObject.getLong("id");
        QFilter qf = new QFilter("id", "=", (Object)argID);
        String fields = String.join((CharSequence)",", "interviewstatus", "intvevlsts", "modifytime");
        DynamicObject query = hrServiceHelper.queryOne(fields, new QFilter[]{qf});
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (map.get(argID) == null) {
            query.set("interviewstatus", (Object)"B");
            query.set("intvevlsts", (Object)"B");
            query.set("modifytime", (Object)now);
            log.info("IntvEvlHelper.updateArgIntvData  update all success");
        } else {
            query.set("intvevlsts", (Object)"C");
            query.set("modifytime", (Object)now);
            log.info("IntvEvlHelper.updateArgIntvData  update part success");
        }
        hrServiceHelper.updateOne(query);
        log.info("IntvEvlHelper.updateArgIntvData.end");
    }

    public Long sendMessage(DynamicObject dynamicObject, DynamicObject argintvDynObj) {
        log.info("IntvEvlHelper.sendMessage.start");
        DynamicObject interviewerid = dynamicObject.getDynamicObject("interviewer");
        Long receiverId = interviewerid.getLong("id");
        if (UserServiceHelper.getCurrentUserId() == receiverId) {
            return null;
        }
        String title = argintvDynObj.getString("interviewtitle");
        MessageInfo message = new MessageInfo();
        message.setType("notice");
        message.setTitle(ResManager.loadKDString((String)"\u9762\u8bd5\u8bc4\u4ef7\u72b6\u6001\u66f4\u65b0", (String)"IntvEvlHelper_1", (String)"tsc-tspr-business", (Object[])new Object[0]));
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(receiverId);
        message.setUserIds(receivers);
        message.setSenderName(RequestContext.get().getUserName());
        message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
        message.setTag(ResManager.loadKDString((String)"\u9762\u8bd5\u8bc4\u4ef7", (String)"IntvEvlHelper_2", (String)"tsc-tspr-business", (Object[])new Object[0]));
        message.setContent(title + ResManager.loadKDString((String)"\u5df2\u7531", (String)"IntvEvlHelper_3", (String)"tsc-tspr-business", (Object[])new Object[0]) + RequestContext.get().getUserName() + ResManager.loadKDString((String)"\u4ee3\u8bc4\u4ef7\u5b8c\u6210\u3002", (String)"IntvEvlHelper_4", (String)"tsc-tspr-business", (Object[])new Object[0]));
        long result = MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        log.info("IntvEvlHelper.sendMessage.end");
        return result;
    }

    public void updateIntvTodoTask(String taskId, DynamicObject dataEntity) {
        log.info("IntvEvlHelper.updateIntvTodoTask.start");
        Long interviewId = dataEntity.getDynamicObject("interviewer").getLong("id");
        String evlCont = dataEntity.getString("interviewcontent");
        String status = dataEntity.getString("interviewstatus");
        ArgIntvFreeFlowTask.completeTask(taskId, interviewId, evlCont, status);
        log.info("IntvEvlHelper.updateIntvTodoTask.end");
    }

    public DynamicObject[] findIntvEvaluationByRoundId(Object id) {
        QFilter filters = new QFilter("interviewevaluator", "=", id).and(enableFilter);
        String fields = String.join((CharSequence)",", "id", "number", "createtime", "interviewstatus", "interviewevaluator", "interviewer", "interviewevaluationtime", "interviewcontent", "intvevlrslt");
        return this.queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
    }

    public List<DynamicObject> selectIntvEvaluationByGroupIdAndApplicationId(Long groupId, Long applicationId) {
        QFilter filters = new QFilter("intvgroup", "=", (Object)groupId).and("application", "=", (Object)applicationId).and(enableFilter);
        String fields = String.join((CharSequence)",", "id", "number", "application.id", "createtime", "interviewstatus", "interviewevaluator", "interviewer", "interviewevaluationtime", "interviewcontent", "intvevlrslt", "round", "handlestatus", "appfiletask", "intvgroup");
        Object[] dynamicObjects = this.queryIntvEvl(fields, filters, null);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dynamicObjects.length);
        if (Collections.addAll(list, dynamicObjects)) {
            return list;
        }
        return Collections.emptyList();
    }

    public DynamicObject[] queryIntvEvl(String queryfields, QFilter filters, String orderBys) {
        filters = filters == null ? enableFilter : filters.and(enableFilter);
        queryfields = queryfields == null ? "id" : queryfields;
        return hrBaseServiceHelper.query(queryfields, filters.toArray(), orderBys);
    }

    public Object[] updateIntvevls(DynamicObject[] dynamicObjects) {
        return hrBaseServiceHelper.update(dynamicObjects);
    }

    public Object[] saveIntvevls(DynamicObject[] dynamicObjects) {
        return hrBaseServiceHelper.save(dynamicObjects);
    }

    public DynamicObject[] getIntvEvls(QFilter qFilter) {
        return hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, qFilter});
    }

    public DynamicObject generateEmptyDynamicObject() {
        return hrBaseServiceHelper.generateEmptyDynamicObject();
    }

    public DynamicObjectCollection queryOriginalCollection(Long taskId, List<String> queryColumnList) {
        QFilter qFilter = new QFilter("intvtask", "=", (Object)taskId).and(enableFilter);
        String queryColumnStr = StringEscapeUtils.unescapeJava((String)StringUtils.join(queryColumnList, (String)","));
        return hrBaseServiceHelper.queryOriginalCollection(queryColumnStr, qFilter.toArray());
    }

    public static DynamicObject[] selectAllColumn(String queryColumn) {
        return IntvEvlHelper.selectAllColumnList(Collections.singletonList(queryColumn));
    }

    public static DynamicObject[] selectAllColumnList(List<String> queryColumnList) {
        String queryColumnStr = StringEscapeUtils.unescapeJava((String)StringUtils.join(queryColumnList, (String)","));
        return hrBaseServiceHelper.query(queryColumnStr, enableFilter.toArray());
    }

    public DynamicObject findById(Object id) {
        return hrBaseServiceHelper.loadSingle(id);
    }

    public void saveIntvevlans(DynamicObject dynamicObject, String status, String customlabeldata) {
        log.info("IntvEvlHelper.saveIntvevlans.start");
        HRBaseServiceHelper intvServiceHelper = IntvevlansHelper.getInstance().getIntvevlansServiceHelper();
        log.info("IntvEvlHelper.saveIntvevlans.customlabeldata :{}", (Object)customlabeldata);
        Gson gson = new Gson();
        Map evlResData = (Map)gson.fromJson(customlabeldata, Map.class);
        String evalResult = gson.toJson(evlResData.get("evalResult"));
        List evlResList = (List)gson.fromJson(evalResult, List.class);
        DynamicObject[] dynamicObjects = IntvevlansHelper.getInstance().bacthSaveIntvevlans(dynamicObject, status, evlResList);
        intvServiceHelper.save(dynamicObjects);
        log.info("IntvEvlHelper.saveIntvevlans.end");
    }

    public DynamicObject[] bacthSaveIntvevlans(DynamicObject dynamicObject, String status, HRBaseServiceHelper intvServiceHelper, List<LinkedTreeMap<String, String>> evlResList) {
        long[] longIDs = ID.genLongIds((int)evlResList.size());
        DynamicObject[] dynamicObjects = new DynamicObject[evlResList.size()];
        for (int i = 0; i < evlResList.size(); ++i) {
            DynamicObject intvRslt = intvServiceHelper.generateEmptyDynamicObject();
            intvRslt.set("id", (Object)longIDs[i]);
            this.setValue(intvRslt, dynamicObject, evlResList.get(i));
            intvRslt.set("status", (Object)status);
            dynamicObjects[i] = intvRslt;
        }
        return dynamicObjects;
    }

    public DynamicObject[] bacthUpdateIntvevlans(DynamicObject[] queryIntvevlans, DynamicObject dynamicObject, String status, List<LinkedTreeMap<String, String>> evlResList) {
        for (int i = 0; i < queryIntvevlans.length; ++i) {
            this.setValue(queryIntvevlans[i], dynamicObject, evlResList.get(i));
            queryIntvevlans[i].set("status", (Object)status);
        }
        return queryIntvevlans;
    }

    public void setValue(DynamicObject intvevlansdynamicObject, DynamicObject intvevldynamicObject, LinkedTreeMap<String, String> linkedTreeMap) {
        intvevlansdynamicObject.set("subanswer", linkedTreeMap.get((Object)"subAnswer"));
        intvevlansdynamicObject.set("comment", linkedTreeMap.get((Object)"comment"));
        intvevlansdynamicObject.set("intvevlqunr", (Object)intvevldynamicObject.getLong("intvevlqunrID"));
        intvevlansdynamicObject.set("intvevl", (Object)intvevldynamicObject.getLong("id"));
        intvevlansdynamicObject.set("inspectdim", (Object)Long.valueOf((String)linkedTreeMap.get((Object)"inspectDimid")));
        intvevlansdynamicObject.set("inspectqu", (Object)Long.valueOf((String)linkedTreeMap.get((Object)"inspectQuid")));
        intvevlansdynamicObject.set("suboption", linkedTreeMap.get((Object)"suboptionId"));
    }

    public void setObjValue(DynamicObject intvObj, String status) {
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        intvObj.set("interviewevaluationtime", (Object)now);
        intvObj.set("handlestatus", (Object)status);
        DynamicObject dynamicObject = intvObj.getDynamicObject("interviewer");
        long interviewerId = dynamicObject.getLong("id");
        long userId = UserServiceHelper.getCurrentUserId();
        if (interviewerId == userId) {
            intvObj.set("interviewevaluator", (Object)interviewerId);
            intvObj.set("interviewstatus", (Object)"B");
        } else {
            intvObj.set("interviewevaluator", (Object)userId);
            intvObj.set("interviewstatus", (Object)"C");
        }
    }

    public String checkIntvEvlStatus(DynamicObject intvObj) {
        DynamicObject byId = IntvEvlHelper.getInstance().findById(intvObj.getLong("id"));
        String message = this.checkIntvEvlStatusAndEnable(byId);
        if (message != null) {
            return message;
        }
        long aLong = byId.getDynamicObject("argintv").getLong("id");
        DynamicObject dynamicObject = ArgIntvHelper.selectById(aLong, "tspr_argintv");
        if (dynamicObject == null) {
            return ResManager.loadKDString((String)"\u9762\u8bd5\u5b89\u6392\u4e0d\u5b58\u5728\u3002", (String)"IntvEvlBaseEdit_6", (String)"tsc-tspr-business", (Object[])new Object[0]);
        }
        return this.getErrorString(dynamicObject.getString("interviewstatus"));
    }

    public String getErrorString(String param) {
        if (HRStringUtils.equals((String)param, (String)"C")) {
            return ResManager.loadKDString((String)"\u9762\u8bd5\u4fe1\u606f\u201c\u5df2\u88ab\u53d6\u6d88\u201d\u3002", (String)"IntvEvlBaseEdit_7", (String)"tsc-tspr-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)param, (String)"B")) {
            return ResManager.loadKDString((String)"\u9762\u8bd5\u4fe1\u606f\u201c\u5df2\u88ab\u8bc4\u4ef7\u201d\u3002", (String)"IntvEvlBaseEdit_5", (String)"tsc-tspr-business", (Object[])new Object[0]);
        }
        return null;
    }

    public String checkIntvEvlStatusAndEnable(DynamicObject intvObj) {
        String enable = intvObj.getString("enable");
        String handlestatus = intvObj.getString("handlestatus");
        if (!HRStringUtils.equals((String)enable, (String)"1")) {
            return ResManager.loadKDString((String)"\u9762\u8bd5\u4fe1\u606f\u201c\u5df2\u88ab\u4fee\u6539\u201d\uff0c\u91cd\u65b0\u5237\u65b0\u9875\u9762\u518d\u8bc4\u4ef7\u3002", (String)"IntvEvlBaseEdit_4", (String)"tsc-tspr-business", (Object[])new Object[0]);
        }
        return this.getErrorString(handlestatus);
    }
}

