/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tsc.tspr.common.entity.intv.response.IntvInfoDTO;
import kd.tsc.tspr.common.util.IntvDateUtil;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import org.apache.commons.collections4.CollectionUtils;

public class QueryHelper {
    public static Map<Long, List<IntvInfoDTO>> selectIntvInfoByAppFileIdList(List<Long> appFileIdList) {
        if (CollectionUtils.isEmpty(appFileIdList)) {
            return null;
        }
        QFilter intvEvlFilter = new QFilter("application", "in", appFileIdList).and("enable", "=", (Object)"1");
        List intvEvlList = BaseHelper.selectByFilter((QFilter[])intvEvlFilter.toArray(), (String)"tspr_intvevl");
        if (CollectionUtils.isEmpty((Collection)intvEvlList)) {
            return null;
        }
        List intverIdList = intvEvlList.stream().map(intvEvl -> intvEvl.getLong("interviewer.id")).distinct().collect(Collectors.toList());
        QFilter intverFilter = new QFilter("user", "in", intverIdList);
        List intverFileList = BaseHelper.selectByFilter((QFilter[])intverFilter.toArray(), (String)"tsrbd_intverfile");
        if (CollectionUtils.isEmpty((Collection)intverFileList)) {
            return null;
        }
        Map<Long, List<DynamicObject>> intverFileMap = intverFileList.stream().collect(Collectors.groupingBy(intverFile -> intverFile.getLong("user.id")));
        Map<Long, List<DynamicObject>> intvEvlMap = intvEvlList.stream().collect(Collectors.groupingBy(intvEvl -> intvEvl.getLong("application.id")));
        HashMap<Long, List<IntvInfoDTO>> map = new HashMap<Long, List<IntvInfoDTO>>();
        intvEvlMap.forEach((appId, intvEvlGroupList) -> {
            List intvInfoDTOList = intvEvlGroupList.stream().map(intvEvl -> {
                List intverFileMapList = (List)intverFileMap.get(intvEvl.getLong("interviewer.id"));
                return QueryHelper.setIntvInfoDTOHandle(intvEvl, (DynamicObject)intverFileMapList.get(0));
            }).collect(Collectors.toList());
            map.put((Long)appId, intvInfoDTOList);
        });
        return map;
    }

    private static IntvInfoDTO setIntvInfoDTOHandle(DynamicObject intvEvl, DynamicObject intvFile) {
        IntvInfoDTO dto = new IntvInfoDTO();
        Optional.ofNullable(intvFile.getDynamicObject("user")).ifPresent(user -> {
            dto.setIntverHeadPicture(user.getString("picturefield"));
            dto.setIntverName(user.getString("name"));
        });
        DynamicObjectCollection intverFileEntryList = intvFile.getDynamicObjectCollection("tsrbd_intverfileentry");
        if (CollectionUtils.isNotEmpty((Collection)intverFileEntryList)) {
            List intverTypeNameList = intverFileEntryList.stream().map(intverFileEntry -> intverFileEntry.getString("intvertypename")).distinct().collect(Collectors.toList());
            dto.setIntverTypeNameList(intverTypeNameList);
        }
        Optional.ofNullable(intvEvl.getDynamicObject("round")).ifPresent(intvRound -> dto.setIntvTheme(intvRound.getString("interviewtheme.name")));
        Optional.ofNullable(intvEvl.getDynamicObject("intvgroup")).ifPresent(intvGroup -> {
            Date intvDate = intvGroup.getDate("intvdate");
            Long intvStartTime = intvGroup.getLong("intvstarttime");
            Date intvDateTime = IntvDateUtil.getIntvDateTime((Date)intvDate, (Long)intvStartTime);
            dto.setIntverTime(intvDateTime);
        });
        if (!"A".equals(intvEvl.getString("handlestatus")) && !"A".equals(intvEvl.getString("interviewstatus"))) {
            dto.setIntvContent(intvEvl.getString("interviewcontent"));
        }
        return dto;
    }
}

