/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.calendar;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.common.entity.intv.ableintvtime.TimePeriod;
import kd.tsc.tspr.common.util.IntvDateUtil;

public class GetAbleInterviewTimeHelper {
    public static final Log log = LogFactory.getLog(GetAbleInterviewTimeHelper.class);
    public static final String DEFAULT_DATE_PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PICTUREFIELD = "picturefield";

    public static List<TimePeriod> getIntvTaskTimes(String interviewerId, DynamicObject[] intvTask) {
        ArrayList<TimePeriod> unableIntvTimes = new ArrayList<TimePeriod>();
        for (int i = 0; i < intvTask.length; ++i) {
            DynamicObject taskInterviewer = intvTask[i].getDynamicObject("interviewer");
            String taskInterviewerId = taskInterviewer.getString("id");
            if (!taskInterviewerId.equals(interviewerId)) continue;
            DynamicObject group = intvTask[i].getDynamicObject("intvgroup");
            unableIntvTimes.add(GetAbleInterviewTimeHelper.getGroupTimePeriod(group));
        }
        return unableIntvTimes;
    }

    public static TimePeriod getGroupTimePeriod(DynamicObject group) {
        TimePeriod timePeriod = new TimePeriod();
        if (group != null) {
            String startTime = IntvDateUtil.getIntvDate((Date)group.getDate("intvdate")) + " " + IntvDateUtil.formatTime((Long)group.getLong("intvstarttime"), (String)"HH:mm") + ":00";
            String endTime = IntvDateUtil.getIntvDate((Date)group.getDate("intvdate")) + " " + IntvDateUtil.formatTime((Long)group.getLong("intvendtime"), (String)"HH:mm") + ":00";
            timePeriod.setStartTime(IntvDateUtil.parseDateStr((String)startTime, (String)DEFAULT_DATE_PATTERN_TIME));
            timePeriod.setEndTime(IntvDateUtil.parseDateStr((String)endTime, (String)DEFAULT_DATE_PATTERN_TIME));
            timePeriod.setTimeType(0);
        }
        return timePeriod;
    }
}

