/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.interveranswer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntervEvalHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.interveranswer.GroupEntity;
import kd.tsc.tspr.business.domain.intv.service.interveranswer.HandOverWorkflowAndMailEntity;
import kd.tsc.tspr.business.domain.intv.service.interveranswer.InteRverAnswerStateEntity;
import kd.tsc.tspr.business.domain.intv.service.intvcheck.IntvCheckResultEntity;
import kd.tsc.tspr.common.util.IntvDateUtil;
import kd.tsc.tsrbd.business.domain.intvfile.IntvFileHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class InteRverAnswerHelper {
    private static final HRBaseServiceHelper HRBASE_SERVICEHELPER = new HRBaseServiceHelper("tspr_intvtask");
    private static final Log logger = LogFactory.getLog(InteRverAnswerHelper.class);

    public static boolean checkRverAnswerAgreeState(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        boolean checkRes = false;
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if ((inteRverAnswerState.getInteRverAnswerState().equals("A") || inteRverAnswerState.getInteRverAnswerState().equals("C")) && inteRverAnswerState.getTaskState().equals("A")) {
            checkRes = true;
        }
        return checkRes;
    }

    public static boolean checkAnswerState(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        boolean checkRes = false;
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if (inteRverAnswerState.getTaskState().equals("A")) {
            checkRes = true;
        }
        return checkRes;
    }

    public static boolean rverAnswerRefuse(List<GroupEntity> groupObj) {
        DynamicObject[] intvTasks = InteRverAnswerHelper.getIntvTasks(groupObj);
        for (int i = 0; i < intvTasks.length; ++i) {
            intvTasks[i].set("interveranswer", (Object)"C");
        }
        HRBASE_SERVICEHELPER.update(intvTasks);
        boolean refuseRes = true;
        return refuseRes;
    }

    public static boolean checkRverAnswerRefuseState(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        boolean checkRes = false;
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if ((inteRverAnswerState.getInteRverAnswerState().equals("A") || inteRverAnswerState.getInteRverAnswerState().equals("B")) && inteRverAnswerState.getTaskState().equals("A")) {
            checkRes = true;
        }
        return checkRes;
    }

    public static IntvCheckResultEntity checkRverAnswerTransferState(GroupEntity groupObj, Long transferId) {
        IntvCheckResultEntity checkRes = new IntvCheckResultEntity();
        checkRes.setCheckResult(true);
        DynamicObject[] intvevlInfos = InteRverAnswerHelper.getIntvevlInfos(groupObj);
        InteRverAnswerStateEntity inteRverAnswerState = InteRverAnswerHelper.getGroupStates(groupObj, intvevlInfos);
        if (inteRverAnswerState.getInteRverAnswerState().equals("D") || !inteRverAnswerState.getTaskState().equals("A") || inteRverAnswerState.isIntvevl()) {
            checkRes.setCheckResult(false);
            checkRes.setCheckMessage("\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8f6c\u4ea4");
            return checkRes;
        }
        boolean checkRverAnswerTransfer = InteRverAnswerHelper.checkRverAnswerTransfer(transferId, groupObj);
        if (checkRverAnswerTransfer) {
            checkRes.setCheckResult(false);
            checkRes.setCheckMessage("\u8f6c\u4ea4\u7684\u9762\u8bd5\u5b98\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8f6c\u4ea4\uff01");
            return checkRes;
        }
        return checkRes;
    }

    public static boolean checkRverAnswerTransfer(Long transfer, GroupEntity groupObj) {
        boolean checkRes = false;
        for (int i = 0; i < groupObj.getInterViewerIds().size(); ++i) {
            if (!transfer.equals(groupObj.getInterViewerIds().get(i))) continue;
            checkRes = true;
        }
        return checkRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rverAnswerTransfer(List<GroupEntity> transferGroups, DynamicObjectCollection intvTasks, DynamicObject transferId) {
        boolean transferRes = true;
        if (transferGroups.size() == 0 && intvTasks.size() == 0) {
            return false;
        }
        HandOverWorkflowAndMailEntity workflowAndMailParam = new HandOverWorkflowAndMailEntity();
        long transfer = transferId.getLong("id");
        DynamicObject intverFile = IntvFileHelper.getInstance().getIntverFileByUserId(Long.valueOf(transfer));
        TXHandle htx = null;
        try {
            htx = TX.required((String)"fi_voucher_submit");
            InteRverAnswerHelper.updateOldIntvInfo(transferGroups, transfer);
            InteRverAnswerHelper.updateGropuIntver(transferGroups, transfer, intverFile.getLong("id"));
            workflowAndMailParam = ArgIntvHelper.INSTANCE.handOverTo(intvTasks, transferId, intverFile);
        }
        catch (Throwable e) {
            transferRes = false;
            if (htx != null) {
                htx.markRollback();
            }
            logger.error("TXHandle has throwable", e);
        }
        finally {
            if (htx != null) {
                htx.close();
            }
            logger.info("resource be closed");
        }
        ArgIntvHelper.INSTANCE.handOverWorkflowAndMail(workflowAndMailParam);
        return transferRes;
    }

    public static void updateOldIntvInfo(List<GroupEntity> transferGroups, Long transferId) {
        DynamicObject[] intvTasks = InteRverAnswerHelper.getIntvTasks(transferGroups);
        for (int i = 0; i < intvTasks.length; ++i) {
            intvTasks[i].set("passedperson", (Object)transferId);
            intvTasks[i].set("taskstatus", (Object)"D");
            intvTasks[i].set("interveranswer", (Object)"D");
            intvTasks[i].set("enable", (Object)"0");
        }
        HRBASE_SERVICEHELPER.update(intvTasks);
        DynamicObject[] intvevlInfos = InteRverAnswerHelper.getIntvevlInfosByGroups(transferGroups);
        for (int i = 0; i < intvevlInfos.length; ++i) {
            intvevlInfos[i].set("handlestatus", (Object)"D");
            intvevlInfos[i].set("enable", (Object)"0");
        }
        HRBASE_SERVICEHELPER.update(intvevlInfos);
    }

    public static void updateGropuIntver(List<GroupEntity> transferGroups, Long transferId, Long intverFileId) {
        HRBaseServiceHelper helperGroup = new HRBaseServiceHelper("tspr_intvgroup");
        Long userId = TSCRequestContext.getUserId();
        ArrayList<Long> groupIds = new ArrayList<Long>(transferGroups.size());
        for (int i = 0; i < transferGroups.size(); ++i) {
            groupIds.add(transferGroups.get(i).getGroupId());
        }
        QFilter qFilter = new QFilter("id", "in", groupIds);
        DynamicObject[] groups = helperGroup.query("detailid,intver,intverfile", new QFilter[]{qFilter});
        for (int i = 0; i < groups.length; ++i) {
            DynamicObject curGroup = groups[i];
            DynamicObjectCollection interViewers = curGroup.getDynamicObjectCollection("intver");
            DynamicObjectCollection intverFiles = curGroup.getDynamicObjectCollection("intverfile");
            for (int n = 0; n < interViewers.size(); ++n) {
                Long intver = ((DynamicObject)interViewers.get(n)).getDynamicObject("fbasedataid").getLong("id");
                if (!intver.equals(userId)) continue;
                DynamicObject intverObj = (DynamicObject)interViewers.get(n);
                intverObj.set("fbasedataid", (Object)transferId);
                ((DynamicObject)intverFiles.get(i)).set("fbasedataid", (Object)intverFileId);
            }
        }
        helperGroup.update(groups);
    }

    public static boolean rverAnswerAgree(List<GroupEntity> groupObjs) {
        DynamicObject[] intvTasks = InteRverAnswerHelper.getIntvTasks(groupObjs);
        for (int i = 0; i < intvTasks.length; ++i) {
            intvTasks[i].set("interveranswer", (Object)"B");
        }
        HRBASE_SERVICEHELPER.update(intvTasks);
        boolean agreeRes = true;
        return agreeRes;
    }

    public static InteRverAnswerStateEntity getGroupStates(GroupEntity groupObj, DynamicObject[] intvevlInfos) {
        InteRverAnswerStateEntity groupstates = new InteRverAnswerStateEntity();
        DynamicObject intvTask = InteRverAnswerHelper.getIntvTask(groupObj);
        if (intvTask != null) {
            groupstates.setInteRverAnswerState(intvTask.getString("interveranswer"));
            groupstates.setTaskState(intvTask.getString("taskstatus"));
            groupstates.setIntvevl(InteRverAnswerHelper.getIsIntvevlOrNot(intvevlInfos));
        }
        return groupstates;
    }

    public static DynamicObject getIntvTask(GroupEntity groupObj) {
        DynamicObject intvTask = null;
        QFilter qFilterTask = new QFilter("id", "=", (Object)groupObj.getIntvTaskId());
        intvTask = IntvTaskHelper.getInstance().getIntvTaskObj(qFilterTask);
        return intvTask;
    }

    public static DynamicObject[] getIntvTasks(List<GroupEntity> groupObjs) {
        DynamicObject[] intvTasks = null;
        ArrayList<Long> groupIds = new ArrayList<Long>(groupObjs.size());
        for (int i = 0; i < groupObjs.size(); ++i) {
            groupIds.add(groupObjs.get(i).getGroupId());
        }
        long userId = TSCRequestContext.getUserId();
        QFilter qFilterTask = new QFilter("intvgroup", "in", groupIds).and("interviewer", "=", (Object)userId).and("taskstatus", "!=", (Object)"E");
        intvTasks = IntvTaskHelper.getInstance().getIntvTaskObjs(qFilterTask);
        return intvTasks;
    }

    public static boolean getIntvTaskStates(List<Long> taskIds) {
        boolean taskStateRes = true;
        if (taskIds.size() == 0) {
            return taskStateRes;
        }
        QFilter qFilterTask = new QFilter("id", "in", taskIds);
        DynamicObject[] intvTasks = IntvTaskHelper.getInstance().getIntvTaskObjs(qFilterTask);
        int taskCount = 0;
        for (int i = 0; i < intvTasks.length; ++i) {
            if (!intvTasks[i].getString("taskstatus").equals("C")) continue;
            ++taskCount;
        }
        if (taskCount == intvTasks.length) {
            taskStateRes = false;
        }
        return taskStateRes;
    }

    public static List<GroupEntity> getIntvTaskByGroup(Long argIntvId, DynamicObject groupDO, DynamicObject roundDO) {
        long userId = TSCRequestContext.getUserId();
        Long groupId = groupDO.getLong("id");
        QFilter qFilterTask = new QFilter("intvgroup", "=", (Object)groupId).and("interviewer", "=", (Object)userId).and("taskstatus", "!=", (Object)"E");
        DynamicObject[] intvTasks = IntvTaskHelper.getInstance().getIntvTasksNoEnableFilter(qFilterTask);
        ArrayList<GroupEntity> groupObjList = new ArrayList<GroupEntity>(intvTasks.length);
        for (int i = 0; i < intvTasks.length; ++i) {
            DynamicObject intvTask = intvTasks[i];
            GroupEntity groupObj = InteRverAnswerHelper.setGroupEntity(argIntvId, groupDO, roundDO, intvTask);
            groupObjList.add(groupObj);
        }
        return groupObjList;
    }

    public static boolean getIsIntvevlOrNot(DynamicObject[] intvevlInfos) {
        boolean isIntvevlOrNot = false;
        if (intvevlInfos != null) {
            for (int i = 0; i < intvevlInfos.length; ++i) {
                String interviewstatus = intvevlInfos[i].getString("interviewstatus");
                if (!interviewstatus.equals("B") && !interviewstatus.equals("C")) continue;
                isIntvevlOrNot = true;
            }
        }
        return isIntvevlOrNot;
    }

    public static DynamicObject[] getIntvevlInfos(GroupEntity groupObj) {
        DynamicObject[] intvevlInfo = null;
        long userId = TSCRequestContext.getUserId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("intvgroup", "=", (Object)groupObj.getGroupId()).and("interviewer", "=", (Object)userId).and(enableFilter);
        String fields = String.join((CharSequence)",", "application", "interviewstatus", "handlestatus", "interviewer");
        intvevlInfo = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        return intvevlInfo;
    }

    public static DynamicObject[] getIntvevlInfosByGroupId(DynamicObject[] intvelDOs, Long groupId) {
        ArrayList<DynamicObject> intvevlInfo = new ArrayList<DynamicObject>(intvelDOs.length);
        for (int i = 0; i < intvelDOs.length; ++i) {
            Long intvelDOGroupId = intvelDOs[i].getDynamicObject("intvgroup").getLong("id");
            if (!groupId.equals(intvelDOGroupId)) continue;
            intvevlInfo.add(intvelDOs[i]);
        }
        return intvevlInfo.toArray(new DynamicObject[intvevlInfo.size()]);
    }

    public static DynamicObject[] getAllIntvevlInfos(Long intvId) {
        DynamicObject[] intvevlInfo = null;
        long userId = TSCRequestContext.getUserId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("argintv", "=", (Object)intvId).and("interviewer", "=", (Object)userId).and(enableFilter);
        String fields = String.join((CharSequence)",", "application", "intvgroup", "interviewstatus", "handlestatus", "interviewer");
        intvevlInfo = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        return intvevlInfo;
    }

    public static DynamicObject[] getIntvevlInfosByGroups(List<GroupEntity> groupObjs) {
        DynamicObject[] intvevlInfo = null;
        ArrayList<Long> groupIds = new ArrayList<Long>(groupObjs.size());
        for (int i = 0; i < groupObjs.size(); ++i) {
            groupIds.add(groupObjs.get(i).getGroupId());
        }
        long userId = TSCRequestContext.getUserId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("intvgroup", "in", groupIds).and("interviewer", "=", (Object)userId).and(enableFilter);
        String fields = String.join((CharSequence)",", "application", "interviewstatus", "handlestatus", "enable", "interviewer");
        intvevlInfo = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        return intvevlInfo;
    }

    public static List<GroupEntity> getIntvGroupsByIntvId(Long argIntvId, Long intverId) {
        ArrayList<GroupEntity> groups = new ArrayList<GroupEntity>();
        DynamicObjectCollection intvGroups = null;
        DynamicObject interview = ArgIntvHelper.selectById(argIntvId, "tspr_argintv");
        DynamicObjectCollection intvRounds = interview.getDynamicObjectCollection("tspr_intvroundentry");
        if (intvRounds == null || intvRounds.isEmpty()) {
            logger.error("rounds business object is null,argIntvId:{}", (Object)argIntvId);
            return groups;
        }
        for (int n = 0; n < intvRounds.size(); ++n) {
            DynamicObject roundDO = (DynamicObject)intvRounds.get(n);
            intvGroups = roundDO.getDynamicObjectCollection("tspr_intvgroupentry");
            if (intvGroups == null || intvGroups.isEmpty()) {
                logger.error("group business object is null, roundInfo:{}", (Object)roundDO.toString());
                return groups;
            }
            for (int i = 0; i < intvGroups.size(); ++i) {
                DynamicObject groupDO = (DynamicObject)intvGroups.get(i);
                List<GroupEntity> groupObj = InteRverAnswerHelper.getIntvTaskByGroup(argIntvId, groupDO, roundDO);
                groups.addAll(groupObj);
            }
        }
        return groups;
    }

    public static GroupEntity setGroupEntity(Long argIntvId, DynamicObject groupDO, DynamicObject intvRoundDO, DynamicObject intvTaskDO) {
        GroupEntity groupObj = new GroupEntity();
        groupObj.setArgintvId(argIntvId);
        groupObj.setGroupId(groupDO.getLong("id"));
        groupObj.setIntvTaskId(intvTaskDO.getLong("id"));
        groupObj.setTaskState(intvTaskDO.getString("taskstatus"));
        DynamicObject persionDO = intvTaskDO.getDynamicObject("passedperson");
        groupObj.setPassPersonName(InteRverAnswerHelper.getPassPersionName(persionDO));
        groupObj.setInterViewMethodId(intvRoundDO.getDynamicObject("interviewmethod").getLong("id"));
        groupObj.setInterViewerName(InteRverAnswerHelper.getInterViewerNameByGroup(groupDO, intvTaskDO));
        groupObj.setIntvDate(IntvDateUtil.getIntvDate((Date)groupDO.getDate("intvdate")));
        groupObj.setIntvDateTypeDate(groupDO.getDate("intvdate"));
        groupObj.setIntvStartTime(IntvDateUtil.formatTime((Long)groupDO.getLong("intvstarttime"), (String)"HH:mm"));
        groupObj.setIntvStartTimeTypeLong(groupDO.getLong("intvstarttime"));
        String admindivision = groupDO.getString("admindivision");
        String location = groupDO.getString("interviewlocation");
        String room = groupDO.getString("interviewroom");
        String adminDivisionName = IntervEvalHelper.getAdminDivisionName(admindivision);
        String interViewLocation = adminDivisionName + location + room;
        groupObj.setInterViewLocation(interViewLocation);
        groupObj.setIntvMethod(intvRoundDO.getDynamicObject("interviewmethod").getString("name"));
        groupObj.setIntvUrl(groupDO.getString("intvervedioaddress"));
        groupObj.setInterViewerIds(InteRverAnswerHelper.getInterViewerIdsByGroup(groupDO));
        groupObj.setAppLicationIds(InteRverAnswerHelper.getAppLicationIdsByGroup(groupDO));
        return groupObj;
    }

    public static String getPassPersionName(DynamicObject persionDO) {
        String passPersionName = "";
        if (null != persionDO) {
            passPersionName = persionDO.getString("name");
        }
        return passPersionName;
    }

    public static boolean checkGoupIntvRver(DynamicObject group, Long intverId) {
        boolean checkGoupIntvRverRes = false;
        List<Long> interViewerIds = InteRverAnswerHelper.getInterViewerIdsByGroup(group);
        if (interViewerIds.indexOf(intverId) > -1) {
            checkGoupIntvRverRes = true;
        }
        return checkGoupIntvRverRes;
    }

    public static String getInterViewerNameByGroup(DynamicObject group, DynamicObject intvTaskDO) {
        String interViewerName = "";
        String passfromPerson = "";
        boolean isPassTask = false;
        DynamicObject passfromPersonDO = intvTaskDO.getDynamicObject("passedpersonfrom");
        if (passfromPersonDO != null) {
            String passfromPersonName = passfromPersonDO.getString("name");
            passfromPerson = String.format(Locale.ROOT, ResManager.loadKDString((String)"(\u6765\u81ea%s\u8f6c\u4ea4\u7684\u9762\u8bd5\u4efb\u52a1)", (String)"IntvPassFrom_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]), passfromPersonName);
            isPassTask = true;
        }
        DynamicObjectCollection interViewers = group.getDynamicObjectCollection("intver");
        for (int i = 0; i < interViewers.size(); ++i) {
            Long interViewerId = ((DynamicObject)interViewers.get(i)).getDynamicObject("fbasedataid").getLong("id");
            interViewerName = interViewerId.equals(TSCRequestContext.getUserId()) && isPassTask ? interViewerName.concat(((DynamicObject)interViewers.get(i)).getDynamicObject("fbasedataid").getString("name").concat(passfromPerson).concat(",")) : interViewerName.concat(((DynamicObject)interViewers.get(i)).getDynamicObject("fbasedataid").getString("name").concat(","));
        }
        interViewerName = interViewerName.substring(0, interViewerName.length() - 1);
        return interViewerName;
    }

    public static List<Long> getInterViewerIdsByGroup(DynamicObject group) {
        DynamicObjectCollection interViewers = group.getDynamicObjectCollection("intver");
        ArrayList<Long> interViewerIds = new ArrayList<Long>(interViewers.size());
        for (int i = 0; i < interViewers.size(); ++i) {
            interViewerIds.add(((DynamicObject)interViewers.get(i)).getDynamicObject("fbasedataid").getLong("id"));
        }
        return interViewerIds;
    }

    public static List<Long> getAppLicationIdsByGroup(DynamicObject group) {
        DynamicObjectCollection appfiles = group.getDynamicObjectCollection("groupcandate");
        ArrayList<Long> appLicationIds = new ArrayList<Long>(appfiles.size());
        for (int i = 0; i < appfiles.size(); ++i) {
            if (((DynamicObject)appfiles.get(i)).getDynamicObject("fbasedataid") == null) continue;
            appLicationIds.add(((DynamicObject)appfiles.get(i)).getDynamicObject("fbasedataid").getLong("id"));
        }
        return appLicationIds;
    }

    public static String getGenderDesc(String gender) {
        switch (gender) {
            case "0": {
                return ResManager.loadKDString((String)"\u7537", (String)"resscr_sex_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u5973", (String)"resscr_sex_1", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u672a\u77e5", (String)"resscr_sex_2", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            }
        }
        return null;
    }
}

