/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.intvcheck;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.CancelIntvResultEntity;
import kd.tsc.tspr.business.domain.intv.service.intvcheck.IntvCheckEntity;
import kd.tsc.tspr.business.domain.intv.service.intvcheck.IntvCheckResultEntity;
import kd.tsc.tspr.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tspr.common.util.IntvDateUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IntvCheckHelper {
    private static final Log logger = LogFactory.getLog(IntvCheckHelper.class);

    public static List<IntvCheckResultEntity> checkIntvObject(List<IntvCheckEntity> checkObjs) {
        ArrayList<IntvCheckResultEntity> checkRes = new ArrayList<IntvCheckResultEntity>();
        for (int i = 0; i < checkObjs.size(); ++i) {
            for (IntvCheckEntity checkObj : checkObjs) {
                String objNameOne = checkObjs.get(i).getObjName();
                String objNamTwo = checkObj.getObjName();
                if (checkObj.isCheck() || objNameOne.equals(objNamTwo)) continue;
                checkRes.add(IntvCheckHelper.compareCheckObj(checkObjs.get(i), checkObj));
                checkObjs.get(i).setCheck(true);
            }
        }
        return checkRes;
    }

    public static IntvCheckResultEntity compareCheckObj(IntvCheckEntity checkObjOne, IntvCheckEntity checkObjTwo) {
        IntvCheckResultEntity checkRes = new IntvCheckResultEntity();
        checkRes.setCheckResult(true);
        String textAnd = ResManager.loadKDString((String)"\u4e0e", (String)"IntvCheckTrueAnd", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        String checkFalseAddresAndPerson = ResManager.loadKDString((String)"\u9762\u8bd5\u5730\u70b9\u548c\u9762\u8bd5\u5b98\u65f6\u95f4\u51b2\u7a81\uff0c\u5efa\u8bae\u91cd\u65b0\u8c03\u6574\uff1b", (String)"IntvCheckFalse1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        String checkFalsePerson = ResManager.loadKDString((String)"\u9762\u8bd5\u5b98\u65f6\u95f4\u51b2\u7a81\uff0c\u5efa\u8bae\u91cd\u65b0\u8c03\u6574\uff1b", (String)"IntvCheckFalse2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        String checkFalseAddres = ResManager.loadKDString((String)"\u9762\u8bd5\u5730\u70b9\u51b2\u7a81\uff0c\u5efa\u8bae\u91cd\u65b0\u8c03\u6574\uff1b", (String)"IntvCheckFalse3", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        if (IntvCheckHelper.compareTime(checkObjOne, checkObjTwo)) {
            String objNameOne = checkObjOne.getObjName();
            String objNameTwo = checkObjTwo.getObjName();
            boolean checkAddress = false;
            if (HRStringUtils.isNotEmpty((String)checkObjOne.getIntvAddress()) && HRStringUtils.isNotEmpty((String)checkObjTwo.getIntvAddress())) {
                checkAddress = checkObjOne.getIntvAddress().equals(checkObjTwo.getIntvAddress());
            }
            List<String> checkIntvers = IntvCheckHelper.receiveCollectionList(checkObjOne.getIntvers(), checkObjTwo.getIntvers());
            if (checkAddress && checkIntvers.size() > 0) {
                checkRes.setCheckResult(false);
                checkRes.setCheckMessage(objNameOne + textAnd + objNameTwo + checkFalseAddresAndPerson);
            } else if (!checkAddress && checkIntvers.size() > 0) {
                checkRes.setCheckResult(false);
                checkRes.setCheckMessage(objNameOne + textAnd + objNameTwo + checkFalsePerson);
            } else if (checkAddress) {
                checkRes.setCheckResult(false);
                checkRes.setCheckMessage(objNameOne + textAnd + objNameTwo + checkFalseAddres);
            }
        }
        return checkRes;
    }

    public static boolean compareTime(IntvCheckEntity checkObjOne, IntvCheckEntity checkObjTwo) {
        boolean res = false;
        Date leftStartDate = checkObjOne.getIntvStartTime();
        Date leftEndDate = checkObjOne.getIntvEndTime();
        Date rightStartDate = checkObjTwo.getIntvStartTime();
        Date rightEndDate = checkObjTwo.getIntvEndTime();
        if (leftStartDate == null || rightStartDate == null) {
            return res;
        }
        if (leftStartDate.compareTo(rightStartDate) == 0 && leftEndDate.compareTo(rightEndDate) == 0) {
            res = true;
        }
        if (leftStartDate.compareTo(rightStartDate) > 0 && leftStartDate.compareTo(rightEndDate) < 0) {
            res = true;
        }
        if (rightStartDate.compareTo(leftStartDate) > 0 && rightStartDate.compareTo(leftEndDate) < 0) {
            res = true;
        }
        return res;
    }

    public static List<String> receiveCollectionList(List<String> firstArrayList, List<String> secondArrayList) {
        if (CollectionUtils.isEmpty(firstArrayList) || CollectionUtils.isEmpty(secondArrayList)) {
            return Lists.newArrayList();
        }
        return firstArrayList.stream().filter(str -> secondArrayList.contains(str)).collect(Collectors.toList());
    }

    public static List<Object> receiveCollectionListDynamicObject(List<Object> firstArrayList, List<Object> secondArrayList) {
        if (CollectionUtils.isEmpty(firstArrayList) || CollectionUtils.isEmpty(secondArrayList)) {
            return Collections.EMPTY_LIST;
        }
        firstArrayList.retainAll(secondArrayList);
        return firstArrayList;
    }

    public static List<String> getIntvers(DynamicObjectCollection intversDyc) {
        ArrayList<String> intverls = new ArrayList<String>(intversDyc.size());
        for (DynamicObject dynamicObject : intversDyc) {
            intverls.add(dynamicObject.getDynamicObject("fbasedataid").getString("name"));
        }
        return intverls;
    }

    public static List<IntvCheckResultEntity> checkIntvCandateState(DynamicObject intvDy) {
        DynamicObject[] appFiles;
        ArrayList<IntvCheckResultEntity> checkRes = new ArrayList<IntvCheckResultEntity>();
        ArrayList<Long> appLicationIds = new ArrayList<Long>();
        DynamicObjectCollection intvRounds = intvDy.getDynamicObjectCollection("tspr_intvroundentry");
        if (HRObjectUtils.isEmpty((Object)intvRounds) || intvRounds.isEmpty()) {
            logger.error("rounds business object is null:{}", (Object)intvDy.toString());
            return checkRes;
        }
        DynamicObject round = (DynamicObject)intvRounds.get(0);
        DynamicObjectCollection intvGroups = round.getDynamicObjectCollection("tspr_intvgroupentry");
        if (HRObjectUtils.isEmpty((Object)intvGroups) || intvGroups.isEmpty()) {
            logger.error("group business object is null, roundInfo:{}", (Object)round.toString());
            return checkRes;
        }
        for (DynamicObject intvGroup : intvGroups) {
            DynamicObjectCollection appfiles = intvGroup.getDynamicObjectCollection("groupcandate");
            for (DynamicObject appfile : appfiles) {
                Long applicationId = appfile.getDynamicObject("fbasedataid").getLong("id");
                appLicationIds.add(applicationId);
            }
        }
        for (DynamicObject appFile : appFiles = ArgIntvHelper.INSTANCE.getAppFile(appLicationIds)) {
            IntvCheckResultEntity intvCheckResul;
            String appFileStatus = appFile.getString("filestatus");
            String appFilesName = appFile.getString("name");
            if (appFileStatus.equals("B")) {
                intvCheckResul = new IntvCheckResultEntity();
                intvCheckResul.setCheckResult(false);
                intvCheckResul.setCheckMessage(appFilesName + ResManager.loadKDString((String)"\u5df2\u6dd8\u6c70\u4e0d\u53ef\u5b89\u6392\u9762\u8bd5", (String)"ArgIntvValidator_11", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]));
                checkRes.add(intvCheckResul);
            }
            if (!appFileStatus.equals("C")) continue;
            intvCheckResul = new IntvCheckResultEntity();
            intvCheckResul.setCheckResult(false);
            intvCheckResul.setCheckMessage(appFilesName + ResManager.loadKDString((String)"\u5df2\u5931\u6548\u4e0d\u53ef\u5b89\u6392\u9762\u8bd5", (String)"ArgIntvValidator_12", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]));
            checkRes.add(intvCheckResul);
        }
        return checkRes;
    }

    public static CancelIntvResultEntity checkAppFileIntv(List<Long> appFileTaskIdList) {
        CancelIntvResultEntity entity = new CancelIntvResultEntity();
        if (CollectionUtils.isEmpty(appFileTaskIdList)) {
            return entity.setResultEntity(Boolean.FALSE);
        }
        List appFileTaskList = appFileTaskIdList.stream().map(IntvCheckHelper::getDynamicObject).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(appFileTaskList)) {
            return entity.setResultEntity(Boolean.FALSE);
        }
        return entity.setResultEntity(Boolean.TRUE, new ArrayList<DynamicObject>(appFileTaskList));
    }

    private static DynamicObject getDynamicObject(Long appFileTaskId) {
        CancelIntvResultEntity entity = IntvCheckHelper.checkAppFileIntv(appFileTaskId);
        return entity.getDynamicObject();
    }

    public static CancelIntvResultEntity checkAppFileIntv(Long appFileTaskId) {
        String intverStatus;
        CancelIntvResultEntity entity = new CancelIntvResultEntity();
        if (Objects.isNull(appFileTaskId)) {
            return entity.setResultEntity(Boolean.FALSE);
        }
        DynamicObject appFileTask = TsrbsHelper.selectById(appFileTaskId, "tspr_appfiletask");
        if (Objects.isNull(appFileTask)) {
            return entity.setResultEntity(Boolean.FALSE);
        }
        String string = intverStatus = StringUtils.isEmpty((CharSequence)appFileTask.getString("intverstatus")) ? "A" : appFileTask.getString("intverstatus");
        if (!"A".equals(appFileTask.getString("taskstatus")) || !"A".equals(intverStatus)) {
            return entity.setResultEntity(Boolean.FALSE);
        }
        DynamicObject intvGroup = TsrbsHelper.selectById(appFileTask.getLong("intvgroup.id"), "tspr_intvgroup");
        if (Objects.isNull(intvGroup)) {
            return entity.setResultEntity(Boolean.FALSE);
        }
        Date intvDate = intvGroup.getDate("intvdate");
        if (Objects.isNull(intvDate)) {
            return entity.setResultEntity(Boolean.TRUE, appFileTask);
        }
        Long intvStartTime = intvGroup.getLong("intvstarttime");
        return IntvDateUtil.intvTimeIsBeforeNow((Date)intvDate, (Long)intvStartTime) != false ? entity.setResultEntity(Boolean.FALSE) : entity.setResultEntity(Boolean.TRUE, appFileTask);
    }

    public static IntvCheckResultEntity checkAppFileTaskStatus(Long intvId) {
        IntvCheckResultEntity entity = new IntvCheckResultEntity();
        if (Objects.isNull(intvId) || intvId.equals(0L)) {
            entity.setCheckResult(true);
            return entity;
        }
        QFilter qFilter = new QFilter("argintv", "=", (Object)intvId).and("enable", "=", (Object)"1");
        List<DynamicObject> appFileTaskList = TsrbsHelper.selectByFilter(qFilter.toArray(), "tspr_appfiletask");
        if (CollectionUtils.isEmpty(appFileTaskList)) {
            entity.setCheckResult(true);
            return entity;
        }
        entity.setCheckResult(appFileTaskList.stream().noneMatch(appFileTask -> StringUtils.isNotEmpty((CharSequence)appFileTask.getString("intvevlstatus"))));
        return entity;
    }

    public static IntvCheckResultEntity checkIntvState(Long intvid) {
        IntvCheckResultEntity checkRes = new IntvCheckResultEntity();
        if (intvid == null || intvid == 0L) {
            checkRes.setCheckResult(true);
            return checkRes;
        }
        DynamicObject newEntity = ArgIntvHelper.INSTANCE.selectIntvStatusById(intvid);
        if (HRObjectUtils.isEmpty((Object)newEntity)) {
            logger.error("intv business object is null:{}", (Object)intvid.toString());
            return checkRes;
        }
        String interviewstatus = newEntity.getString("interviewstatus");
        checkRes.setCheckResult("A".equals(interviewstatus));
        return checkRes;
    }

    public static IntvCheckResultEntity checkIntvStartTime(Long intvid) {
        IntvCheckResultEntity intvCheckResult = new IntvCheckResultEntity();
        intvCheckResult.setCheckResult(true);
        if (intvid == null || intvid == 0L) {
            return intvCheckResult;
        }
        DynamicObject interview = ArgIntvHelper.selectById(intvid, "tspr_argintv");
        DynamicObjectCollection intvRounds = interview.getDynamicObjectCollection("tspr_intvroundentry");
        if (HRObjectUtils.isEmpty((Object)intvRounds) || intvRounds.isEmpty()) {
            logger.error("rounds business object is null,argIntvId:{}", (Object)intvid);
            return intvCheckResult;
        }
        DynamicObject round = (DynamicObject)intvRounds.get(0);
        DynamicObjectCollection intvGroups = round.getDynamicObjectCollection("tspr_intvgroupentry");
        if (HRObjectUtils.isEmpty((Object)intvGroups) || intvGroups.isEmpty()) {
            logger.error("group business object is null, roundInfo:{}", (Object)round.toString());
            return intvCheckResult;
        }
        for (DynamicObject intvGroup : intvGroups) {
            Long intvStartTimeLong;
            Date intvStartTime = intvGroup.getDate("intvdate");
            boolean checktime = IntvDateUtil.intvTimeIsBeforeNow((Date)intvStartTime, (Long)(intvStartTimeLong = Long.valueOf(intvGroup.getLong("intvstarttime"))));
            if (!checktime) continue;
            intvCheckResult.setCheckResult(false);
        }
        return intvCheckResult;
    }

    public static IntvCheckResultEntity checkIntvevlState(Long intvid) {
        IntvCheckResultEntity intvCheckResult = new IntvCheckResultEntity();
        intvCheckResult.setCheckResult(true);
        if (intvid == null || intvid == 0L) {
            return intvCheckResult;
        }
        DynamicObject interview = ArgIntvHelper.selectById(intvid, "tspr_argintv");
        String intvevlsts = interview.getString("intvevlsts");
        if (!intvevlsts.equals("A")) {
            intvCheckResult.setCheckResult(false);
        }
        return intvCheckResult;
    }
}

