/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateIntvTaskEntity;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewCancelModel;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailParam;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tspr.common.enums.intv.InterviewMailType;
import org.apache.commons.collections.CollectionUtils;

public class IntvMailCancelHelper {
    public static final Log log = LogFactory.getLog(IntvMailCancelHelper.class);

    private IntvMailCancelHelper() {
    }

    public static IntvMailCancelHelper getInstance() {
        return IntvMailCancelHelperHolder.INSTANCE;
    }

    public void processCancel(List<DynamicObject> dataEntityList) {
        InterviewNoticeModel interviewNoticeModel = new InterviewNoticeModel();
        interviewNoticeModel.setInterviewMailType(InterviewMailType.CANCEL);
        this.processCancel(dataEntityList, null, interviewNoticeModel, null);
    }

    public void processCancel(Map<Long, List<Long>> candidateIds) {
        Set<Long> longs = candidateIds.keySet();
        DynamicObject[] interviews = ArgIntvHelper.getInterviews(longs);
        Map<Long, InterviewCancelModel> cancelModels = this.getCancelModels(longs, null);
        LinkedList<InterviewMailSendBean> sendMailBeanList = new LinkedList<InterviewMailSendBean>();
        for (DynamicObject dataEntity : interviews) {
            long currId = dataEntity.getLong("id");
            DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
            Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
            DynamicObject[] candidateDbList = IntvMailHelper.getInstance().getCandidateDbArray(dataEntity);
            InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.CANCEL_SINGLE);
            InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, null);
            List<InterviewMailSendBean> interviewerMailSendBeans = IntvMailCommonHelper.getInstance().processInterviewerMail(param, Lists.newArrayList(), candidateDbList, candidateIds.get(currId), null, cancelModels);
            InterviewMailParam mailParam = new InterviewMailParam(dataEntity, variableInfo, interviewNoticeModel, null);
            List<InterviewMailSendBean> candidateMailSendBeans = IntvMailHelper.getInstance().processCandidateMail(mailParam, Lists.newArrayList(), candidateDbList, ResManager.loadKDString((String)"<p class='remove_intvname'>{\u5019\u9009\u4eba\u59d3\u540d},\u60a8\u597d</p><p>\u5341\u5206\u62b1\u6b49\u7684\u901a\u77e5\u60a8\u539f\u5b9a\u4e8e{\u9762\u8bd5\u65f6\u95f4}\u7684<span class=\"emphasis_black\">{\u804c\u4f4d\u540d\u79f0}</span>\u7684\u9762\u8bd5\u5df2\u53d6\u6d88\uff0c\u611f\u8c22\u60a8\u5bf9\u672c\u516c\u53f8\u7684\u5173\u6ce8\uff0c\u671f\u5f85\u4e0e\u60a8\u7684\u4e0b\u6b21\u76f8\u9047\u3002</p><p>\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb{\u9762\u8bd5\u5b89\u6392\u4eba}\uff1a{\u9762\u8bd5\u5b89\u6392\u4eba\u624b\u673a}</p><p style=\"text-align: right;\">{\u516c\u53f8\u540d\u79f0}</p><p style=\"text-align: right;\">{\u5f53\u524d\u65e5\u671f}</p>", (String)"IntvMailConstant_26", (String)"tsc-tspr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88\u9762\u8bd5\u901a\u77e5", (String)"IntvMailConstant_28", (String)"tsc-tspr-common", (Object[])new Object[0]), candidateIds.get(currId), null);
            sendMailBeanList.addAll(interviewerMailSendBeans);
            sendMailBeanList.addAll(candidateMailSendBeans);
            log.info("interview cancel single candidate mail process end , id : {}", (Object)currId);
        }
        IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
    }

    public List<InterviewMailSendBean> processCancel(List<DynamicObject> dataEntityList, List<Long> delInterviewIds, InterviewNoticeModel type, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        DynamicObject dataEntity = dataEntityList.get(0);
        List<Long> collect = dataEntityList.stream().map(task -> task.getLong("id")).collect(Collectors.toList());
        Map<Long, InterviewCancelModel> cancelModels = this.getCancelModels(collect, updateDataEntityList);
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getInstance().getCandidateDbArray(dataEntity);
        InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.CANCEL);
        InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, type);
        HashMap groupUpdateMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty(updateDataEntityList)) {
            for (ArgIntvUpdateResultEntity updateDataEntity : updateDataEntityList) {
                groupUpdateMap.put(updateDataEntity.getGroupId(), updateDataEntity);
            }
        }
        List<InterviewMailSendBean> interviewerMailSendBeans = IntvMailCommonHelper.getInstance().processInterviewerMail(param, Lists.newArrayList(), candidateDbList, null, groupUpdateMap, cancelModels);
        InterviewMailParam mailParam = new InterviewMailParam(dataEntity, variableInfo, interviewNoticeModel, null);
        List<InterviewMailSendBean> candidateMailSendBeans = IntvMailHelper.getInstance().processCandidateMail(mailParam, Lists.newArrayList(), candidateDbList, ResManager.loadKDString((String)"<p class='remove_intvname'>{\u5019\u9009\u4eba\u59d3\u540d},\u60a8\u597d</p><p>\u5341\u5206\u62b1\u6b49\u7684\u901a\u77e5\u60a8\u539f\u5b9a\u4e8e{\u9762\u8bd5\u65f6\u95f4}\u7684<span class=\"emphasis_black\">{\u804c\u4f4d\u540d\u79f0}</span>\u7684\u9762\u8bd5\u5df2\u53d6\u6d88\uff0c\u611f\u8c22\u60a8\u5bf9\u672c\u516c\u53f8\u7684\u5173\u6ce8\uff0c\u671f\u5f85\u4e0e\u60a8\u7684\u4e0b\u6b21\u76f8\u9047\u3002</p><p>\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb{\u9762\u8bd5\u5b89\u6392\u4eba}\uff1a{\u9762\u8bd5\u5b89\u6392\u4eba\u624b\u673a}</p><p style=\"text-align: right;\">{\u516c\u53f8\u540d\u79f0}</p><p style=\"text-align: right;\">{\u5f53\u524d\u65e5\u671f}</p>", (String)"IntvMailConstant_26", (String)"tsc-tspr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88\u9762\u8bd5\u901a\u77e5", (String)"IntvMailConstant_28", (String)"tsc-tspr-common", (Object[])new Object[0]), null, null);
        List<InterviewMailSendBean> receptionMailSendBeans = IntvMailHelper.getInstance().processReceptionistMail(param, candidateDbList, ResManager.loadKDString((String)"<p>\u5df2\u4e3a\u4f60\u53d6\u6d88\u9762\u8bd5\u63a5\u5f85\u4efb\u52a1\uff0c\u8bf7\u6089\u77e5</p><p>{\u9762\u8bd5\u5b89\u6392\u8868}</p><p style=\"text-align: right;\">{\u516c\u53f8\u540d\u79f0}</p><p style=\"text-align: right;\">{\u5f53\u524d\u65e5\u671f}</p>", (String)"IntvMailConstant_24", (String)"tsc-tspr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88\u63a5\u5f85\u9762\u8bd5\u901a\u77e5", (String)"IntvMailConstant_25", (String)"tsc-tspr-common", (Object[])new Object[0]), Collections.emptyMap());
        LinkedList<InterviewMailSendBean> sendMailBeanList = new LinkedList<InterviewMailSendBean>();
        sendMailBeanList.addAll(interviewerMailSendBeans);
        sendMailBeanList.addAll(candidateMailSendBeans);
        sendMailBeanList.addAll(receptionMailSendBeans);
        String tag = ResManager.loadKDString((String)"\u53d6\u6d88\u9762\u8bd5\u901a\u77e5", (String)"IntvMailHelper_23", (String)"tsc-tspr-business", (Object[])new Object[0]);
        String content = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u53d6\u6d88\u4e86\u60a8\u7684\u9762\u8bd5\u4efb\u52a1\uff0c\u5173\u6ce8\u6700\u65b0\u9762\u8bd5\u65e5\u5386", (String)"IntvMailHelper_5", (String)"tsc-tspr-business", (Object[])new Object[0]), UserServiceHelper.getCurrentUser((String)"name").getString("name"));
        List<Long> interviewerIds = Arrays.stream(interviewDbjList).map(intr -> intr.getLong("id")).collect(Collectors.toList());
        if (!Objects.isNull(type) && InterviewMailType.EDIT_CANCEL_INTERVIEW != type.getInterviewMailType()) {
            IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
            IntvMailCommonHelper.getInstance().sendMessage(interviewerIds, tag, content);
        } else {
            ArrayList editorSendList = Lists.newArrayListWithExpectedSize((int)10);
            for (Long interviewerId : interviewerIds) {
                if (!delInterviewIds.contains(interviewerId)) continue;
                editorSendList.add(interviewerId);
            }
            IntvMailCommonHelper.getInstance().sendMessage(editorSendList, tag, content);
        }
        return sendMailBeanList;
    }

    private Map<Long, InterviewCancelModel> getCancelModels(Iterable<Long> longs, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        DynamicObject[] taskObjects;
        HashMap cancelModels = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty(updateDataEntityList)) {
            for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
                Long groupId = argIntvUpdateResultEntity.getGroupId();
                List<ArgIntvUpdateIntvTaskEntity> argInterviewerTasks = argIntvUpdateResultEntity.getArgInterviewerTasks();
                for (ArgIntvUpdateIntvTaskEntity argInterviewerTask : argInterviewerTasks) {
                    if (HRObjectUtils.isEmpty((Object)argInterviewerTask) || !HRStringUtils.equals((String)"Delete", (String)argInterviewerTask.getChangeType())) continue;
                    InterviewCancelModel interviewCancelModel = new InterviewCancelModel();
                    interviewCancelModel.setInterviewerId(argInterviewerTask.getInterviewerId());
                    interviewCancelModel.setInterviewerTaskId(argInterviewerTask.getIntvTaskId());
                    interviewCancelModel.setGroupId(groupId);
                    interviewCancelModel.setTaskStatus("C");
                    cancelModels.put(argInterviewerTask.getIntvTaskId(), interviewCancelModel);
                }
            }
            return cancelModels;
        }
        for (DynamicObject taskObject : taskObjects = IntvTaskHelper.getInstance().getIntvTaskObjs(new QFilter("argintv.id", "in", longs))) {
            InterviewCancelModel interviewCancelModel = new InterviewCancelModel();
            interviewCancelModel.setInterviewerId(Long.valueOf(taskObject.getLong("INTERVIEWER.id")));
            interviewCancelModel.setInterviewerTaskId(Long.valueOf(taskObject.getLong("id")));
            interviewCancelModel.setGroupId(Long.valueOf(taskObject.getLong("INTVGROUP.id")));
            interviewCancelModel.setTaskStatus(taskObject.getString("taskstatus"));
            cancelModels.put(taskObject.getLong("id"), interviewCancelModel);
        }
        return cancelModels;
    }

    private static class IntvMailCancelHelperHolder {
        private static final IntvMailCancelHelper INSTANCE = new IntvMailCancelHelper();

        private IntvMailCancelHelperHolder() {
        }
    }
}

