/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntervEvalHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tspr.common.constants.intv.IntvMailConstants;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewCancelModel;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailContent;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailParam;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tspr.common.enums.intv.EmailTemplateTag;
import kd.tsc.tspr.common.enums.intv.HtmlTag;
import kd.tsc.tspr.common.enums.intv.InterviewMailRol;
import kd.tsc.tspr.common.enums.intv.InterviewMailType;
import kd.tsc.tspr.common.util.IntvDateUtil;
import kd.tsc.tspr.common.util.IntvMailUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.sms.entity.SmsModel;
import kd.tsc.tsrbs.business.domain.sms.service.SmsServiceImpl;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;
import kd.tsc.tsrbs.common.utils.Num2ChUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class IntvMailCommonHelper {
    static final HRBaseServiceHelper RESUME_HELPER = new HRBaseServiceHelper("tspr_appfile");
    protected static final String[] APP_FILE_FIELDS = new String[]{"id", "phone", "position.name", "position.adminorg.id", "email", "name", "position.adminorg.name", "appres.fullname", "appres.id", "appres.email", "appres.phone", "appres.workingyears", "appres.gender", "appres.highestspecialty", "appres.highesteduschool.name", "appres.highestdegree.name", "appres.highesteducation.name"};
    public static final Log log = LogFactory.getLog(IntvMailCommonHelper.class);

    public static String getGender(int gender) {
        String res = gender == 0 ? ResManager.loadKDString((String)"\u7537", (String)"IntvMailHelper_50", (String)"tsc-tspr-business", (Object[])new Object[0]) : (gender == 1 ? ResManager.loadKDString((String)"\u5973", (String)"IntvMailHelper_51", (String)"tsc-tspr-business", (Object[])new Object[0]) : (gender == 2 ? ResManager.loadKDString((String)"\u672a\u77e5", (String)"IntvMailHelper_52", (String)"tsc-tspr-business", (Object[])new Object[0]) : ""));
        return res;
    }

    public static String getValue(DynamicObject obj, String properties) {
        if (HRObjectUtils.isEmpty((Object)obj) || HRStringUtils.isEmpty((String)obj.getString(properties))) {
            return " ";
        }
        return obj.getString(properties);
    }

    public static void setVariableInfoByPosition(Map<String, String> variableInfo, DynamicObject position) {
        String name = position.getString("name");
        variableInfo.put("name", name);
        variableInfo.put("jobTitle", name);
        DynamicObject adminorg = position.getDynamicObject("adminorg");
        Map<String, String> adminOrgInfo = IntvMailCommonHelper.getAdminOrgInfo(adminorg);
        variableInfo.put("compName", adminOrgInfo.get("cmpName"));
        variableInfo.put("deptName", adminOrgInfo.get("deptName"));
    }

    public static void setVariableInfoByArgIntv(Map<String, String> variableInfo, DynamicObject intvObj) {
        variableInfo.put("interviewtitle", intvObj.getString("interviewtitle"));
        DynamicObjectCollection roundCollection = intvObj.getDynamicObjectCollection("tspr_intvroundentry");
        if (CollectionUtils.isEmpty((Collection)roundCollection)) {
            return;
        }
        DynamicObjectCollection groupCollection = ((DynamicObject)roundCollection.get(0)).getDynamicObjectCollection("tspr_intvgroupentry");
        if (CollectionUtils.isEmpty((Collection)groupCollection)) {
            return;
        }
        DynamicObject groupSubEntry = (DynamicObject)groupCollection.get(0);
        Date intvDate = groupSubEntry.getDate("intvdate");
        int startTime = groupSubEntry.getInt("intvstarttime");
        int endTime = groupSubEntry.getInt("intvendtime");
        variableInfo.put("intvtime", IntvMailCommonHelper.getInterviewFormatTime(intvDate, startTime, endTime));
        String admindivision = groupSubEntry.getString("admindivision");
        String location = groupSubEntry.getString("interviewlocation");
        String room = groupSubEntry.getString("interviewroom");
        String adminDivisionName = IntervEvalHelper.getAdminDivisionName(admindivision);
        variableInfo.put("intvAddress", adminDivisionName + location + room);
    }

    public static String getFormatIntvTime(DynamicObject group) {
        Date intvdate = group.getDate("intvdate");
        int intvstarttime = group.getInt("intvstarttime");
        int intvendtime = group.getInt("intvendtime");
        return IntvMailCommonHelper.getInterviewFormatTime(intvdate, intvstarttime, intvendtime);
    }

    public static String getFormatIntvTime1(DynamicObject group) {
        Date intvdate = group.getDate("intvdatetime");
        int intvstarttime = group.getInt("groupduration");
        if (Objects.isNull(intvdate)) {
            return "";
        }
        LocalDateTime from = LocalDateTime.ofInstant(intvdate.toInstant(), ZoneId.systemDefault());
        LocalTime localTime = from.toLocalTime();
        int second = localTime.toSecondOfDay();
        int end = second + intvstarttime * 60;
        return IntvMailCommonHelper.getInterviewFormatTime(intvdate, second, end);
    }

    public static String getFormatIntvAddress(DynamicObject group) {
        String admindivision = group.getString("admindivision");
        String interviewlocation = group.getString("interviewlocation");
        String interviewroom = group.getString("interviewroom");
        String adminDivisionName = IntervEvalHelper.getAdminDivisionName(admindivision);
        if (HRStringUtils.isEmpty((String)adminDivisionName)) {
            adminDivisionName = "";
        }
        if (HRStringUtils.isEmpty((String)interviewlocation)) {
            interviewlocation = "";
        }
        if (HRStringUtils.isEmpty((String)interviewroom)) {
            interviewroom = "";
        }
        return adminDivisionName + interviewlocation + interviewroom;
    }

    static void setNullValue(Map<String, String> variableInfoMap) {
        variableInfoMap.put("compName", " ");
        variableInfoMap.put("deptName", " ");
        variableInfoMap.put("interviewtitle", " ");
        variableInfoMap.put("currentDate", " ");
        variableInfoMap.put("hrName", " ");
        variableInfoMap.put("hrPhone", " ");
    }

    public static Map<String, String> getVariableInfo(DynamicObject intvObj) {
        IntvMailHelper.log.info("set variable start");
        HashMap variableInfoMap = Maps.newHashMapWithExpectedSize((int)32);
        IntvMailCommonHelper.setNullValue(variableInfoMap);
        String hrName = UserServiceHelper.getCurrentUser((String)"name").getString("name");
        variableInfoMap.put("hrName", hrName);
        String hrPhone = UserServiceHelper.getCurrentUser((String)"phone").getString("phone");
        variableInfoMap.put("hrPhone", hrPhone);
        variableInfoMap.put("currentDate", LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE));
        if (!HRObjectUtils.isEmpty((Object)intvObj)) {
            IntvMailCommonHelper.setVariableInfoByArgIntv(variableInfoMap, intvObj);
        }
        long aLong = ((DynamicObject)intvObj.getDynamicObjectCollection("intvcandate").get(0)).getLong("fbasedataid_id");
        DynamicObject appFile = ArgIntvHelper.getInstance().getAppFile(aLong);
        DynamicObject position = appFile.getDynamicObject("position");
        if (!HRObjectUtils.isEmpty((Object)position)) {
            IntvMailCommonHelper.setVariableInfoByPosition(variableInfoMap, position);
        }
        IntvMailHelper.log.info("set variable start\uff1a {}", (Object)variableInfoMap);
        return variableInfoMap;
    }

    public static String getMailContent(Document parse) {
        parse.getElementsByClass(EmailTemplateTag.USER_NAME.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.USER_NAME.getDesc(), (String)"IntvMailHelper_5", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.POSITION_NAME_TAG.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.POSITION_NAME_TAG.getDesc(), (String)"IntvMailHelper_6", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.SEX.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.SEX.getDesc(), (String)"IntvMailHelper_7", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.EDUCATION.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.EDUCATION.getDesc(), (String)"IntvMailHelper_8", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.UNIVERSITY.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.UNIVERSITY.getDesc(), (String)"IntvMailHelper_9", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.MAJOR.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.MAJOR.getDesc(), (String)"IntvMailHelper_10", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.WORK_YEARS.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.WORK_YEARS.getDesc(), (String)"IntvMailHelper_11", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementsByClass(EmailTemplateTag.OPT.getTag()).html(ResManager.loadKDString((String)EmailTemplateTag.OPT.getDesc(), (String)"IntvMailHelper_12", (String)"tsc-tspr-business", (Object[])new Object[0]));
        return parse.toString();
    }

    public static DynamicObject[] getInterViewDbList(DynamicObject dataEntity) {
        DynamicObjectCollection groupEntrys = IntvMailCommonHelper.getInterviewGroupByEntity(dataEntity);
        HashSet interviewIds = new HashSet();
        for (DynamicObject groupEntry : groupEntrys) {
            List collect = groupEntry.getDynamicObjectCollection("intver").stream().map(xValue -> xValue.getLong("fbasedataid_id")).collect(Collectors.toList());
            interviewIds.addAll(collect);
        }
        return IntvMailHelper.USER_HELPER.query("id,name,email,phone", new QFilter[]{new QFilter("id", "in", interviewIds)});
    }

    public static InterviewMailType getInterviewTrueType(InterviewMailType add, InterviewMailType editor) {
        InterviewMailType type = add == InterviewMailType.ADD ? InterviewMailType.ADD : (add == InterviewMailType.EDIT ? (editor == InterviewMailType.EDIT_ADD_INTERVIEW ? InterviewMailType.ADD : (editor == InterviewMailType.EDIT_UPDATE ? InterviewMailType.EDIT : InterviewMailType.CANCEL)) : (add == InterviewMailType.CANCEL || add == InterviewMailType.CANCEL_SINGLE ? InterviewMailType.CANCEL : InterviewMailType.ADD));
        return type;
    }

    public static String getBusinessType(InterviewMailType trueType) {
        String businessType = trueType == InterviewMailType.ADD ? ResManager.loadKDString((String)"\u9762\u8bd5\u9080\u8bf7", (String)"IntvMailHelper_21", (String)"tsc-tspr-business", (Object[])new Object[0]) : (trueType == InterviewMailType.EDIT ? ResManager.loadKDString((String)"\u9762\u8bd5\u4fee\u6539\u901a\u77e5", (String)"IntvMailHelper_22", (String)"tsc-tspr-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9762\u8bd5\u53d6\u6d88\u901a\u77e5", (String)"IntvMailHelper_23", (String)"tsc-tspr-business", (Object[])new Object[0]));
        return businessType;
    }

    public String assemblyOneInterviewerTable(List<DynamicObject> dynamicObjects, List<Long> candidateCancelIds, InterviewMailType type, InterviewMailType editType) {
        StringBuilder interviewerTable = new StringBuilder(5200);
        interviewerTable.append("<div><table class='tbl_candidate' cellpadding=\"10\" cellspacing=\"3\" rules=\"rows\">");
        interviewerTable.append("<tr style=\"background: #F3F3F5;height: 34px\">\n<td class='intv_user_name'></td>\n<td class='intv_position_name'></td>\n<td class='intv_sex'></td>\n<td class='intv_education'></td>\n<td class='intv_university'></td>\n<td class='intv_major'></td>\n<td class='intv_work_years'></td>\n<td class='to_evaluate intv_opt remove_ele'></td></tr>");
        boolean hasText = false;
        for (DynamicObject dynamicObject : dynamicObjects) {
            long aLong = dynamicObject.getLong("id");
            if (type == InterviewMailType.CANCEL_SINGLE && !candidateCancelIds.contains(aLong)) continue;
            hasText = true;
            interviewerTable.append("<tr>");
            interviewerTable.append(this.assemblyEmailContent(dynamicObject));
            interviewerTable.append("</tr>");
        }
        interviewerTable.append("</table></div>");
        if (InterviewMailType.CANCEL_SINGLE == type) {
            return hasText ? interviewerTable.toString() : "";
        }
        return interviewerTable.toString();
    }

    private String assemblyEmailContent(DynamicObject obj) {
        StringBuilder trHtml = new StringBuilder(5200);
        String appId = String.valueOf(obj.getLong("id"));
        String resumeId = IntvMailCommonHelper.getValue(obj, "appres.id");
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        param.put("app_id", appId);
        param.put("resume_id", resumeId);
        String detailUrl = IntvMailUtils.getFormDetailUrl((String)"tsivp_intvevaltask", (Map)param);
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{IntvMailCommonHelper.getValue(obj, "appres.fullname")}));
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{obj.getString("position.name")}));
        String gender = IntvMailCommonHelper.getGender(obj.getInt("appres.gender"));
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{gender}));
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{IntvMailCommonHelper.getValue(obj, "appres.highesteducation.name")}));
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{IntvMailCommonHelper.getValue(obj, "appres.highesteduschool.name")}));
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{IntvMailCommonHelper.getValue(obj, "appres.highestspecialty")}));
        int workYears = obj.getInt("appres.workingyears");
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{workYears == 0 ? " " : ResumeAnalysisHelper.getWorkYearShow((int)workYears)}));
        trHtml.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD_A, (Object[])new Object[]{detailUrl, ResManager.loadKDString((String)EmailTemplateTag.INTV_OPT_VIEW.getDesc(), (String)"IntvMailHelper_17", (String)"tsc-tspr-business", (Object[])new Object[0])}));
        return trHtml.toString();
    }

    public static String replaceVariable(String sourceRichText, Map<String, String> variableInfo) {
        for (Map.Entry entry : IntvMailConstants.VARIABLE_INFO_NAME.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!sourceRichText.contains(val) || Objects.isNull(variableInfo.get(key))) continue;
            String pre = variableInfo.get(key).replaceAll("\\$", "RDS_CHAR_DOLLAR");
            sourceRichText = sourceRichText.replaceAll("\\{" + val.substring(1, val.length() - 1) + "}", pre);
            sourceRichText = sourceRichText.replaceAll("RDS_CHAR_DOLLAR", "\\$");
        }
        return sourceRichText;
    }

    private IntvMailCommonHelper() {
    }

    public static IntvMailCommonHelper getInstance() {
        return IntvMailCommonHelperHolder.INSTANCE;
    }

    public List<InterviewMailSendBean> processInterviewerMail(InterviewMailParam mailParam, List<DynamicObject> intvTaskList, DynamicObject[] candidateDbList, List<Long> candidateCancelIds, Map<Long, ArgIntvUpdateResultEntity> groupUpdateEntity, Map<Long, InterviewCancelModel> cancelModels) {
        DynamicObject dataEntity = mailParam.getDataEntity();
        Map variableInfo = mailParam.getVariableInfo();
        DynamicObject[] interviewDbjList = mailParam.getInterviewDbjList();
        InterviewNoticeModel noticeType = mailParam.getNoticeType();
        InterviewNoticeModel editNoticeType = mailParam.getEditNoticeType();
        LinkedList<InterviewMailSendBean> interviewMailSendBeanList = new LinkedList<InterviewMailSendBean>();
        if (!noticeType.isEmailInterviewer() && !noticeType.isSmsInterviewer()) {
            return interviewMailSendBeanList;
        }
        String businessType = this.getBusinessType(noticeType, editNoticeType);
        InterviewMailContent interviewMailContent = this.getMailContent(dataEntity, noticeType, editNoticeType);
        DynamicObjectCollection groupEntry = IntvMailCommonHelper.getInterviewGroupByEntity(dataEntity);
        LinkedHashMap interviewerMailContentMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        InterviewMailType editType = this.getInterviewMailType(noticeType, editNoticeType);
        InterviewNoticeModel editorModel = this.getInterviewNoticeModel(dataEntity, editType);
        InterviewMailParam interviewTableParam = new InterviewMailParam(interviewDbjList, noticeType, editorModel);
        boolean isUpdateCancel = this.getIsUpdateCancel(noticeType, editNoticeType);
        interviewTableParam.setUpdateCancel(isUpdateCancel);
        String ccInterviewTable = IntvMailHelper.getInstance().getInterviewTable(interviewTableParam, candidateDbList, groupEntry, interviewerMailContentMap, candidateCancelIds, groupUpdateEntity, cancelModels);
        if (MapUtils.isEmpty((Map)interviewerMailContentMap)) {
            return interviewMailSendBeanList;
        }
        Map<Long, DynamicObject> interviewDbMap = IntvMailCommonHelper.getInstance().getInterviewerDbMap(interviewDbjList);
        for (Map.Entry interviewerMailContent : interviewerMailContentMap.entrySet()) {
            Document parse = Jsoup.parse((String)"<!DOCTYPE html><html><head><title></title><style>a:link,a:visited{text-decoration:none;color:#5582F3}body{margin:2px 0px;line-height:140%;overflow-wrap:break-word}.emphasis_black{color:#000;font-weight:bold}.emphasis_blue{color:#5582F3;font-weight:bold}.emphasis_red{color:red;font-weight:bold}a.replay_a{float:right;height:32px;line-height:32px;background:#5582F3;border-radius:2px;display:block;text-decoration:none;font-size:14px;outline:none;color:white;width:88px;text-align:center}.float_right{float:right}.tbl_candidate{text-align:left;border:1px solid#CCCCCC;font-size:12px;margin:18px auto;width:100%}.interview_table{margin-top:12px}.tbl_candidate tr td{width:12.5%;border-right:1px solid#CCCCCC}</style></head><body><div style=\"font-size: 14px;width: 90%;color:#333333;border-radius: 8px;overflow: hidden;box-shadow: 2px 5px 14px 5px rgba(0, 0, 0, 0.1);margin: auto;\"><div id=\"business_type\"style=\"height:54px;background: linear-gradient(225deg, #55E2EE 0%, #437FEC 100%);line-height: 54px;padding-left:30px;font-size: 18px;color: #fff;font-weight: bold;\"></div><div style=\"padding: 20px 30px;background: #fff\"><div id='header'></div><div id='main_content'></div><div id='footer'></div></div></div></body></html>");
            parse.getElementById("business_type").appendText(businessType);
            Long key = (Long)interviewerMailContent.getKey();
            Set<String> currInterviewTaskIds = this.getCurrInterviewTaskIds(intvTaskList, key);
            Map<String, String> param = this.getFormParam(dataEntity, key, currInterviewTaskIds);
            String formDetailUrl = IntvMailUtils.getFormDetailUrl((String)"tssrm_interveranswer", param);
            Document intvHeader = Jsoup.parse((String)"<span id='intv_name_sender'></span><a href=\"#\" class='replay_a' id='replay_a'></a>");
            intvHeader = this.processInterviewHeader(noticeType, interviewDbMap, key, formDetailUrl, intvHeader);
            parse.getElementById("header").append(intvHeader.toString());
            String mailContent = (String)interviewerMailContent.getValue();
            String htmlContent = IntvMailHelper.getInstance().getMailContent(parse, interviewMailContent.getRichText(), variableInfo, mailContent, this.getInterviewALLNames(interviewDbjList));
            Document resParse = Jsoup.parse((String)htmlContent);
            this.removeAndSingBtn(noticeType, param, resParse);
            DynamicObject dynamicObject = interviewDbMap.get(key);
            String email = dynamicObject.getString("email");
            String largeText = this.getLargeText(dataEntity, noticeType);
            HashMap dynamicVariable = Maps.newHashMapWithExpectedSize((int)16);
            dynamicVariable.put(ResManager.loadKDString((String)"\u9762\u8bd5\u5b98\u59d3\u540d", (String)"IntvMailHelper_35", (String)"tsc-tspr-business", (Object[])new Object[0]), interviewDbMap.get(key).getString("name"));
            String phone = interviewDbMap.get(key).getString("phone");
            String smsContent = IntvMailHelper.getInstance().getSmsContent(largeText, variableInfo, dynamicVariable);
            InterviewMailSendBean interviewMailSendBean = new InterviewMailSendBean();
            interviewMailSendBean.setId(key);
            interviewMailSendBean.setInterviewMailRol(InterviewMailRol.INTERVIEWER);
            if (noticeType.isEmailInterviewer()) {
                interviewMailSendBean.setMailTheme(interviewMailContent.getInterviewTheme());
                interviewMailSendBean.setMailContent(resParse.toString());
                interviewMailSendBean.setReceiver((List)Lists.newArrayList((Object[])new String[]{email}));
            }
            if (noticeType.isSmsInterviewer()) {
                interviewMailSendBean.setSmsContent(smsContent);
                interviewMailSendBean.setPhone(phone);
            }
            interviewMailSendBeanList.add(interviewMailSendBean);
        }
        InterviewMailParam mailParamCC = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, noticeType);
        this.processCCMail(mailParamCC, interviewMailSendBeanList, businessType, interviewMailContent, ccInterviewTable);
        return interviewMailSendBeanList;
    }

    private boolean getIsUpdateCancel(InterviewNoticeModel noticeType, InterviewNoticeModel editNoticeType) {
        return !Objects.isNull(noticeType) && InterviewMailType.CANCEL == noticeType.getInterviewMailType() && !Objects.isNull(editNoticeType) && InterviewMailType.EDIT_CANCEL_INTERVIEW == editNoticeType.getInterviewMailType();
    }

    private String getLargeText(DynamicObject dataEntity, InterviewNoticeModel noticeType) {
        return dataEntity.getString("sms_intv_richtext");
    }

    private Document processInterviewHeader(InterviewNoticeModel noticeType, Map<Long, DynamicObject> interviewDbMap, Long key, String formDetailUrl, Document intvHeader) {
        intvHeader.getElementById("intv_name_sender").appendText(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff0c\u60a8\u597d", (String)"IntvMailHelper_32", (String)"tsc-tspr-business", (Object[])new Object[0]), interviewDbMap.get(key).getString("name")));
        if (noticeType.getInterviewMailType() == InterviewMailType.CANCEL || noticeType.getInterviewMailType() == InterviewMailType.CANCEL_SINGLE) {
            intvHeader = Jsoup.parse((String)"<span id='intv_name_sender'></span>");
            intvHeader.getElementById("intv_name_sender").appendText(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff0c\u60a8\u597d", (String)"IntvMailHelper_32", (String)"tsc-tspr-business", (Object[])new Object[0]), interviewDbMap.get(key).getString("name")));
        } else {
            intvHeader.getElementById("replay_a").attr("href", formDetailUrl).appendText(ResManager.loadKDString((String)"\u7b54\u590d", (String)"IntvMailHelper_28", (String)"tsc-tspr-business", (Object[])new Object[0]));
        }
        return intvHeader;
    }

    private Map<String, String> getFormParam(DynamicObject dataEntity, Long key, Set<String> currInterviewTaskIds) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        param.put("argintvid", String.valueOf(dataEntity.getLong("id")));
        String md5Str = EncryptionDecryptUtil.getEncryptStr((Object)key);
        param.put("interviewerIdSecretStr", md5Str);
        param.put("taskids", String.join((CharSequence)",", currInterviewTaskIds));
        return param;
    }

    private String getInterviewALLNames(DynamicObject[] interviewDbjList) {
        return Arrays.stream(interviewDbjList).map(intv -> intv.getString("name")).collect(Collectors.joining(","));
    }

    private void processCCMail(InterviewMailParam mailParam, List<InterviewMailSendBean> interviewMailSendBeanList, String businessType, InterviewMailContent interviewMailContent, String ccInterviewTable) {
        if (HRStringUtils.isEmpty((String)ccInterviewTable)) {
            return;
        }
        DynamicObject dataEntity = mailParam.getDataEntity();
        DynamicObject[] interviewDbjList = mailParam.getInterviewDbjList();
        InterviewNoticeModel noticeType = mailParam.getNoticeType();
        Map variableInfo = mailParam.getVariableInfo();
        if (noticeType.isEmailInterviewer()) {
            String interviewALLNames = this.getInterviewALLNames(interviewDbjList);
            String ccPerson = dataEntity.getString("ccperson");
            if (HRStringUtils.isNotEmpty((String)ccPerson)) {
                Document parse = Jsoup.parse((String)"<!DOCTYPE html><html><head><title></title><style>a:link,a:visited{text-decoration:none;color:#5582F3}body{margin:2px 0px;line-height:140%;overflow-wrap:break-word}.emphasis_black{color:#000;font-weight:bold}.emphasis_blue{color:#5582F3;font-weight:bold}.emphasis_red{color:red;font-weight:bold}a.replay_a{float:right;height:32px;line-height:32px;background:#5582F3;border-radius:2px;display:block;text-decoration:none;font-size:14px;outline:none;color:white;width:88px;text-align:center}.float_right{float:right}.tbl_candidate{text-align:left;border:1px solid#CCCCCC;font-size:12px;margin:18px auto;width:100%}.interview_table{margin-top:12px}.tbl_candidate tr td{width:12.5%;border-right:1px solid#CCCCCC}</style></head><body><div style=\"font-size: 14px;width: 90%;color:#333333;border-radius: 8px;overflow: hidden;box-shadow: 2px 5px 14px 5px rgba(0, 0, 0, 0.1);margin: auto;\"><div id=\"business_type\"style=\"height:54px;background: linear-gradient(225deg, #55E2EE 0%, #437FEC 100%);line-height: 54px;padding-left:30px;font-size: 18px;color: #fff;font-weight: bold;\"></div><div style=\"padding: 20px 30px;background: #fff\"><div id='header'></div><div id='main_content'></div><div id='footer'></div></div></div></body></html>");
                parse.getElementById("business_type").appendText(businessType);
                String ccHtmlContent = IntvMailHelper.getInstance().getMailContent(parse, interviewMailContent.getRichText(), variableInfo, ccInterviewTable, interviewALLNames);
                Document resParse = Jsoup.parse((String)ccHtmlContent);
                resParse.getElementsByClass("remove_ele").remove();
                resParse.getElementsByClass("to_evaluate").remove();
                InterviewMailSendBean ccMailSendBean = new InterviewMailSendBean(ResManager.loadKDString((String)"\u6284\u9001-", (String)"IntvMailHelper_36", (String)"tsc-tspr-business", (Object[])new Object[0]) + interviewMailContent.getInterviewTheme(), resParse.toString(), (List)Lists.newArrayList((Object[])new String[]{ccPerson}));
                ccMailSendBean.setInterviewMailRol(InterviewMailRol.CC);
                interviewMailSendBeanList.add(ccMailSendBean);
            }
        }
    }

    private Set<String> getCurrInterviewTaskIds(List<DynamicObject> intvTaskList, Long key) {
        LinkedHashSet<String> currInterviewTaskIds = new LinkedHashSet<String>();
        for (DynamicObject dynamicObject : intvTaskList) {
            long aLong = dynamicObject.getDynamicObject("interviewer").getLong("id");
            if (aLong != key) continue;
            currInterviewTaskIds.add(String.valueOf(dynamicObject.getLong("id")));
        }
        return currInterviewTaskIds;
    }

    public Map<Long, DynamicObject> getInterviewerDbMap(DynamicObject[] interviewDbjList) {
        LinkedHashMap interviewDbMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject intvObj : interviewDbjList) {
            interviewDbMap.put(intvObj.getLong("id"), intvObj);
        }
        return interviewDbMap;
    }

    private InterviewMailType getInterviewMailType(InterviewNoticeModel noticeType, InterviewNoticeModel editNoticeType) {
        InterviewMailType editType = null;
        if (InterviewMailType.EDIT == noticeType.getInterviewMailType()) {
            editType = editNoticeType.getInterviewMailType();
        } else if (editNoticeType != null && InterviewMailType.EDIT_CANCEL_INTERVIEW == editNoticeType.getInterviewMailType()) {
            editType = editNoticeType.getInterviewMailType();
        } else if (InterviewMailType.ADD == noticeType.getInterviewMailType() && editNoticeType != null && InterviewMailType.EDIT_ADD_INTERVIEW == editNoticeType.getInterviewMailType()) {
            editType = editNoticeType.getInterviewMailType();
        }
        return editType;
    }

    private InterviewMailContent getMailContent(DynamicObject dataEntity, InterviewNoticeModel noticeType, InterviewNoticeModel editNoticeType) {
        InterviewMailContent interviewMailContent;
        if (noticeType.getInterviewMailType() == InterviewMailType.ADD) {
            String interviewTheme;
            String richText;
            if (editNoticeType != null && editNoticeType.getInterviewMailType() == InterviewMailType.EDIT_ADD_INTERVIEW) {
                richText = noticeType.getInterviewerMailContent();
                interviewTheme = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9762\u8bd5\u901a\u77e5: %s", (String)"ArgIntvBaseEdit_11", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), noticeType.getInterviewTitle());
            } else {
                richText = dataEntity.getString("txtmailinterviewer_tag");
                interviewTheme = dataEntity.getString("intetheme");
            }
            interviewMailContent = new InterviewMailContent(richText, interviewTheme);
        } else if (noticeType.getInterviewMailType() == InterviewMailType.CANCEL || noticeType.getInterviewMailType() == InterviewMailType.CANCEL_SINGLE) {
            String richText = ResManager.loadKDString((String)"<p><span class='remove_intvname'>{\u9762\u8bd5\u5b98\u59d3\u540d}\uff0c\u60a8\u597d</span></p><p>\u60a8\u7684\u4ee5\u4e0b\u9762\u8bd5\u5b89\u6392\u5df2\u53d6\u6d88\uff0c\u8bf7\u6089\u77e5</p><p>{\u9762\u8bd5\u5b89\u6392\u8868}</p><p style=\"text-align: right;\">{\u516c\u53f8\u540d\u79f0}</p><p style=\"text-align: right;\">{\u5f53\u524d\u65e5\u671f}</p>", (String)"IntvMailConstant_14", (String)"tsc-tspr-common", (Object[])new Object[0]);
            String interviewTheme = ResManager.loadKDString((String)"\u53d6\u6d88\u9762\u8bd5\u901a\u77e5", (String)"IntvMailHelper_33", (String)"tsc-tspr-business", (Object[])new Object[0]);
            interviewMailContent = new InterviewMailContent(richText, interviewTheme);
        } else {
            String richText = dataEntity.getString("txtmailinterviewer_tag");
            String interviewTheme = dataEntity.getString("intetheme");
            interviewMailContent = new InterviewMailContent(richText, interviewTheme);
        }
        return interviewMailContent;
    }

    private String getBusinessType(InterviewNoticeModel noticeType, InterviewNoticeModel editNoticeType) {
        InterviewMailType trueType = IntvMailCommonHelper.getInterviewTrueType(noticeType.getInterviewMailType(), editNoticeType == null ? null : editNoticeType.getInterviewMailType());
        return IntvMailCommonHelper.getBusinessType(trueType);
    }

    private static DynamicObjectCollection getInterviewGroupByEntity(DynamicObject dataEntity) {
        DynamicObject roundEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tspr_intvroundentry").get(0);
        return roundEntry.getDynamicObjectCollection("tspr_intvgroupentry");
    }

    private void removeAndSingBtn(InterviewNoticeModel noticeType, Map<String, String> param, Document resParse) {
        resParse.getElementsByClass("remove_intvname").remove();
        if (noticeType.getInterviewMailType() == InterviewMailType.ADD) {
            resParse.getElementsByClass("remove_intvname").remove();
            resParse.getElementsByClass(EmailTemplateTag.SIGN.getTag()).attr("href", IntvMailUtils.getListUrl((String)"tsivp_intvevl", param)).append(ResManager.loadKDString((String)"\u7acb\u5373\u767b\u5f55", (String)"IntvMailHelper_34", (String)"tsc-tspr-business", (Object[])new Object[0]));
        } else {
            resParse.getElementsByClass("to_evaluate").remove();
        }
    }

    public String replaceDynamicVariable(String sourceRichText, Map<String, String> dynamicVariable) {
        for (Map.Entry<String, String> dynamicVar : dynamicVariable.entrySet()) {
            String key = dynamicVar.getKey();
            String value = dynamicVar.getValue();
            if (!HRStringUtils.isNotEmpty((String)key) || Objects.isNull(value)) continue;
            value = value.replaceAll("\\$", "RDS_CHAR_DOLLAR");
            sourceRichText = sourceRichText.replaceAll("\\{" + key + "}", value);
            sourceRichText = sourceRichText.replaceAll("RDS_CHAR_DOLLAR", "\\$");
        }
        return sourceRichText;
    }

    public void sendMessage(List<InterviewMailSendBean> sendMailBeanList) {
        log.info("interview send mail, total send mail size: {}", (Object)sendMailBeanList.size());
        Long curOptUserId = TSCRequestContext.getUserId();
        log.info("current opt User : {}", (Object)curOptUserId);
        for (InterviewMailSendBean sendMailBean : sendMailBeanList) {
            log.info("mail bean, role: {}, id: {}", (Object)sendMailBean.getInterviewMailRol(), (Object)sendMailBean.getId());
            String title = sendMailBean.getMailTheme();
            String content = sendMailBean.getMailContent();
            List receiver = sendMailBean.getReceiver();
            boolean allNull = false;
            if (CollectionUtils.isNotEmpty((Collection)receiver)) {
                allNull = receiver.stream().allMatch(HRStringUtils::isNotEmpty);
            }
            if (HRStringUtils.isNotEmpty((String)title) && CollectionUtils.isNotEmpty((Collection)receiver) && allNull) {
                this.sendMail(title, content, receiver);
            }
            String phone = sendMailBean.getPhone();
            String smsContent = sendMailBean.getSmsContent();
            if (!HRStringUtils.isNotEmpty((String)phone) || !HRStringUtils.isNotEmpty((String)smsContent)) continue;
            SmsModel smsModel = new SmsModel();
            smsModel.setContent(sendMailBean.getSmsContent());
            smsModel.setPhone(sendMailBean.getPhone());
            smsModel.setTitle(ResManager.loadKDString((String)"\u9762\u8bd5\u77ed\u4fe1", (String)"IntvMailCommonHelpe_0", (String)"tsc-tspr-business", (Object[])new Object[0]));
            smsModel.setOptUserId(curOptUserId);
            SmsServiceImpl.Singleton.INSTANCE.getInstance().sendSms(smsModel);
        }
    }

    public void sendMessage(List<Long> receiverId, String tag, String content) {
        MessageInfo message = new MessageInfo();
        message.setType("notice");
        message.setTitle(tag);
        message.setUserIds(receiverId);
        message.setSenderId(Long.valueOf(0L));
        message.setTag(tag);
        message.setContent(content);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public InterviewNoticeModel getInterviewNoticeModel(DynamicObject interviewEntity, InterviewMailType type) {
        InterviewNoticeModel interviewNoticeModel = new InterviewNoticeModel();
        interviewNoticeModel.setInterviewTitle(interviewEntity.getString("interviewtitle"));
        interviewNoticeModel.setInterviewOrganizationalForm(interviewEntity.getString("intvorgfrm"));
        interviewNoticeModel.setInterviewMethodId(Long.valueOf(((DynamicObject)interviewEntity.getDynamicObjectCollection("tspr_intvroundentry").get(0)).getDynamicObject("interviewmethod").getLong("id")));
        interviewNoticeModel.setInterviewMethodNumber(((DynamicObject)interviewEntity.getDynamicObjectCollection("tspr_intvroundentry").get(0)).getDynamicObject("interviewmethod").getString("number"));
        interviewNoticeModel.setInterviewMethodName(((DynamicObject)interviewEntity.getDynamicObjectCollection("tspr_intvroundentry").get(0)).getDynamicObject("interviewmethod").getString("name"));
        interviewNoticeModel.setNoticeInterviewer(interviewEntity.getBoolean("noticeinterviewer"));
        interviewNoticeModel.setEmailInterviewer(interviewEntity.getBoolean("intvchkmailsend"));
        interviewNoticeModel.setSmsInterviewer(interviewEntity.getBoolean("intvchksmssend"));
        interviewNoticeModel.setNoticeCandidate(interviewEntity.getBoolean("noticecopiedperson"));
        interviewNoticeModel.setEmailCandidate(interviewEntity.getBoolean("candchkmailsend"));
        interviewNoticeModel.setSmsCandidate(interviewEntity.getBoolean("candchksmssend"));
        interviewNoticeModel.setNoticeReceiver(interviewEntity.getBoolean("noticereceptionist"));
        interviewNoticeModel.setEmailReceiver(interviewEntity.getBoolean("recechkmailsend"));
        interviewNoticeModel.setSmsReceptionist(interviewEntity.getBoolean("recechksmssend"));
        interviewNoticeModel.setInterviewMailType(type);
        interviewNoticeModel.setInterviewerMailTheme(interviewEntity.getString("intetheme"));
        interviewNoticeModel.setInterviewerMailContent(interviewEntity.getString("txtmailinterviewer_tag"));
        interviewNoticeModel.setInterviewerSmsContent(interviewEntity.getString("sms_intv_richtext"));
        return interviewNoticeModel;
    }

    public void sendMail(String title, String content, List<String> receiver) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("email", receiver);
        messageInfo.setParams((Map)map);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static String getInterviewFormatTime(Date date, int startTime, int endTime) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (endTime > IntvDateUtil.MAX_SECOND_OF_DAY) {
            endTime -= IntvDateUtil.MAX_SECOND_OF_DAY.intValue();
        }
        LocalTime localTimeStart = LocalTime.ofSecondOfDay(startTime);
        LocalTime localTimeEnd = LocalTime.ofSecondOfDay(endTime);
        String strDate = localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        String strStartTime = localTimeStart.format(DateTimeFormatter.ofPattern("HH:mm"));
        String strEndTime = localTimeEnd.format(DateTimeFormatter.ofPattern("HH:mm"));
        int value = localDate.getDayOfWeek().getValue();
        String ch = Num2ChUtils.toCH((int)value);
        if (localTimeStart.isAfter(localTimeEnd)) {
            String strEndDate = localDate.plusDays(1L).format(DateTimeFormatter.ISO_LOCAL_DATE);
            return String.format(ResManager.loadKDString((String)"%s %s\uff08\u5468%s\uff09 - %s %s", (String)"IntvMailHelper_40", (String)"tsc-tspr-business", (Object[])new Object[0]), strDate, strStartTime, ch, strEndDate, strEndTime);
        }
        return String.format(ResManager.loadKDString((String)"%s\uff08\u5468%s\uff09 %s-%s", (String)"IntvMailHelper_41", (String)"tsc-tspr-business", (Object[])new Object[0]), strDate, ch, strStartTime, strEndTime);
    }

    public static DynamicObject getCompanyFromOrgId(Long orgId) {
        DynamicObject parentOrgByOrgId = IntvMailCommonHelper.getParentOrgByOrgId(orgId);
        if (HRObjectUtils.isEmpty((Object)parentOrgByOrgId)) {
            return null;
        }
        DynamicObject adminOrgType = parentOrgByOrgId.getDynamicObject("orgtype");
        if (HRObjectUtils.isEmpty((Object)adminOrgType)) {
            return null;
        }
        String number = adminOrgType.getString("number");
        if (HRStringUtils.isNotEmpty((String)number) && ("1010_S".equals(number) || "1020_S".equals(number))) {
            return parentOrgByOrgId;
        }
        long parentOrgId = parentOrgByOrgId.getLong("parent.id");
        if (parentOrgId == orgId) {
            return null;
        }
        return IntvMailCommonHelper.getCompanyFromOrgId(parentOrgId);
    }

    private static DynamicObject getParentOrgByOrgId(Long orgId) {
        return IntvMailHelper.SERVICE_HELPER.queryOne("orgtype,parent.id", (Object)orgId);
    }

    public static String getCompanyName(Long id) {
        DynamicObject companyFromOrgId = IntvMailCommonHelper.getCompanyFromOrgId(id);
        if (HRObjectUtils.isEmpty((Object)companyFromOrgId)) {
            companyFromOrgId = IntvMailHelper.SERVICE_HELPER.queryOne(QFilter.of((String)"parent.id = 0", (Object[])new Object[0]).toArray());
        }
        String deptName = null;
        if (HRObjectUtils.isEmpty((Object)companyFromOrgId)) {
            deptName = "";
        }
        if (companyFromOrgId != null && HRStringUtils.isNotEmpty((String)companyFromOrgId.getString("name"))) {
            deptName = companyFromOrgId.getString("name");
        }
        return deptName;
    }

    public static Map<String, String> getAdminOrgInfo(DynamicObject adminOrg) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            map.put("deptName", "");
            map.put("cmpName", "");
            return map;
        }
        String deptName = adminOrg.getString("name");
        String name = IntvMailCommonHelper.getCompanyName(adminOrg.getLong("id"));
        map.put("deptName", deptName);
        map.put("cmpName", name);
        return map;
    }

    public List<DynamicObject> getGroupInterviewList(Map<Long, DynamicObject> interviewDbMap, DynamicObjectCollection interviewerMulBase) {
        LinkedList<DynamicObject> interviewerDbObj = new LinkedList<DynamicObject>();
        for (DynamicObject next : interviewerMulBase) {
            long aLong = next.getLong("fbasedataid_id");
            DynamicObject dynamicObject = interviewDbMap.get(aLong);
            interviewerDbObj.add(dynamicObject);
        }
        return interviewerDbObj;
    }

    public List<DynamicObject> getGroupCandidateIds(DynamicObject[] candidateDbList, DynamicObjectCollection candidateEntry) {
        List interviewGroupCandidateIds = candidateEntry.stream().map(xValue -> xValue.getLong("fbasedataid_id")).collect(Collectors.toList());
        LinkedList<DynamicObject> gList = new LinkedList<DynamicObject>();
        for (DynamicObject dynamicObject : candidateDbList) {
            long aLong = dynamicObject.getLong("id");
            if (!interviewGroupCandidateIds.contains(aLong)) continue;
            gList.add(dynamicObject);
        }
        return gList;
    }

    private static class IntvMailCommonHelperHolder {
        private static final IntvMailCommonHelper INSTANCE = new IntvMailCommonHelper();

        private IntvMailCommonHelperHolder() {
        }
    }
}

