/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCancelHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tspr.common.enums.intv.InterviewMailRol;
import kd.tsc.tspr.common.enums.intv.InterviewMailType;
import org.apache.commons.collections.CollectionUtils;

public class IntvMailEditorHelper {
    public static final Log log = LogFactory.getLog(IntvMailEditorHelper.class);

    private IntvMailEditorHelper() {
    }

    public static IntvMailEditorHelper getInstance() {
        return IntvMailEditorHelperHolder.INSTANCE;
    }

    public void processEditor(DynamicObject dataEntity, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        HashMap groupUpdateMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ArgIntvUpdateResultEntity updateDataEntity : updateDataEntityList) {
            groupUpdateMap.put(updateDataEntity.getGroupId(), updateDataEntity);
        }
        ArrayList<InterviewMailSendBean> sendMailBeanList = new ArrayList<InterviewMailSendBean>();
        ArrayList<Long> delInterviewIds = new ArrayList<Long>();
        ArrayList<Long> addInterviewIds = new ArrayList<Long>();
        ArrayList<Long> noChangeInterviewIds = new ArrayList<Long>();
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            delInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdDelete());
            addInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdAdd());
            noChangeInterviewIds.addAll(argIntvUpdateResultEntity.getInterViewerIdNoChange());
        }
        long interviewId = dataEntity.getLong("id");
        DynamicObject oldDataEntity = ArgIntvHelper.INSTANCE.getIntvDataEntiry(interviewId);
        Object[] interviewTaskIds = ArgIntvHelper.findIntvTaskByArgIntvId(interviewId);
        Object[] candidateTaskId = IntvAppfileTaskHelper.getInstance().findCandidateTaskByArgIntvId(interviewId);
        InterviewNoticeModel type = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT);
        boolean timeOrAddressChange = false;
        if (timeOrAddressChange = this.isTimeOrAddressChange(updateDataEntityList, timeOrAddressChange)) {
            InterviewNoticeModel editType = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT_UPDATE);
            List<InterviewMailSendBean> interviewMailSendBeans = IntvMailHelper.getInstance().processAddNew(dataEntity, Lists.newArrayList((Object[])interviewTaskIds), Lists.newArrayList((Object[])candidateTaskId), false, type, groupUpdateMap, editType);
            this.processAddrOrTime(sendMailBeanList, noChangeInterviewIds, interviewMailSendBeans);
        }
        boolean addInterviewer = false;
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            if (!CollectionUtils.isNotEmpty(argIntvUpdateResultEntity.getInterViewerIdAdd())) continue;
            addInterviewer = true;
            break;
        }
        if (addInterviewer) {
            this.processEditorAddInterview(dataEntity, groupUpdateMap, sendMailBeanList, addInterviewIds, oldDataEntity, (DynamicObject[])interviewTaskIds, (DynamicObject[])candidateTaskId);
        }
        boolean delInterviewer = false;
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            if (!CollectionUtils.isNotEmpty(argIntvUpdateResultEntity.getInterViewerIdDelete())) continue;
            delInterviewer = true;
            break;
        }
        if (delInterviewer) {
            InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT_CANCEL_INTERVIEW);
            this.processEditorDelInterview(oldDataEntity, sendMailBeanList, delInterviewIds, interviewNoticeModel, updateDataEntityList);
        }
        IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
    }

    private boolean isTimeOrAddressChange(List<ArgIntvUpdateResultEntity> updateDataEntityList, boolean timeOrAddressChange) {
        for (ArgIntvUpdateResultEntity argIntvUpdateResultEntity : updateDataEntityList) {
            boolean time = argIntvUpdateResultEntity.isGroupIntvTimeChange();
            boolean groupAddressChange = argIntvUpdateResultEntity.isGroupAddressChange();
            boolean groupAppAddressChange = argIntvUpdateResultEntity.isGroupAppAddressChange();
            boolean groupInterviewerAddressChange = argIntvUpdateResultEntity.isGroupInterviewerAddressChange();
            if (!groupAddressChange && !time && !groupAppAddressChange && !groupInterviewerAddressChange) continue;
            timeOrAddressChange = true;
            break;
        }
        return timeOrAddressChange;
    }

    private void processEditorDelInterview(DynamicObject dataEntity, List<InterviewMailSendBean> sendMailBeanList, List<Long> delInterviewIds, InterviewNoticeModel type, List<ArgIntvUpdateResultEntity> updateDataEntityList) {
        List<InterviewMailSendBean> interviewMailSendBeans = IntvMailCancelHelper.getInstance().processCancel(Lists.newArrayList((Object[])new DynamicObject[]{dataEntity}), delInterviewIds, type, updateDataEntityList);
        for (InterviewMailSendBean interviewMailSendBean : interviewMailSendBeans) {
            if (interviewMailSendBean.getInterviewMailRol() != InterviewMailRol.INTERVIEWER || !delInterviewIds.contains(interviewMailSendBean.getId())) continue;
            sendMailBeanList.add(interviewMailSendBean);
        }
    }

    private void processEditorAddInterview(DynamicObject dataEntity, Map<Long, ArgIntvUpdateResultEntity> groupUpdateMap, List<InterviewMailSendBean> sendMailBeanList, List<Long> addInterviewIds, DynamicObject oldDataEntity, DynamicObject[] interviewTaskIds, DynamicObject[] candidateTaskId) {
        InterviewNoticeModel type = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(oldDataEntity, InterviewMailType.ADD);
        InterviewNoticeModel editType = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.EDIT_ADD_INTERVIEW);
        List<InterviewMailSendBean> interviewMailSendBeans = IntvMailHelper.getInstance().processAddNew(dataEntity, Lists.newArrayList((Object[])interviewTaskIds), Lists.newArrayList((Object[])candidateTaskId), false, type, groupUpdateMap, editType);
        for (InterviewMailSendBean interviewMailSendBean : interviewMailSendBeans) {
            if (interviewMailSendBean.getInterviewMailRol() != InterviewMailRol.INTERVIEWER || !addInterviewIds.contains(interviewMailSendBean.getId())) continue;
            sendMailBeanList.add(interviewMailSendBean);
        }
    }

    private void processAddrOrTime(List<InterviewMailSendBean> sendMailBeanList, List<Long> noChangeInterviewIds, List<InterviewMailSendBean> interviewMailSendBeans) {
        for (InterviewMailSendBean interviewMailSendBean : interviewMailSendBeans) {
            if (InterviewMailRol.INTERVIEWER == interviewMailSendBean.getInterviewMailRol()) {
                if (!noChangeInterviewIds.contains(interviewMailSendBean.getId())) continue;
                sendMailBeanList.add(interviewMailSendBean);
                continue;
            }
            sendMailBeanList.add(interviewMailSendBean);
        }
    }

    private static class IntvMailEditorHelperHolder {
        private static final IntvMailEditorHelper INSTANCE = new IntvMailEditorHelper();

        private IntvMailEditorHelperHolder() {
        }
    }
}

