/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tspr.common.enums.intv.InterviewMailRol;
import kd.tsc.tspr.common.enums.intv.InterviewMailType;
import kd.tsc.tsrbs.common.utils.Num2ChUtils;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.nodes.Document;

public class IntvMailPreviewHelper {
    public static final Log log = LogFactory.getLog(IntvMailPreviewHelper.class);

    public static InterviewMailSendBean getInterviewMailSendBean(String interviewTheme, InterviewNoticeModel noticeType, long candidateId, Document mailContentParse, String smsContent, String email, String phone) {
        InterviewMailSendBean interviewMailSendBean = new InterviewMailSendBean();
        interviewMailSendBean.setId(Long.valueOf(candidateId));
        interviewMailSendBean.setInterviewMailRol(InterviewMailRol.CANDIDATE);
        if (noticeType.isEmailCandidate()) {
            interviewMailSendBean.setMailTheme(interviewTheme);
            interviewMailSendBean.setMailContent(mailContentParse.toString());
            interviewMailSendBean.setReceiver((List)Lists.newArrayList((Object[])new String[]{email}));
        }
        if (noticeType.isSmsCandidate()) {
            interviewMailSendBean.setSmsContent(smsContent);
            interviewMailSendBean.setPhone(phone);
        }
        return interviewMailSendBean;
    }

    public void setDynamicVarMap(DynamicObject dataEntity, DynamicObject subDataEntity, Map<String, String> dynamicVarMap, String control) {
        String interviewTable = ResManager.loadKDString((String)"\u9762\u8bd5\u5b89\u6392\u8868", (String)"IntvMailHelper_45", (String)"tsc-tspr-business", (Object[])new Object[0]);
        String interviewerName = ResManager.loadKDString((String)"\u9762\u8bd5\u5b98\u59d3\u540d", (String)"IntvMailHelper_46", (String)"tsc-tspr-business", (Object[])new Object[0]);
        String candidateName = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u59d3\u540d", (String)"IntvMailHelper_47", (String)"tsc-tspr-business", (Object[])new Object[0]);
        String interviewTime = ResManager.loadKDString((String)"\u9762\u8bd5\u65f6\u95f4", (String)"IntvMailHelper_48", (String)"tsc-tspr-business", (Object[])new Object[0]);
        String interviewAddress = ResManager.loadKDString((String)"\u9762\u8bd5\u5730\u70b9", (String)"IntvMailHelper_49", (String)"tsc-tspr-business", (Object[])new Object[0]);
        String interviewVideoAddress = ResManager.loadKDString((String)"\u89c6\u9891\u9762\u8bd5\u5730\u5740", (String)"IntvMailHelper_53", (String)"tsc-tspr-business", (Object[])new Object[0]);
        this.initDynamicVarValue(dataEntity, dynamicVarMap, interviewTable, interviewerName, candidateName, interviewTime, interviewAddress);
        String intvOrgForm = dataEntity.getString("intvorgfrm");
        DynamicObject interviewMethodObj = ((DynamicObject)dataEntity.getDynamicObjectCollection("tspr_intvroundentry").get(0)).getDynamicObject("interviewmethod");
        String interviewMethod = interviewMethodObj.getString("name");
        long interviewMethodId = interviewMethodObj.getLong("id");
        StringBuilder interviewTableStr = new StringBuilder(5200);
        if ("D".equals(intvOrgForm) || "A".equals(intvOrgForm)) {
            String collect = this.putInterviewVar(subDataEntity, dynamicVarMap, interviewerName);
            if (interviewMethodId == 1040L) {
                this.videoInterview(subDataEntity, dynamicVarMap, control, interviewVideoAddress, interviewAddress);
            }
            if (interviewMethodId == 1010L) {
                String formatInterviewAddress = IntvMailCommonHelper.getFormatIntvAddress(subDataEntity);
                dynamicVarMap.put(interviewAddress, formatInterviewAddress);
            }
            String interviewTimeStr = IntvMailCommonHelper.getFormatIntvTime1(subDataEntity);
            dynamicVarMap.put(interviewTime, interviewTimeStr);
            StringBuilder oneTable = new StringBuilder(5200);
            Object[] appFile = IntvMailCommonHelper.RESUME_HELPER.queryOriginalArray(String.join((CharSequence)",", IntvMailCommonHelper.APP_FILE_FIELDS), new QFilter[]{new QFilter("id", "in", (Object)((DynamicObject)dataEntity.getDynamicObjectCollection("intvcandate").get(0)).getLong("fbasedataid_id"))});
            if (interviewMethodId == 1020L) {
                oneTable.append(String.format(ResManager.loadKDString((String)"<div>%s</div> <div>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_black\">%s</span></div><div>\u9762\u8bd5\u5b98\uff1a%s</div>", (String)"IntvMailHelper_43", (String)"tsc-tspr-business", (Object[])new Object[0]), interviewMethod, appFile[0].getString("position.name"), interviewTimeStr, collect));
            } else {
                oneTable.append(String.format(ResManager.loadKDString((String)"<div>%s</div> <div>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_black\">%s</span></div><div>\u9762\u8bd5\u5730\u70b9\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u5b98\uff1a%s</div>", (String)"IntvMailHelper_43", (String)"tsc-tspr-business", (Object[])new Object[0]), interviewMethod, appFile[0].getString("position.name"), interviewTimeStr, dynamicVarMap.get(interviewAddress), collect));
            }
            String result = IntvMailCommonHelper.getInstance().assemblyOneInterviewerTable(Lists.newArrayList((Object[])appFile), null, InterviewMailType.ADD, null);
            oneTable.append(result);
            interviewTableStr.append((CharSequence)oneTable);
        } else if ("C".equals(intvOrgForm)) {
            subDataEntity = (DynamicObject)((DynamicObject)subDataEntity.getDynamicObjectCollection("entryentity").get(0)).getDynamicObjectCollection("subentryentity").get(0);
            String formatInterviewAddress = IntvMailCommonHelper.getFormatIntvAddress(subDataEntity);
            dynamicVarMap.put(interviewAddress, formatInterviewAddress);
            String collect = this.putInterviewerGroupVar(subDataEntity, dynamicVarMap, interviewerName);
            String interviewTimeStr = IntvMailCommonHelper.getFormatIntvTime1(subDataEntity);
            dynamicVarMap.put(interviewTime, interviewTimeStr);
            StringBuilder oneTable = new StringBuilder(5200);
            DynamicObject[] appFile = this.getAppFileData(dataEntity, dynamicVarMap, interviewAddress, interviewMethod, collect, interviewTimeStr, oneTable);
            String result = IntvMailCommonHelper.getInstance().assemblyOneInterviewerTable(Lists.newArrayList((Object[])new DynamicObject[]{appFile[0]}), null, InterviewMailType.ADD, null);
            oneTable.append(result);
            interviewTableStr.append((CharSequence)oneTable);
        } else {
            DynamicObjectCollection groups = ((DynamicObject)subDataEntity.getDynamicObjectCollection("entryentity").get(0)).getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)groups)) {
                return;
            }
            subDataEntity = (DynamicObject)groups.get(0);
            String formatInterviewAddress = IntvMailCommonHelper.getFormatIntvAddress(subDataEntity);
            dynamicVarMap.put(interviewAddress, formatInterviewAddress);
            this.putInterviewVar(subDataEntity, dynamicVarMap, interviewerName);
            String interviewTimeStr = IntvMailCommonHelper.getFormatIntvTime1(subDataEntity);
            dynamicVarMap.put(interviewTime, interviewTimeStr);
            for (int k = 0; k < groups.size(); ++k) {
                this.groupData(interviewMethod, interviewTableStr, groups, k);
            }
        }
        dynamicVarMap.put(interviewTable, interviewTableStr.toString());
    }

    private String putInterviewerGroupVar(DynamicObject subDataEntity, Map<String, String> dynamicVarMap, String interviewerName) {
        String collect = subDataEntity.getDynamicObjectCollection("intver").stream().map(sub -> sub.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(","));
        dynamicVarMap.put(interviewerName, collect);
        return collect;
    }

    private String putInterviewVar(DynamicObject subDataEntity, Map<String, String> dynamicVarMap, String interviewerName) {
        String collect = subDataEntity.getDynamicObjectCollection("intver").stream().map(sub -> sub.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(","));
        dynamicVarMap.put(interviewerName, collect);
        return collect;
    }

    private void groupData(String interviewMethod, StringBuilder interviewTableStr, DynamicObjectCollection groups, int kNumber) {
        DynamicObject group = (DynamicObject)groups.get(kNumber);
        String groupName = Num2ChUtils.toCH((int)(kNumber + 1));
        String tempTime = IntvMailCommonHelper.getFormatIntvTime1(group);
        String tempAddress = IntvMailCommonHelper.getFormatIntvAddress(group);
        String collect1 = group.getDynamicObjectCollection("intver").stream().map(intver -> intver.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(","));
        ArrayList candidateIds = Lists.newArrayListWithCapacity((int)10);
        for (int i = 0; i < 20; ++i) {
            long aLong = group.getLong("groupappresid" + i);
            if (aLong == 0L || aLong == -1L) continue;
            candidateIds.add(aLong);
        }
        Object[] appFile = IntvMailCommonHelper.RESUME_HELPER.queryOriginalArray(String.join((CharSequence)",", IntvMailCommonHelper.APP_FILE_FIELDS), new QFilter[]{new QFilter("id", "in", (Object)candidateIds)});
        StringBuilder oneTable = new StringBuilder(5200);
        oneTable.append(String.format(ResManager.loadKDString((String)"<div>\u7b2c%s\u7ec4-%s</div><div>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u5730\u70b9\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u5b98\uff1a%s</div>", (String)"IntvMailHelper_42", (String)"tsc-tspr-business", (Object[])new Object[0]), groupName, interviewMethod, appFile[0].getString("position.name"), tempTime, tempAddress, collect1));
        String result = IntvMailCommonHelper.getInstance().assemblyOneInterviewerTable(Lists.newArrayList((Object[])appFile), null, InterviewMailType.ADD, null);
        oneTable.append(result);
        interviewTableStr.append((CharSequence)oneTable);
    }

    private DynamicObject[] getAppFileData(DynamicObject dataEntity, Map<String, String> dynamicVarMap, String interviewAddress, String interviewMethod, String collect, String interviewTimeStr, StringBuilder oneTable) {
        DynamicObject[] appFile = IntvMailCommonHelper.RESUME_HELPER.queryOriginalArray(String.join((CharSequence)",", IntvMailCommonHelper.APP_FILE_FIELDS), new QFilter[]{new QFilter("id", "in", (Object)((DynamicObject)dataEntity.getDynamicObjectCollection("intvcandate").get(0)).getLong("fbasedataid_id"))});
        oneTable.append(String.format(ResManager.loadKDString((String)"<div>%s</div> <div>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_black\">%s</span></div><div>\u9762\u8bd5\u5730\u70b9\uff1a<span class=\"emphasis_black\">%s</span></div> <div>\u9762\u8bd5\u5b98\uff1a%s</div>", (String)"IntvMailHelper_43", (String)"tsc-tspr-business", (Object[])new Object[0]), interviewMethod, appFile[0].getString("position.name"), interviewTimeStr, dynamicVarMap.get(interviewAddress), collect));
        return appFile;
    }

    private void videoInterview(DynamicObject subDataEntity, Map<String, String> dynamicVarMap, String control, String interviewVideoAddress, String interviewAddress) {
        if (control.contains("intv")) {
            String string = subDataEntity.getString("intvervedioaddress");
            dynamicVarMap.put(interviewVideoAddress, string);
            dynamicVarMap.put(interviewAddress, string);
        } else {
            String string1 = subDataEntity.getString("candatevedioaddress");
            dynamicVarMap.put(interviewVideoAddress, string1);
            dynamicVarMap.put(interviewAddress, string1);
        }
    }

    private void initDynamicVarValue(DynamicObject dataEntity, Map<String, String> dynamicVarMap, String interviewTable, String interviewerName, String candidateName, String interviewTime, String interviewAddress) {
        dynamicVarMap.put(interviewTable, " ");
        dynamicVarMap.put(interviewerName, " ");
        String candidateNameVar = ((DynamicObject)dataEntity.getDynamicObjectCollection("intvcandate").get(0)).getDynamicObject("fbasedataid").getString("name");
        dynamicVarMap.put(candidateName, candidateNameVar);
        dynamicVarMap.put(interviewTime, " ");
    }

    private IntvMailPreviewHelper() {
    }

    public static IntvMailPreviewHelper getInstance() {
        return IntvMailPreviewHelperHolder.INSTANCE;
    }

    private static class IntvMailPreviewHelperHolder {
        private static final IntvMailPreviewHelper INSTANCE = new IntvMailPreviewHelper();

        private IntvMailPreviewHelperHolder() {
        }
    }
}

