/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.intvmail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailHelper;
import kd.tsc.tspr.business.domain.intv.service.urge.IntvUrgeAppAnswerEntity;
import kd.tsc.tspr.business.domain.intv.service.urge.IntvUrgeIntvevlEntity;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailParam;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewMailSendBean;
import kd.tsc.tspr.common.entity.intv.intvmail.InterviewNoticeModel;
import kd.tsc.tspr.common.enums.intv.InterviewMailType;
import kd.tsc.tspr.common.util.IntvMailUtils;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class IntvMailUrgedHelper {
    public static final Log log = LogFactory.getLog(IntvMailUrgedHelper.class);

    private IntvMailUrgedHelper() {
    }

    public static IntvMailUrgedHelper getInstance() {
        return IntvMailUrgedHelperHolder.INSTANCE;
    }

    public void processTransfer(DynamicObjectCollection intvTasks, DynamicObject passedPerson) {
        log.info("interview transfer passPerson : {}", (Object)passedPerson);
        ArrayList intvTaskList = Lists.newArrayList((Iterable)intvTasks);
        Long intvId = ((DynamicObject)intvTasks.get(0)).getDynamicObject("argintv").getLong("id");
        DynamicObject dataEntity = ArgIntvHelper.getInstance().getIntvDataEntiry(intvId);
        DynamicObject[] interviewDbjList = IntvMailCommonHelper.getInterViewDbList(dataEntity);
        Map<String, String> variableInfo = IntvMailCommonHelper.getVariableInfo(dataEntity);
        DynamicObject[] candidateDbList = IntvMailHelper.getInstance().getCandidateDbArray(dataEntity);
        LinkedList<InterviewMailSendBean> sendMailBeanList = new LinkedList<InterviewMailSendBean>();
        InterviewNoticeModel interviewNoticeModel = IntvMailCommonHelper.getInstance().getInterviewNoticeModel(dataEntity, InterviewMailType.ADD);
        InterviewMailParam param = new InterviewMailParam(dataEntity, interviewDbjList, variableInfo, interviewNoticeModel, null);
        List<InterviewMailSendBean> interviewerMailSendBeans = IntvMailCommonHelper.getInstance().processInterviewerMail(param, intvTaskList, candidateDbList, null, null, null);
        for (InterviewMailSendBean interviewerMailSendBean : interviewerMailSendBeans) {
            Long interviewerId = interviewerMailSendBean.getId();
            if (interviewerId == null || !interviewerId.equals(passedPerson.getLong("id"))) continue;
            sendMailBeanList.add(interviewerMailSendBean);
        }
        String string = dataEntity.getString("interviewtitle");
        String theme = ResManager.loadKDString((String)"\u8f6c\u4ea4\u9762\u8bd5\u901a\u77e5\uff1a", (String)"IntvMailHelper_27", (String)"tsc-tspr-business", (Object[])new Object[0]) + string;
        for (InterviewMailSendBean interviewMailSendBean : sendMailBeanList) {
            interviewMailSendBean.setMailTheme(theme);
        }
        IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
    }

    public void processCandidateReply(List<IntvUrgeAppAnswerEntity> intvUrgeAppAnswers) {
        ArrayList sendMailBeanList = Lists.newArrayListWithCapacity((int)10);
        String mailTemplate = ResManager.loadKDString((String)"<p>\u60a8\u6709\u4e00\u4e2a\u9762\u8bd5\u5b89\u6392\u5c1a\u672a\u7b54\u590d\uff0c\u8bf7\u70b9\u51fb<span class='emphasis_blue'>\u53f3\u4e0a\u89d2</span>\u7b54\u590d\u6309\u94ae\u786e\u8ba4\u662f\u5426\u53c2\u52a0\u9762\u8bd5</p><p>\u8be6\u7ec6\u9762\u8bd5\u4fe1\u606f\u5982\u4e0b</p><p>\u804c\u4f4d\u540d\u79f0\uff1a<span class=\"emphasis_black\">%s</span></p><p>\u9762\u8bd5\u65f6\u95f4\uff1a<span class=\"emphasis_black\">%s</span></p><p class='remove_tag'>\u9762\u8bd5\u5730\u70b9\uff1a<span class=\"emphasis_black\">%s</span></p><p>\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb%s\uff1a%s</p><p style=\"text-align: right;\">%s</p><p style=\"text-align: right;\">%s</p>", (String)"IntvMailHelper_1", (String)"tsc-tspr-business", (Object[])new Object[0]);
        String smsTemplate = ResManager.loadKDString((String)"%s\uff0c\u60a8\u597d\uff1a\n%s\u7684\u9762\u8bd5\u5b89\u6392\u60a8\u5c1a\u672a\u7b54\u590d\uff0c\u8bf7\u524d\u5f80\u90ae\u4ef6\u53ca\u65f6\u7b54\u590d\n\u9762\u8bd5\u65f6\u95f4\uff1a%s\n\u9762\u8bd5\u5730\u70b9\uff1a%s\n\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb%s:%s\n", (String)"IntvMailHelper_1", (String)"tsc-tspr-business", (Object[])new Object[0]);
        for (IntvUrgeAppAnswerEntity intvUrgeAppAnswer : intvUrgeAppAnswers) {
            String smsContent;
            Document parse = Jsoup.parse((String)"<!DOCTYPE html><html><head><title></title><style>a:link,a:visited{text-decoration:none;color:#5582F3}body{margin:2px 0px;line-height:140%;overflow-wrap:break-word}.emphasis_black{color:#000;font-weight:bold}.emphasis_blue{color:#5582F3;font-weight:bold}.emphasis_red{color:red;font-weight:bold}a.replay_a{float:right;height:32px;line-height:32px;background:#5582F3;border-radius:2px;display:block;text-decoration:none;font-size:14px;outline:none;color:white;width:88px;text-align:center}.float_right{float:right}.tbl_candidate{text-align:left;border:1px solid#CCCCCC;font-size:12px;margin:18px auto;width:100%}.interview_table{margin-top:12px}.tbl_candidate tr td{width:12.5%;border-right:1px solid#CCCCCC}</style></head><body><div style=\"font-size: 14px;width: 90%;color:#333333;border-radius: 8px;overflow: hidden;box-shadow: 2px 5px 14px 5px rgba(0, 0, 0, 0.1);margin: auto;\"><div id=\"business_type\"style=\"height:54px;background: linear-gradient(225deg, #55E2EE 0%, #437FEC 100%);line-height: 54px;padding-left:30px;font-size: 18px;color: #fff;font-weight: bold;\"></div><div style=\"padding: 20px 30px;background: #fff\"><div id='header'></div><div id='main_content'></div><div id='footer'></div></div></div></body></html>");
            String headerStr = "<span id='intv_name_sender'></span><a href=\"#\" class='replay_a'id='replay_a'></a>";
            Document intvHeader = Jsoup.parse((String)headerStr);
            intvHeader.getElementById("intv_name_sender").appendText(String.format(Locale.ROOT, "%s\uff0c\u60a8\u597d", intvUrgeAppAnswer.getAppfileName()));
            HashMap param = Maps.newHashMapWithExpectedSize((int)16);
            param.put("userId", "Guest");
            param.put("phone", EncryptionDecryptUtil.getEncryptStr((Object)intvUrgeAppAnswer.getAppfilePhone()));
            param.put("appfileTaskId", String.valueOf(intvUrgeAppAnswer.getAppfileTaskId()));
            String formDetailUrl = IntvMailUtils.getFormDetailUrl((String)"tssrm_answer", (Map)param);
            intvHeader.getElementById("replay_a").attr("href", formDetailUrl).appendText(ResManager.loadKDString((String)"\u7b54\u590d", (String)"IntvMailHelper_28", (String)"tsc-tspr-business", (Object[])new Object[0]));
            parse.getElementById("header").append(intvHeader.toString());
            String busType = ResManager.loadKDString((String)"\u9762\u8bd5\u9080\u8bf7\u7b54\u590d", (String)"IntvMailHelper_25", (String)"tsc-tspr-business", (Object[])new Object[0]);
            parse.getElementById("business_type").appendText(busType);
            parse.getElementById("main_content").html(String.format(mailTemplate, intvUrgeAppAnswer.getPositionName(), intvUrgeAppAnswer.getIntvTime(), intvUrgeAppAnswer.getIntvLocation(), intvUrgeAppAnswer.getInterviewArrangerName(), intvUrgeAppAnswer.getInterviewArrangerContact(), LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE), intvUrgeAppAnswer.getCompanyName()));
            String intvLocation = intvUrgeAppAnswer.getIntvLocation();
            if (intvUrgeAppAnswer.getIntvMethod() == 1040L) {
                intvLocation = ResManager.loadKDString((String)"\u8bf7\u5728\u90ae\u4ef6\u4e2d\u67e5\u9605\u89c6\u9891\u9762\u8bd5\u5730\u5740", (String)"IntvMailHelper_29", (String)"tsc-tspr-business", (Object[])new Object[0]);
            }
            if (intvUrgeAppAnswer.getIntvMethod() == 1020L) {
                parse.getElementsByClass("remove_tag").remove();
                String smsTemplate1 = ResManager.loadKDString((String)"%s\uff0c\u60a8\u597d\uff1a\n%s\u7684\u9762\u8bd5\u5b89\u6392\u60a8\u5c1a\u672a\u7b54\u590d\uff0c\u8bf7\u524d\u5f80\u90ae\u4ef6\u53ca\u65f6\u7b54\u590d\n\u9762\u8bd5\u65f6\u95f4\uff1a%s\n\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb%s:%s\n", (String)"IntvMailHelper_1", (String)"tsc-tspr-business", (Object[])new Object[0]);
                smsContent = String.format(smsTemplate1, intvUrgeAppAnswer.getAppfileName(), intvUrgeAppAnswer.getPositionName(), intvUrgeAppAnswer.getIntvTime(), intvUrgeAppAnswer.getInterviewArrangerName(), intvUrgeAppAnswer.getInterviewArrangerContact());
            } else {
                smsContent = String.format(smsTemplate, intvUrgeAppAnswer.getAppfileName(), intvUrgeAppAnswer.getPositionName(), intvUrgeAppAnswer.getIntvTime(), intvLocation, intvUrgeAppAnswer.getInterviewArrangerName(), intvUrgeAppAnswer.getInterviewArrangerContact());
            }
            InterviewMailSendBean interviewMailSendBean = new InterviewMailSendBean(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u9762\u8bd5\u901a\u77e5\u5c1a\u672a\u7b54\u590d", (String)"IntvMailHelper_30", (String)"tsc-tspr-business", (Object[])new Object[0]), intvUrgeAppAnswer.getCompanyName()), parse.toString(), smsContent, intvUrgeAppAnswer.getAppfilePhone(), (List)Lists.newArrayList((Object[])new String[]{intvUrgeAppAnswer.getAppfileEmail()}));
            sendMailBeanList.add(interviewMailSendBean);
        }
        IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
    }

    /*
     * WARNING - void declaration
     */
    public void processInterviewEval(List<IntvUrgeIntvevlEntity> intvUrgeAppAnswers) {
        void var13_19;
        log.info("urge eval size: {}", (Object)intvUrgeAppAnswers.size());
        ArrayList sendMailBeanList = Lists.newArrayListWithCapacity((int)10);
        String mailTemplate = ResManager.loadKDString((String)"<p>\u60a8\u7684\u9762\u8bd5\u5c1a\u672a\u8bc4\u4ef7\uff0c\u8bf7\u5173\u6ce8\u8bc4\u4ef7\u4efb\u52a1\u5217\u8868\uff0c\u53ca\u65f6\u5904\u7406</p>", (String)"IntvMailHelper_31", (String)"tsc-tspr-business", (Object[])new Object[0]);
        List appFileIds = intvUrgeAppAnswers.stream().map(IntvUrgeIntvevlEntity::getAppfileId).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", appFileIds);
        DynamicObject[] appFile = IntvMailCommonHelper.RESUME_HELPER.queryOriginalArray(String.join((CharSequence)",", IntvMailCommonHelper.APP_FILE_FIELDS), filter.toArray());
        LinkedHashMap candidateDbMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : appFile) {
            candidateDbMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        List intvIDs = intvUrgeAppAnswers.stream().map(IntvUrgeIntvevlEntity::getInterViewerId).collect(Collectors.toList());
        DynamicObject[] interviewDbjList = IntvMailHelper.USER_HELPER.query("id,name,email,phone", new QFilter[]{new QFilter("id", "in", intvIDs)});
        LinkedHashMap interviewDbMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObject[] dynamicObjectArray = interviewDbjList;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var13_19 < n) {
            DynamicObject intvObj = dynamicObjectArray[var13_19];
            interviewDbMap.put(intvObj.getLong("id"), intvObj);
            ++var13_19;
        }
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (IntvUrgeIntvevlEntity intvUrgeIntvevlEntity : intvUrgeAppAnswers) {
            long curInterviewId = intvUrgeIntvevlEntity.getInterViewerId();
            Long appfileId = intvUrgeIntvevlEntity.getAppfileId();
            List longs = (List)linkedHashMap.get(curInterviewId);
            if (CollectionUtils.isNotEmpty((Collection)longs)) {
                longs.add(appfileId);
                continue;
            }
            linkedHashMap.put(curInterviewId, Lists.newArrayList((Object[])new Long[]{appfileId}));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            this.buildInterviewerMail(intvUrgeAppAnswers, sendMailBeanList, mailTemplate, candidateDbMap, interviewDbMap, entry);
        }
        IntvMailCommonHelper.getInstance().sendMessage(sendMailBeanList);
    }

    private void buildInterviewerMail(List<IntvUrgeIntvevlEntity> intvUrgeAppAnswers, List<InterviewMailSendBean> sendMailBeanList, String mailTemplate, Map<Long, DynamicObject> candidateDbMap, Map<Long, DynamicObject> interviewDbMap, Map.Entry<Long, List<Long>> longListEntry) {
        Long intvId = longListEntry.getKey();
        List<Long> value = longListEntry.getValue();
        ArrayList candidateTableList = Lists.newArrayListWithCapacity((int)10);
        for (Long aLong : value) {
            DynamicObject dynamicObject = candidateDbMap.get(aLong);
            candidateTableList.add(dynamicObject);
        }
        String table = IntvMailCommonHelper.getInstance().assemblyOneInterviewerTable(candidateTableList, Lists.newArrayListWithCapacity((int)0), InterviewMailType.URGE_EVALUATION, null);
        Document parse = Jsoup.parse((String)"<!DOCTYPE html><html><head><title></title><style>a:link,a:visited{text-decoration:none;color:#5582F3}body{margin:2px 0px;line-height:140%;overflow-wrap:break-word}.emphasis_black{color:#000;font-weight:bold}.emphasis_blue{color:#5582F3;font-weight:bold}.emphasis_red{color:red;font-weight:bold}a.replay_a{float:right;height:32px;line-height:32px;background:#5582F3;border-radius:2px;display:block;text-decoration:none;font-size:14px;outline:none;color:white;width:88px;text-align:center}.float_right{float:right}.tbl_candidate{text-align:left;border:1px solid#CCCCCC;font-size:12px;margin:18px auto;width:100%}.interview_table{margin-top:12px}.tbl_candidate tr td{width:12.5%;border-right:1px solid#CCCCCC}</style></head><body><div style=\"font-size: 14px;width: 90%;color:#333333;border-radius: 8px;overflow: hidden;box-shadow: 2px 5px 14px 5px rgba(0, 0, 0, 0.1);margin: auto;\"><div id=\"business_type\"style=\"height:54px;background: linear-gradient(225deg, #55E2EE 0%, #437FEC 100%);line-height: 54px;padding-left:30px;font-size: 18px;color: #fff;font-weight: bold;\"></div><div style=\"padding: 20px 30px;background: #fff\"><div id='header'></div><div id='main_content'></div><div id='footer'></div></div></div></body></html>");
        String headerStr = "<span id='intv_name_sender'></span><a href=\"#\" class='replay_a'id='replay_a'></a>";
        Document intvHeader = Jsoup.parse((String)headerStr);
        intvHeader.getElementById("intv_name_sender").appendText(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff0c\u60a8\u597d", (String)"IntvMailHelper_32", (String)"tsc-tspr-business", (Object[])new Object[0]), interviewDbMap.get(intvId).getString("name")));
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        param.put("intverid", String.valueOf(intvId));
        String detailUrl = IntvMailUtils.getListUrl((String)"tsivp_intvevl", (Map)param);
        intvHeader.getElementById("replay_a").attr("href", detailUrl).appendText(ResManager.loadKDString((String)"\u53bb\u8bc4\u4ef7", (String)"IntvMailHelper_17", (String)"tsc-tspr-business", (Object[])new Object[0]));
        parse.getElementById("header").append(intvHeader.toString());
        String busType = ResManager.loadKDString((String)"\u50ac\u4fc3\u9762\u8bd5\u8bc4\u4ef7", (String)"IntvMailHelper_24", (String)"tsc-tspr-business", (Object[])new Object[0]);
        parse.getElementById("business_type").appendText(busType);
        parse.getElementById("main_content").html(mailTemplate + table);
        String mailContent = IntvMailCommonHelper.getMailContent(parse);
        String evlTitlte = ResManager.loadKDString((String)"\u9762\u8bd5\u8bc4\u4ef7\u50ac\u4fc3", (String)"IntvMailHelper_26", (String)"tsc-tspr-business", (Object[])new Object[0]);
        InterviewMailSendBean interviewMailSendBean = new InterviewMailSendBean(evlTitlte, mailContent, (List)Lists.newArrayList((Object[])new String[]{interviewDbMap.get(intvId).getString("email")}));
        sendMailBeanList.add(interviewMailSendBean);
    }

    private static class IntvMailUrgedHelperHolder {
        private static final IntvMailUrgedHelper INSTANCE = new IntvMailUrgedHelper();

        private IntvMailUrgedHelperHolder() {
        }
    }
}

