/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.intvupdate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvTaskChangeEntity;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateIntvTaskEntity;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateIntvelEntity;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateParamEntity;
import kd.tsc.tspr.business.domain.intv.service.intvupdate.ArgIntvUpdateResultEntity;

public class ArgIntvUpdateHelper {
    private static final Log logger = LogFactory.getLog(ArgIntvUpdateHelper.class);
    private static final int MAPCOUNT = 10;

    private ArgIntvUpdateHelper() {
    }

    public static List<ArgIntvUpdateResultEntity> getIntvChange(ArgIntvUpdateParamEntity argIntvUpParamm) {
        ArrayList<ArgIntvUpdateResultEntity> resIntvTasks = new ArrayList<ArgIntvUpdateResultEntity>(10);
        if (argIntvUpParamm != null) {
            DynamicObjectCollection groupsOld = ArgIntvUpdateHelper.getGroupsByIntvId(argIntvUpParamm.getArgIntvId());
            DynamicObjectCollection groupsNew = ((DynamicObject)argIntvUpParamm.getRoundsNew().get(0)).getDynamicObjectCollection("tspr_intvgroupentry");
            if (groupsOld != null && !groupsOld.isEmpty()) {
                for (DynamicObject dynamicObject : groupsOld) {
                    Long oldGroupId = dynamicObject.getLong("id");
                    DynamicObject newGroupDO = ArgIntvUpdateHelper.getNewGroupDO(oldGroupId, groupsNew);
                    List<DynamicObject> groupTasks = ArgIntvUpdateHelper.getGroupTasks(oldGroupId, argIntvUpParamm.getIntvTasksOld());
                    List<DynamicObject> groupIntvs = ArgIntvUpdateHelper.groupIntvs(oldGroupId, argIntvUpParamm.getIntvelsOld());
                    DynamicObjectCollection roundsNew = argIntvUpParamm.getRoundsNew();
                    if (Objects.isNull(newGroupDO) || roundsNew == null || roundsNew.isEmpty()) continue;
                    ArgIntvUpdateResultEntity groupChanges = ArgIntvUpdateHelper.getGroupChange(dynamicObject, newGroupDO, groupTasks, groupIntvs, (DynamicObject)roundsNew.get(0), argIntvUpParamm.getAppfileTaskDOs());
                    resIntvTasks.add(groupChanges);
                }
            }
        }
        return resIntvTasks;
    }

    public static DynamicObject removeGroupNoChangeInterViewer(DynamicObject groupCopy, List<ArgIntvUpdateResultEntity> argChangeRes) {
        Long groupCopyId = groupCopy.getLong("id");
        DynamicObjectCollection interViewers = groupCopy.getDynamicObjectCollection("intver");
        List<Object> noChangeIntverIds = new ArrayList();
        for (ArgIntvUpdateResultEntity argChangeRe : argChangeRes) {
            if (!argChangeRe.getGroupId().equals(groupCopyId) || ArgIntvUpdateHelper.checkGroupTimeOrAddressChange(argChangeRe)) continue;
            noChangeIntverIds = argChangeRe.getInterViewerIdNoChange();
        }
        DynamicObjectCollection deleteInterViewers = new DynamicObjectCollection();
        for (DynamicObject interViewer : interViewers) {
            if (!noChangeIntverIds.contains(interViewer.getLong("fbasedataid_id"))) continue;
            deleteInterViewers.add((Object)interViewer);
        }
        groupCopy.getDynamicObjectCollection("intver").removeAll((Collection)deleteInterViewers);
        return groupCopy;
    }

    public static DynamicObject[] getDeleteIntvTask(List<ArgIntvUpdateResultEntity> argChangeRes) {
        ArrayList<DynamicObject> deleteIntvTasksList = new ArrayList<DynamicObject>();
        for (ArgIntvUpdateResultEntity argChangeRe : argChangeRes) {
            if (argChangeRe.getInterViewerIdDelete().size() > 0) {
                List<ArgIntvUpdateIntvTaskEntity> argInterviewerTasks = argChangeRe.getArgInterviewerTasks();
                deleteIntvTasksList.addAll(ArgIntvUpdateHelper.getIntvelTasksByChangeTyppe(argInterviewerTasks, "Delete"));
            }
            if (!ArgIntvUpdateHelper.checkGroupTimeOrAddressChange(argChangeRe)) continue;
            List<ArgIntvUpdateIntvTaskEntity> argIntvTaskList = argChangeRe.getArgInterviewerTasks();
            deleteIntvTasksList.addAll(ArgIntvUpdateHelper.getIntvelTasksByChangeTyppe(argIntvTaskList, "NoChange"));
        }
        return deleteIntvTasksList.toArray(new DynamicObject[0]);
    }

    public static ArgIntvTaskChangeEntity getIntvTaskChange(List<ArgIntvUpdateResultEntity> argChangeRes) {
        ArgIntvTaskChangeEntity argIntvTaskChangeEntity = new ArgIntvTaskChangeEntity();
        ArrayList deleteIntvTasksDeleteList = Lists.newArrayListWithExpectedSize((int)argChangeRes.size());
        ArrayList deleteIntvTasksTimeChangeList = Lists.newArrayListWithExpectedSize((int)argChangeRes.size());
        for (ArgIntvUpdateResultEntity argChangeRe : argChangeRes) {
            if (argChangeRe.getInterViewerIdDelete().size() > 0) {
                List<ArgIntvUpdateIntvTaskEntity> argInterviewerTasks = argChangeRe.getArgInterviewerTasks();
                deleteIntvTasksDeleteList.addAll(ArgIntvUpdateHelper.getIntvelTasksByChangeTyppe(argInterviewerTasks, "Delete"));
            }
            if (!ArgIntvUpdateHelper.checkGroupTimeOrAddressChange(argChangeRe)) continue;
            List<ArgIntvUpdateIntvTaskEntity> argIntvTaskList = argChangeRe.getArgInterviewerTasks();
            deleteIntvTasksTimeChangeList.addAll(ArgIntvUpdateHelper.getIntvelTasksByChangeTyppe(argIntvTaskList, "NoChange"));
        }
        argIntvTaskChangeEntity.setIntvTasksDelete(deleteIntvTasksDeleteList);
        argIntvTaskChangeEntity.setIntvelTasksChange(deleteIntvTasksTimeChangeList);
        return argIntvTaskChangeEntity;
    }

    public static List<DynamicObject> getIntvelTasksByChangeTyppe(List<ArgIntvUpdateIntvTaskEntity> argIntvelTasks, String changeType) {
        ArrayList<DynamicObject> intvelTasks = new ArrayList<DynamicObject>(argIntvelTasks.size());
        for (ArgIntvUpdateIntvTaskEntity argIntvelTask : argIntvelTasks) {
            if (!argIntvelTask.getChangeType().equals(changeType)) continue;
            intvelTasks.add(argIntvelTask.getIntvTaskDO());
        }
        return intvelTasks;
    }

    public static void updateIntvTasks(ArgIntvTaskChangeEntity argIntvTaskChange) {
        DynamicObject[] intvTasksDelete;
        DynamicObject[] intvTasksUpdate;
        for (DynamicObject dynamicObject : intvTasksUpdate = argIntvTaskChange.getIntvelTasksChange().toArray(new DynamicObject[0])) {
            dynamicObject.set("taskstatus", (Object)"E");
            dynamicObject.set("enable", (Object)"0");
        }
        for (DynamicObject dynamicObject : intvTasksDelete = argIntvTaskChange.getIntvTasksDelete().toArray(new DynamicObject[0])) {
            dynamicObject.set("taskstatus", (Object)"C");
            dynamicObject.set("enable", (Object)"0");
        }
        IntvTaskHelper.getInstance().updateTasks(intvTasksUpdate);
        IntvTaskHelper.getInstance().updateTasks(intvTasksDelete);
    }

    public static void resetIntvTasks(DynamicObject[] intvTasks) {
        for (DynamicObject intvTask : intvTasks) {
            intvTask.set("taskstatus", (Object)"A");
            intvTask.set("interveranswer", (Object)"A");
        }
        IntvTaskHelper.getInstance().updateTasks(intvTasks);
    }

    public static void resetAppTasks(DynamicObject[] appTasks) {
        for (DynamicObject appTask : appTasks) {
            appTask.set("applicationanswer", (Object)"A");
            appTask.set("signinstatus", (Object)"A");
        }
        IntvAppfileTaskHelper.getInstance().updateTasks(appTasks);
    }

    public static void updateIntvels(DynamicObject[] intvels) {
        for (DynamicObject intvel : intvels) {
            intvel.set("handlestatus", (Object)"C");
            intvel.set("enable", (Object)"0");
        }
        IntvEvlHelper.getInstance().updateIntvevls(intvels);
    }

    public static void resetTask(List<ArgIntvUpdateResultEntity> argChangeRes) {
        ArrayList<DynamicObject> timeOrAddressChangeAppTaskList = new ArrayList<DynamicObject>();
        for (ArgIntvUpdateResultEntity argChangeRe : argChangeRes) {
            if (!ArgIntvUpdateHelper.checkGroupTimeOrAddressChange(argChangeRe)) continue;
            timeOrAddressChangeAppTaskList.addAll(argChangeRe.getGroupAppFileTasks());
        }
        ArgIntvUpdateHelper.resetAppTasks(timeOrAddressChangeAppTaskList.toArray(new DynamicObject[0]));
    }

    public static List<DynamicObject> getTimeOrAddressChangeIntvTasks(List<ArgIntvUpdateResultEntity> argChangeRes) {
        return new ArrayList<DynamicObject>();
    }

    public static boolean checkGroupTimeOrAddressChange(ArgIntvUpdateResultEntity argChangeObj) {
        boolean changeOrNot = argChangeObj.isGroupIntvTimeChange() || argChangeObj.isGroupAddressChange() || argChangeObj.isGroupAppAddressChange() || argChangeObj.isGroupInterviewerAddressChange();
        return changeOrNot;
    }

    public static DynamicObject[] getDeleteIntvels(List<ArgIntvUpdateResultEntity> argChangeRes) {
        ArrayList<DynamicObject> deleteIntvelList = new ArrayList<DynamicObject>();
        for (ArgIntvUpdateResultEntity argChangeRe : argChangeRes) {
            if (argChangeRe.getInterViewerIdDelete().size() > 0) {
                List<ArgIntvUpdateIntvelEntity> argIntvIntvelList = argChangeRe.getArgIntvIntvels();
                deleteIntvelList.addAll(ArgIntvUpdateHelper.getIntvDeleteIntvelelByTaskList(argIntvIntvelList, "Delete"));
            }
            if (!ArgIntvUpdateHelper.checkGroupTimeOrAddressChange(argChangeRe)) continue;
            deleteIntvelList.addAll(ArgIntvUpdateHelper.getIntvDeleteIntvelelByTaskList(argChangeRe.getArgIntvIntvels(), "NoChange"));
        }
        return deleteIntvelList.toArray(new DynamicObject[0]);
    }

    public static List<DynamicObject> getIntvDeleteIntvelelByTaskList(List<ArgIntvUpdateIntvelEntity> argIntvIntvels, String changeType) {
        ArrayList<DynamicObject> intvDeleteIntvelTasks = new ArrayList<DynamicObject>();
        for (ArgIntvUpdateIntvelEntity argIntvIntvel : argIntvIntvels) {
            if (!argIntvIntvel.getChangeType().equals(changeType)) continue;
            intvDeleteIntvelTasks.add(argIntvIntvel.getIntvelDO());
        }
        return intvDeleteIntvelTasks;
    }

    public static DynamicObject getNewGroupDO(Long oldGroupId, DynamicObjectCollection groupsNew) {
        DynamicObject groupNewDO = null;
        for (DynamicObject dynamicObject : groupsNew) {
            if (dynamicObject.getLong("id") != oldGroupId.longValue()) continue;
            groupNewDO = dynamicObject;
        }
        return groupNewDO;
    }

    public static List<DynamicObject> getGroupTasks(Long groupId, DynamicObject[] intvTasksOld) {
        return Arrays.stream(intvTasksOld).filter(dynamicObject -> dynamicObject.getDynamicObject("intvgroup").getLong("id") == groupId.longValue()).collect(Collectors.toCollection(() -> new ArrayList(10)));
    }

    public static List<DynamicObject> groupIntvs(Long groupId, DynamicObject[] intvelsOld) {
        ArrayList<DynamicObject> groupIntvs = new ArrayList<DynamicObject>(10);
        for (DynamicObject dynamicObject : intvelsOld) {
            if (dynamicObject.getDynamicObject("intvgroup").getLong("id") != groupId.longValue()) continue;
            groupIntvs.add(dynamicObject);
        }
        return groupIntvs;
    }

    public static ArgIntvUpdateResultEntity getGroupChange(DynamicObject groupOld, DynamicObject groupNew, List<DynamicObject> groupTasks, List<DynamicObject> groupIntvs, DynamicObject roundDO, DynamicObject[] appfileTaskDOs) {
        ArgIntvUpdateResultEntity groupChange = new ArgIntvUpdateResultEntity();
        Long groupId = groupNew.getLong("id");
        List<Long> interViewerIdsOld = ArgIntvUpdateHelper.getInterViewerIdsByGroup(groupOld);
        List<Long> interViewerIdsNew = ArgIntvUpdateHelper.getInterViewerIdsByGroup(groupNew);
        List<Long> interViewerIdNoChange = ArgIntvUpdateHelper.getListRetainAll(interViewerIdsOld, interViewerIdsNew);
        List<Long> interViewerIdAdd = ArgIntvUpdateHelper.getListRemoveAll(interViewerIdsNew, interViewerIdsOld);
        List<Long> interViewerIdDelete = ArgIntvUpdateHelper.getListRemoveAll(interViewerIdsOld, interViewerIdsNew);
        groupChange.setNewGroupDO(groupNew);
        groupChange.setOldGroupDO(groupOld);
        groupChange.setGroupId(groupId);
        groupChange.setInterViewerIdNoChange(interViewerIdNoChange);
        groupChange.setInterViewerIdAdd(interViewerIdAdd);
        groupChange.setInterViewerIdDelete(interViewerIdDelete);
        groupChange.setGroupAppFileTasks(ArgIntvUpdateHelper.getGroupAppfileTaskDOs(groupId, appfileTaskDOs));
        ArrayList<ArgIntvUpdateIntvTaskEntity> argIntvUpdateIntvTasks = new ArrayList<ArgIntvUpdateIntvTaskEntity>(10);
        ArrayList<ArgIntvUpdateIntvelEntity> argIntvUpdateIntvels = new ArrayList<ArgIntvUpdateIntvelEntity>(10);
        for (DynamicObject groupTask : groupTasks) {
            Long interViewerId = groupTask.getDynamicObject("interviewer").getLong("id");
            Long taskId = groupTask.getLong("id");
            Long taskGroupId = groupTask.getDynamicObject("intvgroup").getLong("id");
            String taskChangeType = ArgIntvUpdateHelper.getTaskChangeType(interViewerIdNoChange, interViewerIdAdd, interViewerIdDelete, interViewerId);
            ArgIntvUpdateIntvTaskEntity argIntvUpdateIntvTask = ArgIntvUpdateHelper.setArgIntvUpdateIntvTask(groupTask, taskChangeType, interViewerId, taskGroupId);
            argIntvUpdateIntvTasks.add(argIntvUpdateIntvTask);
            List<ArgIntvUpdateIntvelEntity> argIntvUpdateIntvelTask = ArgIntvUpdateHelper.setArgIntvUpdateIntvel(taskId, taskChangeType, groupIntvs, taskGroupId);
            argIntvUpdateIntvels.addAll(argIntvUpdateIntvelTask);
        }
        for (Long aLong : interViewerIdAdd) {
            ArgIntvUpdateIntvTaskEntity argIntvUpdateIntvTaskNew = new ArgIntvUpdateIntvTaskEntity();
            argIntvUpdateIntvTaskNew.setIntvTaskDO(null);
            argIntvUpdateIntvTaskNew.setGroupId(groupNew.getLong("id"));
            argIntvUpdateIntvTaskNew.setIntvTaskId(null);
            argIntvUpdateIntvTaskNew.setInterviewerId(aLong);
            argIntvUpdateIntvTaskNew.setChangeType("Add");
            argIntvUpdateIntvTasks.add(argIntvUpdateIntvTaskNew);
        }
        groupChange.setArgInterviewerTasks(argIntvUpdateIntvTasks);
        groupChange.setArgIntvIntvels(argIntvUpdateIntvels);
        DynamicObject intvMethod = roundDO.getDynamicObject("interviewmethod");
        groupChange.setIntvMethod(intvMethod);
        if (intvMethod.getLong("id") == 1040L) {
            groupChange.setGroupAppAddressChange(ArgIntvUpdateHelper.checkGroupAppAddressChange(groupOld, groupNew));
            groupChange.setGroupInterviewerAddressChange(ArgIntvUpdateHelper.checkGroupInterviewerAddressChange(groupOld, groupNew));
        } else {
            groupChange.setGroupAddressChange(ArgIntvUpdateHelper.checkGroupAddressChange(groupOld, groupNew));
        }
        groupChange.setGroupIntvTimeChange(ArgIntvUpdateHelper.checkGroupIntvTimeChange(groupOld, groupNew));
        return groupChange;
    }

    public static List<DynamicObject> getGroupAppfileTaskDOs(Long groupId, DynamicObject[] intvAppfileTaskDOs) {
        ArrayList<DynamicObject> groupAppfileTaskDOs = new ArrayList<DynamicObject>(intvAppfileTaskDOs.length);
        for (DynamicObject intvAppfileTaskDO : intvAppfileTaskDOs) {
            Long taskGroupId = intvAppfileTaskDO.getDynamicObject("INTVGROUP").getLong("id");
            if (!groupId.equals(taskGroupId)) continue;
            groupAppfileTaskDOs.add(intvAppfileTaskDO);
        }
        return groupAppfileTaskDOs;
    }

    public static ArgIntvUpdateIntvTaskEntity setArgIntvUpdateIntvTask(DynamicObject intvTask, String taskChangeType, Long interViewerId, Long taskGroupId) {
        ArgIntvUpdateIntvTaskEntity argIntvUpdateIntvTask = new ArgIntvUpdateIntvTaskEntity();
        argIntvUpdateIntvTask.setIntvTaskDO(intvTask);
        argIntvUpdateIntvTask.setGroupId(taskGroupId);
        argIntvUpdateIntvTask.setIntvTaskId(intvTask.getLong("id"));
        argIntvUpdateIntvTask.setInterviewerId(interViewerId);
        argIntvUpdateIntvTask.setChangeType(taskChangeType);
        return argIntvUpdateIntvTask;
    }

    public static List<ArgIntvUpdateIntvelEntity> setArgIntvUpdateIntvel(Long taskId, String taskChangeType, List<DynamicObject> groupIntvs, Long groupId) {
        ArrayList<ArgIntvUpdateIntvelEntity> argIntvUpdateIntvels = new ArrayList<ArgIntvUpdateIntvelEntity>();
        for (DynamicObject groupIntv : groupIntvs) {
            if (taskId.longValue() != groupIntv.getDynamicObject("INTVTASK").getLong("id")) continue;
            ArgIntvUpdateIntvelEntity argIntvUpdateIntvel = new ArgIntvUpdateIntvelEntity();
            argIntvUpdateIntvel.setIntvelDO(groupIntv);
            argIntvUpdateIntvel.setGroupId(groupId);
            argIntvUpdateIntvel.setTaskId(taskId);
            argIntvUpdateIntvel.setIntvelId(groupIntv.getLong("id"));
            argIntvUpdateIntvel.setChangeType(taskChangeType);
            argIntvUpdateIntvels.add(argIntvUpdateIntvel);
        }
        return argIntvUpdateIntvels;
    }

    public static boolean checkGroupIntvTimeChange(DynamicObject groupOld, DynamicObject groupNew) {
        String newIntvTime;
        String oldIntvTime = IntvMailCommonHelper.getFormatIntvTime(groupOld);
        return !HRStringUtils.equals((String)oldIntvTime, (String)(newIntvTime = IntvMailCommonHelper.getFormatIntvTime(groupNew)));
    }

    public static boolean checkGroupAppAddressChange(DynamicObject groupOld, DynamicObject groupNew) {
        return !HRStringUtils.equals((String)groupOld.getString("candatevedioaddress"), (String)groupNew.getString("candatevedioaddress"));
    }

    public static boolean checkGroupInterviewerAddressChange(DynamicObject groupOld, DynamicObject groupNew) {
        return !HRStringUtils.equals((String)groupOld.getString("intvervedioaddress"), (String)groupNew.getString("intvervedioaddress"));
    }

    public static boolean checkGroupAddressChange(DynamicObject groupOld, DynamicObject groupNew) {
        String intvAddressNew;
        boolean res = false;
        String cityOld = groupOld.getString("admindivision");
        String locationOld = groupOld.getString("interviewlocation");
        String roomOld = groupOld.getString("interviewroom");
        String cityNew = groupNew.getString("admindivision");
        String locationNew = groupNew.getString("interviewlocation");
        String roomNew = groupNew.getString("interviewroom");
        String intvAddressOld = cityOld + locationOld + roomOld;
        if (!intvAddressOld.equals(intvAddressNew = cityNew + locationNew + roomNew)) {
            res = true;
        }
        return res;
    }

    public static String getTaskChangeType(List<Long> interViewerIdNoChange, List<Long> interViewerIdAdd, List<Long> interViewerIdDelete, Long interViewerId) {
        String changeType = "";
        if (interViewerIdNoChange.contains(interViewerId)) {
            changeType = "NoChange";
        }
        if (interViewerIdAdd.contains(interViewerId)) {
            changeType = "Add";
        }
        if (interViewerIdDelete.contains(interViewerId)) {
            changeType = "Delete";
        }
        return changeType;
    }

    public static List<Long> getListRetainAll(List<Long> ListOne, List<Long> ListTwo) {
        ArrayList<Long> resListA = new ArrayList<Long>(10);
        ArrayList<Long> resListB = new ArrayList<Long>(10);
        if (ListOne != null && ListTwo != null) {
            resListA.addAll(ListOne);
            resListB.addAll(ListTwo);
            resListA.retainAll(resListB);
        }
        return resListA;
    }

    public static List<Long> getListRemoveAll(List<Long> ListOne, List<Long> ListTwo) {
        ArrayList<Long> resListA = new ArrayList<Long>();
        if (ListOne != null && ListTwo != null) {
            resListA.addAll(ListOne);
            ArrayList<Long> resListB = new ArrayList<Long>(ListTwo);
            resListA.removeAll(resListB);
        }
        return resListA;
    }

    public static DynamicObjectCollection getGroupsByIntvId(Long argIntvId) {
        DynamicObject interview = ArgIntvHelper.selectById(argIntvId, "tspr_argintv");
        DynamicObjectCollection intvRounds = interview.getDynamicObjectCollection("tspr_intvroundentry");
        if (intvRounds == null || intvRounds.isEmpty() || intvRounds.get(0) == null) {
            logger.error("rounds business object is null,argIntvId: {}", (Object)argIntvId);
            return null;
        }
        return ((DynamicObject)intvRounds.get(0)).getDynamicObjectCollection("tspr_intvgroupentry");
    }

    public static List<Long> getInterViewerIdsByGroup(DynamicObject group) {
        DynamicObjectCollection interViewers = group.getDynamicObjectCollection("intver");
        List interViewerIds = interViewers.stream().map(interViewer -> interViewer.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toCollection(() -> new ArrayList(10)));
        return interViewerIds;
    }

    public static DynamicObject[] getIntvIntvels(Long intvId) {
        QFilter qFilterEvl = new QFilter("argintv", "=", (Object)intvId).and("interviewstatus", "=", (Object)"A");
        return IntvEvlHelper.getInstance().getIntvEvls(qFilterEvl);
    }

    public static DynamicObject[] getAppfileTasks(Long intvId) {
        QFilter qFilter = new QFilter("argintv", "=", (Object)intvId);
        return IntvAppfileTaskHelper.getInstance().getAppfileTasks(qFilter);
    }

    public static long[] getGroupAppfileTaskIds(DynamicObject[] appfileTaskDOs, DynamicObjectCollection tsrbsGroupCandates, boolean isAddNew) {
        ArrayList<Long> appfileTaskIds = new ArrayList<Long>();
        if (isAddNew) {
            long[] longAppfileTaskIds = ID.genLongIds((int)tsrbsGroupCandates.size());
            return longAppfileTaskIds;
        }
        for (DynamicObject tsrbsGroupCandate : tsrbsGroupCandates) {
            for (DynamicObject appfileTaskDO : appfileTaskDOs) {
                Long appfileIdFromGroupCandates;
                Long appfileIdFromTask = appfileTaskDO.getDynamicObject("application").getLong("id");
                if (!appfileIdFromTask.equals(appfileIdFromGroupCandates = Long.valueOf(tsrbsGroupCandate.getDynamicObject("fbasedataid").getLong("id")))) continue;
                appfileTaskIds.add(appfileTaskDO.getLong("id"));
            }
        }
        long[] longAppfileTaskIds = appfileTaskIds.stream().mapToLong(Long::longValue).toArray();
        return longAppfileTaskIds;
    }
}

