/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.oprecord;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.common.enums.oprecord.ORStructText;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class IntvORBasicService {
    private static final Log logger = LogFactory.getLog(IntvORBasicService.class);

    public static IntvORBasicService getInstance() {
        return Instance.INTV_OR_BASIC_SERVICE;
    }

    private IntvORBasicService() {
    }

    public OprecordMessageModel getOpRecordModel(String operatorName, DynamicObject resume, OpDefEnum opDefEnum, String opText) {
        OprecordMessageModel model = new OprecordMessageModel();
        model.setOperator(Long.valueOf(RequestContext.get().getCurrUserId()));
        model.setOperatorname(operatorName);
        model.setBizobjname(resume.getString("name"));
        model.setBizentry("tspr_appfile");
        model.setBizobj(resume.getLong("id"));
        model.setOpnumber(opDefEnum.getCode());
        model.setOptime(DateUtils.nowDateTime());
        model.setOprtext(opText);
        logger.info("IntvORBasicService.sendStdRsmOpRecord.model:{}", (Object)model);
        return model;
    }

    public String getORStructText(ORStructText orStructText, Object ... values) {
        String text = orStructText.getText();
        return String.format(text, values);
    }

    public void sendStdRsmOpRecord(List<OprecordMessageModel> modelList) {
        try {
            OprecordMQ.sendOpRecordChangeMessage(modelList);
        }
        catch (KDException exception) {
            logger.error("sendStdRsm error:", (Throwable)exception);
        }
    }

    private static class Instance {
        private static final IntvORBasicService INTV_OR_BASIC_SERVICE = new IntvORBasicService();

        private Instance() {
        }
    }
}

