/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.oprecord;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tspr.business.domain.intv.service.oprecord.IntvORBasicService;
import kd.tsc.tspr.common.enums.oprecord.ORStructText;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.EvalResultEnum;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class IntvOpRecordService {
    private static final Log logger = LogFactory.getLog(IntvOpRecordService.class);
    private final IntvORBasicService intvORBasicService = IntvORBasicService.getInstance();

    public static IntvOpRecordService getInstance() {
        return Instance.INTV_OP_RECORD_SERVICE;
    }

    private IntvOpRecordService() {
    }

    public void intvCommonOR(List<DynamicObject> candates, OpDefEnum opDefEnum, ORStructText orStructText, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject candate : candates) {
            String candateName = candate.getString("name");
            String opText = this.intvORBasicService.getORStructText(orStructText, RequestContext.get().getUserName(), candateName, title);
            modelList.add(this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), candate, opDefEnum, opText));
        }
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void cancelIntvOR(List<DynamicObject> appFileTaskList, OpDefEnum opDefEnum, ORStructText orStructText) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : appFileTaskList) {
            DynamicObject application = dynamicObject.getDynamicObject("application");
            String candateName = application.getString("name");
            String interviewtitle = dynamicObject.getDynamicObject("argintv").getString("interviewtitle");
            String opText = this.intvORBasicService.getORStructText(orStructText, RequestContext.get().getUserName(), candateName, interviewtitle);
            modelList.add(this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), application, opDefEnum, opText));
        }
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public OprecordMessageModel getHastenReplyOM(DynamicObject appFile, String title) {
        String candateName = appFile.getString("name");
        String opText = this.intvORBasicService.getORStructText(ORStructText.HASTEN_REPLY_INTV, RequestContext.get().getUserName(), candateName, title);
        return this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), appFile, OpDefEnum.HASTEN_REPLY_INTV, opText);
    }

    public void signInOR(DynamicObject dynamicObject, String title, String status) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String opText = this.intvORBasicService.getORStructText(ORStructText.SIGN_IN_INTV, dynamicObject.getString("name"), title, status);
        modelList.add(this.intvORBasicService.getOpRecordModel(dynamicObject.getString("name"), dynamicObject, OpDefEnum.SIGN_IN_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void modifyCommonOR(DynamicObject dynamicObject, String status, OpDefEnum opDefEnum, ORStructText orStructText, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        String opText = this.intvORBasicService.getORStructText(orStructText, RequestContext.get().getUserName(), candateName, title, status);
        modelList.add(this.intvORBasicService.getOpRecordModel(RequestContext.get().getUserName(), dynamicObject, opDefEnum, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void autoPathOR(DynamicObject dynamicObject, String status, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        String opText = this.intvORBasicService.getORStructText(ORStructText.GENERAL_EVA_INTV_AUTO, candateName, title, status);
        modelList.add(this.intvORBasicService.getOpRecordModel("\u7cfb\u7edf", dynamicObject, OpDefEnum.GENERAL_EVA_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void replyAcceptOR(DynamicObject dynamicObject, String title) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        String opText = this.intvORBasicService.getORStructText(ORStructText.REPLY_INTV, candateName, title, "\u53c2\u52a0");
        modelList.add(this.intvORBasicService.getOpRecordModel(candateName, dynamicObject, OpDefEnum.REPLY_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void replyRefuseOR(DynamicObject dynamicObject, DynamicObjectCollection refusereson, String refusalcause, String title) {
        String reasons;
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        String candateName = dynamicObject.getString("name");
        StringBuilder stringBuilder = new StringBuilder();
        if (null == refusalcause || refusalcause.length() == 0) {
            for (DynamicObject rdy : refusereson) {
                String reason = rdy.getDynamicObject("fbasedataid").getString("description");
                stringBuilder.append(reason);
                stringBuilder.append("\uff1b");
            }
            reasons = stringBuilder.substring(0, stringBuilder.toString().length() - 1);
        } else {
            for (DynamicObject rdy : refusereson) {
                String reason = rdy.getDynamicObject("fbasedataid").getString("description");
                if (reason.equals("\u5176\u4ed6\u539f\u56e0\u4e0d\u80fd\u53c2\u52a0")) continue;
                stringBuilder.append(reason);
                stringBuilder.append("\uff1b");
            }
            stringBuilder.append("\u5176\u4ed6\u539f\u56e0\u4e0d\u80fd\u53c2\u52a0\uff0c");
            stringBuilder.append(refusalcause);
            reasons = stringBuilder.toString();
        }
        String opText = this.intvORBasicService.getORStructText(ORStructText.REPLY_INTV_OTHER, candateName, title, "\u4e0d\u53c2\u52a0", reasons);
        modelList.add(this.intvORBasicService.getOpRecordModel(candateName, dynamicObject, OpDefEnum.REPLY_INTV, opText));
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    public void intvOp(List<DynamicObject> objectList) {
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)objectList.size());
        objectList.forEach(intvevl -> {
            DynamicObject affFile = intvevl.getDynamicObject("application");
            String appFileName = affFile.getString("name");
            String evaluator = TSCRequestContext.getUserName();
            String interviewerName = intvevl.getDynamicObject("interviewer").getString("name");
            String intvRsl = EvalResultEnum.valuesOf((String)intvevl.getString("intvevlrslt"));
            String intvTitle = intvevl.getDynamicObject("argintv").getString("interviewtitle");
            long interviewerID = intvevl.getDynamicObject("interviewer").getLong("id");
            String opText = "";
            opText = TSCRequestContext.getUserId() == interviewerID ? this.intvORBasicService.getORStructText(ORStructText.EVALUATE_INTV, interviewerName, appFileName, intvTitle, intvRsl) : this.intvORBasicService.getORStructText(ORStructText.ALTERNATIVE_EVA_INTV, evaluator, interviewerName, appFileName, intvTitle, intvRsl);
            modelList.add(this.intvORBasicService.getOpRecordModel(evaluator, affFile, OpDefEnum.EVALUATE_INTV, opText));
            logger.info("interviewerID:{}", (Object)interviewerID);
        });
        this.intvORBasicService.sendStdRsmOpRecord(modelList);
    }

    private static class Instance {
        private static final IntvOpRecordService INTV_OP_RECORD_SERVICE = new IntvOpRecordService();

        private Instance() {
        }
    }
}

