/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.urge;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntervEvalHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailUrgedHelper;
import kd.tsc.tspr.business.domain.intv.service.oprecord.IntvORBasicService;
import kd.tsc.tspr.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tspr.business.domain.intv.service.urge.IntvUrgeAppAnswerEntity;
import kd.tsc.tspr.business.domain.intv.service.urge.IntvUrgeIntvevlEntity;
import kd.tsc.tspr.business.domain.intv.service.urge.IntvUrgeResultEntity;
import kd.tsc.tspr.common.util.IntvDateUtil;
import org.apache.commons.lang3.StringUtils;

public class IntvUrgeHelper {
    private static final Log logger = LogFactory.getLog(IntvUrgeHelper.class);

    public static IntvUrgeResultEntity urgeIntvevl(List<Long> appfileTaskIds) {
        IntvUrgeResultEntity urgRes = new IntvUrgeResultEntity();
        ArrayList<IntvUrgeIntvevlEntity> urgeIntvevlObjAll = new ArrayList<IntvUrgeIntvevlEntity>();
        ArrayList<Long> urgeAppfileTaskIds = new ArrayList<Long>();
        urgRes = IntvUrgeHelper.checkUrgeNum(appfileTaskIds, 200);
        if (!urgRes.isUtgeCheckRes()) {
            return urgRes;
        }
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks(appfileTaskIds);
        int notStart = 0;
        int alreadyUrge = 0;
        int alreadyProcess = 0;
        for (int i = 0; i < appfileTasks.length; ++i) {
            DynamicObject appfileTask = appfileTasks[i];
            DynamicObject application = appfileTask.getDynamicObject("application");
            String applicationName = application.getString("name");
            if (StringUtils.isNotEmpty((CharSequence)appfileTask.getString("intvevlstatus")) || !"A".equals(appfileTask.getString("taskstatus"))) {
                ++alreadyProcess;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add("\u50ac\u4fc3\u5931\u8d25\uff0c" + applicationName + "\u9762\u8bd5\u5df2\u7ed3\u675f\uff01");
                continue;
            }
            if (IntvUrgeHelper.checkIntvTimeEqNow(appfileTask)) {
                ++notStart;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(applicationName + "\u7684\u9762\u8bd5\u5c1a\u672a\u5f00\u59cb\uff0c\u4e0d\u53ef\u50ac\u4fc3\u8bc4\u4ef7\uff01");
                continue;
            }
            if (!IntvUrgeHelper.checkUrgeDayCount("urgeintvevltime", appfileTask)) {
                ++alreadyUrge;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(applicationName + "\u4eca\u5929\u5df2\u50ac\u4fc3\u8fc7\u8bc4\u4ef7\uff01");
                continue;
            }
            List<IntvUrgeIntvevlEntity> urgeIntvevlObj = IntvUrgeHelper.getUrgeInterviewerIds(appfileTask);
            if (urgeIntvevlObj.size() == 0) {
                ++alreadyProcess;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(applicationName + "\u9762\u8bd5\u5b98\u5df2\u5904\u7406\u8bc4\u4ef7\uff01");
                continue;
            }
            urgRes.utgeCheckSuccessName.add(applicationName);
            urgeIntvevlObjAll.addAll(urgeIntvevlObj);
            urgeAppfileTaskIds.add(appfileTask.getLong("id"));
        }
        if (urgRes.utgeCheckFailName.size() == appfileTaskIds.size()) {
            urgRes.setUtgeCheckRes(false);
            urgRes.setShowTitileMessage(IntvUrgeHelper.setShowTitileMessage(notStart, alreadyUrge, alreadyProcess));
            return urgRes;
        }
        IntvUrgeHelper.sendUrgeIntvevlMaile(urgeIntvevlObjAll);
        IntvUrgeHelper.sendUrgeIntvevlSysMessage(urgeIntvevlObjAll);
        IntvUrgeHelper.updateUrgeTime("urgeintvevltime", urgeAppfileTaskIds);
        return urgRes;
    }

    private static String setShowTitileMessage(int notStart, int alreadyUrge, int alreadyProcess) {
        ArrayList<String> messageList = new ArrayList<String>();
        if (0 != notStart) {
            messageList.add(String.valueOf(notStart).concat("\u4eba\u7684\u9762\u8bd5\u5c1a\u672a\u5f00\u59cb"));
        }
        if (0 != alreadyUrge) {
            messageList.add(String.valueOf(alreadyUrge).concat("\u4eba\u4eca\u5929\u5df2\u50ac\u4fc3\u8fc7\u9762\u8bd5\u5b98\u8bc4\u4ef7"));
        }
        if (0 != alreadyProcess) {
            messageList.add(String.valueOf(alreadyProcess).concat("\u4eba\u9762\u8bd5\u5b98\u5df2\u5904\u7406\u8bc4\u4ef7"));
        }
        return Joiner.on((String)",").join(messageList);
    }

    public static void sendUrgeIntvevlMaile(List<IntvUrgeIntvevlEntity> intvUrgeIntvevls) {
        IntvMailUrgedHelper.getInstance().processInterviewEval(intvUrgeIntvevls);
    }

    public static void sendUrgeIntvevlSysMessage(List<IntvUrgeIntvevlEntity> intvUrgeIntvevls) {
        String tag = ResManager.loadKDString((String)"\u9762\u8bd5\u8bc4\u4ef7\u50ac\u4fc3", (String)"IntvAnswerEdit_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        List<IntvUrgeIntvevlEntity> convertMessageObjs = IntvUrgeHelper.convertMessageObj(intvUrgeIntvevls);
        for (IntvUrgeIntvevlEntity intvUrgeIntvevl : convertMessageObjs) {
            String content = ResManager.loadKDString((String)String.format("\u60a8\u7684%s\u9762\u8bd5\u5c1a\u672a\u8bc4\u4ef7\uff0c\u8bf7\u5173\u6ce8\u4efb\u52a1\u5217\u8868\uff0c\u53ca\u65f6\u5904\u7406", intvUrgeIntvevl.getAppfileName()), (String)"IntvAnswerEdit_5", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
            IntvMailCommonHelper.getInstance().sendMessage(Lists.newArrayList((Object[])new Long[]{intvUrgeIntvevl.getInterViewerId()}), tag, content);
        }
    }

    public static List<IntvUrgeIntvevlEntity> convertMessageObj(List<IntvUrgeIntvevlEntity> intvUrgeIntvevls) {
        List<IntvUrgeIntvevlEntity> convertMessageObjs = new ArrayList<IntvUrgeIntvevlEntity>(10);
        for (IntvUrgeIntvevlEntity intvUrgeIntvevl : intvUrgeIntvevls) {
            Long interViewerId = intvUrgeIntvevl.getInterViewerId();
            boolean checkConvertMessageObjHaveOrNot = IntvUrgeHelper.checkConvertMessageObjHaveOrNot(interViewerId, convertMessageObjs);
            convertMessageObjs = IntvUrgeHelper.convertMessageObjs(checkConvertMessageObjHaveOrNot, intvUrgeIntvevl, convertMessageObjs);
        }
        return convertMessageObjs;
    }

    public static boolean checkConvertMessageObjHaveOrNot(Long interViewerId, List<IntvUrgeIntvevlEntity> convertMessageObjs) {
        boolean res = false;
        for (IntvUrgeIntvevlEntity convertMessageObj : convertMessageObjs) {
            if (!convertMessageObj.getInterViewerId().equals(interViewerId)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static List<IntvUrgeIntvevlEntity> convertMessageObjs(boolean haveOrNot, IntvUrgeIntvevlEntity intvUrgeIntvevl, List<IntvUrgeIntvevlEntity> convertMessageObjs) {
        if (haveOrNot) {
            for (IntvUrgeIntvevlEntity convertMessageObj : convertMessageObjs) {
                if (!convertMessageObj.getInterViewerId().equals(intvUrgeIntvevl.getInterViewerId())) continue;
                String appfileName = convertMessageObj.getAppfileName() + "," + intvUrgeIntvevl.getAppfileName();
                convertMessageObj.setAppfileName(appfileName);
            }
        } else {
            convertMessageObjs.add(intvUrgeIntvevl);
        }
        return convertMessageObjs;
    }

    public static List<IntvUrgeIntvevlEntity> getUrgeInterviewerIds(DynamicObject appfileTask) {
        ArrayList<IntvUrgeIntvevlEntity> intvUrgeIntvevls = new ArrayList<IntvUrgeIntvevlEntity>();
        DynamicObject application = appfileTask.getDynamicObject("application");
        Long applicationId = application.getLong("id");
        DynamicObject group = appfileTask.getDynamicObject("intvgroup");
        Long groupId = group.getLong("id");
        DynamicObject argIntv = appfileTask.getDynamicObject("argintv");
        Long argIntvId = argIntv.getLong("id");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filters = new QFilter("intvgroup", "=", (Object)groupId).and("application", "=", (Object)applicationId).and(enableFilter).and("handlestatus", "=", (Object)"A");
        String fields = String.join((CharSequence)",", "application", "interviewstatus", "handlestatus", "interviewer");
        DynamicObject[] intvevlInfos = IntvEvlHelper.getInstance().queryIntvEvl(fields, filters, "interviewevaluationtime ASC");
        if (intvevlInfos.length > 0) {
            for (int i = 0; i < intvevlInfos.length; ++i) {
                IntvUrgeIntvevlEntity intvUrgeIntvevl = new IntvUrgeIntvevlEntity();
                intvUrgeIntvevl.setAppfileTaskId(appfileTask.getLong("id"));
                intvUrgeIntvevl.setAppfileId(applicationId);
                intvUrgeIntvevl.setAppfileName(application.getString("name"));
                intvUrgeIntvevl.setInterViewerId(intvevlInfos[i].getDynamicObject("interviewer").getLong("id"));
                intvUrgeIntvevl.setIntvevlId(intvevlInfos[i].getLong("id"));
                intvUrgeIntvevl.setArgIntvId(argIntvId);
                intvUrgeIntvevl.setGroupId(groupId);
                intvUrgeIntvevls.add(intvUrgeIntvevl);
            }
        }
        return intvUrgeIntvevls;
    }

    public static IntvUrgeResultEntity urgeAppAnswer(List<Long> appfileTaskIds) {
        IntvUrgeResultEntity urgRes = new IntvUrgeResultEntity();
        ArrayList<IntvUrgeAppAnswerEntity> intvUrgeAppAnswers = new ArrayList<IntvUrgeAppAnswerEntity>();
        ArrayList<Long> urgeAppfileTaskIds = new ArrayList<Long>();
        urgRes = IntvUrgeHelper.checkUrgeNum(appfileTaskIds, 200);
        if (!urgRes.isUtgeCheckRes()) {
            return urgRes;
        }
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks(appfileTaskIds);
        DynamicObject[] appfilePoitions = IntvUrgeHelper.getAppfilePostions(appfileTasks);
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)16);
        int endIntv = 0;
        int alreadyApply = 0;
        int notProcessing = 0;
        int alreadyUrge = 0;
        for (int i = 0; i < appfileTasks.length; ++i) {
            DynamicObject appfileTask = appfileTasks[i];
            DynamicObject application = appfileTask.getDynamicObject("application");
            String applicationName = application.getString("name");
            if (!IntvUrgeHelper.checkIntvTimeEqNow(appfileTask)) {
                ++endIntv;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(applicationName + "\u7684\u9762\u8bd5\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u50ac\u4fc3\uff01");
                continue;
            }
            if (!IntvUrgeHelper.checkAppAnswerState(appfileTask)) {
                ++alreadyApply;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(applicationName + "\u5df2\u7b54\u590d\uff01 ");
                continue;
            }
            if (!IntvUrgeHelper.checkAppTaskState(appfileTask)) {
                ++notProcessing;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(applicationName + "\u9762\u8bd5\u8fdb\u5ea6\u4e0d\u5728\u8fdb\u884c\u4e2d\uff01");
                continue;
            }
            if (!IntvUrgeHelper.checkUrgeDayCount("urgeanswertime", appfileTask)) {
                ++alreadyUrge;
                urgRes.utgeCheckFailName.add(applicationName);
                urgRes.showMessages.add(applicationName + "\u4eca\u5929\u5df2\u50ac\u4fc3\u8fc7\u7b54\u590d\uff01");
                continue;
            }
            urgRes.utgeCheckSuccessName.add(applicationName);
            intvUrgeAppAnswers.add(IntvUrgeHelper.getIntvUrgeAppAnswerObj(appfileTask, appfilePoitions));
            urgeAppfileTaskIds.add(appfileTask.getLong("id"));
            modelList.add(IntvOpRecordService.getInstance().getHastenReplyOM(application, appfileTask.getDynamicObject("argintv").getString("interviewtitle")));
        }
        if (urgRes.utgeCheckFailName.size() == appfileTaskIds.size()) {
            urgRes.setUtgeCheckRes(false);
            urgRes.setShowTitileMessage(IntvUrgeHelper.setShowTitileMessage(endIntv, alreadyApply, notProcessing, alreadyUrge));
            return urgRes;
        }
        IntvUrgeHelper.sendUrgeAppAnswerMaile(intvUrgeAppAnswers);
        IntvUrgeHelper.updateUrgeTime("urgeanswertime", urgeAppfileTaskIds);
        IntvORBasicService.getInstance().sendStdRsmOpRecord(modelList);
        return urgRes;
    }

    private static String setShowTitileMessage(int endIntv, int alreadyApply, int notProcessing, int alreadyUrge) {
        ArrayList<String> messageList = new ArrayList<String>();
        if (0 != endIntv) {
            messageList.add(String.valueOf(endIntv).concat("\u4eba\u9762\u8bd5\u5df2\u7ed3\u675f"));
        }
        if (0 != alreadyApply) {
            messageList.add(String.valueOf(alreadyApply).concat("\u4eba\u5df2\u7b54\u590d"));
        }
        if (0 != notProcessing) {
            messageList.add(String.valueOf(notProcessing).concat("\u4eba\u9762\u8bd5\u8fdb\u5ea6\u4e0d\u5728\u8fdb\u884c\u4e2d"));
        }
        if (0 != alreadyUrge) {
            messageList.add(String.valueOf(alreadyUrge).concat("\u4eba\u4eca\u5929\u5df2\u50ac\u4fc3\u8fc7\u7b54\u590d"));
        }
        return Joiner.on((String)",").join(messageList);
    }

    public static DynamicObject[] getAppfilePostions(DynamicObject[] appfileTasks) {
        DynamicObject[] appfilePostions = null;
        ArrayList<Long> positionIds = new ArrayList<Long>(appfileTasks.length);
        for (int i = 0; i < appfileTasks.length; ++i) {
            Long positionId = appfileTasks[i].getDynamicObject("application").getDynamicObject("position").getLong("id");
            positionIds.add(positionId);
        }
        appfilePostions = IntvAppfileTaskHelper.getInstance().getPositions(positionIds);
        return appfilePostions;
    }

    public static void sendUrgeAppAnswerMaile(List<IntvUrgeAppAnswerEntity> intvUrgeAppAnswers) {
        IntvMailUrgedHelper.getInstance().processCandidateReply(intvUrgeAppAnswers);
    }

    public static void sendUrgeAppAnswerTextMessage(List<IntvUrgeAppAnswerEntity> intvUrgeAppAnswers) {
    }

    public static void updateUrgeTime(String upField, List<Long> urgeAppfileTaskIds) {
        DynamicObject[] appfileTasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks(urgeAppfileTaskIds);
        for (int i = 0; i < appfileTasks.length; ++i) {
            appfileTasks[i].set(upField, (Object)new Date());
        }
        IntvAppfileTaskHelper.getInstance().updateTasks(appfileTasks);
    }

    public static IntvUrgeAppAnswerEntity getIntvUrgeAppAnswerObj(DynamicObject appfileTask, DynamicObject[] appfilePositions) {
        IntvUrgeAppAnswerEntity intvUrgeAppAnswer = new IntvUrgeAppAnswerEntity();
        DynamicObject application = appfileTask.getDynamicObject("application");
        DynamicObject group = appfileTask.getDynamicObject("intvgroup");
        DynamicObject argIntv = appfileTask.getDynamicObject("argintv");
        DynamicObject appPosition = null;
        Long intvMethod = 0L;
        Long interviewArrangerId = 0L;
        String interviewArrangerName = "";
        String interviewArrangerContact = "";
        String interViewLocation = "";
        Long applicationId = 0L;
        String applicationName = "";
        String positionName = "";
        String intvTime = "";
        String applicationPhone = "";
        String applicationEmail = "";
        String companyName = "";
        DynamicObject argintvDb = null;
        if (null != argIntv) {
            argintvDb = ArgIntvHelper.getInstance().getIntvDataEntiry(argIntv.getLong("id"));
            interviewArrangerId = argIntv.getDynamicObject("interviewarranger").getLong("id");
            interviewArrangerName = argIntv.getDynamicObject("interviewarranger").getString("name");
            interviewArrangerContact = UserServiceHelper.getUserInfoByID((long)interviewArrangerId).get("phone").toString();
        }
        if (group != null) {
            intvTime = IntvDateUtil.getIntvDate((Date)group.getDate("intvdate")) + " " + IntvDateUtil.formatTime((Long)group.getLong("intvstarttime"), (String)"HH:mm");
            String admindivision = group.getString("admindivision");
            String location = group.getString("interviewlocation");
            String room = group.getString("interviewroom");
            String adminDivisionName = IntervEvalHelper.getAdminDivisionName(admindivision);
            interViewLocation = adminDivisionName + location + room;
            if (null != argintvDb) {
                intvMethod = ((DynamicObject)argintvDb.getDynamicObjectCollection("tspr_intvroundentry").get(0)).getDynamicObject("interviewmethod").getLong("id");
                DynamicObject interviewMethod = ((DynamicObject)argintvDb.getDynamicObjectCollection("tspr_intvroundentry").get(0)).getDynamicObject("interviewmethod");
                long id = interviewMethod.getLong("id");
                if (id == 1040L) {
                    interViewLocation = group.getString("candatevedioaddress");
                }
            }
        }
        if (application != null) {
            applicationId = application.getLong("id");
            applicationName = application.getString("name");
            appPosition = application.getDynamicObject("position");
            applicationPhone = application.getString("phone");
            applicationEmail = application.getString("email");
        }
        if (appPosition != null) {
            positionName = appPosition.getString("name");
            companyName = IntvUrgeHelper.getCompanyName(appPosition.getLong("id"), appfilePositions);
        }
        intvUrgeAppAnswer.setAppfileTaskId(appfileTask.getString("id"));
        intvUrgeAppAnswer.setAppfileId(applicationId);
        intvUrgeAppAnswer.setAppfileName(applicationName);
        intvUrgeAppAnswer.setAppfilePhone(applicationPhone);
        intvUrgeAppAnswer.setAppfileEmail(applicationEmail);
        intvUrgeAppAnswer.setCompanyName(companyName);
        intvUrgeAppAnswer.setPositionName(positionName);
        intvUrgeAppAnswer.setIntvTime(intvTime);
        intvUrgeAppAnswer.setIntvMethod(intvMethod);
        intvUrgeAppAnswer.setIntvLocation(interViewLocation);
        intvUrgeAppAnswer.setInterviewArrangerId(interviewArrangerId);
        intvUrgeAppAnswer.setInterviewArrangerName(interviewArrangerName);
        intvUrgeAppAnswer.setInterviewArrangerContact(interviewArrangerContact);
        return intvUrgeAppAnswer;
    }

    public static String getCompanyName(Long positionId, DynamicObject[] appfilePosition) {
        String companyName = "";
        for (int i = 0; i < appfilePosition.length; ++i) {
            if (appfilePosition[i].getLong("id") != positionId.longValue() || appfilePosition[i].getDynamicObject("adminorg") == null) continue;
            Long adminOrgId = appfilePosition[i].getDynamicObject("adminorg").getLong("id");
            companyName = IntvMailCommonHelper.getCompanyName(adminOrgId);
        }
        return companyName;
    }

    public static boolean checkUrgeDayCount(String checkField, DynamicObject appfileTask) {
        boolean res = false;
        Date urgeAnswerTime = appfileTask.getDate(checkField);
        if (urgeAnswerTime == null) {
            return true;
        }
        String urgeAnswerTimes = IntvDateUtil.getIntvDate((Date)urgeAnswerTime);
        String dateNow = IntvDateUtil.getIntvDate((Date)new Date());
        if (!dateNow.equals(urgeAnswerTimes)) {
            res = true;
        }
        return res;
    }

    public static boolean checkIntvTimeEqNow(DynamicObject appfileTask) {
        boolean res = false;
        DynamicObject group = appfileTask.getDynamicObject("intvgroup");
        if (group != null) {
            Long intvStartTimeLong;
            Date intvStartTime = group.getDate("intvdate");
            boolean checktime = IntvDateUtil.intvTimeIsBeforeNow((Date)intvStartTime, (Long)(intvStartTimeLong = Long.valueOf(group.getLong("intvstarttime"))));
            res = !checktime;
        }
        return res;
    }

    public static boolean checkAppAnswerState(DynamicObject appfileTask) {
        boolean res = false;
        if ("A".equals(appfileTask.getString("applicationanswer"))) {
            res = true;
        }
        return res;
    }

    public static boolean checkAppTaskState(DynamicObject appfileTask) {
        boolean res = false;
        if ("A".equals(appfileTask.getString("taskstatus"))) {
            res = true;
        }
        return res;
    }

    public static IntvUrgeResultEntity checkUrgeNum(List<Long> appfiletaskIds, int count) {
        IntvUrgeResultEntity urgRes = new IntvUrgeResultEntity();
        if (appfiletaskIds.size() > count) {
            urgRes.setUtgeCheckRes(false);
            urgRes.showMessages.add("\u6761\u6570\u4e0d\u80fd\u5927\u4e8e200");
        }
        return urgRes;
    }
}

