/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.intv.service.util;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tspr.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tspr.business.domain.intv.service.intvmail.IntvMailCancelHelper;
import kd.tsc.tspr.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tspr.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tspr.common.enums.oprecord.ORStructText;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import org.apache.commons.lang3.StringUtils;

public class IntvDetailUtil {
    private static final Log log = LogFactory.getLog(IntvDetailUtil.class);
    public static final IntvMailCancelHelper MAIL_HELPER = IntvMailCancelHelper.getInstance();

    public static Object updateSignInStatus(DynamicObject appFileTask, String signInStatus) {
        if (IntvDetailUtil.isValidate(appFileTask, signInStatus).booleanValue()) {
            return null;
        }
        appFileTask.set("signinstatus", (Object)signInStatus);
        String status = "";
        status = HRStringUtils.equals((String)signInStatus, (String)"A") ? "\u672a\u7b7e\u5230" : (HRStringUtils.equals((String)signInStatus, (String)"B") ? "\u5df2\u7b7e\u5230" : "\u672a\u5230\u573a");
        DynamicObject appFile = appFileTask.getDynamicObject("application");
        String interviewtitle = appFileTask.getDynamicObject("argintv").getString("interviewtitle");
        IntvOpRecordService.getInstance().modifyCommonOR(appFile, status, OpDefEnum.SIGN_IN_INTV, ORStructText.MODIFY_SIGN_IN_INTV, interviewtitle);
        return TsrbsHelper.update(appFileTask, "tspr_appfiletask");
    }

    public static Object updateReplyStatus(DynamicObject appFileTask, String applyStatus) {
        if (IntvDetailUtil.isValidate(appFileTask, applyStatus).booleanValue()) {
            return null;
        }
        appFileTask.set("applicationanswer", (Object)applyStatus);
        String status = "";
        status = HRStringUtils.equals((String)applyStatus, (String)"A") ? "\u672a\u7b54\u590d" : (HRStringUtils.equals((String)applyStatus, (String)"B") ? "\u53c2\u52a0" : "\u4e0d\u53c2\u52a0");
        DynamicObject appFile = appFileTask.getDynamicObject("application");
        String interviewtitle = appFileTask.getDynamicObject("argintv").getString("interviewtitle");
        IntvOpRecordService.getInstance().modifyCommonOR(appFile, status, OpDefEnum.REPLY_INTV, ORStructText.MODIFY_REPLY_INTV, interviewtitle);
        return TsrbsHelper.update(appFileTask, "tspr_appfiletask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTotalResult(DynamicObject appFileTask, String totalResult) {
        if (IntvDetailUtil.isValidate(appFileTask, totalResult).booleanValue()) {
            return;
        }
        TXHandle txHandle = null;
        try {
            txHandle = TX.required((String)"tssrm_total_result");
            appFileTask.set("intvevlstatus", (Object)totalResult);
            IntvDetailUtil.updateAppFileTask(Collections.singletonList(appFileTask), "C");
            List<DynamicObject> intvEvlList = IntvDetailUtil.getIntvEvlListByAppFileTask(appFileTask);
            if (CollectionUtils.isEmpty(intvEvlList)) {
                throw new RuntimeException("intvEvlList is empty!");
            }
            IntvDetailUtil.updateIntvEvl(intvEvlList, "B");
            String status = "";
            status = HRStringUtils.equals((String)totalResult, (String)"A") ? "\u901a\u8fc7" : (HRStringUtils.equals((String)totalResult, (String)"B") ? "\u4e0d\u901a\u8fc7" : "\u5f85\u5b9a");
            DynamicObject appFile = appFileTask.getDynamicObject("application");
            String interviewtitle = appFileTask.getDynamicObject("argintv").getString("interviewtitle");
            IntvOpRecordService.getInstance().modifyCommonOR(appFile, status, OpDefEnum.GENERAL_EVA_INTV, ORStructText.GENERAL_EVA_INTV, interviewtitle);
            QFilter qFilter = new QFilter("argintv.id", "=", (Object)appFileTask.getLong("argintv.id"));
            List<DynamicObject> appFileTaskList = TsrbsHelper.selectByFilter("id, taskstatus", qFilter.toArray(), "tspr_appfiletask");
            if (appFileTaskList.stream().noneMatch(IntvDetailUtil::isUnFinishTask)) {
                DynamicObject argIntv = TsrbsHelper.selectById(appFileTask.getLong("argintv.id"), "tspr_argintv");
                IntvDetailUtil.updateArgIntv(Collections.singletonList(argIntv), "B");
                List<DynamicObject> intvTaskList = TsrbsHelper.selectByFilter("id, taskstatus", qFilter.toArray(), "tspr_intvtask");
                IntvDetailUtil.updateIntvTask(intvTaskList, "B");
            }
        }
        catch (Exception e) {
            log.error("update totalResult error -> ", (Throwable)e);
            Optional.ofNullable(txHandle).ifPresent(TXHandle::markRollback);
        }
        finally {
            Optional.ofNullable(txHandle).ifPresent(TXHandle::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean cancelIntv(List<DynamicObject> argIntvList, List<DynamicObject> appFileTaskList, Boolean isAppFile) {
        if (Objects.isNull(isAppFile)) {
            return Boolean.FALSE;
        }
        TXHandle txHandle = null;
        try {
            txHandle = TX.required((String)"cancelIntv");
            if (isAppFile.booleanValue()) {
                Optional.ofNullable(appFileTaskList).ifPresent(IntvDetailUtil::cancelSingleIntv);
                IntvOpRecordService.getInstance().cancelIntvOR(appFileTaskList, OpDefEnum.CANCEL_INTV, ORStructText.CANCEL_INTV);
            } else {
                Optional.ofNullable(argIntvList).ifPresent(IntvDetailUtil::cancelTotalIntv);
            }
        }
        catch (Throwable e) {
            log.error("cancelIntv error info is -> ", e);
            Optional.ofNullable(txHandle).ifPresent(TXHandle::markRollback);
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            Optional.ofNullable(txHandle).ifPresent(TXHandle::close);
        }
        return Boolean.TRUE;
    }

    private static void cancelTotalIntv(List<DynamicObject> argIntvList) {
        argIntvList.forEach(argIntv -> {
            ArgIntvHelper argIntvHelper = new ArgIntvHelper();
            argIntvHelper.setCancelStatus((DynamicObject)argIntv);
        });
    }

    private static void cancelSingleIntv(List<DynamicObject> appFileTaskList) {
        if (CollectionUtils.isEmpty(appFileTaskList)) {
            throw new RuntimeException("cancel single interview appFileTaskList is null!");
        }
        List<Long> argIntvIdList = IntvDetailUtil.getDistinctArgIntvIdList(appFileTaskList);
        IntvDetailUtil.updateAppFileTask(appFileTaskList, "B");
        List<DynamicObject> argIntvList = TsrbsHelper.selectByIdList(argIntvIdList, "tspr_argintv");
        if (CollectionUtils.isEmpty(argIntvList)) {
            throw new RuntimeException("cancel single interview argIntvList is empty!");
        }
        QFilter argIntvIdFilter = new QFilter("argintv.id", "in", argIntvIdList);
        List<DynamicObject> allAppFileTaskList = TsrbsHelper.selectByFilter(argIntvIdFilter.toArray(), "tspr_appfiletask");
        List<DynamicObject> intvTaskList = TsrbsHelper.selectByFilter(argIntvIdFilter.toArray(), "tspr_intvtask");
        List<DynamicObject> intvEvlList = IntvDetailUtil.getIntvEvlList(argIntvIdFilter, appFileTaskList);
        if (IntvDetailUtil.isAlreadyEvlExists(intvEvlList)) {
            throw new RuntimeException("cancel single interview already evaluation exists!");
        }
        IntvDetailUtil.updateIntvEvl(intvEvlList, "C");
        if (!IntvDetailUtil.isNotCancelStatusExists(allAppFileTaskList)) {
            IntvDetailUtil.updateIntvTask(intvTaskList, "C");
            IntvDetailUtil.updateArgIntv(argIntvList, "C");
            IntvDetailUtil.sendMessage(argIntvList, Lists.newArrayListWithCapacity((int)1), Boolean.FALSE);
            for (DynamicObject argIntv : argIntvList) {
                ArgIntvHelper.INTV_THREAD_POOL.execute(() -> ArgIntvHelper.getInstance().cancelMeetingByArgIntv(argIntv));
            }
        } else {
            Map<Long, List<DynamicObject>> allAppFileTaskMap = allAppFileTaskList.stream().collect(Collectors.groupingBy(allAppFileTask -> allAppFileTask.getLong("intvgroup.id")));
            allAppFileTaskMap.forEach((intvGroupId, groupAppFileTaskList) -> IntvDetailUtil.handle(intvGroupId, groupAppFileTaskList, intvTaskList, appFileTaskList));
        }
    }

    public static void sendMessage(List<DynamicObject> argIntvList, List<DynamicObject> appFileList, Boolean isSingle) {
        if (isSingle.booleanValue()) {
            if (CollectionUtils.isEmpty(appFileList)) {
                return;
            }
            HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
            appFileList.stream().collect(Collectors.groupingBy(appFile -> appFile.getLong("argintv.id"))).forEach((argIntvId, newAppFileTaskList) -> {
                List appIdList = newAppFileTaskList.stream().map(appFile -> appFile.getLong("application.id")).collect(Collectors.toList());
                map.put((Long)argIntvId, appIdList);
            });
            MAIL_HELPER.processCancel(map);
        } else {
            if (CollectionUtils.isEmpty(argIntvList)) {
                return;
            }
            MAIL_HELPER.processCancel(argIntvList);
        }
    }

    private static void handle(Long intvGroupId, List<DynamicObject> groupAppFileTaskList, List<DynamicObject> intvTaskList, List<DynamicObject> appFileTaskList) {
        if (Objects.isNull(intvGroupId) || CollectionUtils.isEmpty(groupAppFileTaskList) || CollectionUtils.isEmpty(intvTaskList) || CollectionUtils.isEmpty(appFileTaskList)) {
            log.warn("cancelSingleIntv handle method return, has null value int the input parameter!");
            return;
        }
        if (IntvDetailUtil.isNotCancelGroup(intvGroupId, appFileTaskList)) {
            log.warn("is not cancel group!");
            return;
        }
        List<DynamicObject> groupIntvTaskList = intvTaskList.stream().filter(intvTask -> intvGroupId.equals(intvTask.getLong("intvgroup.id"))).collect(Collectors.toList());
        if (!IntvDetailUtil.isNotCancelStatusExists(groupAppFileTaskList)) {
            log.info("is not cancel status exists, all cancel");
            IntvDetailUtil.updateIntvTask(groupIntvTaskList, "C");
            groupIntvTaskList.forEach(groupIntvTask -> {
                DynamicObject group = groupIntvTask.getDynamicObject("intvgroup");
                ArgIntvHelper.INTV_THREAD_POOL.execute(() -> ArgIntvHelper.getInstance().cancelMeetingByRound(group));
            });
        } else {
            log.info("partial cancel");
            if (!IntvDetailUtil.isProcessingStatusExists(groupAppFileTaskList)) {
                IntvDetailUtil.updateIntvTask(groupIntvTaskList, "B");
            }
        }
        IntvDetailUtil.sendMessage(null, appFileTaskList, Boolean.TRUE);
    }

    private static Boolean isValidate(DynamicObject appFileTask, String validateStr) {
        return Objects.isNull(appFileTask) || StringUtils.isEmpty((CharSequence)validateStr) || !"A".equals(appFileTask.getString("taskstatus"));
    }

    private static List<DynamicObject> getIntvEvlListByAppFileTask(DynamicObject appFileTask) {
        QFilter qFilter = new QFilter("appfiletask", "=", (Object)appFileTask.getLong("id")).and("enable", "=", (Object)"1");
        return TsrbsHelper.selectByFilter(qFilter.toArray(), "tspr_intvevl");
    }

    private static List<DynamicObject> getIntvEvlList(QFilter intvIdFilter, List<DynamicObject> appFileTaskList) {
        List<Long> appIdList = IntvDetailUtil.getAppIdListByAppFileTaskList(appFileTaskList);
        QFilter appIdFilter = intvIdFilter.and(new QFilter("application.id", "in", appIdList));
        return TsrbsHelper.selectByFilter(appIdFilter.toArray(), "tspr_intvevl");
    }

    private static List<Long> getAppIdListByAppFileTaskList(List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().map(appFileTask -> appFileTask.getLong("application.id")).collect(Collectors.toList());
    }

    private static List<Long> getDistinctArgIntvIdList(List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().map(argAppFile -> argAppFile.getLong("argintv.id")).distinct().collect(Collectors.toList());
    }

    private static boolean isNotCancelGroup(Long intvGroupId, List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().anyMatch(appFileTask -> !intvGroupId.equals(appFileTask.getLong("intvgroup.id")));
    }

    private static boolean isNotCancelStatusExists(List<DynamicObject> allAppFileTaskList) {
        return allAppFileTaskList.stream().anyMatch(appFileTask -> !"B".equals(appFileTask.getString("taskstatus")));
    }

    private static boolean isAlreadyEvlExists(List<DynamicObject> evlList) {
        return evlList.stream().anyMatch(evl -> !"A".equals(evl.getString("handlestatus")) && !"A".equals(evl.getString("interviewstatus")));
    }

    private static boolean isProcessingStatusExists(List<DynamicObject> appFileTaskList) {
        return appFileTaskList.stream().anyMatch(appFileTask -> "A".equals(appFileTask.getString("taskstatus")));
    }

    private static boolean isUnFinishTask(DynamicObject appFileTask) {
        return "A".equals(StringUtils.isEmpty((CharSequence)appFileTask.getString("taskstatus")) ? "A" : appFileTask.getString("taskstatus"));
    }

    private static void updateAppFileTask(List<DynamicObject> appFileTaskList, String taskStatus) {
        List<DynamicObject> updateAppFileTaskList = appFileTaskList.stream().map(appFileTask -> IntvDetailUtil.setAppFileTaskStatus(appFileTask, taskStatus)).collect(Collectors.toList());
        IntvAppfileTaskHelper.getInstance().updateAppfileTaskAndAppfile(updateAppFileTaskList.toArray(new DynamicObject[0]));
    }

    private static void updateArgIntv(List<DynamicObject> argIntvList, String status) {
        List<DynamicObject> updateArgIntvList = argIntvList.stream().map(argIntv -> IntvDetailUtil.setIntvStatus(argIntv, status)).collect(Collectors.toList());
        TsrbsHelper.update(updateArgIntvList.toArray(new DynamicObject[0]), "tspr_argintv");
    }

    public static void updateIntvEvl(List<DynamicObject> intvEvlList, String status) {
        List<DynamicObject> updateIntvEvlList = intvEvlList.stream().map(intvEvl -> IntvDetailUtil.setIntvEvlStatus(intvEvl, status)).collect(Collectors.toList());
        TsrbsHelper.update(updateIntvEvlList.toArray(new DynamicObject[0]), "tspr_intvevl");
    }

    private static void updateIntvTask(List<DynamicObject> intvTaskList, String status) {
        List<DynamicObject> updateIntvTaskList = intvTaskList.stream().map(intvTask -> IntvDetailUtil.setIntvTaskStatus(intvTask, status)).collect(Collectors.toList());
        TsrbsHelper.update(updateIntvTaskList.toArray(new DynamicObject[0]), "tspr_intvtask");
    }

    private static DynamicObject setIntvTaskStatus(DynamicObject intvTask, String status) {
        intvTask.set("taskstatus", (Object)status);
        return intvTask;
    }

    private static DynamicObject setIntvStatus(DynamicObject argIntv, String status) {
        argIntv.set("interviewstatus", (Object)status);
        return argIntv;
    }

    private static DynamicObject setIntvEvlStatus(DynamicObject intvEvl, String status) {
        intvEvl.set("handlestatus", (Object)status);
        return intvEvl;
    }

    private static DynamicObject setAppFileTaskStatus(DynamicObject appFileTask, String taskStatus) {
        appFileTask.set("taskstatus", (Object)taskStatus);
        return appFileTask;
    }
}

