/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.mq.consumer.hom;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.tsc.tspr.business.domain.appfile.service.AppFileService;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionCommModel;
import kd.tsc.tspr.business.domain.offer.mq.model.StopInductionInfo;
import kd.tsc.tspr.common.dto.response.OnbrdRespVal;
import kd.tsc.tspr.common.dto.response.ResponseDTO;
import kd.tsc.tsrbs.business.domain.util.MsgCenterUtils;

public class OfferConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(OfferConsumer.class);
    private static final Long ACTION_ID = 104010L;

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            log.info("OfferConsumer.onMessage.body");
            InductionCommModel model = (InductionCommModel)body;
            int messageType = model.getMessageType();
            if (messageType != InductionCommModel.MessageType.LAUNCH_INDUCTION.getCode() && messageType == InductionCommModel.MessageType.TERMINATE_INDUCTION.getCode()) {
                StopInductionInfo stopInductionInfo = model.getStopInductionInfo();
                AppFileService.getInstance().breakupAppFile(stopInductionInfo.getAppfileId());
                this.publishMsgToOnbrd(stopInductionInfo);
            }
            acker.ack(messageId);
        }
        catch (Exception e) {
            log.error("OfferConsumer.onMessage", (Throwable)e);
            acker.deny(messageId);
        }
    }

    private void publishMsgToOnbrd(StopInductionInfo stopInductionInfo) {
        ResponseDTO responseDTO = new ResponseDTO();
        responseDTO.setOnboardType("C");
        OnbrdRespVal onbrdRespVal = new OnbrdRespVal();
        onbrdRespVal.setAppFileId(Long.valueOf(stopInductionInfo.getAppfileId()));
        onbrdRespVal.setBreakupTypeId(Long.valueOf(stopInductionInfo.getEndTypeId()));
        onbrdRespVal.setBreakupReasonId(stopInductionInfo.getEndIdcReasonId());
        onbrdRespVal.setBreakupRemarks(stopInductionInfo.getEndIdcReasonStr());
        responseDTO.setResult((Object)onbrdRespVal);
        HashMap<String, String> contentMap = new HashMap<String, String>(1);
        contentMap.put("breakUpOnbrdInfo", JSON.toJSONString((Object)responseDTO));
        MsgCenterUtils.publishAction((String)"MP20220824001006", (Long)ID.genLongId(), (String)"breakup-onbrd", (Long)ACTION_ID, contentMap);
    }
}

