/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.mq.consumer.positon;

import java.io.IOException;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.tsc.tspr.business.domain.position.service.PositionRuleServiceHelper;

public class PositionRuleConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(PositionRuleConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        Map pushData = (Map)body;
        Integer assignType = (Integer)pushData.get("assignType");
        try {
            DynamicObject[] entities = (DynamicObject[])pushData.get("data");
            logger.info("PositionRule consumption start assignType : {},entities : {}", (Object)assignType, (Object)entities.length);
            if (assignType == 1) {
                PositionRuleServiceHelper.getInstance().rsmAssignPositionByRule(entities);
            } else {
                PositionRuleServiceHelper.getInstance().positionAssignRsmByRule(entities);
            }
            logger.info("PositionRule consumption end assignType : {}", (Object)assignType);
            acker.ack(messageId);
        }
        catch (Throwable e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
                logger.error("PositionRule consumption discard assignType : {} msg : {}", (Object)assignType, (Object)e);
            }
            acker.deny(messageId);
            logger.error("PositionRule consumption again assignType : {} msg : {}", (Object)assignType, (Object)e);
        }
    }

    public String getRouteKey() {
        return "tsc";
    }
}

