/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.mq.producer;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tsc.tspr.business.domain.mq.producer.ProducerStrategyService;
import kd.tsc.tspr.business.domain.mq.producer.appfile.BreakupOnbrdProducer;
import kd.tsc.tspr.business.domain.mq.producer.hcdm.Tspr2HcdmProducer;
import kd.tsc.tspr.business.domain.mq.producer.offer.Tspr2OfferProducer;
import kd.tsc.tspr.business.domain.mq.producer.tstpm.Tspr2TstpmProducer;

public class ProducerExecution {
    private static final Map<String, ProducerStrategyService> HANDLE_STRATEGY_SERVICE_HASH_MAP = Maps.newHashMapWithExpectedSize((int)16);

    public static ProducerStrategyService getHandleInstance(String handleType) {
        return HANDLE_STRATEGY_SERVICE_HASH_MAP.get(handleType);
    }

    public static void handleExecution(String handleType, Object obj) {
        ProducerExecution.getHandleInstance(handleType).handle(obj);
    }

    static {
        HANDLE_STRATEGY_SERVICE_HASH_MAP.put("offer", new Tspr2OfferProducer());
        HANDLE_STRATEGY_SERVICE_HASH_MAP.put("tstpm", new Tspr2TstpmProducer());
        HANDLE_STRATEGY_SERVICE_HASH_MAP.put("hcdm", new Tspr2HcdmProducer());
        HANDLE_STRATEGY_SERVICE_HASH_MAP.put("onbrd", new BreakupOnbrdProducer());
    }
}

