/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.offer;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tspr.business.domain.offer.mq.model.InductionOfferDataBo;
import kd.tsc.tspr.business.domain.offer.mq.model.LaunchInductionInfo;
import kd.tsc.tspr.common.dto.request.OnboardReqDTO;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tsrbs.business.domain.util.MsgCenterUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class HomOnBrdService {
    private static final Map<String, String> map = new HashMap<String, String>();
    private static final Log logger = LogFactory.getLog(HomOnBrdService.class);
    private static final String MSGPUB_NO = "MP20220808001004";
    private static final Long ACTION_ID;

    public void createOnBrd(LaunchInductionInfo info) {
        Long candidateId = this.getCandidateId(info.getAppfileId());
        this.createOnbrdHandle(info, candidateId);
    }

    private Long getCandidateId(Long appFileId) {
        QFilter qFilter = new QFilter("appfileid", "=", (Object)appFileId).and("iscurrentversion", "=", (Object)Boolean.TRUE);
        List candidateList = BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"hcf_candidate");
        if (CollectionUtils.isEmpty((Collection)candidateList)) {
            return null;
        }
        return ((DynamicObject)candidateList.get(0)).getLong("id");
    }

    private void createOnbrdHandle(LaunchInductionInfo info, Long candidateId) {
        OnboardReqDTO dto = this.convert2HOMReqDTOHandle(info, candidateId);
        HashMap contentMap = Maps.newHashMapWithExpectedSize((int)1);
        contentMap.put("onboard_req", JSON.toJSONString((Object)dto));
        logger.info("createOnbrdHandle.onboard_req\uff1a{}", (Object)contentMap);
        String msgTitle = String.format(ResManager.loadKDString((String)"%s\u53d1\u8d77\u5165\u804c", (String)"HomOnBrdService_0", (String)"tsc-tspr-business", (Object[])new Object[0]), dto.getAppFileNumber());
        MsgCenterUtils.publishAction((String)MSGPUB_NO, (Long)ID.genLongId(), (String)msgTitle, (Long)ACTION_ID, (Map)contentMap);
    }

    private OnboardReqDTO convert2HOMReqDTOHandle(LaunchInductionInfo info, Long candidateId) {
        Long appFileId = info.getAppfileId();
        OnboardReqDTO dto = new OnboardReqDTO();
        dto.setCandidateId(candidateId);
        this.candidateInfoHandle(dto, candidateId);
        this.offerHandle(dto, info.getInductionOfferDataBo());
        this.appFileHandle(dto, appFileId);
        return dto;
    }

    private void candidateInfoHandle(OnboardReqDTO dto, Long candidateId) {
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId).and("iscurrentversion", "=", (Object)Boolean.TRUE);
        List contactInfoList = BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"hcf_cancontactinfo");
        if (CollectionUtils.isEmpty((Collection)contactInfoList)) {
            return;
        }
        DynamicObject contactInfo = (DynamicObject)contactInfoList.get(0);
        dto.setPhone(contactInfo.getString("phone"));
        dto.setEmail(contactInfo.getString("peremail"));
        List creInfoList = BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"hcf_cancre");
        if (CollectionUtils.isEmpty((Collection)creInfoList)) {
            return;
        }
        DynamicObject creInfo = (DynamicObject)creInfoList.get(0);
        dto.setCertificateType(Long.valueOf(creInfo.getLong("credentialstype.id")));
        dto.setCertificateNumber(creInfo.getString("number"));
    }

    private void offerHandle(OnboardReqDTO dto, InductionOfferDataBo offerInfo) {
        BeanUtils.copyProperties((Object)offerInfo, (Object)dto);
        dto.setOfferNumber(offerInfo.getNumber());
        dto.setPperiodtermunit(map.get(offerInfo.getPperiodtermunit()));
        dto.setHavePeriodTerm(Boolean.valueOf("1".equals(offerInfo.getIsHavePeriodTerm())));
        Optional.ofNullable(offerInfo.getRecrutyp()).ifPresent(reCreTyp -> dto.setRecrutyp(Long.valueOf(reCreTyp.getLong("id"))));
        Optional.ofNullable(offerInfo.getPejob()).ifPresent(peJob -> dto.setPejob(Long.valueOf(peJob.getLong("id"))));
        Optional.ofNullable(offerInfo.getJobgrade()).ifPresent(jobGrade -> dto.setJobgrade(Long.valueOf(jobGrade.getLong("id"))));
        Optional.ofNullable(offerInfo.getJoblevel()).ifPresent(jobLevel -> dto.setJoblevel(Long.valueOf(jobLevel.getLong("id"))));
        Optional.ofNullable(offerInfo.getEmprelationtype()).ifPresent(emprelationType -> dto.setEmprelationtype(Long.valueOf(emprelationType.getLong("id"))));
        Optional.ofNullable(offerInfo.getPeadminorg()).ifPresent(peadMinOrg -> {
            dto.setPeadminorg(Long.valueOf(peadMinOrg.getLong("id")));
            dto.setOrg(Long.valueOf(peadMinOrg.getLong("org.id")));
        });
        Optional.ofNullable(offerInfo.getPeposition()).ifPresent(pePosition -> {
            long pePositionId = pePosition.getLong("id");
            if (0L != pePositionId) {
                dto.setPeposition(Long.valueOf(pePositionId));
                DynamicObject selPePosition = BaseHelper.selectById((Long)pePositionId, (String)"hbpm_positionhr");
                dto.setPejob(Long.valueOf(selPePosition.getLong("job.id")));
            }
        });
        Optional.ofNullable(offerInfo.getPestdposition()).ifPresent(pestdPosition -> {
            long pePositionId = pestdPosition.getLong("id");
            if (0L != pePositionId) {
                dto.setPestdposition(Long.valueOf(pePositionId));
                DynamicObject selPePosition = BaseHelper.selectById((Long)pePositionId, (String)"hbpm_stposition");
                dto.setPejob(Long.valueOf(selPePosition.getLong("job.id")));
            }
        });
        Optional.ofNullable(offerInfo.getPlacework()).ifPresent(placeWork -> {
            long workPlaceId = placeWork.getLong("id");
            if (0L != workPlaceId) {
                DynamicObject workPlace = BaseHelper.selectById((Long)workPlaceId, (String)"hbss_workplace");
                if (workPlace.getBoolean("ispermanworkplace")) {
                    dto.setPlacework(Long.valueOf(workPlace.getLong("id")));
                }
                if (workPlace.getBoolean("iscontractworkplace")) {
                    dto.setAgreePlacework(Long.valueOf(workPlace.getLong("id")));
                }
            }
        });
    }

    private void appFileHandle(OnboardReqDTO dto, Long appFileId) {
        DynamicObject appFile = BaseHelper.selectById((Long)appFileId, (String)"tspr_appfile");
        dto.setAppFileId(appFileId);
        dto.setAppFileName(appFile.getString("name"));
        dto.setAppFileNumber(appFile.getString("number"));
        dto.setResacqmthd(Long.valueOf(appFile.getLong("resacqmthd.id")));
        DynamicObject appres = appFile.getDynamicObject("appres");
        if (Objects.isNull(appres)) {
            return;
        }
        dto.setAppresNumber(appres.getString("number"));
        dto.setGender(Long.valueOf(appres.getLong("gender.id")));
        dto.setNatreg(Long.valueOf(appres.getLong("natreg.id")));
    }

    static {
        map.put("D", "3");
        map.put("W", "2");
        map.put("M", "1");
        ACTION_ID = 104010L;
    }
}

