/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tspr.business.domain.position.service;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class HbssJobAdapter {
    private static String JOB_ENTITY = "hbjm_jobhr";
    private static String JOB_LEVEL_ENTITY = "hbjm_joblevelhr";
    private static String JOB_GRADE_ENTITY = "hbjm_jobgradehr";
    private static String JOB_LEVEL = "joblevel";
    private static String JOB_GRADE = "jobgrade";

    public static DynamicObject queryJobDymById(long id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(JOB_ENTITY);
        String selectFields = "lowjoblevel,highjoblevel,lowjobgrade,highjobgrade";
        return hrBaseServiceHelper.queryOriginalOne(selectFields, (Object)id);
    }

    public static List<Long> getJobLevelRangeByLevelId(Long positionId) {
        return HbssJobAdapter.getRangeIdsBySeq(positionId, JOB_LEVEL_ENTITY);
    }

    public static List<Long> getJobGradeRangeByGradeId(Long positionId) {
        return HbssJobAdapter.getRangeIdsBySeq(positionId, JOB_GRADE_ENTITY);
    }

    public static List<Long> getRangeIdsBySeq(Long positionId, String entityId) {
        Map dataMap;
        Map positionMap;
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobLevelGradeRangeInfo", (Object[])new Object[]{ImmutableList.of((Object)positionId)});
        List<Long> resultList = new ArrayList<Long>(8);
        int code = (Integer)resultMap.get("code");
        if (200 == code && ObjectUtils.isNotEmpty((Object)(positionMap = (Map)(dataMap = (Map)resultMap.get("data")).get(positionId.toString())))) {
            if (JOB_LEVEL_ENTITY.equals(entityId)) {
                List joblevelList = (List)positionMap.get(JOB_LEVEL);
                resultList = joblevelList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            } else {
                List jobgradeList = (List)positionMap.get(JOB_GRADE);
                resultList = jobgradeList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            }
        }
        return resultList;
    }
}

